//
//           __ ,
//            ,-| ~           ,               ,,
//           ('||/__,        ||               ||                  _
//          (( |||  | \\ \\ =||=   _-_  \\/\\ ||/|,  _-_  ,._-_  / \\
//          (( |||==| || ||  ||   || \\ || || || || || \\  ||   || ||
//           ( / |  , || ||  ||   ||/   || || || |' ||/    ||   || ||
//            -____/  \\/\\  \\,  \\,/  \\ \\ \\/   \\,/   \\,  \\_-|
//                                                               /  \
//                                                              '----`
//                     Text Output and Font Management System
//                       Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1995-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// gbrgfont.c
//
// Contains the basic font management routines.
//
//

//
//
//                                Includes
//
//

#include <debug.h>

#include <assert.h>
#include <string.h>

#include <gutenbrg.h>

//
//
//                                Equates
//
//

//
//
//                               Routines
//
//

extern GBergFontInfo *igberg_empty_font();

//
//
//                                 Data
//
//

extern GBergIData   *GBergInstance;

//
//
//                                 Code
//
//

//Ŀ
// gberg_color                                                              
//                                                                          
// This sets the current color for the font draw which is used by the mono  
// fonts.                                                                   
//
gberg_error_codes gberg_color(dword fcol, dword bcol)
{
    assertMyth("Gutenberg must be initialized",GBergInstance);

    GBergInstance->fcol = fcol;
    GBergInstance->bcol = bcol;

    return GBERG_ERR_NONE;
}


//Ŀ
// gberg_select_font                                                        
//                                                                          
// Makes the given font active, locking it's handle.                        
//
gberg_error_codes gberg_select_font(const char *fntname)
{
    ulong               i;
    GBergFontInfo       *fnt, *nfnt;

    assertMyth("Gutenberg must be initialized",GBergInstance);

    if (!fntname)
        return GBERG_ERR_FONTNOTINSTALLED;

    fnt=GBergInstance->font_active;
    if (fnt)
    {
// Check to see if already active
        if (*fntname == *fnt->name)
        {
            if (!strcmp(fntname,fnt->name))
                return GBERG_ERR_NONE;
        }
    }

// Search for given font name
    for(i=0, nfnt=&GBergInstance->fonts[0]; i < GBergInstance->fonts_hi; i++, nfnt++)
    {
        if (*fntname == *nfnt->name)
        {
            if (!strcmp(fntname,nfnt->name))
                break;
        }
    }

    if (i >= GBergInstance->fonts_hi)
    {
        return GBERG_ERR_FONTNOTINSTALLED;
    }

// Unlock old font, if active
    if (fnt)
    {
        assertMyth("gberg_select_font assumes active font has valid data",
                   fnt->data);

        ivory_hunlock(fnt->data);
        fnt->ptr=0;

        GBergInstance->font_active=0;
    }

// Lock new font
    assertMyth("gberg_select_font assumes font not already locked",
               !nfnt->ptr);

    nfnt->ptr=ivory_hlock(nfnt->data);
    if (!nfnt->ptr)
        return GBERG_ERR_LOCKFAILED;

    GBergInstance->font_active=nfnt;

    return GBERG_ERR_NONE;
}

// End of module - gbrgfont.c 
