//
//           __ ,
//            ,-| ~           ,               ,,
//           ('||/__,        ||               ||                  _
//          (( |||  | \\ \\ =||=   _-_  \\/\\ ||/|,  _-_  ,._-_  / \\
//          (( |||==| || ||  ||   || \\ || || || || || \\  ||   || ||
//           ( / |  , || ||  ||   ||/   || || || |' ||/    ||   || ||
//            -____/  \\/\\  \\,  \\,/  \\ \\ \\/   \\,/   \\,  \\_-|
//                                                               /  \
//                                                              '----`
//                     Text Output and Font Management System
//                       Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1995-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Chuck Walbourn
//
// gbrgxstr.cpp
//
// Contains the extended string management routines.
//
//

//
//
//                                Includes
//
//

#include <assert.h>
#include <string.h>

#include <ivory.hpp>
#include <xfile.hpp>

#include <gutenbrg.hpp>
#include <gbrgfile.hpp>

//
//
//                                 Data
//
//

extern "C" GBergIData   *GBergInstance;

//
//
//                                 Code
//
//

//Ŀ
// gberg_remove_strings                                                     
//                                                                          
// This routine removes the given string set from memory.                   
//
extern "C" gberg_error_codes gberg_remove_strings (const char *txtname)
{
    ulong               i;
    GBergTextInfo       *txt;

    assertMyth("Gutenberg must be initialized",GBergInstance);

    if (!txtname)
        return GBERG_ERR_FONTNOTINSTALLED;

// Check to see if active
    txt=GBergInstance->text_active;
    if (txt)
    {
        if (*txtname == *txt->name)
        {
            if (!strcmp(txtname,txt->name))
            {
                GBergInstance->text_active=0;
            }
        }
    }

// Search for given strings name
    for(i=0, txt=&GBergInstance->text[0]; i < GBergInstance->text_hi; i++, txt++)
    {
        if (*txtname == *txt->name)
        {
            if (!strcmp(txtname,txt->name))
                break;
        }
    }

    if (i >= GBergInstance->text_hi)
    {
        return GBERG_ERR_FONTNOTINSTALLED;
    }

// Remove strings
    if (txt->data)
    {
        ivory_hfree(&txt->data);
    }
    memset(txt,0,sizeof(GBergTextInfo));

    return GBERG_ERR_NONE;
}

// End of module - gbrgxtxt.cpp 

