//
//                                   ____
//                                  / __ \
//                                 ( (__) )
//                                 _\____/___
//                                /  |  |   /\
//                               /_________/  \_
//                              /          \    \
//                             /            \    \_
//                            /              \     \
//                           /                \     \_
//                          /                  \      \
//                         /                    \      \_
//                        /                      \       \
//                       /                        \       \_
//                      /                          \        \
//                     /                            \        \_
//                    /                              \         \
//                   / N  N EEE W   W TTTTT  OO  N  N \        /
//                  /  NN N E_  W   W   T   O  O NN N  \      /
//                 /   N NN E   W W W   T   O  O N NN   \    /
//                /    N  N EEE  W W    T    OO  N  N    \  /
//               /________________________________________\/
//
//                     Newtonian Physics Simulation Library
//
//                      Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1995-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// newtobj.cpp
//
// Object Class implementation.
//
// The basic newton object describes a single "thing" in 3-space which has
// a position, velocity, and accleration.  It may be acted upon by force
// objects.
//
//

//
//
//                                Includes
//
//

#include <newton.hpp>

//
//
//                                 Code
//
//

//
//  Constructors/Destructors  
//

//
//  NewtObject - Vector constructor
//
NewtObject::NewtObject (float m, const NewtVector &_position, const NewtVector &_velocity):
    mass     (m),
    drag     (0),
    position (_position),
    last_position (_position),
    velocity (_velocity)
{
}


//
//  NewtObject - Location constructor
//
NewtObject::NewtObject (float m, float x, float y, float z, const NewtVector &_velocity):
    mass     (m),
    drag     (0),
    position (x, y, z),
    last_position (x, y, z),
    velocity (_velocity)
{
}


//
//  NewtObject - Alternate location constructor
//
NewtObject::NewtObject (float m, float x, float y, float z):
    mass     (m),
    drag     (0),
    position (x, y, z),
    last_position (x, y, z)
{
}


//
//  NewtObject - default constructor
//
NewtObject::NewtObject ():
    mass     (1),
    drag     (0),
    position (0, 0, 0),
    last_position (0, 0, 0)
{
}


//
//  NewtObject - Destructor
//
NewtObject::~NewtObject ()
{
}



//
//  Operations  
//

//
//  NewtObject - step
//
void NewtObject::step (float t)
{
// If no time passed, then nothing should change and temps should
// not be lost
    if (t == 0)
        return;

// Remember our position (for collide detection)
    last_position = position;

    NewtVector acc (acceleration.i + temp_acceleration.i,
                    acceleration.j + temp_acceleration.j,
                    acceleration.k + temp_acceleration.k);
    NewtVector vel (velocity.i + temp_velocity.i,
                    velocity.j + temp_velocity.j,
                    velocity.k + temp_velocity.k);

    // Since we need at for this step, and 1/2 at^2 for the next,
    // we can combine the computations slightly...

// Calculate the new velocity v += at
    // Acc == at
    velocity.i += (acc.i *= t);
    velocity.j += (acc.j *= t);
    velocity.k += (acc.k *= t);

// Calculate the new position d += 1/2at^2 + vt
    vel.i *= t;     // vt
    vel.j *= t;
    vel.k *= t;

    // acc == 1/2at^2
    t /= 2.0f;      // t = 1/2t
    acc.i *= t;
    acc.j *= t;
    acc.k *= t;

    position.i += acc.i + vel.i;
    position.j += acc.j + vel.j;
    position.k += acc.k + vel.k;

// Clear the instantaneous force values
    temp_acceleration.i = 0;
    temp_acceleration.j = 0;
    temp_acceleration.k = 0;

    temp_velocity.i = 0;
    temp_velocity.j = 0;
    temp_velocity.k = 0;
}


// End of module - newtobj.cpp 
