//
//
//           ^           **   **   **** ***** *    ****     ^      Take me to
//          (_)            * *     *      *   *    *       (_)    / your
//     ^                    *      **     *   *    **            ^  leader...
//    (_)       ^          * *     *      *   *    *            (_)
//             (_)       **   **   *    ***** **** ****
//
//                    Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
//                          *** Tester Application ***
//
// Created by Chuck Walbourn
//
// xtlow.cpp
//
//

//
//
//                                Includes
//
//

#include <iostream.h>

#include <io.h>
#include <fcntl.h>

#include "xfile.hpp"

//
//
//                               Routines
//
//

void print_error(char *s);
void print_error(class XFile *xf, char *s);

//
//
//                                 Code
//
//

//Ŀ
// low_level                                                                
//                                                                          
//     Entry point for the low-level file tests for XFile.                  
//
void low_level()
{
   HANDLE   fhandle;

// Perform file tests 
   cout << "\n\n\n Low-level/Base object tests \n";

   cout << " Using low-level functions \n";
   fhandle=xf_open("TESTFILE.DAT",XF_OPEN_CREATE|XF_OPEN_WRITE);

   if (fhandle == INVALID_HANDLE_VALUE)
   {
       print_error("Failed to open file");
   }
   else
   {
       ulong   result;
       char    data[128];

       cout << "File created.\n";

       result = xf_write(fhandle,"Test String\n",sizeof("Test String\n") );

       if (result != sizeof("Test String\n"))
           print_error("Failed to write string");
       else
           cout << "Written.\n";

       cout << "Current file position: " << xf_seek (fhandle,1,0) << "\n";

       xf_flush (fhandle);
       xf_close (fhandle);

       fhandle = xf_open("TESTFILE.DAT",XF_OPEN_READ);
       if (fhandle == INVALID_HANDLE_VALUE)
       {
           print_error("Failed to open file");
       }
       else
       {
           ulong    i;

           cout << "File size " << xf_getsize(fhandle) << "\n";

           result = xf_read (fhandle, data, 128);

           if (!result)
               print_error ("Error reading");
           else
           {
               for (i = 0; i < result; i++)
                   cout << data[i];
           }

           xf_close(fhandle);
       }
   }

   cout << " Temporary file" << endl;

   char fname[16] = "xxx";

   fhandle=xf_opentmp(fname,XF_OPEN_CREATE|XF_OPEN_WRITE);

   if (fhandle == INVALID_HANDLE_VALUE)
   {
       print_error("Failed to open temporary file");
   }
   else
   {
       ulong   result;
       char    data[128];

       cout << "File created as " << fname << ".\n";

       result=xf_write(fhandle,"Test String\n",sizeof("Test String\n") );

       if (result != sizeof("Test String\n"))
           print_error("Failed to write string");
       else
           cout << "Written.\n";

       cout << "Current file position: " << xf_seek(fhandle,1,0) << "\n";

       xf_flush(fhandle);
       xf_close(fhandle);

       fhandle=xf_open(fname,XF_OPEN_READ);
       if (fhandle == INVALID_HANDLE_VALUE)
       {
           print_error("Failed to open file");
       }
       else
       {
           ulong    i;

           cout << "File size " << xf_getsize(fhandle) << "\n";

           result=xf_read(fhandle,data,128);

           if (!result)
               print_error("Error reading");
           else
           {
               for (i = 0; i < result; i++)
                   cout << data[i];
           }

           xf_close(fhandle);
       }

       xf_remove(fname);
   }

   cout << "\n Using XFileDisk object \n";
   XFileDisk   xf;

   if (xf.create("TESTFIL2.DAT",0))
   {
       print_error(&xf,"Failed to create file");
   }
   else
   {
       ulong   result;
       char    data[128];

       cout << "File created.\n";

       result=xf.write("Test string\n",sizeof("Test string\n"));

       if (result != sizeof("Test string\n"))
           print_error(&xf,"Failed to write string");
       else
           cout << "Written.\n";

       cout << "Current file position: " << xf.tell() << "\n";

       xf.flush();
       xf.close();

       if (xf.open("TESTFIL2.DAT",XF_OPEN_READ))
       {
           print_error(&xf,"Failed to open file");
       }
       else
       {
           ulong    i;

           result=xf.read(data,128);

           if (!result)
               print_error(&xf,"Failed to read");
           else
           {
               for (i = 0; i < result; i++)
                   cout << data[i];
           }

           xf.close();
       }
   }

   cout << "\n Testing miscellanous low-level routines \n";

   if (xf_exist("TESTFILE.DAT"))
   {
       int attrs;

       cout << "Testfile.dat exists, this is correct.  Attributes =";

       attrs=xf_getattr("TESTFILE.DAT");

       if (attrs & XF_ATTRIB_READONLY)
           cout << " Ronly";
       if (attrs & XF_ATTRIB_HIDDEN)
           cout << " Hidden";
       if (attrs & XF_ATTRIB_SYSTEM)
           cout << " System";
       if (attrs & XF_ATTRIB_LABEL)
           cout << " Label";
       if (attrs & XF_ATTRIB_DIRECTORY)
           cout << " Directory";
       if (attrs & XF_ATTRIB_ARCHIVE)
           cout << " Archive";
       if (attrs & XF_ATTRIB_SHAREABLE)
           cout << " Shareable";

       cout << "\n";
   }
   else
       print_error("Testfile.dat should exist at this point");

   if (xf_remove("TESTFILE.DAT"))
       print_error("Error removing file");
   else
       cout << "File removed\n";

   if (!xf_exist("TESTFILE.DAT"))
       cout << "Testfile.dat doesnt exist, this is correct\n";
   else
       print_error("Testfile.dat should NOT exist at this point");

   if (xf_rename("TESTFIL2.DAT","TESTFILE.DAT"))
   {
       print_error("Renaming didn't work");
       xf_remove("TESTFIL2.DAT");
   }
   else
   {
       cout << "Renamed file work...\n";

       xf_remove("TESTFILE.DAT");
   }

   char *c;
   cout << "\nDumping PATH\n";

   c=xf_getenv("PATH");
   if (!c)
       cout << "Path not set\n";
   else
       cout << "Path = " << c;
   cout << "\n";

   cout << "\nTest searching\n";
   char buff[128];
   if (*xf_searchenv("WPP386.EXE","PATH",buff))
   {
       cout << "Filename: " << buff << "\n";
   }

   cout << "Test path ops\n";
   cout << xf_makepath(buff,"C:","TEMP","RESULT","DAT") << "\n";

   cout << "Test find file\n";
   struct xf_find_type find;

   if (!xf_findfirst ("*.bat",0,&find))
   {
       cout << find.xf_name << "  " << find.xf_size << " bytes\n";

       while (xf_findnext (&find) == 0)
       {
            cout << find.xf_name << "  " << find.xf_size << " bytes\n";
       }

       xf_findclose(&find);
   }
   else
       cout << "No Files Found\n";
}

// End of module - xtlow.cpp 

