
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: cobject.h,v 1.8 1998/06/14 12:23:57 stes Exp $
 */

#ifndef __CAOBJECT_HEADER__
#define __CAOBJECT_HEADER__

#include "stdio.h"

#ifndef __OBJECT_INCLUDED__
#define __OBJECT_INCLUDED__
#include "Object.h"		/* Stepstone Object.h assumes #import */
#endif

@interface CAObject : Object
{
  int refCount;
  STR _str;
}

+ (STR) cakitRevision;

+ new;
+ str:(STR)aString;
+ int:(int)intValue;
- copy;
- deepCopy;
- cheapCopy;
- clear;
- free;

- (BOOL) sameClass:a;
- (BOOL) differentClass:a;
- (BOOL) isKindOfSequence;

- (STR) str;
- str:(STR)aString;
- (int) intValue;
- intValue:(int)i;
- asModp:(unsigned short)p;
- (BOOL) isFloatingPoint;
- asNumerical;
- (float) floatValue;
- floatValue:(float)f;
- asTotalFraction;
- asScalar;
- asSymbol;

- (BOOL) isEqual:a;
- (BOOL) notEqual:a;

- (BOOL) inOrderedSet;
- (int) compare:b;
- (int) sign;
- (BOOL) isLess:a;
- (BOOL) isGreater:a;
- (BOOL) isLessEqual:a;
- (BOOL) isGreaterEqual:a;
- absValue;

- (BOOL) inAdditiveSemiGroup;
- (BOOL) inAdditiveMonoid;
- (BOOL) inAdditiveGroup;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- zero;
- negate;
- add:b;
- subtract:b;
- increment;
- decrement;
- multiplyIntValue:(int)b;
- double;
- quadruple;
- divideIntValue:(int)b;
- half;
- quarter;

- (BOOL) commutes;
- (BOOL) commutesWith:b;
- (BOOL) inSemiGroup;
- (BOOL) inMonoid;
- (BOOL) inGroup;
- one;
- minusOne;
- (BOOL) isOne;
- (BOOL) notOne;
- (BOOL) isMinusOne;
- (BOOL) notMinusOne;
- square;
- multiply:b;
- power:(int)n;
- inverse;
- (BOOL) isUnit;
- (BOOL) notUnit;
- divide:b;

- remainder:b quotient:(id *)q;
- remainder:b;
- quotient:b;

- (BOOL) inEuclideanDomain;
- (BOOL) isCoprime:b;
- (BOOL) notCoprime:b;
- (BOOL) isGcd:a:b;
- (BOOL) isLcm:a:b;
- gcd:b;
- bezout:b gcd:(id *)gcd;
- lcm:b;

- modulo:m;
- multiply:b modulo:m;
- squareModulo:m;
- power:(int)n modulo:m;
- inverseModulo:m;

- random;

- (int) characteristic;
- (BOOL) isCharacteristicZero;
- (BOOL) notCharacteristicZero;
- (BOOL) isCharacteristicTwo;
- (BOOL) notCharacteristicTwo;
- frobenius;
- frobeniusInverse;
- (int) dimensionOverPrimeField;

- (BOOL) inRing;
- (BOOL) inIntegralDomain;
- (BOOL) inField;
- (BOOL) inFieldOfFractions;

- scalarZero;
- scalarContent;
- divideScalarContent;
- multiplyScalar:s;
- divideScalar:s;
- addScalar:s;
- subtractScalar:s;

- (BOOL) printsLeadingSign;
- (BOOL) printsSum;
- (BOOL) printsProduct;
- printOn:(IOD)aFile;
- fileOutOn:aFiler;
- fileInFrom:aFiler;
- addReference;			/* Obsoleted, use -cheapCopy */

@end

id idReplace(id o, id n);

#endif				/* __CAOBJECT_HEADER__ */

