
/*
 * Copyright (c) 1998 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: condxpr.m,v 1.2 1999/08/10 22:36:44 stes Exp $
 */

#include "config.h"
#include <stdlib.h>
#include <assert.h>
#ifndef __OBJECT_INCLUDED__
#define __OBJECT_INCLUDED__
#include <stdio.h> /* FILE */
#include "Object.h" /* Stepstone Object.h assumes #import */
#endif
#include "node.h"
#include "expr.h"
#include "condxpr.h"

@implementation CondExpr

- expr:aRcvr
{
  expr = aRcvr;
  return self;
}

- lhs:args
{
  lhs = args;
  return self;
}

- rhs:args
{
  rhs = args;
  return self;
}

- (int)lineno
{
  return [expr lineno];
}

- filename
{
  return [expr filename];
}

- typesynth
{
  type = [lhs type];
#if 0
  /* warn about (t)?t:NULL */
  if (![[rhs type] isEqual:type])
    warn("types in conditional expr not equal");
#endif
  return self;
}

- synth
{
  [expr synth];
  [lhs synth];
  [rhs synth];
  return self;
}

- gen
{
  [expr gen];
  gc('?');
  [lhs gen];
  gc(':');
  [rhs gen];
  return self;
}

- st80
{
  gc('(');
  gc('(');
  [expr st80];
  gc(')');
  gs("ifTrue:[");
  [lhs st80];
  gs("]ifFalse:[");
  [rhs st80];
  gc(']');
  gc(')');
  return self;
}

@end
 
