// DialogString.cpp : implementation file
//

#include "stdafx.h"
#include "OzAPI.h"
#include "DialogString.h"
#include <string.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDialogString dialog


CDialogString::CDialogString(CWnd* pParent /*=NULL*/)
	: CDialog(CDialogString::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDialogString)
	m_text = _T("");
	m_value = _T("");
	//}}AFX_DATA_INIT
}


void CDialogString::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDialogString)
	DDX_Text(pDX, IDC_DLG_STR_TEXT, m_text);
	DDX_Text(pDX, IDC_DLG_STR_VALUE, m_value);
	DDV_MaxChars(pDX, m_value, m_length);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDialogString, CDialog)
	//{{AFX_MSG_MAP(CDialogString)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDialogString message handlers




///////////////////  FORTRAN /////////////////////////////////////

extern "C" void ozstringdlg (char* prompt, char* text, long* length)
{
	CDialogString  dlg;
	char*	out;
	int		outLen;
	int		i;
	unsigned int	size = *length;


	if (size < 1)
		OzFatalError ("ozstringdlg - illegal length");
	if (strlen(text) >= size)
		OzFatalError ("ozstringdlg - illegal length initial string");
	dlg.m_text = prompt;
	dlg.m_value = text;
	dlg.m_length = size;
	if (dlg.DoModal() == IDOK)
	{
		out = (char*) LPCSTR(dlg.m_value);
		outLen = strlen(out);
		if (outLen > size)
			outLen = size;
		for (i=0; i<outLen; i++)
			text[i] = out[i];
		for (i=outLen; i<size; i++)
			text[i] = ' ';
	}


}

void CDialogString::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
		this->GetDlgItem(IDC_DLG_STR_VALUE)->SetFocus();

	
	// Do not call CDialog::OnPaint() for painting messages
}
