// gksText.cpp : implementation of the CgksMarker class
//					markers are single characters from a symbol font
//

#include "stdafx.h"

#include "OzAPIDoc.h"
#include "OzAPIView.h"
#include "gksObject.h"
#include "gksLine.h"
#include "OzGKS.h"
#include "gksMarker.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif



CgksMarker::CgksMarker(float* x, float* y, long num, 
					   char marker, float size, int colour) :
	CgksLine(x, y, num, 1, 1, 0)

{
	m_objType = gksMarker;
	m_char = marker; 
	m_size = size;
	m_colour = colour;
	m_minNum = 1;
	this->Transform();

}

// draw on screen.

BOOL CgksMarker::Draw(CDC* pDC)
{
	int	i, num;
	int	height;
	// centred, aligned at base, marker font
	height = GKStext(pDC, m_size, 1.0, 2, 4, NUM_FONTS, m_colour, TRUE);
	num = m_screenPoint.GetSize();
	for (i=0; i<num; i++)
		pDC->TextOut(m_screenPoint[i].x, m_screenPoint[i].y+height/3, &m_char, 1);
	return TRUE;
}


//  change attributes

void CgksMarker::Attributes(float newSize, int newColour)
{
	m_size = newSize;
	m_colour = newColour;
}
