#pragma hdrstop

#include <condefs.h>
#include <stdio.h>

#include <set>
using namespace std;

#include "refcnt.hpp"

class test {
public:
	int i;

	test(int p = 0) : i(p) {}
	~test() { ::printf("deleted %d\n", i); }

	bool operator==(const test& rhs) const { return i == rhs.i; }
	bool operator<(const test& rhs) const { return i < rhs.i; }
};

typedef key_smart_ref< test > test_t;
typedef set< test_t, less<test_t> > set_t;

static void print(set_t& t, const char* name) {
	::printf(name);
	set_t::iterator i = t.begin();
	while(i != t.end()) {
		::printf(" (%d,%d,%d)", (*i)->i, (*i).counter(), (*i).accessed());
		i++;
	}
	::printf("\n");
}

void main(void) {
	set_t *t1 = new set_t, *t2 = new set_t;
	for(register i = 0; i < 9; i++) {
		test_t t(new test(i));
		t1->insert(t);
		t2->insert(t);
	}
	::printf("after insertion:\n");
	::print(*t1, "t1");
	::print(*t2, "t2");
	delete t2;
	::printf("t2 deleted:\n");
	::print(*t1, "t1");
	::printf("deleting t1:\n");
	delete t1;
}

#define WinMain
