#include <windows.h>
#include <stdio.h>


#ifdef REVLIB_UTILS
	int getreg_main
#else
	void _ExceptInit(void) {}
	int main
#endif
(int argc, char *argv[])
{

	char *extension;
	HKEY  hkResult;
	long status;
	DWORD index;

	LPTSTR  	doctype[512];
	LPTSTR  	docopen_commandstring[1024];
	DWORD    valtype,vallen;

	if (argc<2)
	{  fputs("getreg 0.5 - Get the command associated with a file extension\n",stdout);
		fputs("Usage: getreg .extension\nNote: the parametre should normally include a dot\n",stdout);
		return 1;
	}

	extension=argv[1];

	status=RegOpenKeyEx(
						HKEY_CLASSES_ROOT,
						extension,
						0,	// reserved
						KEY_QUERY_VALUE,
						&hkResult );
	if (status!=ERROR_SUCCESS)
	{	fputs("No success on lookup of key HKEY_CLASSES_ROOT\\",stderr);
		fputs(extension,stderr);
		fputs("\n",stderr);
		return 1;
	}

	/* how does the system call know the size of the buffer?  Maybe
		the len is used in both directions */
	vallen=sizeof(doctype);
	status = RegQueryValueEx(
						hkResult,	// handle of open key
						"",	// address of name of value
						0,	// reserved
						&valtype,
						doctype,
						&vallen  );
	if (status!=ERROR_SUCCESS)
	{	fputs("No success on lookup for value of HKEY_CLASSES_ROOT\\",stderr);
		fputs(extension,stderr);
		fputs("\n",stderr);
		return 2;
	}

	/* now we know "doctype", try to do lookup of the keys
		%doctype%\shell\open\command
	*/
	status=RegOpenKeyEx(
						HKEY_CLASSES_ROOT,
						doctype,
						0,	// reserved
						KEY_QUERY_VALUE,
						&hkResult );
	if (status!=ERROR_SUCCESS)
	{	fputs("No success on lookup of key HKEY_CLASSES_ROOT\\",stderr);
		fputs(doctype,stderr);
		fputs("\n",stderr);
		return 3;
	}
	status=RegOpenKeyEx(
						hkResult,
						"shell",
						0,	// reserved
						KEY_QUERY_VALUE,
						&hkResult );
	if (status!=ERROR_SUCCESS)
	{	fputs("No success on lookup of key HKEY_CLASSES_ROOT\\",stderr);
		fputs(doctype,stderr);
		fputs("\\shell\n",stderr);
		return 4;
	}
	status=RegOpenKeyEx(
						hkResult,
						"open",
						0,	// reserved
						KEY_QUERY_VALUE,
						&hkResult );
	if (status!=ERROR_SUCCESS)
	{	fputs("No success on lookup of key HKEY_CLASSES_ROOT\\",stderr);
		fputs(doctype,stderr);
		fputs("\\shell\\open\n",stderr);
		return 4;
	}
	status=RegOpenKeyEx(
						hkResult,
						"command",
						0,	// reserved
						KEY_QUERY_VALUE,
						&hkResult );
	if (status!=ERROR_SUCCESS)
	{	fputs("No success on lookup of key HKEY_CLASSES_ROOT\\",stderr);
		fputs(doctype,stderr);
		fputs("\\shell\\open\\command\n",stderr);
		return 4;
	}

	/* how does the system call know the size of the buffer?  Maybe
		the len is used in both directions */
	vallen=sizeof(docopen_commandstring);
	status = RegQueryValueEx(
						hkResult,	// handle of open key
						"",	// address of name of value
						0,	// reserved
						&valtype,
						docopen_commandstring,
						&vallen  );
	if (status!=ERROR_SUCCESS)
	{	fputs("No success on lookup for value of HKEY_CLASSES_ROOT\\",stderr);
		fputs(doctype,stderr);
		fputs("\\shell\\open\\command\n",stderr);
		return 5;
	}
	if (!strstr(docopen_commandstring,"%1")) strcat(docopen_commandstring," %1");

	fputs(docopen_commandstring,stdout);
	return 0;
}

