
/*
  SCRIPTOL LIBRARY
  (c) 2002 by Denis G. Sureau
  http://www.scriptol.com
  http://www.scriptol.net

GENERAL PUBLIC LICENCE

Along with the free Scriptol to native compiler is
provided the libsol.a library. The library contains
the TEXT, DYN and ARRAY classes and lot of functions
compatibles with the Php library.
This library is the orginal work of Denis G. Sureau.
It has been registered at INPI 25 june 2002.
The Php compatible functions are original work. They
have nothing to do with Php sources.
The source of the library is furnished to registered
user of the compiler, enterprise edition.

The library is provided to allow the user to link it
with its Scriptol compiled program. He is allowed to
include the library in its program and distribute its
programs with the library included into, with no any
fee required and no any restriction or condition.

He is not allowed to distribute the library as it but
in the case of an open-source program. The library may
be included unchanged among other files of the open
source distribution and headers of the file to include,
libsol.hpp, text.hpp, dyn.hpp, array.hpp, fun.hpp and
other files, must be included unchanged, and must hold
my name and the address of the Scriptol site.

The source of the library is provided to licensed users
to allow them either to modify it according to their need,
or to compile it in a different file format, for a different
compiler. The registered user is not permitted to
distribute the source of the library in no any case, even
if is is modified.
*/


#ifndef _DYN_HEADER
#define _DYN_HEADER

#define TYPE_UNKNOW 0
#define TYPE_BYTE  1
#define TYPE_BOOL 2
#define TYPE_INT 3
#define TYPE_LONG 4
#define TYPE_REAL 5
#define TYPE_DOUBLE 6
#define TYPE_COMPLEX 7
#define TYPE_NUMBER 10
#define TYPE_TEXT 12
#define TYPE_ARRAY 32
#define TYPE_DICT  64
#define TYPE_PAIR 13
#define TYPE_FILE 14
#define TYPE_DIR 15
#define TYPE_OBJECT 31

class item;
class dyn;
class sol_pair;
class array;
class text;

class object
{
  public:
  object() { }
};

ostream& operator<< (ostream& out, dyn );
ostream& operator<< (ostream& out, dyn *);

extern dyn Nil;

class dyn
 {
  public:
  int flag;

  union
  {
   bool b;        // bool for error
   double n;
   text *t;
   array *a;
//   dict *di;
   sol_pair *p;
   FILE *f;
   object *o;
   DIR *dir;
  };

  static dyn error;

  void set(unsigned char a);
  void set(char);
  void set(bool);
  void set(int);
  void set(unsigned int);
  void set(long);
  void set(float);
  void set(double);
  void set(const char *);
  void set(text);
  void set(text *);
  void set(dyn);
  void set(dyn *);
  void set(sol_pair *);
  void set(array *);
  void set(array);
//  void set(dict);
  void set(FILE *);
  void set(DIR *);

  dyn()  { flag = 0; b = false; }
  template<class ANY> dyn(ANY a) { set(a); }

  inline bool isPair()   { return flag == TYPE_PAIR; }
  inline bool isInt()    { return flag == TYPE_INT;    }
  inline bool isInteger()    { return flag == TYPE_INT;    }
  bool isNumber();
  inline bool isText()   { return flag == TYPE_TEXT; }
  inline bool isArray()  { return flag == TYPE_ARRAY; }
  inline bool isBoolean()   { return flag == TYPE_BOOL; }
  inline bool isFile()   { return flag == TYPE_FILE; }

  int len();
  int size();

  array    *doArray();
  bool     doBoolean();
  int      doInt();
  double   doReal();
  text     doText();      // any data
  array    *doDict();
  FILE     *doFile();
  text     doFunction();
  object   *doObject();

  bool     toBoolean();
  int      toInt();
  double   toReal();
  sol_pair *toPair();
  array    *toArray();
  text     toText();      // any data
  char     *toStr();      // any data
  array    *toDict();
  FILE     *toFile();
  text     toFunction();
  object   *toObject();

  static bool    toBoolean(dyn d);
  static int     toInt(dyn d);
  static double  toReal(dyn d);
  static double  toNumber(dyn d);
  static char    *toStr(dyn d);
  static array   *toArray(dyn d);
  static array   *toDict(dyn d);
  static sol_pair *toPair(dyn d);
  static text    toText(dyn d);
  static FILE    *toFile(dyn d);

  bool equal(double, const char *);
  bool equal(double, text *);
  static bool isNumber(const char *);
  static bool isNumber(text t);
  static bool isNumber(text *t);
  double toReal(const char *);

  void clone(dyn);

  template<class ANY> void operator=(ANY a) { set(a); }

  double operator+(int);
  double operator+(double);
  char *operator+(const char *);
  text operator+(text);
  dyn operator+(dyn);
  array operator+(array);
//  array operator+(array *);

  double operator-(int);
  double operator-(double);
  dyn operator-(dyn);
  array  operator-(array);
//  array operator-(array *);

  double operator*(int);
  double operator*(double);
  double operator*(dyn);

  double operator/(int);
  double operator/(double);
  double operator/(dyn);

  double operator%(int);
  double operator%(double);
  double operator%(dyn);

  bool operator==(dyn);
  bool operator==(dyn *);
  bool operator==(int);
  bool operator==(double);
  bool operator==(const char *);
  bool operator==(text);
  bool operator==(bool);
  bool operator==(array);
//  bool operator==(dict);

  bool operator!=(int);
  bool operator!=(double);
  bool operator!=(dyn);
  bool operator!=(dyn *);
  bool operator!=(const char *);
  bool operator!=(text);
  bool operator!=(bool);
  bool operator!=(array);
//  bool operator!=(dict);

  bool operator<(int);
  bool operator<(double);
  bool operator<(dyn);
  bool operator<(dyn *);
  bool operator<(const char *);
  bool operator<(text);
  bool operator<(bool);
  bool operator<(array);
//  bool operator<(dict);

  bool operator>(int);
  bool operator>(double);
  bool operator>(dyn);
  bool operator>(dyn *);
  bool operator>(const char *);
  bool operator>(text);
  bool operator>(bool);
  bool operator>(array);
//  bool operator>(dict);

  template<class ANY> bool operator>=(ANY b) { return !operator<(b); }
  template<class ANY> bool operator<=(ANY b) { return !operator>(b); }

  void operator+=(dyn);
  void operator+=(int);
  void operator+=(double);
  void operator+=(const char *);
  void operator+=(const text &);
  void operator+=(array);
//  void operator+=(dict);

  void operator-=(dyn);
  void operator-=(int);
  void operator-=(double);
  void operator-=(array);
//  void operator-=(dict);

  void operator*=(dyn);
  void operator*=(int);
  void operator*=(double);

  void operator/=(dyn);
  void operator/=(int);
  void operator/=(double);

  void operator<<=(int);
  void operator>>=(int);


  bool operator!();

  dyn at(int);
  dyn at(text);
  dyn at(const char *);
  dyn  operator[](int);
  dyn  operator[](text);
  dyn  operator[](const char *);
  dyn  operator[](dyn);
  void setAt(int, dyn);
  void setAt(int, text);
  void setAt(int, const char *);

  static bool nil(dyn);
  static bool nil();
  static dyn dummyNil;
  void setFalse() { flag = TYPE_BOOL; b = 0; }
  static int nil(int a) { return a; }

  //===== text

  text trim();
  text lTrim();
  text rTrim();
  text lower();
  text upper();

  void cat(char *);
  void cat(dyn);
  void cat(text);

  //===== array: iterators
  void reset();
  dyn  inc();
  dyn  dec();
  dyn  value();
  dyn  key();
  dyn  begin();
  dyn  end();

  //==== stack
  void push(dyn);
  dyn pop();
  dyn shift();
  void unshift(dyn);

  array slice(int, int, int);
  void splice(int, int, array, int);
  double sum();

  //=====
  void display();
  static text str(dyn);

  int nomatch();
  void boolToNum();
};

void error();
void error(char *e);

template<class ANY> bool operator==(ANY a, dyn b) { return b == a; }
template<class ANY> bool operator!=(ANY a, dyn b) { return b != a; }
template<class ANY> bool operator<=(ANY a, dyn b) { return b > a; }
template<class ANY> bool operator>=(ANY a, dyn b) { return b < a; }
template<class ANY> bool operator<(ANY a, dyn b)  { return b > a; }
template<class ANY> bool operator>(ANY a, dyn b)  { return b < a; }
template<class ANY> dyn operator+(ANY a, dyn b)   { return dyn(a) + b; }
template<class ANY> dyn operator-(ANY a, dyn b)   { return dyn(a) - b; }
template<class ANY> dyn operator*(ANY a, dyn b)   { return b * a; }
template<class ANY> dyn operator/(ANY a, dyn b)   { return dyn(a) / b; }
template<class ANY> int operator&(ANY a, dyn b)   { return b & a; }
template<class ANY> int operator|(ANY a, dyn b)   { return b | a; }
template<class ANY> void operator+=(ANY a, dyn b) { return dyn(a) += b; }
template<class ANY> void operator-=(ANY a, dyn b) { return dyn(a) -= b; }
template<class ANY> void operator*=(ANY a, dyn b) { return b *= a; }
template<class ANY> void operator/=(ANY a, dyn b) { return dyn(a) /= b; }
template<class ANY> int operator&=(ANY a, dyn b)  { return b &= a; }
template<class ANY> int operator|=(ANY a, dyn b)  { return b |= a; }
template<class ANY> bool operator&&(ANY a, dyn b) { return b && a; }
template<class ANY> bool operator||(ANY a, dyn b) { return b || a; }

template<class ANY> ANY max(ANY a, ANY b) { return (a > b) ? a : b;  }
template<class ANY> ANY min(ANY a, ANY b) { return (a < b) ? a : b;  }

#endif

