
include "image.sol"

` Example using the "image" class
` if a filename is given as argument, load the (jpg) file
` else create an image from scratch

print "Writing a text into an image"
print "Require PHP v.4.06 for Jpeg"
print "usage: give an original jpeg filename as argument"

Image myimage(0,0)

print "Your configuration:"
myimage.checkSupport()
print

int black = 0

` load or create

array arglist = $argv
if (arglist.size() > 1)
  myimage.loadJpg(arglist[1])
  black = myimage.createColor(0, 0, 0)    ` make pen color
  print arglist[1], "loaded"
else
  myimage.create(88,31)
  black = myimage.createColor(0, 0, 0)         ` make black
  int white = myimage.createColor(255,255,255)
  int green = myimage.createColor(0, 192, 0)   ` make green
  myimage.fill(green)                  ` background
  myimage.line(0,0,87,0, white)        ` borders
  myimage.line(0,0,0,30, white)
  myimage.line(0,30,87,30, black)
  myimage.line(87,0,87,30, black)
  print "image created"
/if

` Now, writing a label either on the loaded image
` or the created one

myimage.setFont(5)                    ` select a font among 1-5
myimage.write(28, 8, "Home", black)   ` put the label

print "text written"

myimage.saveJpg("image2.jpg")

print "image2.jpg saved"
print "width=", myimage.width
print "height=", myimage.height
