/*
    Scriptol Gui using Java Demo
    That's a template for your scriptol with gui programs
    reuse it freely
*/

include "Path.sol"

import java.lang.System
import java.awt.Button
import java.awt.TextField
import java.awt.Panel
import java.awt.Label
import java.awt.Menu
import java.awt.MenuBar
import java.awt.MenuItem
import java.awt.Font
import java.awt.FileDialog
import java.awt.Choice

import java AListen        ` class created for events
import java IListen        ` for item selection

extern
  class java.awt.Frame
    boolean visible
    void setSize(int, int)
    void setLocation(int, int)
    void show()
    void setTitle(text)
    void validate()
    void dispose()
    void add(dyn, dyn = nil)
    void sleep(int)
    void setMenuBar(MenuBar)
  /class
/extern

` these java constants must be defined as Php doesn't recognize static attributes

enum PLAIN, BOLD, ITALIC
enum LOAD, SAVE
enum ACTION_OPEN, ACTION_SAVE, ACTION_EXIT


class UserInterface
   Frame gui              ` main windows
   AListen jd             ` java event listener
   IListen il             ` java item selection listener
   int BUTTON_CLICK
   int BUTTON_EXIT
   int BUTTON_JAVA
   int BUTTON_OS
   int MENU_OPEN
   int MENU_SAVE
   int MENU_EXIT
   int MENU_HELP
   int CHOICE_LIST
   Label lab("")
   TextField myText("Hello world of Scriptol programmers!")
   MenuBar mainMenu
   Font menuFont("Dialog", PLAIN, 16)
   Font textFont("Dialog", PLAIN, 18)
   Menu menuFile("File")
   Choice choiceSquare


   void UserInterface()

     gui.setTitle("Scriptol Gui Demo with events")
     gui.setSize(400,300)
     gui.setLocation(50,50)
     gui.setMenuBar(mainMenu)

     // Menu file

     menuFile.setFont(menuFont)

     MenuItem miOpen("Open")
     miOpen.setFont(menuFont)
     menuFile.add(miOpen)
     MENU_OPEN = jd.add(miOpen)

     MenuItem miSave("Save")
     miSave.setFont(menuFont)
     menuFile.add(miSave);
     MENU_SAVE = jd.add(miSave)

     menuFile.addSeparator();
  
     MenuItem miExit("Exit");
     miExit.setFont(menuFont);
     menuFile.add(miExit);
     MENU_EXIT = jd.add(miExit)

     mainMenu.add(menuFile);

     `` Menu help

     Menu menuHelp("Help")
     menuHelp.setFont(menuFont);
     mainMenu.setHelpMenu(menuHelp);
     mainMenu.add(menuHelp);

     MenuItem miHelp("Help")
     miHelp.setFont(menuFont);
     menuHelp.add(miHelp)
     MENU_HELP = jd.add(miHelp)

     `` Window

     Panel myPanel
     myPanel.setLayout(null)
     myPanel.setFont(menuFont)
     gui.add("Center", myPanel)

     Label title("Type some text here:")
     title.setBounds(16,16, 200, 20)
     myPanel.add(title)

     myText.setBounds(16, 40, 250, 24)
     myPanel.add(myText)

     Button bClick("Click me")
     bClick.setBounds(8, 120, 84, 32)
     myPanel.add(bClick)
     BUTTON_CLICK = jd.add(bClick)

     Button bJava("Java")
     bJava.setBounds(101, 120, 84, 32)
     myPanel.add(bJava)
     BUTTON_JAVA = jd.add(bJava)

     Button bOs("Os version")
     bOs.setBounds(192, 120, 100, 32)
     myPanel.add(bOs)
     BUTTON_OS = jd.add(bOs)

     Button bExit("Exit")
     bExit.setBounds(298, 120, 84, 32)
     myPanel.add(bExit)
     BUTTON_EXIT = jd.add(bExit)

     lab.setBounds(16, 80, 300, 24)
     lab.setFont(textFont)
     myPanel.add(lab)

     choiceSquare.setBounds(32, 180, 48, 22)
     choiceSquare.addItem("3x")
     choiceSquare.addItem("5x")
     choiceSquare.addItem("7x")
     CHOICE_LIST = il.add(choiceSquare)
     myPanel.add(choiceSquare)
     choiceSquare.select("3x")

     gui.validate()

   return

   void show() : gui.setVisible(true); return
   void close()
      gui.dispose()
   return

   void setAction(AListen j) : jd = j;  return
   void setFrame(Frame f) : gui = f; return
   Frame getFrame() return gui
   AListen getAction() return jd
   IListen getItem() return il
   text getText() return myText.getText()

   void setText(text t)
     lab.setText(t)
   return

   void choiceUpdate()
     text t = choiceSquare.getSelectedItem()
     lab.setText(t + " selected")
   return

/class


` interface to file dialog box

class FileDemo
  text fileName
  text dirName
  text pathName
  text extension
  Frame gui

  void setFrame(Frame f) : gui = f; return
  void setGui(UserInterface ui)
    gui = ui.getFrame()
  return

  boolean loadDialog(text title)
    FileDialog fd(gui, title, LOAD)
    fd.setDirectory(".")
    fd.show()

    fileName  = fd.getFile()
    dirName   = fd.getDirectory()
    pathName  = Path.merge(dirName, fileName)
    extension = Path.getExtension(fileName)
  return fileName != null

  boolean actionOpen()
   if not loadDialog("Load") return false
  return true

  boolean actionSave()
   if not loadDialog("Save") return false
  return true


/class


` main loop

void main()

  UserInterface user
  AListen click
  IListen item
  System infos
  FileDemo filer

  click  = user.getAction()
  item = user.getItem()
  filer.setGui(user)

  user.show()

  int code
  int state


  ` select action according to button or menu clicked

  while forever
    state = click.getState()
    if state != 0
      code = click.getCode()
      click.setState(0)
      if code
      = user.BUTTON_EXIT:   break
      = user.BUTTON_CLICK:  user.setText(user.getText())
      = user.BUTTON_JAVA:
         user.setText("Java " + infos.getProperty("java.version"))
      = user.BUTTON_OS:
         user.setText("OS " + infos.getProperty("os.name") + " " + infos.getProperty("os.version"))
      = user.MENU_OPEN:
                            filer.actionOpen()
                            user.setText(filer.fileName + " selected for loading");
      = user.MENU_SAVE:
                            filer.actionSave()
                            user.setText(filer.fileName + " selected for saving)");
      = user.MENU_EXIT:     break
      = user.MENU_HELP:     user.setText("Help selected")
      else
        print "unknow command"
      /if
    /if

    state = item.getState()
    if state <> 0
       code = item.getCode()
       item.setState(0)
       if code
       = user.CHOICE_LIST:  user.choiceUpdate()
       /if
    /if

  /while

  user.close()
  exit()

return

main()

