/*
 * Decompiled with CFR 0.152.
 */
package stec.ss;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import stec.ss.ssByteArray;

final class ssBuffer
extends ssByteArray {
    private static final String _ = "Copyright (c) 1997-1999 Manuel J. Goyenechea. All rights reserved.";
    private int length;
    private int index;
    private int mark;

    protected ssBuffer() {
        this(32);
    }

    protected ssBuffer(int n) {
        super(n);
        this.length = 0;
        this.index = 0;
        this.mark = 0;
    }

    protected ssBuffer(byte[] byArray) {
        super(byArray);
        this.index = this.length = byArray.length;
        this.mark = 0;
    }

    protected ssBuffer(byte[] byArray, int n, int n2) {
        super(byArray, n, n2);
        this.index = this.length = byArray.length - this.index;
        this.mark = 0;
    }

    protected ssBuffer(ssBuffer ssBuffer2) {
        this(ssBuffer2.getBuffer());
    }

    protected ssBuffer(ssBuffer ssBuffer2, int n, int n2) {
        this(ssBuffer2.getBuffer(), n, n2);
    }

    protected ssBuffer(String string) {
        this(string.getBytes());
    }

    protected ssBuffer(String string, int n, int n2) {
        this(string.getBytes(), n, n2);
    }

    protected final void clear() {
        this.length = 0;
        this.index = 0;
        this.mark = 0;
    }

    protected final int length() {
        return this.length;
    }

    protected final void setLength(int n) {
        this.ensureCapacity(n);
        if (this.length < n) {
            while (this.length < n) {
                super.setByteAt(this.length, (byte)0);
                ++this.length;
            }
        }
        this.length = n;
    }

    protected final int capacity() {
        return super.length();
    }

    protected final void ensureCapacity(int n) {
        if (n > super.length()) {
            n = Math.max(super.length() << 1, n);
            byte[] byArray = new byte[n];
            System.arraycopy(super.getByteArray(), 0, byArray, 0, this.length);
            super.setByteArray(byArray);
        }
    }

    protected final int mark() {
        this.mark = this.index;
        return this.mark;
    }

    protected final int reset() {
        this.index = this.mark;
        this.mark = 0;
        return this.index;
    }

    protected final int reset(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.length) {
            n = this.length;
        }
        this.index = n;
        this.mark = 0;
        return this.index;
    }

    protected final int skip(int n) {
        if (n <= 0) {
            return 0;
        }
        if (this.index + n > this.length) {
            n = this.length - this.index;
        }
        this.index += n;
        return n;
    }

    protected final int pushBack(int n) {
        if (n <= 0) {
            return 0;
        }
        if (n > this.index) {
            n = this.index;
        }
        this.index -= n;
        return n;
    }

    protected final int seek(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.length) {
            n = this.length;
        }
        this.index = n;
        return n;
    }

    protected final int available() {
        return this.length - this.index;
    }

    protected final int getIndex() {
        return this.index;
    }

    protected final int setIndex(int n) {
        this.index = n;
        return this.index;
    }

    protected final byte[] getBuffer() {
        return super.getByteArray();
    }

    protected final void setBuffer(byte[] byArray) {
        super.setByteArray(byArray);
        this.index = this.length = byArray.length;
        this.mark = 0;
    }

    protected final byte[] toByteArray() {
        byte[] byArray = new byte[this.length];
        System.arraycopy(super.getByteArray(), 0, byArray, 0, this.length);
        return byArray;
    }

    public final String toString() {
        return new String(super.getByteArray(), 0, this.length);
    }

    protected final byte read() {
        if (this.index < this.length) {
            return super.getByteAt(this.index++);
        }
        return -1;
    }

    protected final int read(byte[] byArray, int n, int n2) {
        if (n2 <= 0) {
            return 0;
        }
        if (this.index >= this.length) {
            return -1;
        }
        if (this.index + n2 > this.length) {
            n2 = this.length - this.index;
        }
        System.arraycopy(super.getByteArray(), this.index, byArray, n, n2);
        this.index += n2;
        return n2;
    }

    protected final String getString(int n) throws IOException {
        if (n <= 0) {
            return "";
        }
        if (this.index + n > this.length) {
            throw new EOFException();
        }
        if (this.index + n > this.length) {
            n = this.length - this.index;
        }
        String string = new String(super.getByteArray(), this.index, n);
        this.index += n;
        return string;
    }

    protected final int readInt() throws IOException {
        if (this.index + 4 > this.length) {
            throw new EOFException();
        }
        int n = super.getIntAt(this.index);
        this.index += 4;
        return n;
    }

    protected final long readLong() throws IOException {
        if (this.index + 8 > this.length) {
            throw new EOFException();
        }
        long l = super.getLongAt(this.index);
        this.index += 8;
        return l;
    }

    protected final double readDouble() throws IOException {
        if (this.index + 8 > this.length) {
            throw new EOFException();
        }
        int n = this.index;
        double d = Double.longBitsToDouble(this.getLongAt(n));
        this.index += 8;
        return d;
    }

    protected final boolean readBoolean() throws IOException {
        if (this.index + 1 > this.length) {
            throw new EOFException();
        }
        boolean bl = super.getBooleanAt(this.index);
        ++this.index;
        return bl;
    }

    protected final byte readByte() throws IOException {
        if (this.index + 1 > this.length) {
            throw new EOFException();
        }
        byte by = super.getByteAt(this.index);
        ++this.index;
        return by;
    }

    protected final char readChar() throws IOException {
        if (this.index + 2 > this.length) {
            throw new EOFException();
        }
        char c = super.getCharAt(this.index);
        this.index += 2;
        return c;
    }

    protected final void write(byte by) {
        int n = this.index + 1;
        this.ensureCapacity(n);
        super.setByteAt(this.index, by);
        this.index = n;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void write(byte[] byArray, int n, int n2) {
        int n3 = this.index + n2;
        this.ensureCapacity(n3);
        super.setBytes(this.index, byArray, n, n2);
        this.index = n3;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeString(String string) {
        int n = this.index + string.length();
        this.ensureCapacity(n);
        super.setBytes(this.index, string.getBytes(), 0, string.length());
        this.index = n;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeInt(int n) {
        int n2 = this.index + 4;
        this.ensureCapacity(n2);
        super.setIntAt(this.index, n);
        this.index = n2;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeLong(long l) {
        int n = this.index + 8;
        this.ensureCapacity(n);
        super.setLongAt(this.index, l);
        this.index = n;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeDouble(double d) {
        int n = this.index + 8;
        this.ensureCapacity(n);
        int n2 = this.index;
        this.setLongAt(n2, Double.doubleToLongBits(d));
        this.index = n;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeBoolean(boolean bl) {
        int n = this.index + 1;
        this.ensureCapacity(n);
        super.setBooleanAt(this.index, bl);
        this.index = n;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeByte(byte by) {
        int n = this.index + 1;
        this.ensureCapacity(n);
        super.setByteAt(this.index, by);
        this.index = n;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeChar(char c) {
        int n = this.index + 2;
        this.ensureCapacity(n);
        super.setCharAt(this.index, c);
        this.index = n;
        if (this.index > this.length) {
            this.length = this.index;
        }
    }

    protected final void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(super.getByteArray(), 0, this.length);
    }

    protected final byte peek() throws IOException {
        if (this.index + 1 > this.length) {
            throw new EOFException();
        }
        return super.getByteAt(this.index);
    }
}

