/*
 * @(#)iscript.h 1.0.0
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Servertec ("Confidential Information").  You shall not disclose
 * such Confidential Information and shall use it only in accordance
 * with the terms of the license agreement you entered into with
 * Servertec.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

#define PACKAGE "stec.ss."

#ifdef _WIN32
#include <windows.h>
#include <process.h>
#endif

#include <stdio.h>
#include <string.h>
#include <errno.h>

#define JAVA "java"
#define SPACE " "
#define PATHSIZE 256
#define MSVM "jview"

void error(char *msg)
{
    fprintf(stderr, "%s\n", msg);
    exit(-1);
}

int main( int argc, char *argv[], char *envp[] )
{
    char *java_exe;
	char *classpath;
    char buf[2048];
	char **envarg;
	int rc;
	char *envfilenm;
	FILE *envFH;

	int l;
	int j;
	char *p;

#ifdef _WIN32
    char **args, **ap;

	boolean usingMSVM;
	int lMSVM;
	int i;
#else
	char command[2048];
#endif

	// setup java
	java_exe = (char *)getenv("JAVA_EXE");
    if (java_exe == 0)
		error("JAVA_EXE is not defined");

#ifdef _WIN32
	// strip quotes
	l = strlen(java_exe);
	p = (char *)malloc((l+1) * sizeof(char));

	j = 0;

	for(i = 0; i < l; i++)
	{
		if(java_exe[i] != '"')
		{
			p[j++] = java_exe[i];
		}
	}

	p[j] = 0x00;
	java_exe = p;

	// which java vm, microsoft/javasoft
	usingMSVM = FALSE;
	p = java_exe;
	lMSVM = strlen(MSVM);
	l = strlen(java_exe) - lMSVM + 1;
	for(i = 0; i < l; i++)
	{
		if(strnicmp(p, MSVM, lMSVM) == 0)
		{
			usingMSVM = TRUE;
			break;
		}

		p++;
	}

	// setup java executable
    ap = args = (char **)malloc((argc + 5) * sizeof(char *));
    *ap++ = strdup(java_exe);

	// setup args

	// setup classpath
	classpath = (char *)getenv("CLASSPATH");
    if (classpath == 0)
		error("CLASSPATH is not defined");

	if(!usingMSVM)
	{
	    sprintf(buf, "-classpath %s", classpath);
	    *ap++ = strdup(buf);
	}
#else
	// setup java executable
    strcpy(command, java_exe);

	// setup args

	// setup classpath
	classpath = (char *)getenv("CLASSPATH");
    if (classpath == 0)
		error("CLASSPATH is not defined");

    sprintf(buf, "-classpath %s", classpath);
    strcat(command, SPACE);
	strcat(command, buf);
#endif

	// setup env file
	envfilenm = (char *)tempnam(NULL, "~" CLASS);
	if(envfilenm == NULL)
		error( "Unable to create a temp filename" );

	envFH = fopen(envfilenm, "wb");

	// setup environmental variables
	
	envarg = envp;
	while(*envarg)
	{
		fprintf(envFH, "%s\n", *envarg++);
	}

	fflush(envFH);
	fclose(envFH);

#ifdef _WIN32
	if(usingMSVM)
		sprintf(buf, "/D:env=%s", envfilenm);
	else
		sprintf(buf, "-Denv=%s", envfilenm);

	*ap++ = strdup(buf);

	// setup CLASS executable
    *ap++ = strdup(PACKAGE CLASS);

	// setup user arguements
    while (--argc > 0)
		*ap++ = *++argv;

    *ap = 0;

	rc = spawnv(P_WAIT, args[0], args);
#else
	sprintf(buf, "-Denv=%s", envfilenm);
    strcat(command, SPACE);
	strcat(command, buf);

	// setup CLASS executable
    strcat(command, SPACE);
	strcat(command, PACKAGE CLASS);

	// setup user arguements
    while (--argc > 0)
	{
	    strcat(command, SPACE);
		strcat(command, *++argv);
	}

	rc = system(command);
#endif

	remove(envfilenm);
	free(envfilenm);

#ifdef __NEVER__
	if(rc != 0)
	{
		sprintf(buf, "errno: %d", errno);
		error(buf);
	}
#endif

	return rc;
}
