#include <iostream>
#include <map>
#include <algorithm>
#include <cmath>
using namespace std;

const int values[] = { 1,2,3,4,5 };
const int NVALS = sizeof values / sizeof (int);

struct intComp: public binary_function<int, int, bool>
{
	bool operator()(int a, int b) const
	{
		return a < b;
	}
};

int main()
{
	using namespace std;

	typedef map<int, double> valmap;
	typedef map<int *, double *> pmap;
	
	valmap m2(1,2,3);
	pmap m3(1,2,3);
	map<int, double, intComp> valmap3;

	valmap m;
	pmap p;
	
	for (int i = 0; i < NVALS; i++)
	{
		m.insert(make_pair(values[i], pow(values[i], .5)));
		valmap3.insert(0);
	}

	valmap::iterator it = 100;
	valmap::const_iterator cit = 100;
	
	m.insert(1,2);
	m.insert(make_pair(36, 10.57)); // fine, more convenient
	m.insert(m.end(), make_pair(40, 2.29)); // also fine
	return 0;
}

