/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * $Id: config.h,v 1.11 1993/05/10 06:08:55 anders Exp anders $
 */

/*
    This code modified for Win32 port by Ataman Software, Inc. June 29, 1995.
*/

/* Configurable values */


/* The macro MAXLEVELS is the maximum number of levels that the
 *   interpreter shall handle. One level is used for functioncalls and
 *   the commands CALL, IF, DO and SELECT
 */
#define MAXLEVELS        1024

/* The macro HASHTABLENGTH is the number of sloths in the hash table
 *   containing the values of the rexx variables
 */
#define HASHTABLENGTH     256

/* The macro MAX_INDEX_LENGTH defines the maximum length that the name
 *   of an compund variable might expand to.
 */
#define MAX_INDEX_LENGTH  256

/*
 * The macro DEFAULT_FLUSH_STACK can be defined to either 1 or 0,
 * depending on whether you want the stack to be flushed during a
 * command reading input from or writing output to the stack. If
 * defined, a line written will be physically in the stack at once,
 * while if not defined, all output lines will be temporarily stacked
 * until the command has terminated, then they are all simultaneously
 * flushed to the stack. The default default value is 0, it can be
 * changed through OPTIONS.
 */
#ifndef DEFAULT_FLUSHSTACK
# define DEFAULT_FLUSHSTACK 0
#endif

/*
 * The macro DEFAULT_LINEOUTTRUNC can be set to 1 or 0, whether you want
 * the default behavior of lineout() to truncate the file immediately
 * after the end of each new file written out. When set to 1, the file
 * will be truncated. Also note, that if HAS_FTRUNCATE isn't set later
 * in this script, the DEFAULT_LINEOUTTRUNC will be forced to 0, just
 * for consistency (then, setting it to 1 will have no practical effect.
 */
#ifndef DEFAULT_LINEOUTTRUNC
# define DEFAULT_LINEOUTTRUNC 1
#endif

/*
 * Whether the OPEN() and CLOSE() bifs are available by default
 */
#define DEFAULT_OPEN_BIF 1
#define DEFAULT_CLOSE_BIF 1

#define DEFAULT_MAKEBUF_BIF 1
#define DEFAULT_DROPBUF_BIF 1
#define DEFAULT_BUFTYPE_BIF 1
#define DEFAULT_DESBUF_BIF 1

#define DEFAULT_CACHEEXT 0
#define DEFAULT_PRUNE_TRACE 1

#define DEFAULT_FIND_BIF 1

/*
 * Define the following macro if you have 'struct timeval' and gettimeofday()
 *   these should be in /usr/include/sys/time.h
 */
#define HAS_TIMEVAL

/*
 * Define the following if your machine has putenv(), unfortunately,
 *   Standard C does not include a way to set environmentvariables, just
 *   to read them. But most machines have the putenv() function.
 * If it is not defined, you will not be able to set the environment
 *   variables throught the VALUE() builtin function.
 */
#define HAS_PUTENV

/*
 * The FILE_SEPARATOR is one character, and defines the char that separates
 *    directories, and filename from directories
 */

#if defined(MSDOS) || defined(WIN32)
# define FILE_SEPARATOR	   '\\'
#else
# define FILE_SEPARATOR    '/'
#endif


#define FIX_PROTOS
#define FIX_ALL_PROTOS



   /* don't properly include dyn. libraries, since they don't work yet */
#define CHEATING


extern unsigned char u_to_l[] ;
#define RXTOLOW(a) (u_to_l[(unsigned char)(a)])



#if defined(hpux) || defined(__hpux)
# define HPUX
# define YY_CHAR_TYPE unsigned char
/* # undef HAS_TIMEVAL */
#endif

#ifdef sun
# define SUNOS 1
#endif

#ifdef SunKludges
  char *get_sys_errlist( int num );
# define memmove(a,b,c) bcopy(b,a,c)
# define strerror(a)    get_sys_errlist(a)
#endif


#if defined(sgi) || defined(__sgi)
# define SGI 1
#endif

#if defined(__osf__)
# define OSF 1
# define YY_CHAR_TYPE unsigned char
#endif

/*
 * Define HAS_USLEEP if you have the usleep() function available. It will
 *    take the number of micro-seconds to sleep. If this is not defined,
 *    the 'normal' sleep() will be used.
 */

#ifdef SUNOS
#define HAS_USLEEP
#endif


/*
 * Define HAS_RANDOM if your machine has the routines random() and
 *    srandom(). If it is not defined, rand() and srand() are used
 *    instead. There are several reason why you might want to use
 *    random() instead of rand()
 */

#if SUNOS || ULTRIX
# define HAS_RANDOM
#endif

#ifdef HAS_RANDOM
  extern long random( void ) ;
  extern void srandom( int ) ;
#endif


#define DEFAULT_NUMERIC_FUZZ 0
#define DEFAULT_NUMERIC_SIZE 9
#define DEFAULT_MATH_TYPE 0


/*
 * If you use gcc on a machine that does not have proper ANSI C
 * libraries and the function div() is not defined, then you can
 * define the symbol HAS_NO_DIV, which will try to kludge it.
 *
 * This is necessary on Suns, and some other machines.
 */

/* #define HAS_NO_DIV */          /* does div() exist? */


#ifndef YY_CHAR_TYPE
# ifdef _AIX
#  define YY_CHAR_TYPE unsigned char
# else
#  define YY_CHAR_TYPE char
# endif
#endif


/* Unfortunately, ftruncate() is not POSIX, so if you don't have it,
 * just ignore it, the effect is that lines written to the middle of a
 * file will not cause the rest of the file (after the linefeed
 * terminating the line written), also to truncate the file at that
 * point. If you wonder whether you have ftruncate(), the bsd portions
 * of you system (if it exist) is a good place to start looking. You
 * may have to link in a specific library too, maybe libbsd.a.
 */
#define HAS_FTRUNCATE



#ifdef VAXC
# ifdef HAS_TIMEVAL
#  undef HAS_TIMEVAL
# endif
# ifdef HAS_PUTENV
#  undef HAS_PUTENV
# endif
# ifdef HAS_FTRUNCATE
#  undef HAS_FTRUNCATE
# endif
#endif

#ifdef WIN32
# ifdef HAS_TIMEVAL
#  undef HAS_TIMEVAL
# endif
#endif

#if defined(__GNUC__) && defined(VMS)
# ifdef HAS_TIMEVAL
#  undef HAS_TIMEVAL
# endif
#endif

#define OLD_REGINA_FEATURES


#if defined(DYNAMIC_DLOPEN) || defined(DYNAMIC_AIXLOAD) || \
             defined(DYNAMIC_HPSHLOAD)

# define DYNAMIC
/*
 * DLOPEN   - dlopen()/dlsym() under SunOS and SysV42
 * AIXLOAD  - load()/loadbind() under AIX
 */
#endif

/*
 * If we don't have ftruncate() then we don't want the default setting
 * of LINEOUT() to be to truncate after each new line written out.
 */
#ifndef HAS_FTRUNCATE
# ifdef DEFAULT_LINEOUTTRUNC
#  undef DEFAULT_LINEOUTTRUNC
# endif
# define DEFAULT_LINEOUTTRUNC 0
#endif



