#ifndef lint
static char *RCSid = "$Id: interp.c,v 1.7 1993/05/07 20:23:38 anders Exp anders $";
#endif

/*
 *  The Regina Rexx Interpreter
 *  Copyright (C) 1992-1994  Anders Christensen <anders@pvv.unit.no>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "rexx.h"
#include <stdio.h>
#include <ctype.h>


extern nodeptr parseroot ;

void set_line_nos( treenode *ptr, int lineno, int charno ) 
{
   int i ;

   if (!ptr)
      return ;
 
   if (ptr->lineno >= 0)
   {
      ptr->lineno = lineno ;
      ptr->charnr = charno ;
   }

   for (i=0; i<5; i++)
      if (ptr->p[i])
         set_line_nos( ptr->p[i], lineno, charno ) ;

   if (ptr->next)
      set_line_nos( ptr->next, lineno, charno ) ;
}



static streng *ostring=NULL ;

void dointerpret( streng *string ) 
{
   treenode *newtree ;
   extern nodeptr currentnode ;

   if (ostring)
      Free_string(ostring) ;

   initinterpret( ostring=string ) ;
   parseroot = NULL ;
   if (!yyparse()) {
      newtree = parseroot ;
      parseroot = NULL ;
      kill_lines( first_source_line ) ;
      if (currentnode)
         set_line_nos( newtree, currentnode->lineno, currentnode->charnr ) ;

      treadit( newtree ) ;
      Free( string ) ;
      ostring = NULL ;
      interpret( newtree ) ;
      if (newtree) 
         destroytree( newtree ) ;
   }
   else
   {
      exiterror( ERR_YACC_SYNTAX ) ;
   }
}



/* actually, this is rather useless .... */
streng *dovalue( streng *string ) 
{
   treenode *newtree ;
   streng *tstr ;

   initvalue( string ) ;
   parseroot = NULL ;
   if (yyparse())
      exiterror( ERR_YACC_SYNTAX ) ;

   kill_lines( first_source_line ) ;
   newtree = parseroot ;
   parseroot = NULL ;
   tstr = evaluate(newtree->p[0]->p[1]->p[0],NULL) ;
   destroytree(newtree) ;
   return tstr ;
}


