// Testing issue with BoundsChecker and realloc()
//
// BC doesn't notice that the size of a memory block has
// changed after a realloc() if realloc() returns the same
// pointer address.  If it returns a different address,
// it works fine.

#include <malloc.h>
#include <assert.h>

void main()
{
	char *p;
	char *p2;
	size_t size;
	size_t current;
	int i;

	size = 100;
	p = malloc(size);

	// Dummy malloc to make sure realloc() has to change the
	// address of the memory block.  This allows BoundsChecker
	// to work the first time, but not the second.
	p2 = malloc(size);

	current = 0;

	for (i = 0; i < 1000; i++)
	{
		// Assert if there is really a problem
		assert(current < _msize(p));

		p[current] = 't';  // BChecker: "Writing overflows memory"

		current++;
		if (current >= size)
		{
			size += 20;
			p = realloc(p, size);
		}
	}
	free(p);
	free(p2);
}