//		WINZILLA.H


#ifndef __WINZILLA_H
#define __WINZILLA_H


//--- DO NOT MODIFY THESE DEFINES!

//--- WinZilla defines and macros
#define	WZ_NONE_SELECTED	-1
#define WZ_WINDOW_NOT_FOUND	-1
#define	WZ_CANCELLED		0
#define WZ_SUCCESS			TRUE
#define WZ_FAILURE			FALSE
#define WZ_BUTTON1			0x01
#define WZ_BUTTON2			0x02
#define	WZ_BUTTON3			0x04
#define WZ_MAX_CHILD_WIN	100

//--- DO NOT MODIFY THESE DEFINES!
#define WZ_MAX_DIALOGS		100

//--- window creation
#define WZ_INVISIBLE		0
#define WZ_MAXIMIZE			1
#define WZ_MINIMIZE			2
#define WZ_DEFAULT			3

#define WZ_MODAL_DLG		0
#define WZ_MODELESS_DLG		1

//--- window flags
#define WZ_SQUARE_ASPECT		( 1 << 0 )
#define WZ_OUTPUT_ONLY			( 1 << 1 )
#define WZ_DOCK_PARENT_BOTTOM	( 1 << 2 )
#define WZ_DOCK_PARENT_RIGHT	( 1 << 3 )
#define WZ_SIZE_PARENT_WIDTH	( 1 << 4 )
#define WZ_SIZE_PARENT_HEIGHT	( 1 << 5 )
#define WZ_WINDOW_PATHMODE		( 1 << 6 )
#define WZ_STRETCH_CORNER		( 1 << 7 )
#define WZ_MOVE_CORNERS			( 1 << 8 )
#define WZ_POSITION_EXACTLY		( 1 << 9 )

//--- window styles
#define WZ_STYLE_DLGWINDOW		( WS_CHILDWINDOW | WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CLIPSIBLINGS | WS_DLGFRAME )
#define WZ_STYLE_SIMPLE			( WS_CHILDWINDOW | WS_VISIBLE | WS_CLIPSIBLINGS | WS_DLGFRAME )

//--- window system commands
#define WZ_CLOSEWINDOW		0xffffDEAD
#define WZ_SIZEWINDOW		0xffffDECA
#define WZ_MOVEWINDOW		0xffffACAB
#define WZ_STATBAR			0xffffBADD
#define WZ_INITDIALOG		0xffffDGBF

//--- WinZilla drawing related
#define WZ_FILL_COLOR		0
#define WZ_FILL_PATTERN		1
#define WZ_FILL_NOTHING		2

//--- MENU MAP macros
#define WZ_MENUMAP(m)		t_WZ_Menu	m[] = {
#define WZ_MAP(m,i)			m,i,
#define WZ_ENDMAP			"", 0 };

//--- macros and defines for WZ_PositionWindow
#define WZ_LEFT_EDGE	1
#define WZ_RIGHT_EDGE	2
#define WZ_TOP_EDGE		3
#define WZ_BOTTOM_EDGE	4
#define	WZ_COORD		5

#define WZ_LEFT_OF(hwnd)			WZ_LEFT_EDGE,hwnd
#define WZ_RIGHT_OF(hwnd)			WZ_RIGHT_EDGE,hwnd
#define WZ_ABOVE(hwnd)				WZ_TOP_EDGE,hwnd
#define WZ_BELOW(hwnd)				WZ_BOTTOM_EDGE,hwnd
#define WZ_EXACTLY_AT(value)		WZ_COORD,(HWND)(value)

//--- WinZilla structures
typedef struct
{
	int		code;
	HWND	hwnd;
} t_WZ_PosCode;


typedef struct
{

	int				Flags;
	HWND			Window;
	HBITMAP			Bitmap;
	int				cx,cy;
	RECT			EdgeDeltas;
	RECT			wdims;
	int				*px, *py;
	t_WZ_PosCode	pleft;
	t_WZ_PosCode	ptop;
	t_WZ_PosCode	pright;
	t_WZ_PosCode	pbottom;
	void	(*Regen)(HWND hwnd);

} t_WZ_ChildWin;


typedef struct
{

	char	*MenuText;
	int		MenuID;

} t_WZ_Menu;

#ifdef __cplusplus
extern "C" {
#endif


//--- WinZilla globals
extern int			WZ_LastCommand;
extern int			WZ_MenuItemChosen;
extern int			WZ_MouseX, WZ_MouseY;
extern int			WZ_MouseButtons;
extern LONG			WZ_PenPressure;
extern int			WZ_Done;
extern int			WZ_AppDone;
extern int			WZ_Style;
extern int          WZ_ExStyle;
extern HBRUSH		WZ_WindowBG;
extern HWND			WZ_Hwnd;
extern HWND			WZ_ActiveWindow;
extern HDC			WZ_Hdc;
extern UINT			WZ_Msg;
extern WPARAM		WZ_WParam;
extern LPARAM		WZ_LParam;
extern MSG			WZ_WMsg;
extern HWND   WZ_DialogArray[WZ_MAX_DIALOGS];
extern char			*WZ_FileFilter;
extern HWND			WZ_ModalDlg;
extern HINSTANCE	WZ_Instance;
//--- WinZilla drawing-related variables
extern COLORREF		WZ_CurPenColor;
extern COLORREF		WZ_CurFillColor;
extern HBITMAP		WZ_CurFillPattern;
extern int			WZ_CurFillMode;
extern int			WZ_CurPenWidth;
extern POINT		WZ_CursorPos;
extern int			WZ_WriteMode;
extern LOGFONT		WZ_CurFont;

extern t_WZ_ChildWin	WZ_Windows[];

//--- WinZilla functions
void WZ_Init(HINSTANCE hInstance, char *icon);
void WZ_MessageControl(void);
HWND WZ_OpenWindow(int Size, char *WZ_title, HWND WZ_Parent, void (*Regen)(HWND hwnd), int BitmapRegenFlag);
void WZ_AdoptWindow(HWND hwnd, void (*Regen)(HWND hwnd), int BitmapRegenFlag);
HWND WZ_CreateStatusBar(HWND hwnd, char *text);
void WZ_CloseWindow(HWND hwnd);
int  WZ_MaintainParentSpacing(HWND hwnd, int style);
void WZ_SetAutoScroll(HWND hwnd, BOOL state);
int WZ_SetWinView(HWND hwnd, int x1, int y1, int x2, int y2, int *cx, int *cy);
void WZ_UpdateScrollbar(HWND hwnd);

HWND WZ_AddButton(int x, int y, char *text, int retval, HWND parent);
HWND WZ_AddCheckBox(int x, int y, char *text, int retval, HWND parent);
HWND WZ_AddRadioButton(int x, int y, char *text, int retval, HWND parent);

void	WZ_Menubar(HWND owner, int base_id, int reset, char *options);
int		WZ_PopupMenu(int x, int y, char *options);
void	WZ_SetMenubarFromResource(HWND owner, char *resource);
void	WZ_GetMenu(void);
int		WZ_GetMenuAndRect(RECT *rect);
int		WZ_GetPoint(int *x, int *y, int immediate);
int		WZ_GetPoint2(int x1, int y1, int *x2, int *y2, int immediate);
int		WZ_GetCorner(int x1, int y1, int *x2, int *y2, int immediate);
int		WZ_GetCircle(int x1, int y1, int *x2, int *y2, int immediate);
void	WZ_GetMouse(int *x, int *y, int *b);
void	WZ_RegenWindow(HWND hwnd);
void	WZ_Regen(HWND hwnd);
void	WZ_Redraw(HWND hwnd);
HBITMAP WZ_FindWindowBitmap(HWND hwnd);
void	WZ_SetWindowState(HWND hwnd, int state_flags);
int		WZ_GetWindowState(HWND hwnd);
int		WZ_IsWindowOutputOnly(HWND hwnd);
HWND	WZ_AddIconBar(t_WZ_Menu *options, int max_cols, HWND owner);
void	WZ_SetButtonState(HWND parent, int id, int value);

//--- WinZilla window utility functions
void	WZ_SetWindowSize(HWND hwnd, int width, int height);
void	WZ_PositionWindow(HWND hwnd, int code1, HWND hwnd1, int code2, HWND hwnd2, int code3, HWND hwnd3, int code4, HWND hwnd4);
int		WZ_GetWindowWidth(HWND hwnd);
int		WZ_GetWindowHeight(HWND hwnd);
int		WZ_GetClientWidth(HWND hwnd);
int		WZ_GetClientHeight(HWND hwnd);
//--- file dialog functions
int		WZ_InitFileTypes(void);
BOOL	WZ_OpenFileDlg (char *default_name, char *selected, DWORD filter_idx);
BOOL	WZ_SaveFileDlg (char *default_name, char *selected, DWORD filter_idx);

//--- WinZilla drawing functions
int	 WZ_ChooseColor(COLORREF *color);
void WZ_SetPenColor(HWND hwnd, COLORREF color);
void WZ_SetFillColor(HWND hwnd, COLORREF color);
void WZ_SetFillPattern(HWND hwnd, HBITMAP bitmap);
void WZ_SetPenWidth(HWND hwnd, int width);
void WZ_SetWriteMode(HWND hwnd, int mode);
void WZ_PutPixel(HWND hwnd, int x, int y);
void WZ_MoveTo(HWND hwnd, int x, int y);
void WZ_LineTo(HWND hwnd, int x, int y);
void WZ_Circle(HWND hwnd, int x, int y, int r);
void WZ_Ellipse(HWND hwnd, int x1, int y1, int x2, int y2);
void WZ_Rectangle(HWND hwnd, int x1, int y1, int x2, int y2);
void WZ_RoundRect(HWND hwnd, int x1, int y1, int x2, int y2, int xsize, int ysize);
void WZ_Bezier(HWND hwnd, POINT *pt, int count);
void WZ_Poly(HWND hwnd, POINT *pt, int count);
void WZ_FloodFill(HWND hwnd, int x, int y);

void WZ_SetCursor(char *cursor_rsc);

HBITMAP WZ_LoadBitmap(char *filename);
void WZ_DrawBitmap(HWND hwnd, HBITMAP hbitmap, int x, int y, int mode);
void WZ_StretchBitmap(HWND hwnd, HBITMAP hbitmap, int x1, int y1, int x2, int y2);
//--- for use with standard Win32 drawing functions
void WZ_StartDrawing(HWND hwnd);
void WZ_StopDrawing(HWND hwnd);

BOOL WZ_ChooseFont(LOGFONT *font);
BOOL WZ_WriteFontStyle(LOGFONT *font, char *filename);
BOOL WZ_ReadFontStyle(LOGFONT *font, char *filename);
void WZ_Print(HWND hwnd, int x, int y, char *string, ...);
RECT WZ_GetPrintSize(HWND hwnd, int x, int y, char *string, ...);
void WZ_PrintWindow(HWND hwnd);

//--- WinZilla Dialog Functions
HWND WZ_OpenDialog(char *dlgname, int method);
void WZ_CloseDialog(HWND hwnd);

//--- currently implemented but not yet supported
HWND WZ_AddComboBox(int x1, int y1, int x2, int y2, int retval, HWND parent);
HWND WZ_AddListBox(int x1, int y1, int x2, int y2, int retval, HWND parent);
HWND WZ_AddEditBox(int x1, int y1, int x2, int y2, int retval, HWND parent);
HWND WZ_AddTreeView(int x1, int y1, int x2, int y2, int retval, HWND parent);
HWND WZ_AddIcon(int x, int y, HBITMAP bitmap, int retval, HWND parent);
//--- old line drawing routine
void WZ_Line(int x1, int y1, int x2, int y2, COLORREF color, int thickness, HWND parent);

//--- internal ---
int		    WZ_FindWindow(HWND hwnd);
HBRUSH		WZ_BuildBrush(void);
void		WZ_AddDialogHwnd(HWND hwnd);
int			WZ_UpdateAllChildren(HWND hwnd, int cx, int cy);
void		WZ_NullFunc(HWND hwnd);
LRESULT CALLBACK WZ_GetMenuProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WZ_GetDlgProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WZ_DockableProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam);
char		*WZ_GetNthItem(char *list, int nth);
int			WZ_InterpretPositionCode(HWND hwnd, int code, HWND hwnd_rel);
void		WZ_AddWindowRef(HWND hwnd);
void		WZ_BuildHdc(HDC hdc, int i);

#ifdef __cplusplus
}
#endif

#endif