__fastcall TCubeForm::TCubeForm(TComponent* Owner)
  : TForm(Owner) {

  Steps = 5; //       90
  Dir = 1;   //  1  -1,  
             //     

  //      :
  LogList = new TList;
  //     :
  D3dView = new TD3dView(this);
  D3dView->Parent = this;
  D3dView->Align = alClient;
  //      :
  LeftPort = new TVport(D3dView);
  LeftPort->Parent = D3dView;
  LeftPort->Width = D3dView->Width / 2;
  LeftPort->Align = alLeft;
  LeftPort->Name = "LefPort";
  //       
  //  :
  paSplit = new TPanel(D3dView);
  paSplit->Parent = D3dView;
  paSplit->Align = alLeft;
  paSplit->Width = 5;
  paSplit->Cursor = crHSplit;
  paSplit->OnMouseUp = paSplitMouseUp;
  //      :
  RightPort  = new TVport(D3dView);
  RightPort->Parent = D3dView;
  RightPort->Align = alClient;
  RightPort->Name  = "RighPort";
  //     
  //  :
  D3dView->Init();
  //   Direct3D   :
  TRY(LeftPort->IRMVport->
                  SetProjection(D3DRMPROJECT_ORTHOGRAPHIC));
  TRY(LeftPort->IRMVport->SetField(6));
  TRY(RightPort->IRMVport->
                  SetProjection(D3DRMPROJECT_ORTHOGRAPHIC));
  TRY(RightPort->IRMVport->SetField(6));
  TRY(D3dView->IRMDevice->SetQuality(D3DRMRENDER_GOURAUD));
  //      (  
  //  TForm::Loaded ):
  TRY(LoadSceneID(D3dView->IScene, "XCUBE_SCENE"));

  LPDIRECT3DRM IRM = D3dView->IRM;
  //         :
  LPDIRECT3DRMFRAME ILeftCamera  = NULL;
  LPDIRECT3DRMFRAME IRightCamera = NULL;
  TRY(IRM->GetNamedObject("LeftCameraFrame",
                        (LPDIRECT3DRMOBJECT*)&ILeftCamera));
  TRY(IRM->GetNamedObject("RightCameraFrame",
                       (LPDIRECT3DRMOBJECT*)&IRightCamera));
  TRY(IRM->GetNamedObject("XCubeCenter",
                        (LPDIRECT3DRMOBJECT*)&ICubeCenter));

  //      :
  TRY(IRM->CreateFrame(D3dView->IScene, &IHandleFrame));
  //     :
  LeftPort->SetCamera (ILeftCamera,  false);
  RightPort->SetCamera(IRightCamera, false);
  //     
  // :
  RELEASE(ILeftCamera);
  RELEASE(IRightCamera);
  //   :
  NewGame();
  //     :
  Application->OnIdle = ApplicationIdle;
}//---------------------------------------------------------
void __fastcall TCubeForm::FormDestroy(TObject*) {
  //     :
  Application->OnIdle = NULL;
  //     :
  RELEASE(ICubeCenter);
  RELEASE(IHandleFrame);
  //      :
  delete LogList;
}//---------------------------------------------------------
void __fastcall TCubeForm::NewGame() {
  LogList->Clear();
  PlayStep  = 0;
  StepsDone = 0;
  StatBar->SimpleText = "Seeding... press any key to stop";
  StatBar->SimplePanel = true;
  StopSeeding = false;
}//---------------------------------------------------------
