@echo off

rem CONVERT.BAT must be called from the C directory
rem param 1 is the name of main c files
rem param 2 is the name of the project with path without extension, without @

if "%1" == "" goto bad
if "%2" == "" goto bad

rem Making the list of c files
python mklist.py %1 %2.prj

rem Building or correcting header files
python mkheader.py @%2.prj hpp

rem Converting headers into class files
python mkclass.py @%2.prj

rem Making the list of all hpp files
python allhead.py %1 %2.hpj

rem Converting functions into methods
python mkcpp.py @%2.prj @%2.hpj

goto end

:bad
echo This batch file requires 2 parameters...
echo Usage:  convert mainfile project
echo         mainfile: the main c source file (holds "main") with full path
echo         project:  the name of the project with the new full path
echo                   without extension, without @

:end
