#!/usr/bin/env python

"""
   Mover - (c) D.G. Sureau 2001-2003
   Comes along the C to C++ translator pack.
   Require python (www.python.org)

   This python script moves all c files and their headers
   from a set of directories to another set of directories.
   "#include" statements inside the files are updated...

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    webmaster@scriptol.com
    http://www.scriptol.com
"""


import os
import sys
import string
import wstring
import lexer


TRUE = 1
FALSE = 0

sources = []
dico = {}
counter = 0

# this function updates the '#include' statement
# by replacing the old path by the new given one

def update(line):
 i = string.find(line, "#include ")
 if i == -1:
   print "which?"
   sys.exit(0)

 i = i + 9
 lindex = i
 rindex = i
 sline = line[i:]
 first = FALSE
 second = FALSE

 # scanning the line for delimiters
 for c in sline:
   if c == '<' :        # test for left delimiter
     lindex = i
     first = TRUE
     return line        # standard libraries include unchanged
   if c == '\"':
     if first :         # test for right delimiter
       rindex = i
       second = TRUE
       break
     lindex = i + 1         # test for left delimiter
     first = TRUE
   i = i + 1

 if (rindex <= lindex) | (not first) | (not second):
   print "error, unrecognized statenent", line
   sys.exit(0)

 # extracting the header filename
 sline = line[lindex:rindex]
 sline = wstring.localize(sline)          # change separators for the os

 # occurence of header with the old path replaced by
 # the header with the new path found in the dictionary

 oldpath, name = os.path.split(sline)
 if oldpath == "": return line               # simple filename without path

 if dico.has_key(oldpath):
   newpath = os.path.join(dico[oldpath], name)
 else:
   print oldpath, "not in dictionary of paths"
   newpath = oldpath

 line = line[ : lindex] + newpath + line[rindex: ]
 return line


# this function copies a file
# and updates any '#include' statement embedded

def move(oldpath, newpath):
  if not os.path.exists(oldpath): return 0
  path, name = os.path.split(newpath)
  if not os.path.exists(path):
     os.mkdir(path)
     print path, "created"

  o = open(oldpath, 'r')
  n = open(newpath, 'w')

  while(1):
   line = o.readline()
   if not line: break
   line = wstring.chop(line)
   i = string.find(line, "#include ")
   if i != -1:
     line = update(line)
   n.write(line + "\n")

  o.close()
  n.close()
  return 1

# this function change the path of a file

def changepath(f):
  path, name = os.path.split(f)
  if dico.has_key(path):
     np = dico[path]
     return os.path.join(np , name)
  else:
     return f


"""
    Contructs a list of all headers included in a project
    from the main source file.
"""

# Add header to list
# Windows ignore case, so string are compared without case

def add(hpath, dir):
 global counter
 global sources

 hpath = hpath[1:-1]    # Removing ""
 if hpath is None:
   print "Error"
   sys.exit(0)


 # if no dir in the path, the path of the main file
 # if added to, as it is presumed to be the location
 # when compiling the project

 hpath = wstring.localize(hpath)
 dir = wstring.localize(dir)
 
 p, n = os.path.split(hpath)
 if p == "":
   hpath = os.path.join(dir, n)  # adding the default path

 Windows = (os.name == "nt") | (os.name == "dos")

 if Windows: hname = string.lower(hpath)
 if hpath in sources: return       # Already here

 sources.append(hpath)
 counter = counter + 1
 return


# Change a .h header name into .c source name

def makesource(name):
 node, ext = os.path.splitext(name)
 ext = string.lower(ext)
 if ext ==  ".h":
   nname = node + ".c"
   if os.path.exists(nname): name = nname
 return name


# Is the file a c source?

def iscode(name):
  node, ext = os.path.splitext(name)
  ext = string.lower(ext)
  return (ext == ".c")


# Scan a source file for included headers

def hprocess(name, dir):

  print "processing", name

  f = open(name, 'r')
  lines = f.readlines()
  f.close()

  if not lines: return

  for l in lines:
   if len(l) < 10: continue
   if l[0] != '#': continue
   if l[:9] != "#include ": continue
   hpath = l[9:]
   hpath = wstring.chop(hpath)
   hpath = lexer.removecomment(hpath)
   hpath = wstring.strip(hpath)
   if hpath[-1] == ';': hpath = hpath[:-1]
   if len(hpath) < 3: continue     # minimum is: "a"
   if lexer.isheader(hpath):       # Has the format "name" or <name>
     add(hpath, dir)
  # End for
  return

def processheader(mainfile, startsource):
  p, n = os.path.split(mainfile)
  hprocess(mainfile, p)
  index = 0
  while(1):
   if index >= len(sources): break
   nextfile = sources[index];
   nextfile = makesource(nextfile)
   if iscode(nextfile):
     hprocess(nextfile, p)
   index = index + 1
  startsource.extend(sources)


"""
    Contructs the list of all c sources included in a project
    from the file holding the main function
"""

notexist = []
mainpath = ""

# Add to the list the name of an header file to include
# Windows ignore case, so string are compared without case
# The .h header filename is transformed into .c source filename
# and added to the list if the source exists

def addc(hpath, dir):
 global counter
 global notexist
 global source

 if hpath is None: return None
 if len(hpath) < 3: return None
 hpath = hpath[1:-1]    # removing quotes

 # if no dir in the path, the path of the main file
 # if added to, as it is presumed to be the location
 # when compiling the project

 hpath = wstring.localize(hpath)
 dir = wstring.localize(dir)
 
 p, n = os.path.split(hpath)
 if p == "":
   hpath = os.path.join(dir, n)  # adding the default path

 node, ext = os.path.splitext(hpath)
 ext = string.lower(ext)
 if ext ==  ".h":
   if lexer.iswindows(): node = string.lower(node)
   hpath = node + ".c"
   # Converting local relative path into absolute path
   if string.find(hpath, mainpath) == -1:       # path not in include
      hpath = os.path.join(mainpath, hpath)     # add it
      #print hpath
   if hpath in sources: return None             # Already here
   if os.path.exists(hpath):
      sources.append(hpath)
      counter = counter + 1
      #print "added", hpath
      return hpath
   else:
      if hpath not in notexist:
        notexist.append(hpath)
 return None



def cprocess(name, dir):
  if name is None: return
  print "processing", name

  f = open(name, 'r')
  lines = f.readlines()
  f.close()

  if not lines: return

  for l in lines:
   if len(l) < 12: continue                # minimum length 12, ex: #include "a"
   if l[0] != '#': continue                # not a directive, pass
   if l[:9] != "#include ": continue       # not an include statement, pass
   hpath = l[8:]                           # remove the '#include' string
   hpath = wstring.chop(hpath)             # remove separators
   hpath = lexer.removecomment(hpath)      # remove comments
   hpath = wstring.strip(hpath)            # remove extra whitespaces
   if hpath[-1] == ';': hpath = hpath[:-1] # ignore useless delimiter
   if len(hpath) < 3: continue             # minimum is: "a"
   if lexer.isheader(hpath):               # test the format
      cfile = addc(hpath, dir)             # add to the list of headers
      cprocess(cfile, dir)
  # End for
  return



def processource(mainfile, startsource):
  p, n = os.path.split(mainfile)
  cprocess(mainfile, p)

  index = 0
  while(1):
   if index >= len(sources): break
   nextfile = sources[index];
   nextfile = makesource(nextfile)
   if iscode(nextfile):
     cprocess(nextfile, p)
   index = index + 1
  startsource.extend(sources)



def main():
  global sources
  global dico
  
  param = sys.argv
  paramlen = len(param)
  if paramlen < 3:
    print """
 Move Project - C to C++ converter by D.G. Sureau
 usage:    mover mainfile.c oldpath@newpath [oldpath@newpath] etc...
    or:    mover mainfile.c @list_in_file
 mainfile.c (holds the main function), type the full path.
 oldpaths are current paths of c files.
 newpaths are new locations where to copy them into.
 Example:
  python mover.py \lister\list.c \lister@\cpplist \gui@\cpplist
 Under Unix the slash symbol is used instead.
 All sources are copied and "#include" directives inside are updated.
 """
    sys.exit()

  replacements = []              # list of couple olddir:newdir

  mainfile = param[1]            # main file
  listof = param[2]              # couple or file of couples
  if listof[0] == '@':           # reading list from file
    listof = listof[1:]
    f = open(listof, 'r')
    replacements = f.readlines()
    f.close()
  else:                          # reading list from params
    paths = []
    n = 2
    while n < paramlen:
      couple = param[n]
      replacements.append(couple)
      n = n + 1

  # separating old and new paths in couples

  print "Directories..."

  for couple in replacements:
    if wstring.chop(couple) == "" : break
    i = string.find(couple, '@')
    old = couple[:i]
    if lexer.iswindows():
      old = string.lower(old)
    dico[old] = couple[i + 1:]
    print "from", old, "to", dico[old]

  processheader(mainfile, sources)
  processource(mainfile, sources)       # extracting headers filenames

  if len(sources) == 0:
    sources.append(mainfile)
  else:
    print len(sources), " files found"

  """
  # for debugging
  test = open("testlist", 'w')
  for t in sources:
    test.write(t + "\n")
  test.close()
  """

  # moving files and headers not listed

  for f in sources:
    newf = changepath(f)   # define a new path
    if newf <> f:
      print f, "-->", newf
      move(f, newf)          # move, and update include directives inside

  return 0


main()








