/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <signal.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>

int _abterm=0;

static void sigill(int)
{
}
static void sigint(int)
{
}
static void sigfpe(int)
{
}
static void sigsegv(int)
{
}
static void sigterm(int)
{
	exit(EXIT_SUCCESS);
}
static void siguser1()
{
}
static void siguser2()
{
}
static void siguser3()
{
}
static void siguser()
{
}
static void sigabort(int)
{
	_abterm = 1;
	exit(EXIT_FAILURE);
}
static void (*deftab[NSIG])(int) = {
    SIG_ERR,  sigabort,  SIG_ERR,   SIG_ERR,
	sigill,  SIG_ERR, SIG_ERR, SIG_ERR,
	sigfpe,  SIG_ERR, SIG_ERR, sigsegv,
	 SIG_ERR, SIG_ERR, SIG_ERR,sigterm,
	siguser1,siguser2, SIG_ERR, SIG_ERR,
	siguser3,SIG_ERR,sigabort 
};

static void (*sigtab[NSIG])(int);
#pragma startup siginit 149

static void siginit(void)
{
	int i;
	for (i=0; i < NSIG; i++)
		sigtab[i] = deftab[i];
}
void (*signal(int signum, void (*func)()))(int)
{
	void (*temp)(int);
	if (signum >= NSIG) {
		errno = EINVAL;
		return SIG_ERR;
	}
	temp = sigtab[signum];
	if (func == SIG_DFL) 
		sigtab[signum] = deftab[signum];
	else    /* SIG_IGN && SIG_ERR gets used as-is, 
                   otherwise func is a valid func */
		sigtab[signum] = func;
   _ll_signal(signum,func) ;
	return temp;
}
int raise(int sig)
{
	void (*temp)(int a) = sigtab[sig];
	if (temp == SIG_ERR)
		return 1;
	if (temp == SIG_IGN)
		return 0;
	(*temp)(sig);
	sigtab[sig] = deftab[sig];
	return 0;
}