/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
/*
 * ibits.c
 *
 * bitfield functions for the global convergence algorithms
 */
/* Define this to get a dump of the flow graph and dominator tree 
 * These are dumped into ccfg.$$$
 */
#define DEBUG

#include        <stdio.h>
#include				<malloc.h>
#include 				<string.h>
#include				"utype.h"	
#include				"cmdline.h"	
#include        "lists.h"
#include        "expr.h"
#include        "c.h"
#include				"iexpr.h"
#include				"iopt.h"
#include 				"diag.h"

static int names,namebytes;
static ENODE **bitnames;
static ENODE ***enodehash;

static int bittab[8] = { 1,2,4,8,16,32,64,128 };

BYTE *alloc_bitarray(void)
{
	return xalloc(namebytes);
}
void SetBit(BYTE *array, int bit)
{
	array[bit/8] |= bittab[bit & 7];
}
void ClearBit(BYTE *array, int bit)
{
	array[bit/8] &= ~bittab[bit & 7];
}
int TestBit(BYTE *array, int bit)
{
	return array[bit/8] & bittab[bit & 7];
}
void OrArray(BYTE *array1, BYTE *array2)
{
	int i;
	for (i=0; i < namebytes; i++)
		array1[i] |= array2[i];
}
void AndArray(BYTE *array1, BYTE *array2)
{
	int i;
	for (i=0; i < namebytes; i++)
		array1[i] &= ~array2[i];
}
int CompareArray(BYTE *array1, BYTE *array2)
{
	return memcmp(array1,array2,namebytes);
}
