/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <dos.h>
#include <dir.h>
#include <errno.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

void	_searchenv(const char *file, const char *inpath, char *output)
{
	char *path = getenv(inpath),*p=path,*q;
	FILE *t;
	strcpy(output,file);
	t = fopen(output,"rb");
	if (t) {
		fclose(t);
		if (!strchr(output,'\\')) {
			getcwd(output,255);
			strcat(output,"\\");
			strcat(output,file) ;
		}
		return ;
	}
	else while (*p) {
		q = output;
		while (*p != ';' && *p)
			*q++=*p++;
		if (*p) p++;
		if (*(q-1) != '\\')
			*q++ = '\\';
		strcpy(q,file);
		if ((t = fopen(output,"rb")) != 0) {
			fclose(t);
//			q[0] = 0 ;
			return ;
		}
	}
	*output = 0 ;
	return ;
}
int         chdir( const char  *__path )
{
	return _dos_setpwd(__path);
}
int         findfirst( const char  *__path,
                                    struct ffblk  *__ffblk,
                                    int __attrib )
{
	return _dos_findfirst(__path,__attrib | _A_NORMAL,__ffblk);
}
int         findnext( struct ffblk  *__ffblk )
{
	return _dos_findnext(__ffblk);
}
void        fnmerge( char  *__path,
                                    const char  *__drive,
                                    const char  *__dir,
                                    const char  *__name,
                                    const char  *__ext )
{
	char *p;
	if (__drive[0]) {
		__path[0] = __drive[0];
		__path[1] = ':';
		__path[2] = 0;
		p = __path+2;
	}
	if (__dir[0]) {
		if (__dir[0] != '\\')
			*p++ = '\\';
		strcpy(p,__dir);
		p = p + strlen(p);
	}
	strcpy(p,__name);
	p = p + strlen(p);
	if (__ext[0] && __ext[0] != '.')
		*p++ = '.';
	strcpy(p,__ext);
}
int         fnsplit(const char  *__path,
                                    char  *__drive,
                                    char  *__dir,
                                    char  *__name,
                                    char  *__ext )
{
	char buf[256],*p,*q =buf;
	strcpy(buf,__path);
	p = strrchr(buf,'.');
	if (*(p-1) != '.') {
		strcpy(__ext,p);
		*p=0;
	}
	else __ext[0] = 0;

	if (buf[1] == ':') {
		strncpy(__drive,buf,2);
		__drive[2] = 0;
		q += 2;
	}
	else
		__drive[0] = 0;
	
	p = strrchr(buf,'\\');
	if (p) {
		strcpy(__name,p+1);
		*(p+1) = 0;
	}
   else  {
      strcpy(__name,q) ;
      q = 0 ;
   }
   if (q)
      strcpy(__dir,q);
   else
      __dir[0] = 0 ;
	return 0;
}
int         getcurdir( int __drive, char  *__directory )
{
	return _dos_getpwd(__directory,__drive);
}
char  *     getcwd( char  *__buf, int __buflen )
{
	int drv,rv;
	char ibuf[260];
	drv = getdisk();
	rv = _dos_getpwd(ibuf+3,drv+1);
	ibuf[0] = drv + 'A';
	ibuf[1] = ':';
	ibuf[2] = '\\';
	memcpy(__buf,ibuf,__buflen);
	__buf[__buflen-1] = 0;
   return __buf;
}
int         getdisk( void )
{
	int drv;
	_dos_getdrive(&drv);
	return drv-1;
}
int         mkdir( const char  *__path )
{
	if (!CreateDirectory(__path,0)) {
		errno = ENOENT;
		return -1;
	}
	return 0;
}
						
int         rmdir( const char  *__path )
{
	if (!RemoveDirectory(__path)) {
		errno = ENOENT;
		return -1;
	}
	return 0;
}
char  *     searchpath( const char  *__file )
{
	static char buf[256];
        LPTSTR xx ;
        buf[0] = 0 ;
        SearchPath(NULL,__file,NULL,256,buf, &xx) ;
        if (!buf[0])
               return 0 ;
        return buf ;

}
int         setdisk( int __drive )
{
	int nd ;
	return _dos_setdrive(__drive,&nd);
}