/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
**********************************************************************

FILEDLG.C handles low level of the save/open dialog functionality.

**********************************************************************
*/
#include <windows.h>
#include <commctrl.h>
#include <commdlg.h>
#include <richedit.h>
#include <stdio.h>
#include <dir.h>
#include <ctype.h>
#include "header.h"
extern HINSTANCE hInstance ;

char szSourceFilter[] = 
			"Source files (*.c,*.cpp)\0*.c;*.cpp\0"
			"Headers (*.h,*.p)\0*.h;*.p\0"
			"Assembly files (*.asm)\0*.asm\0"
			"Resource files (*.rc)\0*.rc\0"
			"Any file\0*.*\0" ;

char szProjectFilter[] =
			"Project files (*.prj)\0*.prj\0" ;

char szTargetFilter[] = 
			"Executables (*.exe)\0*.exe\0"
			"DLLs (*.dll)\0*.dll\0"
			"Librarys (*.lib)\0*.lib\0" ;

static char szFileName[10000],szFileTitle[260] ;
static char szDefExt[] = "" ;
static char *szTitle ;
/* hook function gets rid of the toolbar on the left hand size of the 
 * explorer dialog box
 */
static LRESULT CALLBACK filedlghook(HWND hwnd, UINT iMessage, WPARAM wParam, LPARAM lParam)
{
   if (iMessage == WM_INITDIALOG) {
      SendMessage(hwnd,CDM_HIDECONTROL,1184,0) ;
      if (szTitle)
         SendMessage(GetParent(hwnd),WM_SETTEXT,0,(LPARAM)szTitle) ;
   }
   return 0 ;
}
void setofndata(OPENFILENAME * ofn, char *name, HWND handle, char *dir, char *filter)
{
	memset(ofn,0,sizeof(*ofn)) ;
	if (name)
		strcpy(szFileName,name) ;
	else
		szFileName[0] = 0 ;
	szFileTitle[0] = 0 ;
	ofn->lStructSize = sizeof(OPENFILENAME) ;
	ofn->hwndOwner = handle ;
	ofn->hInstance = hInstance ;
   ofn->lpstrFilter = filter ;
	ofn->nFilterIndex = 1 ;
	ofn->lpstrFile = szFileName ;
   ofn->nMaxFile = sizeof(szFileName) ;
	ofn->lpstrFileTitle = szFileTitle ;
	ofn->nMaxFileTitle = 260 ;
	ofn->lpstrInitialDir = dir ;
   ofn->Flags = OFN_EXPLORER|OFN_ENABLEHOOK ;
   ofn->lpfnHook = filedlghook ;
	ofn->lpstrDefExt = 0 ;
}
void savedir (char *name, char *reg) 
{
	char buf[260],*p ;
	strcpy(buf,name) ;
   p = buf + strlen(buf) + 1 ;
//   if (!p) {
      p = strrchr(buf,'\\') ;
      if (p)
         *p = 0 ;
      else {
         p = strrchr(buf,':') ;
         if (p) {
            *(++p) = '\\' ;
            *(++p) = 0 ;
         } else
            buf[0] = 0 ;
      }
//   }
	StringToProfile(reg,buf) ;	
	
}
void AppendExtension(OPENFILENAME *ofn)
{
   if (ofn->lpstrFilter) { // has a filter
      char *p = ofn->lpstrFile + strlen(p) + 1;
      if (!p) { // they didn't multiselect

        p = strrchr(ofn->lpstrFile,'.') ;
        if (!p || *(p-1) == '.') { // has an  extension
           int n = ofn->nFilterIndex *2 - 1 ;
           char *s = ofn->lpstrFilter ;
           char *q = ofn->lpstrFileTitle + strlen(ofn->lpstrFileTitle) ;
           p = ofn->lpstrFile + strlen(ofn->lpstrFile) ;
           while (n--)
              s = s+strlen(s)+1 ;
           s = strchr(s,'.') ;
           while (*s && *s != ';') {
              *p++ = *s ;
              *q++ = *s++ ;
           }
           *p = 0 ;
           *q = 0 ;
        }
      }
   }
}
int  OpenFileDialog(OPENFILENAME *ofn, char *name, HWND handle, int new, int multiple, char *filter, char *reg, char *title)
{
	char cwd[256] ;
	HFILE xhandle ;
   szTitle = title ;
   setofndata(ofn, name,handle,(char *)ProfileToString(reg,getcwd(cwd,256)),filter) ;
	if (!new)
		ofn->Flags |= OFN_CREATEPROMPT ;
   if (multiple)
      ofn->Flags |= OFN_ALLOWMULTISELECT ;
	xhandle = GetOpenFileName(ofn) ;
	if (xhandle && xhandle != HFILE_ERROR) {
		_lclose(xhandle) ;
		savedir(szFileName,reg) ;
      AppendExtension(ofn) ;
		return 1 ;
	}
	return 0 ;
}
int SaveFileDialog(OPENFILENAME *ofn, char *name, HWND handle, int saveas,char *filter, char*reg, char *title)
{
	char cwd[256] ;
	HFILE xhandle ;
   szTitle = title ;
	setofndata(ofn, name,handle,(char *)ProfileToString(reg,getcwd(cwd,256)),filter) ;
	if (saveas)
		 ofn->Flags |= OFN_OVERWRITEPROMPT ;
	xhandle = GetSaveFileName(ofn) ;
	if (xhandle && xhandle != HFILE_ERROR) {
		_lclose(xhandle) ;
		savedir(szFileName,reg) ;
      AppendExtension(ofn) ;
		return 1 ;
	}
	return 0 ;
}