/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <windows.h>
#include <time.h>
#include <Stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <libp.h>

#undef _daylight
#undef _timezone
#undef _tzname

static int _daylight = 1;
static long _timezone=5 * 60 * 60 ;
static char tz1[36] = "EST", tz2[36]= "EDT" ;
static char * _tzname[2] = { tz1, tz2 } ;

int  *       __getDaylight(void)
{
   _ll_tzset() ;
   return &_daylight ;
}
long *       __getTimezone(void)
{
   _ll_tzset() ;
   return &_timezone ;
}
char * *     __getTzname(void)
{
   _ll_tzset() ;
   return &_tzname[0] ;
}
void _ll_tzset(void)
{
   TIME_ZONE_INFORMATION tzinfo ;
   int temp = GetTimeZoneInformation(&tzinfo) ;
   int i ;
   if (temp != TIME_ZONE_ID_INVALID) {
      _daylight = temp == TIME_ZONE_ID_DAYLIGHT ;
      _timezone = - tzinfo.Bias * 60 ;

      if (_daylight) {
         _tzname[1] = tz2 ;
      } else {
         _tzname[1] = 0 ;
      }
      for (i=0; i < 32; i++) {
         tz1[i] = tzinfo.StandardName[i] ;
         tz2[i] = tzinfo.DaylightName[i] ;
      }
   }
}