/* 
   CommonFunctions.h

   Declarations for all the Windows32 API Functions that do not have
   separate ANSI and UNICODE versions.

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Colin Peters <colin@fu.is.saga-u.ac.jp>

   Most of this file was extracted from Functions.h, by Scott Christley

   This file is part of the Windows32 API Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation, 
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   -----------
   DAL 2003 - this file modified extensively for my compiler.  New
   definitionswnwn added as well.
*/ 

#ifndef _GNU_H_WINDOWS32_COMMONFUNCTIONS
#define _GNU_H_WINDOWS32_COMMONFUNCTIONS


/* Skip if invoked by resource compiler */
#ifndef RC_INVOKED

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern WINBOOL  PASCAL AbnormalTermination(VOID);
extern int  PASCAL AbortDoc(HDC);
extern WINBOOL  PASCAL AbortPath(HDC);
extern WINBOOL  PASCAL AbortPrinter(HANDLE);
extern WINBOOL  PASCAL AbortProc(HDC, int);
extern WINBOOL  PASCAL AccessCheck(
		    PSECURITY_DESCRIPTOR  pSecurityDescriptor,
		    HANDLE  ClientToken,
		    DWORD  DesiredAccess,
		    PGENERIC_MAPPING  GenericMapping,
		    PPRIVILEGE_SET  PrivilegeSet,
		    LPDWORD  PrivilegeSetLength,
		    LPDWORD  GrantedAccess,
		    LPBOOL  AccessStatus
		    );

extern LONG
 PASCAL InterlockedIncrement(
		     LPLONG lpAddend
		     );

extern LONG
 PASCAL InterlockedDecrement(
		     LPLONG lpAddend
		     );

extern LONG
 PASCAL InterlockedExchange(
		    LPLONG Target,
		    LONG Value
		    );

extern WINBOOL
 PASCAL FreeResource(
	     HGLOBAL hResData
	     );

extern LPVOID
 PASCAL LockResource(
	     HGLOBAL hResData
	     );

extern int
 PASCAL WinMain(
	HINSTANCE hInstance,
	HINSTANCE hPrevInstance,
	LPSTR lpCmdLine,
	int nShowCmd
	);

extern WINBOOL
 PASCAL FreeLibrary(
	    HINSTANCE hLibModule
	    );


extern VOID
 PASCAL FreeLibraryAndExitThread(
			 HMODULE hLibModule,
			 DWORD dwExitCode
			 );

extern WINBOOL
 PASCAL DisableThreadLibraryCalls(
			  HMODULE hLibModule
			  );

extern FARPROC
 PASCAL GetProcAddress(
	       HINSTANCE hModule,
	       LPCSTR lpProcName
	       );

extern DWORD
 PASCAL GetVersion( VOID );

extern HGLOBAL
 PASCAL GlobalAlloc(
	    UINT uFlags,
	    DWORD dwBytes
	    );

extern HGLOBAL
GlobalDiscard(
	      HGLOBAL hglbMem
	      );

extern HGLOBAL
 PASCAL GlobalReAlloc(
	      HGLOBAL hMem,
	      DWORD dwBytes,
	      UINT uFlags
	      );

extern DWORD
 PASCAL GlobalSize(
	   HGLOBAL hMem
	   );

extern UINT
 PASCAL GlobalFlags(
	    HGLOBAL hMem
	    );


extern LPVOID
 PASCAL GlobalLock(
	   HGLOBAL hMem
	   );

extern HGLOBAL
 PASCAL GlobalHandle(
	     LPCVOID pMem
	     );


extern WINBOOL
 PASCAL GlobalUnlock(
	     HGLOBAL hMem
	     );


extern HGLOBAL
 PASCAL GlobalFree(
	   HGLOBAL hMem
	   );

extern UINT
 PASCAL GlobalCompact(
	      DWORD dwMinFree
	      );


extern VOID
 PASCAL GlobalFix(
	  HGLOBAL hMem
	  );


extern VOID
 PASCAL GlobalUnfix(
	    HGLOBAL hMem
	    );


extern LPVOID
 PASCAL GlobalWire(
	   HGLOBAL hMem
	   );


extern WINBOOL
 PASCAL GlobalUnWire(
	     HGLOBAL hMem
	     );


extern VOID
 PASCAL GlobalMemoryStatus(
		   LPMEMORYSTATUS lpBuffer
		   );


extern HLOCAL
 PASCAL LocalAlloc(
	   UINT uFlags,
	   UINT uBytes
	   );

extern HLOCAL
LocalDiscard(
	     HLOCAL hlocMem
	     );

extern HLOCAL
 PASCAL LocalReAlloc(
	     HLOCAL hMem,
	     UINT uBytes,
	     UINT uFlags
	     );


extern LPVOID
 PASCAL LocalLock(
	  HLOCAL hMem
	  );


extern HLOCAL
 PASCAL LocalHandle(
	    LPCVOID pMem
	    );


extern WINBOOL
 PASCAL LocalUnlock(
	    HLOCAL hMem
	    );


extern UINT
 PASCAL LocalSize(
	  HLOCAL hMem
	  );


extern UINT
 PASCAL LocalFlags(
	   HLOCAL hMem
	   );


extern HLOCAL
 PASCAL LocalFree(
	  HLOCAL hMem
	  );


extern UINT
 PASCAL LocalShrink(
	    HLOCAL hMem,
	    UINT cbNewSize
	    );


extern UINT
 PASCAL LocalCompact(
	     UINT uMinFree
	     );


extern WINBOOL
 PASCAL FlushInstructionCache(
		      HANDLE hProcess,
		      LPCVOID lpBaseAddress,
		      DWORD dwSize
		      );


extern LPVOID
 PASCAL VirtualAlloc(
	     LPVOID lpAddress,
	     DWORD dwSize,
	     DWORD flAllocationType,
	     DWORD flProtect
	     );


extern WINBOOL
 PASCAL VirtualFree(
	    LPVOID lpAddress,
	    DWORD dwSize,
	    DWORD dwFreeType
	    );


extern WINBOOL
 PASCAL VirtualProtect(
	       LPVOID lpAddress,
	       DWORD dwSize,
	       DWORD flNewProtect,
	       PDWORD lpflOldProtect
	       );


extern DWORD
 PASCAL VirtualQuery(
	     LPCVOID lpAddress,
	     PMEMORY_BASIC_INFORMATION lpBuffer,
	     DWORD dwLength
	     );


extern WINBOOL
 PASCAL VirtualProtectEx(
		 HANDLE hProcess,
		 LPVOID lpAddress,
		 DWORD dwSize,
		 DWORD flNewProtect,
		 PDWORD lpflOldProtect
		 );


extern DWORD
 PASCAL VirtualQueryEx(
	       HANDLE hProcess,
	       LPCVOID lpAddress,
	       PMEMORY_BASIC_INFORMATION lpBuffer,
	       DWORD dwLength
	       );


extern HANDLE
 PASCAL HeapCreate(
	   DWORD flOptions,
	   DWORD dwInitialSize,
	   DWORD dwMaximumSize
	   );

extern WINBOOL
 PASCAL HeapDestroy(
	    HANDLE hHeap
	    );

extern LPVOID
 PASCAL HeapAlloc(
	  HANDLE hHeap,
	  DWORD dwFlags,
	  DWORD dwBytes
	  );

extern LPVOID
 PASCAL HeapReAlloc(
	    HANDLE hHeap,
	    DWORD dwFlags,
	    LPVOID lpMem,
	    DWORD dwBytes
	    );

extern WINBOOL
 PASCAL HeapFree(
	 HANDLE hHeap,
	 DWORD dwFlags,
	 LPVOID lpMem
	 );

extern DWORD
 PASCAL HeapSize(
	 HANDLE hHeap,
	 DWORD dwFlags,
	 LPCVOID lpMem
	 );

extern WINBOOL
 PASCAL HeapValidate(
	     HANDLE hHeap,
	     DWORD dwFlags,
	     LPCVOID lpMem
	     );

extern UINT
 PASCAL HeapCompact(
	    HANDLE hHeap,
	    DWORD dwFlags
	    );

extern HANDLE
 PASCAL GetProcessHeap( VOID );

extern DWORD
 PASCAL GetProcessHeaps(
		DWORD NumberOfHeaps,
		PHANDLE ProcessHeaps
		);

extern WINBOOL
 PASCAL HeapLock(
	 HANDLE hHeap
	 );

extern WINBOOL
 PASCAL HeapUnlock(
	   HANDLE hHeap
	   );

extern WINBOOL
 PASCAL HeapWalk(
	 HANDLE hHeap,
	 LPPROCESS_HEAP_ENTRY lpEntry
	 );

extern WINBOOL
 PASCAL GetProcessAffinityMask(
		       HANDLE hProcess,
		       LPDWORD lpProcessAffinityMask,
		       LPDWORD lpSystemAffinityMask
		       );

extern WINBOOL
 PASCAL GetProcessTimes(
		HANDLE hProcess,
		LPFILETIME lpCreationTime,
		LPFILETIME lpExitTime,
		LPFILETIME lpKernelTime,
		LPFILETIME lpUserTime
		);

extern WINBOOL
 PASCAL GetProcessWorkingSetSize(
			 HANDLE hProcess,
			 LPDWORD lpMinimumWorkingSetSize,
			 LPDWORD lpMaximumWorkingSetSize
			 );

extern WINBOOL
 PASCAL SetProcessWorkingSetSize(
			 HANDLE hProcess,
			 DWORD dwMinimumWorkingSetSize,
			 DWORD dwMaximumWorkingSetSize
			 );

extern HANDLE
 PASCAL OpenProcess(
	    DWORD dwDesiredAccess,
	    WINBOOL bInheritHandle,
	    DWORD dwProcessId
	    );

extern HANDLE
 PASCAL GetCurrentProcess(
		  VOID
		  );

extern DWORD
 PASCAL GetCurrentProcessId(
		    VOID
		    );

extern VOID
 PASCAL ExitProcess(
	    UINT uExitCode
	    );

extern WINBOOL
 PASCAL TerminateProcess(
		 HANDLE hProcess,
		 UINT uExitCode
		 );

extern WINBOOL
 PASCAL GetExitCodeProcess(
		   HANDLE hProcess,
		   LPDWORD lpExitCode
		   );

extern VOID
 PASCAL FatalExit(
	  int ExitCode
	  );

extern VOID
 PASCAL RaiseException(
	       DWORD dwExceptionCode,
	       DWORD dwExceptionFlags,
	       DWORD nNumberOfArguments,
	       CONST DWORD *lpArguments
	       );

extern LONG
 PASCAL UnhandledExceptionFilter(
			 struct _EXCEPTION_POINTERS *ExceptionInfo
			 );

/* TODO: Should this go somewhere else? Colin Peters 1997/10/20 */
typedef LONG (*LPTOP_LEVEL_EXCEPTION_FILTER) (struct _EXCEPTION_POINTERS *);

extern LPTOP_LEVEL_EXCEPTION_FILTER
 PASCAL SetUnhandledExceptionFilter(
    LPTOP_LEVEL_EXCEPTION_FILTER lpTopLevelExceptionFilter
    );


extern HANDLE
 PASCAL CreateThread(
	     LPSECURITY_ATTRIBUTES lpThreadAttributes,
	     DWORD dwStackSize,
	     LPTHREAD_START_ROUTINE lpStartAddress,
	     LPVOID lpParameter,
	     DWORD dwCreationFlags,
	     LPDWORD lpThreadId
	     );


extern HANDLE
 PASCAL CreateRemoteThread(
		   HANDLE hProcess,
		   LPSECURITY_ATTRIBUTES lpThreadAttributes,
		   DWORD dwStackSize,
		   LPTHREAD_START_ROUTINE lpStartAddress,
		   LPVOID lpParameter,
		   DWORD dwCreationFlags,
		   LPDWORD lpThreadId
		   );


extern HANDLE
 PASCAL GetCurrentThread(
		 VOID
		 );


extern DWORD
 PASCAL GetCurrentThreadId(
		   VOID
		   );


extern DWORD
 PASCAL SetThreadAffinityMask(
		      HANDLE hThread,
		      DWORD dwThreadAffinityMask
		      );


extern WINBOOL
 PASCAL SetThreadPriority(
		  HANDLE hThread,
		  int nPriority
		  );


extern int
 PASCAL GetThreadPriority(
		  HANDLE hThread
		  );


extern WINBOOL
 PASCAL GetThreadTimes(
	       HANDLE hThread,
	       LPFILETIME lpCreationTime,
	       LPFILETIME lpExitTime,
	       LPFILETIME lpKernelTime,
	       LPFILETIME lpUserTime
	       );


extern VOID
 PASCAL ExitThread(
	   DWORD dwExitCode
	   );


extern WINBOOL
 PASCAL TerminateThread(
		HANDLE hThread,
		DWORD dwExitCode
		);


extern WINBOOL
 PASCAL GetExitCodeThread(
		  HANDLE hThread,
		  LPDWORD lpExitCode
		  );

extern WINBOOL
 PASCAL GetThreadSelectorEntry(
		       HANDLE hThread,
		       DWORD dwSelector,
		       LPLDT_ENTRY lpSelectorEntry
		       );


extern DWORD
 PASCAL GetLastError(
	     VOID
	     );


extern VOID
 PASCAL SetLastError(
	     DWORD dwErrCode
	     );


extern WINBOOL
 PASCAL GetOverlappedResult(
		    HANDLE hFile,
		    LPOVERLAPPED lpOverlapped,
		    LPDWORD lpNumberOfBytesTransferred,
		    WINBOOL bWait
		    );


extern HANDLE
 PASCAL CreateIoCompletionPort(
		       HANDLE FileHandle,
		       HANDLE ExistingCompletionPort,
		       DWORD CompletionKey,
		       DWORD NumberOfConcurrentThreads
		       );


extern WINBOOL
 PASCAL GetQueuedCompletionStatus(
			  HANDLE CompletionPort,
			  LPDWORD lpNumberOfBytesTransferred,
			  LPDWORD lpCompletionKey,
			  LPOVERLAPPED *lpOverlapped,
			  DWORD dwMilliseconds
			  );

extern UINT
 PASCAL SetErrorMode(
	     UINT uMode
	     );


extern WINBOOL
 PASCAL ReadProcessMemory(
		  HANDLE hProcess,
		  LPCVOID lpBaseAddress,
		  LPVOID lpBuffer,
		  DWORD nSize,
		  LPDWORD lpNumberOfBytesRead
		  );


extern WINBOOL
 PASCAL WriteProcessMemory(
		   HANDLE hProcess,
		   LPVOID lpBaseAddress,
		   LPVOID lpBuffer,
		   DWORD nSize,
		   LPDWORD lpNumberOfBytesWritten
		   );


extern WINBOOL
 PASCAL GetThreadContext(
		 HANDLE hThread,
		 LPCONTEXT lpContext
		 );


extern WINBOOL
 PASCAL SetThreadContext(
		 HANDLE hThread,
		 CONST CONTEXT *lpContext
		 );


extern DWORD
 PASCAL SuspendThread(
	      HANDLE hThread
	      );


extern DWORD
 PASCAL ResumeThread(
	     HANDLE hThread
	     );


extern VOID
 PASCAL DebugBreak(
	   VOID
	   );


extern WINBOOL
 PASCAL WaitForDebugEvent(
		  LPDEBUG_EVENT lpDebugEvent,
		  DWORD dwMilliseconds
		  );


extern WINBOOL
 PASCAL ContinueDebugEvent(
		   DWORD dwProcessId,
		   DWORD dwThreadId,
		   DWORD dwContinueStatus
		   );


extern WINBOOL
 PASCAL DebugActiveProcess(
		   DWORD dwProcessId
		   );


extern VOID
 PASCAL InitializeCriticalSection(
			  LPCRITICAL_SECTION lpCriticalSection
			  );


extern VOID
 PASCAL EnterCriticalSection(
		     LPCRITICAL_SECTION lpCriticalSection
		     );


extern VOID
 PASCAL LeaveCriticalSection(
		     LPCRITICAL_SECTION lpCriticalSection
		     );


extern VOID
 PASCAL DeleteCriticalSection(
		      LPCRITICAL_SECTION lpCriticalSection
		      );


extern WINBOOL
 PASCAL SetEvent(
	 HANDLE hEvent
	 );


extern WINBOOL
 PASCAL ResetEvent(
	   HANDLE hEvent
	   );


extern WINBOOL
 PASCAL PulseEvent(
	   HANDLE hEvent
	   );


extern WINBOOL
 PASCAL ReleaseSemaphore(
		 HANDLE hSemaphore,
		 LONG lReleaseCount,
		 LPLONG lpPreviousCount
		 );


extern WINBOOL
 PASCAL ReleaseMutex(
	     HANDLE hMutex
	     );


extern DWORD
 PASCAL WaitForSingleObject(
		    HANDLE hHandle,
		    DWORD dwMilliseconds
		    );


extern DWORD
 PASCAL WaitForMultipleObjects(
		       DWORD nCount,
		       CONST HANDLE *lpHandles,
		       WINBOOL bWaitAll,
		       DWORD dwMilliseconds
		       );


extern VOID
 PASCAL Sleep(
      DWORD dwMilliseconds
      );


extern HGLOBAL
 PASCAL LoadResource(
	     HINSTANCE hModule,
	     HRSRC hResInfo
	     );


extern DWORD
 PASCAL SizeofResource(
	       HINSTANCE hModule,
	       HRSRC hResInfo
	       );



extern ATOM
 PASCAL GlobalDeleteAtom(
		 ATOM nAtom
		 );


extern WINBOOL
 PASCAL InitAtomTable(
	      DWORD nSize
	      );


extern ATOM
 PASCAL DeleteAtom(
	   ATOM nAtom
	   );


extern UINT
 PASCAL SetHandleCount(
	       UINT uNumber
	       );


extern DWORD
 PASCAL GetLogicalDrives(
		 VOID
		 );


extern WINBOOL
 PASCAL LockFile(
	 HANDLE hFile,
	 DWORD dwFileOffsetLow,
	 DWORD dwFileOffsetHigh,
	 DWORD nNumberOfBytesToLockLow,
	 DWORD nNumberOfBytesToLockHigh
	 );


extern WINBOOL
 PASCAL UnlockFile(
	   HANDLE hFile,
	   DWORD dwFileOffsetLow,
	   DWORD dwFileOffsetHigh,
	   DWORD nNumberOfBytesToUnlockLow,
	   DWORD nNumberOfBytesToUnlockHigh
	   );


extern WINBOOL
 PASCAL LockFileEx(
	   HANDLE hFile,
	   DWORD dwFlags,
	   DWORD dwReserved,
	   DWORD nNumberOfBytesToLockLow,
	   DWORD nNumberOfBytesToLockHigh,
	   LPOVERLAPPED lpOverlapped
	   );

extern WINBOOL
 PASCAL UnlockFileEx(
	     HANDLE hFile,
	     DWORD dwReserved,
	     DWORD nNumberOfBytesToUnlockLow,
	     DWORD nNumberOfBytesToUnlockHigh,
	     LPOVERLAPPED lpOverlapped
	     );

extern WINBOOL
 PASCAL GetFileInformationByHandle(
			   HANDLE hFile,
			   LPBY_HANDLE_FILE_INFORMATION lpFileInformation
			   );


extern DWORD
 PASCAL GetFileType(
	    HANDLE hFile
	    );


extern DWORD
 PASCAL GetFileSize(
	    HANDLE hFile,
	    LPDWORD lpFileSizeHigh
	    );


extern HANDLE
 PASCAL GetStdHandle(
	     DWORD nStdHandle
	     );


extern WINBOOL
 PASCAL SetStdHandle(
	     DWORD nStdHandle,
	     HANDLE hHandle
	     );


extern WINBOOL
 PASCAL WriteFile(
	  HANDLE hFile,
	  LPCVOID lpBuffer,
	  DWORD nNumberOfBytesToWrite,
	  LPDWORD lpNumberOfBytesWritten,
	  LPOVERLAPPED lpOverlapped
	  );


extern WINBOOL
 PASCAL ReadFile(
	 HANDLE hFile,
	 LPVOID lpBuffer,
	 DWORD nNumberOfBytesToRead,
	 LPDWORD lpNumberOfBytesRead,
	 LPOVERLAPPED lpOverlapped
	 );


extern WINBOOL
 PASCAL FlushFileBuffers(
		 HANDLE hFile
		 );


extern WINBOOL
 PASCAL DeviceIoControl(
		HANDLE hDevice,
		DWORD dwIoControlCode,
		LPVOID lpInBuffer,
		DWORD nInBufferSize,
		LPVOID lpOutBuffer,
		DWORD nOutBufferSize,
		LPDWORD lpBytesReturned,
		LPOVERLAPPED lpOverlapped
		);


extern WINBOOL
 PASCAL SetEndOfFile(
	     HANDLE hFile
	     );


extern DWORD
 PASCAL SetFilePointer(
	       HANDLE hFile,
	       LONG lDistanceToMove,
	       PLONG lpDistanceToMoveHigh,
	       DWORD dwMoveMethod
	       );


extern WINBOOL
 PASCAL FindClose(
	  HANDLE hFindFile
	  );


extern WINBOOL
 PASCAL GetFileTime(
	    HANDLE hFile,
	    LPFILETIME lpCreationTime,
	    LPFILETIME lpLastAccessTime,
	    LPFILETIME lpLastWriteTime
	    );


extern WINBOOL
 PASCAL SetFileTime(
	    HANDLE hFile,
	    CONST FILETIME *lpCreationTime,
	    CONST FILETIME *lpLastAccessTime,
	    CONST FILETIME *lpLastWriteTime
	    );


extern WINBOOL
 PASCAL CloseHandle(
	    HANDLE hObject
	    );


extern WINBOOL
 PASCAL DuplicateHandle(
		HANDLE hSourceProcessHandle,
		HANDLE hSourceHandle,
		HANDLE hTargetProcessHandle,
		LPHANDLE lpTargetHandle,
		DWORD dwDesiredAccess,
		WINBOOL bInheritHandle,
		DWORD dwOptions
		);


extern WINBOOL
 PASCAL GetHandleInformation(
		     HANDLE hObject,
		     LPDWORD lpdwFlags
		     );


extern WINBOOL
 PASCAL SetHandleInformation(
		     HANDLE hObject,
		     DWORD dwMask,
		     DWORD dwFlags
		     );

extern DWORD
 PASCAL LoadModule(
	   LPCSTR lpModuleName,
	   LPVOID lpParameterBlock
	   );


extern UINT
 PASCAL WinExec(
	LPCSTR lpCmdLine,
	UINT uCmdShow
	);


extern WINBOOL
 PASCAL ClearCommBreak(
	       HANDLE hFile
	       );


extern WINBOOL
 PASCAL ClearCommError(
	       HANDLE hFile,
	       LPDWORD lpErrors,
	       LPCOMSTAT lpStat
	       );


extern WINBOOL
 PASCAL SetupComm(
	  HANDLE hFile,
	  DWORD dwInQueue,
	  DWORD dwOutQueue
	  );


extern WINBOOL
 PASCAL EscapeCommFunction(
		   HANDLE hFile,
		   DWORD dwFunc
		   );


extern WINBOOL
 PASCAL GetCommConfig(
	      HANDLE hCommDev,
	      LPCOMMCONFIG lpCC,
	      LPDWORD lpdwSize
	      );


extern WINBOOL
 PASCAL GetCommMask(
	    HANDLE hFile,
	    LPDWORD lpEvtMask
	    );


extern WINBOOL
 PASCAL GetCommProperties(
		  HANDLE hFile,
		  LPCOMMPROP lpCommProp
		  );


extern WINBOOL
 PASCAL GetCommModemStatus(
		   HANDLE hFile,
		   LPDWORD lpModemStat
		   );


extern WINBOOL
 PASCAL GetCommState(
	     HANDLE hFile,
	     LPDCB lpDCB
	     );


extern WINBOOL
 PASCAL GetCommTimeouts(
		HANDLE hFile,
		LPCOMMTIMEOUTS lpCommTimeouts
		);


extern WINBOOL
 PASCAL PurgeComm(
	  HANDLE hFile,
	  DWORD dwFlags
	  );


extern WINBOOL
 PASCAL SetCommBreak(
	     HANDLE hFile
	     );


extern WINBOOL
 PASCAL SetCommConfig(
	      HANDLE hCommDev,
	      LPCOMMCONFIG lpCC,
	      DWORD dwSize
	      );


extern WINBOOL
 PASCAL SetCommMask(
	    HANDLE hFile,
	    DWORD dwEvtMask
	    );


extern WINBOOL
 PASCAL SetCommState(
	     HANDLE hFile,
	     LPDCB lpDCB
	     );


extern WINBOOL
 PASCAL SetCommTimeouts(
		HANDLE hFile,
		LPCOMMTIMEOUTS lpCommTimeouts
		);


extern WINBOOL
 PASCAL TransmitCommChar(
		 HANDLE hFile,
		 char cChar
		 );


extern WINBOOL
 PASCAL WaitCommEvent(
	      HANDLE hFile,
	      LPDWORD lpEvtMask,
	      LPOVERLAPPED lpOverlapped
	      );



extern DWORD
 PASCAL SetTapePosition(
		HANDLE hDevice,
		DWORD dwPositionMethod,
		DWORD dwPartition,
		DWORD dwOffsetLow,
		DWORD dwOffsetHigh,
		WINBOOL bImmediate
		);


extern DWORD
 PASCAL GetTapePosition(
		HANDLE hDevice,
		DWORD dwPositionType,
		LPDWORD lpdwPartition,
		LPDWORD lpdwOffsetLow,
		LPDWORD lpdwOffsetHigh
		);


extern DWORD
 PASCAL PrepareTape(
	    HANDLE hDevice,
	    DWORD dwOperation,
	    WINBOOL bImmediate
	    );


extern DWORD
 PASCAL EraseTape(
	  HANDLE hDevice,
	  DWORD dwEraseType,
	  WINBOOL bImmediate
	  );


extern DWORD
 PASCAL CreateTapePartition(
		    HANDLE hDevice,
		    DWORD dwPartitionMethod,
		    DWORD dwCount,
		    DWORD dwSize
		    );


extern DWORD
 PASCAL WriteTapemark(
	      HANDLE hDevice,
	      DWORD dwTapemarkType,
	      DWORD dwTapemarkCount,
	      WINBOOL bImmediate
	      );


extern DWORD
 PASCAL GetTapeStatus(
	      HANDLE hDevice
	      );


extern DWORD
 PASCAL GetTapeParameters(
		  HANDLE hDevice,
		  DWORD dwOperation,
		  LPDWORD lpdwSize,
		  LPVOID lpTapeInformation
		  );

extern DWORD
 PASCAL SetTapeParameters(
		  HANDLE hDevice,
		  DWORD dwOperation,
		  LPVOID lpTapeInformation
		  );

extern WINBOOL
 PASCAL Beep(
     DWORD dwFreq,
     DWORD dwDuration
     );


extern VOID
 PASCAL OpenSound(
	  VOID
	  );


extern VOID
 PASCAL CloseSound(
	   VOID
	   );


extern VOID
 PASCAL StartSound(
	   VOID
	   );


extern VOID
 PASCAL StopSound(
	  VOID
	  );


extern DWORD
 PASCAL WaitSoundState(
	       DWORD nState
	       );


extern DWORD
 PASCAL SyncAllVoices(
	      VOID
	      );


extern DWORD
 PASCAL CountVoiceNotes(
		DWORD nVoice
		);


extern LPDWORD
 PASCAL GetThresholdEvent(
		  VOID
		  );


extern DWORD
 PASCAL GetThresholdStatus(
		   VOID
		   );


extern DWORD
 PASCAL SetSoundNoise(
	      DWORD nSource,
	      DWORD nDuration
	      );


extern DWORD
 PASCAL SetVoiceAccent(
	       DWORD nVoice,
	       DWORD nTempo,
	       DWORD nVolume,
	       DWORD nMode,
	       DWORD nPitch
	       );


extern DWORD
 PASCAL SetVoiceEnvelope(
		 DWORD nVoice,
		 DWORD nShape,
		 DWORD nRepeat
		 );


extern DWORD
 PASCAL SetVoiceNote(
	     DWORD nVoice,
	     DWORD nValue,
	     DWORD nLength,
	     DWORD nCdots
	     );


extern DWORD
 PASCAL SetVoiceQueueSize(
		  DWORD nVoice,
		  DWORD nBytes
		  );


extern DWORD
 PASCAL SetVoiceSound(
	      DWORD nVoice,
	      DWORD Frequency,
	      DWORD nDuration
	      );


extern DWORD
 PASCAL SetVoiceThreshold(
		  DWORD nVoice,
		  DWORD nNotes
		  );


extern int
 PASCAL MulDiv(
       int nNumber,
       int nNumerator,
       int nDenominator
       );


extern VOID
 PASCAL GetSystemTime(
	      LPSYSTEMTIME lpSystemTime
	      );


extern WINBOOL
 PASCAL SetSystemTime(
	      CONST SYSTEMTIME *lpSystemTime
	      );


extern VOID
 PASCAL GetLocalTime(
	     LPSYSTEMTIME lpSystemTime
	     );


extern WINBOOL
 PASCAL SetLocalTime(
	     CONST SYSTEMTIME *lpSystemTime
	     );


extern VOID
 PASCAL GetSystemInfo(
	      LPSYSTEM_INFO lpSystemInfo
	      );

extern WINBOOL
 PASCAL SystemTimeToTzSpecificLocalTime(
				LPTIME_ZONE_INFORMATION lpTimeZoneInformation,
				LPSYSTEMTIME lpUniversalTime,
				LPSYSTEMTIME lpLocalTime
				);


extern DWORD
 PASCAL GetTimeZoneInformation(
		       LPTIME_ZONE_INFORMATION lpTimeZoneInformation
		       );


extern WINBOOL
 PASCAL SetTimeZoneInformation(
		       CONST TIME_ZONE_INFORMATION *lpTimeZoneInformation
		       );

extern WINBOOL
 PASCAL SystemTimeToFileTime(
		     CONST SYSTEMTIME *lpSystemTime,
		     LPFILETIME lpFileTime
		     );


extern WINBOOL
 PASCAL FileTimeToLocalFileTime(
			CONST FILETIME *lpFileTime,
			LPFILETIME lpLocalFileTime
			);


extern WINBOOL
 PASCAL LocalFileTimeToFileTime(
			CONST FILETIME *lpLocalFileTime,
			LPFILETIME lpFileTime
			);


extern WINBOOL
 PASCAL FileTimeToSystemTime(
		     CONST FILETIME *lpFileTime,
		     LPSYSTEMTIME lpSystemTime
		     );


extern LONG
 PASCAL CompareFileTime(
		CONST FILETIME *lpFileTime1,
		CONST FILETIME *lpFileTime2
		);


extern WINBOOL
 PASCAL FileTimeToDosDateTime(
		      CONST FILETIME *lpFileTime,
		      LPWORD lpFatDate,
		      LPWORD lpFatTime
		      );


extern WINBOOL
 PASCAL DosDateTimeToFileTime(
		      WORD wFatDate,
		      WORD wFatTime,
		      LPFILETIME lpFileTime
		      );


extern DWORD
 PASCAL GetTickCount(
	     VOID
	     );


extern WINBOOL
 PASCAL SetSystemTimeAdjustment(
			DWORD dwTimeAdjustment,
			WINBOOL  bTimeAdjustmentDisabled
			);


extern WINBOOL
 PASCAL GetSystemTimeAdjustment(
			PDWORD lpTimeAdjustment,
			PDWORD lpTimeIncrement,
			PWINBOOL  lpTimeAdjustmentDisabled
			);


extern WINBOOL
 PASCAL CreatePipe(
	   PHANDLE hReadPipe,
	   PHANDLE hWritePipe,
	   LPSECURITY_ATTRIBUTES lpPipeAttributes,
	   DWORD nSize
	   );


extern WINBOOL
 PASCAL ConnectNamedPipe(
		 HANDLE hNamedPipe,
		 LPOVERLAPPED lpOverlapped
		 );


extern WINBOOL
 PASCAL DisconnectNamedPipe(
		    HANDLE hNamedPipe
		    );


extern WINBOOL
 PASCAL SetNamedPipeHandleState(
			HANDLE hNamedPipe,
			LPDWORD lpMode,
			LPDWORD lpMaxCollectionCount,
			LPDWORD lpCollectDataTimeout
			);


extern WINBOOL
 PASCAL GetNamedPipeInfo(
		 HANDLE hNamedPipe,
		 LPDWORD lpFlags,
		 LPDWORD lpOutBufferSize,
		 LPDWORD lpInBufferSize,
		 LPDWORD lpMaxInstances
		 );


extern WINBOOL
 PASCAL PeekNamedPipe(
	      HANDLE hNamedPipe,
	      LPVOID lpBuffer,
	      DWORD nBufferSize,
	      LPDWORD lpBytesRead,
	      LPDWORD lpTotalBytesAvail,
	      LPDWORD lpBytesLeftThisMessage
	      );


extern WINBOOL
 PASCAL TransactNamedPipe(
		  HANDLE hNamedPipe,
		  LPVOID lpInBuffer,
		  DWORD nInBufferSize,
		  LPVOID lpOutBuffer,
		  DWORD nOutBufferSize,
		  LPDWORD lpBytesRead,
		  LPOVERLAPPED lpOverlapped
		  );



extern WINBOOL
 PASCAL GetMailslotInfo(
		HANDLE hMailslot,
		LPDWORD lpMaxMessageSize,
		LPDWORD lpNextSize,
		LPDWORD lpMessageCount,
		LPDWORD lpReadTimeout
		);


extern WINBOOL
 PASCAL SetMailslotInfo(
		HANDLE hMailslot,
		DWORD lReadTimeout
		);


extern LPVOID
 PASCAL MapViewOfFile(
	      HANDLE hFileMappingObject,
	      DWORD dwDesiredAccess,
	      DWORD dwFileOffsetHigh,
	      DWORD dwFileOffsetLow,
	      DWORD dwNumberOfBytesToMap
	      );


extern WINBOOL
 PASCAL FlushViewOfFile(
		LPCVOID lpBaseAddress,
		DWORD dwNumberOfBytesToFlush
		);


extern WINBOOL
 PASCAL UnmapViewOfFile(
		LPVOID lpBaseAddress
		);

extern HFILE
 PASCAL OpenFile(
	 LPCSTR lpFileName,
	 LPOFSTRUCT lpReOpenBuff,
	 UINT uStyle
	 );


extern HFILE
 PASCAL _lopen(
       LPCSTR lpPathName,
       int iReadWrite
       );


extern HFILE
 PASCAL _lcreat(
	LPCSTR lpPathName,
	int  iAttribute
	);


extern UINT
 PASCAL _lread(
       HFILE hFile,
       LPVOID lpBuffer,
       UINT uBytes
       );


extern UINT
 PASCAL _lwrite(
	HFILE hFile,
	LPCSTR lpBuffer,
	UINT uBytes
	);


extern long
 PASCAL _hread(
       HFILE hFile,
       LPVOID lpBuffer,
       long lBytes
       );


extern long
 PASCAL _hwrite(
	HFILE hFile,
	LPCSTR lpBuffer,
	long lBytes
	);


extern HFILE
 PASCAL _lclose(
	HFILE hFile
	);


extern LONG
 PASCAL _llseek(
	HFILE hFile,
	LONG lOffset,
	int iOrigin
	);


extern WINBOOL
 PASCAL IsTextUnicode(
	      CONST LPVOID lpBuffer,
	      int cb,
	      LPINT lpi
	      );


extern DWORD
 PASCAL TlsAlloc(
	 VOID
	 );

extern LPVOID
 PASCAL TlsGetValue(
	    DWORD dwTlsIndex
	    );


extern WINBOOL
 PASCAL TlsSetValue(
	    DWORD dwTlsIndex,
	    LPVOID lpTlsValue
	    );


extern WINBOOL
 PASCAL TlsFree(
	DWORD dwTlsIndex
	);

extern DWORD
 PASCAL SleepEx(
	DWORD dwMilliseconds,
	WINBOOL bAlertable
	);


extern DWORD
 PASCAL WaitForSingleObjectEx(
		      HANDLE hHandle,
		      DWORD dwMilliseconds,
		      WINBOOL bAlertable
		      );


extern DWORD
 PASCAL WaitForMultipleObjectsEx(
			 DWORD nCount,
			 CONST HANDLE *lpHandles,
			 WINBOOL bWaitAll,
			 DWORD dwMilliseconds,
			 WINBOOL bAlertable
			 );


extern WINBOOL
 PASCAL ReadFileEx(
	   HANDLE hFile,
	   LPVOID lpBuffer,
	   DWORD nNumberOfBytesToRead,
	   LPOVERLAPPED lpOverlapped,
	   LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
	   );


extern WINBOOL
 PASCAL WriteFileEx(
	    HANDLE hFile,
	    LPCVOID lpBuffer,
	    DWORD nNumberOfBytesToWrite,
	    LPOVERLAPPED lpOverlapped,
	    LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine
	    );


extern WINBOOL
 PASCAL BackupRead(
	   HANDLE hFile,
	   LPBYTE lpBuffer,
	   DWORD nNumberOfBytesToRead,
	   LPDWORD lpNumberOfBytesRead,
	   WINBOOL bAbort,
	   WINBOOL bProcessSecurity,
	   LPVOID *lpContext
	   );


extern WINBOOL
 PASCAL BackupSeek(
	   HANDLE hFile,
	   DWORD  dwLowBytesToSeek,
	   DWORD  dwHighBytesToSeek,
	   LPDWORD lpdwLowByteSeeked,
	   LPDWORD lpdwHighByteSeeked,
	   LPVOID *lpContext
	   );


extern WINBOOL
 PASCAL BackupWrite(
	    HANDLE hFile,
	    LPBYTE lpBuffer,
	    DWORD nNumberOfBytesToWrite,
	    LPDWORD lpNumberOfBytesWritten,
	    WINBOOL bAbort,
	    WINBOOL bProcessSecurity,
	    LPVOID *lpContext
	    );

extern WINBOOL
 PASCAL SetProcessShutdownParameters(
			     DWORD dwLevel,
			     DWORD dwFlags
			     );


extern WINBOOL
 PASCAL GetProcessShutdownParameters(
			     LPDWORD lpdwLevel,
			     LPDWORD lpdwFlags
			     );


extern VOID
 PASCAL SetFileApisToOEM( VOID );


extern VOID
 PASCAL SetFileApisToANSI( VOID );


extern WINBOOL
 PASCAL AreFileApisANSI( VOID );

extern WINBOOL
 PASCAL CloseEventLog(
	       HANDLE hEventLog
		);


extern WINBOOL
 PASCAL DeregisterEventSource(
		       HANDLE hEventLog
			);


extern WINBOOL
 PASCAL NotifyChangeEventLog(
		      HANDLE hEventLog,
		      HANDLE hEvent
		       );


extern WINBOOL
 PASCAL GetNumberOfEventLogRecords(
			    HANDLE hEventLog,
			    PDWORD NumberOfRecords
			     );


extern WINBOOL
 PASCAL GetOldestEventLogRecord(
			 HANDLE hEventLog,
			 PDWORD OldestRecord
			  );

extern WINBOOL
 PASCAL DuplicateToken(
	       HANDLE ExistingTokenHandle,
	       SECURITY_IMPERSONATION_LEVEL ImpersonationLevel,
	       PHANDLE DuplicateTokenHandle
	       );


extern WINBOOL
 PASCAL GetKernelObjectSecurity(
			 HANDLE Handle,
			 SECURITY_INFORMATION RequestedInformation,
			 PSECURITY_DESCRIPTOR pSecurityDescriptor,
			 DWORD nLength,
			 LPDWORD lpnLengthNeeded
			  );


extern WINBOOL
 PASCAL ImpersonateNamedPipeClient(
			   HANDLE hNamedPipe
			   );


extern WINBOOL
 PASCAL ImpersonateSelf(
		SECURITY_IMPERSONATION_LEVEL ImpersonationLevel
		);



extern WINBOOL
 PASCAL RevertToSelf(
	      VOID
	       );


extern WINBOOL
 PASCAL SetThreadToken(
		PHANDLE Thread,
		HANDLE Token
		 );


extern WINBOOL
 PASCAL AccessCheck(
	     PSECURITY_DESCRIPTOR pSecurityDescriptor,
	     HANDLE ClientToken,
	     DWORD DesiredAccess,
	     PGENERIC_MAPPING GenericMapping,
	     PPRIVILEGE_SET PrivilegeSet,
	     LPDWORD PrivilegeSetLength,
	     LPDWORD GrantedAccess,
	     LPBOOL AccessStatus
	      );



extern WINBOOL
 PASCAL OpenProcessToken(
		  HANDLE ProcessHandle,
		  DWORD DesiredAccess,
		  PHANDLE TokenHandle
		   );



extern WINBOOL
 PASCAL OpenThreadToken(
		 HANDLE ThreadHandle,
		 DWORD DesiredAccess,
		 WINBOOL OpenAsSelf,
		 PHANDLE TokenHandle
		  );



extern WINBOOL
 PASCAL GetTokenInformation(
		     HANDLE TokenHandle,
		     TOKEN_INFORMATION_CLASS TokenInformationClass,
		     LPVOID TokenInformation,
		     DWORD TokenInformationLength,
		     PDWORD ReturnLength
		      );



extern WINBOOL
 PASCAL SetTokenInformation(
		     HANDLE TokenHandle,
		     TOKEN_INFORMATION_CLASS TokenInformationClass,
		     LPVOID TokenInformation,
		     DWORD TokenInformationLength
		      );



extern WINBOOL
 PASCAL AdjustTokenPrivileges(
		       HANDLE TokenHandle,
		       WINBOOL DisableAllPrivileges,
		       PTOKEN_PRIVILEGES NewState,
		       DWORD BufferLength,
		       PTOKEN_PRIVILEGES PreviousState,
		       PDWORD ReturnLength
			);



extern WINBOOL
 PASCAL AdjustTokenGroups(
		   HANDLE TokenHandle,
		   WINBOOL ResetToDefault,
		   PTOKEN_GROUPS NewState,
		   DWORD BufferLength,
		   PTOKEN_GROUPS PreviousState,
		   PDWORD ReturnLength
		    );



extern WINBOOL
 PASCAL PrivilegeCheck(
		HANDLE ClientToken,
		PPRIVILEGE_SET RequiredPrivileges,
		LPBOOL pfResult
		 );



extern WINBOOL
 PASCAL IsValidSid(
	    PSID pSid
	     );



extern WINBOOL
 PASCAL EqualSid(
	  PSID pSid1,
	  PSID pSid2
	   );



extern WINBOOL
 PASCAL EqualPrefixSid(
		PSID pSid1,
		PSID pSid2
		 );



extern DWORD
 PASCAL GetSidLengthRequired(
		      UCHAR nSubAuthorityCount
		       );



extern WINBOOL
 PASCAL AllocateAndInitializeSid(
			  PSID_IDENTIFIER_AUTHORITY pIdentifierAuthority,
			  BYTE nSubAuthorityCount,
			  DWORD nSubAuthority0,
			  DWORD nSubAuthority1,
			  DWORD nSubAuthority2,
			  DWORD nSubAuthority3,
			  DWORD nSubAuthority4,
			  DWORD nSubAuthority5,
			  DWORD nSubAuthority6,
			  DWORD nSubAuthority7,
			  PSID *pSid
			   );


extern PVOID
 PASCAL FreeSid(
	PSID pSid
	);


extern WINBOOL
 PASCAL InitializeSid(
	       PSID Sid,
	       PSID_IDENTIFIER_AUTHORITY pIdentifierAuthority,
	       BYTE nSubAuthorityCount
		);



extern PSID_IDENTIFIER_AUTHORITY
 PASCAL GetSidIdentifierAuthority(
			   PSID pSid
			    );



extern PDWORD
 PASCAL GetSidSubAuthority(
		    PSID pSid,
		    DWORD nSubAuthority
		     );



extern PUCHAR
 PASCAL GetSidSubAuthorityCount(
			 PSID pSid
			  );



extern DWORD
 PASCAL GetLengthSid(
	      PSID pSid
	       );



extern WINBOOL
 PASCAL CopySid(
	 DWORD nDestinationSidLength,
	 PSID pDestinationSid,
	 PSID pSourceSid
	  );



extern WINBOOL
 PASCAL AreAllAccessesGranted(
		       DWORD GrantedAccess,
		       DWORD DesiredAccess
			);



extern WINBOOL
 PASCAL AreAnyAccessesGranted(
		       DWORD GrantedAccess,
		       DWORD DesiredAccess
			);



extern VOID
 PASCAL MapGenericMask(
		PDWORD AccessMask,
		PGENERIC_MAPPING GenericMapping
		 );



extern WINBOOL
 PASCAL IsValidAcl(
	    PACL pAcl
	     );



extern WINBOOL
 PASCAL InitializeAcl(
	       PACL pAcl,
	       DWORD nAclLength,
	       DWORD dwAclRevision
		);



extern WINBOOL
 PASCAL GetAclInformation(
		   PACL pAcl,
		   LPVOID pAclInformation,
		   DWORD nAclInformationLength,
		   ACL_INFORMATION_CLASS dwAclInformationClass
		    );



extern WINBOOL
 PASCAL SetAclInformation(
		   PACL pAcl,
		   LPVOID pAclInformation,
		   DWORD nAclInformationLength,
		   ACL_INFORMATION_CLASS dwAclInformationClass
		    );



extern WINBOOL
 PASCAL AddAce(
	PACL pAcl,
	DWORD dwAceRevision,
	DWORD dwStartingAceIndex,
	LPVOID pAceList,
	DWORD nAceListLength
	 );



extern WINBOOL
 PASCAL DeleteAce(
	   PACL pAcl,
	   DWORD dwAceIndex
	    );



extern WINBOOL
 PASCAL GetAce(
	PACL pAcl,
	DWORD dwAceIndex,
	LPVOID *pAce
	 );



extern WINBOOL
 PASCAL AddAccessAllowedAce(
		     PACL pAcl,
		     DWORD dwAceRevision,
		     DWORD AccessMask,
		     PSID pSid
		      );



extern WINBOOL
 PASCAL AddAccessDeniedAce(
		    PACL pAcl,
		    DWORD dwAceRevision,
		    DWORD AccessMask,
		    PSID pSid
		     );



extern WINBOOL
 PASCAL AddAuditAccessAce(
		  PACL pAcl,
		  DWORD dwAceRevision,
		  DWORD dwAccessMask,
		  PSID pSid,
		  WINBOOL bAuditSuccess,
		  WINBOOL bAuditFailure
		  );



extern WINBOOL
 PASCAL FindFirstFreeAce(
		  PACL pAcl,
		  LPVOID *pAce
		   );



extern WINBOOL
 PASCAL InitializeSecurityDescriptor(
			      PSECURITY_DESCRIPTOR pSecurityDescriptor,
			      DWORD dwRevision
			       );



extern WINBOOL
 PASCAL IsValidSecurityDescriptor(
			   PSECURITY_DESCRIPTOR pSecurityDescriptor
			    );



extern DWORD
 PASCAL GetSecurityDescriptorLength(
			     PSECURITY_DESCRIPTOR pSecurityDescriptor
			      );



extern WINBOOL
 PASCAL GetSecurityDescriptorControl(
			      PSECURITY_DESCRIPTOR pSecurityDescriptor,
			      PSECURITY_DESCRIPTOR_CONTROL pControl,
			      LPDWORD lpdwRevision
			       );



extern WINBOOL
 PASCAL SetSecurityDescriptorDacl(
			   PSECURITY_DESCRIPTOR pSecurityDescriptor,
			   WINBOOL bDaclPresent,
			   PACL pDacl,
			   WINBOOL bDaclDefaulted
			    );



extern WINBOOL
 PASCAL GetSecurityDescriptorDacl(
			   PSECURITY_DESCRIPTOR pSecurityDescriptor,
			   LPBOOL lpbDaclPresent,
			   PACL *pDacl,
			   LPBOOL lpbDaclDefaulted
			    );



extern WINBOOL
 PASCAL SetSecurityDescriptorSacl(
			   PSECURITY_DESCRIPTOR pSecurityDescriptor,
			   WINBOOL bSaclPresent,
			   PACL pSacl,
			   WINBOOL bSaclDefaulted
			    );



extern WINBOOL
 PASCAL GetSecurityDescriptorSacl(
			   PSECURITY_DESCRIPTOR pSecurityDescriptor,
			   LPBOOL lpbSaclPresent,
			   PACL *pSacl,
			   LPBOOL lpbSaclDefaulted
			    );



extern WINBOOL
 PASCAL SetSecurityDescriptorOwner(
			    PSECURITY_DESCRIPTOR pSecurityDescriptor,
			    PSID pOwner,
			    WINBOOL bOwnerDefaulted
			     );



extern WINBOOL
 PASCAL GetSecurityDescriptorOwner(
			    PSECURITY_DESCRIPTOR pSecurityDescriptor,
			    PSID *pOwner,
			    LPBOOL lpbOwnerDefaulted
			     );



extern WINBOOL
 PASCAL SetSecurityDescriptorGroup(
			    PSECURITY_DESCRIPTOR pSecurityDescriptor,
			    PSID pGroup,
			    WINBOOL bGroupDefaulted
			     );



extern WINBOOL
 PASCAL GetSecurityDescriptorGroup(
			    PSECURITY_DESCRIPTOR pSecurityDescriptor,
			    PSID *pGroup,
			    LPBOOL lpbGroupDefaulted
			     );



extern WINBOOL
 PASCAL CreatePrivateObjectSecurity(
			     PSECURITY_DESCRIPTOR ParentDescriptor,
			     PSECURITY_DESCRIPTOR CreatorDescriptor,
			     PSECURITY_DESCRIPTOR * NewDescriptor,
			     WINBOOL IsDirectoryObject,
			     HANDLE Token,
			     PGENERIC_MAPPING GenericMapping
			      );



extern WINBOOL
 PASCAL SetPrivateObjectSecurity(
			  SECURITY_INFORMATION SecurityInformation,
			  PSECURITY_DESCRIPTOR ModificationDescriptor,
			  PSECURITY_DESCRIPTOR *ObjectsSecurityDescriptor,
			  PGENERIC_MAPPING GenericMapping,
			  HANDLE Token
			   );



extern WINBOOL
 PASCAL GetPrivateObjectSecurity(
			  PSECURITY_DESCRIPTOR ObjectDescriptor,
			  SECURITY_INFORMATION SecurityInformation,
			  PSECURITY_DESCRIPTOR ResultantDescriptor,
			  DWORD DescriptorLength,
			  PDWORD ReturnLength
			   );



extern WINBOOL
 PASCAL DestroyPrivateObjectSecurity(
			      PSECURITY_DESCRIPTOR * ObjectDescriptor
			       );



extern WINBOOL
 PASCAL MakeSelfRelativeSD(
		    PSECURITY_DESCRIPTOR pAbsoluteSecurityDescriptor,
		    PSECURITY_DESCRIPTOR pSelfRelativeSecurityDescriptor,
		    LPDWORD lpdwBufferLength
		     );



extern WINBOOL
 PASCAL MakeAbsoluteSD(
		PSECURITY_DESCRIPTOR pSelfRelativeSecurityDescriptor,
		PSECURITY_DESCRIPTOR pAbsoluteSecurityDescriptor,
		LPDWORD lpdwAbsoluteSecurityDescriptorSize,
		PACL pDacl,
		LPDWORD lpdwDaclSize,
		PACL pSacl,
		LPDWORD lpdwSaclSize,
		PSID pOwner,
		LPDWORD lpdwOwnerSize,
		PSID pPrimaryGroup,
		LPDWORD lpdwPrimaryGroupSize
		 );



extern WINBOOL
 PASCAL SetKernelObjectSecurity(
			 HANDLE Handle,
			 SECURITY_INFORMATION SecurityInformation,
			 PSECURITY_DESCRIPTOR SecurityDescriptor
			  );


extern WINBOOL
 PASCAL FindNextChangeNotification(
			   HANDLE hChangeHandle
			   );


extern WINBOOL
 PASCAL FindCloseChangeNotification(
			    HANDLE hChangeHandle
			    );


extern WINBOOL
 PASCAL VirtualLock(
	    LPVOID lpAddress,
	    DWORD dwSize
	    );


extern WINBOOL
 PASCAL VirtualUnlock(
	      LPVOID lpAddress,
	      DWORD dwSize
	      );


extern LPVOID
 PASCAL MapViewOfFileEx(
		HANDLE hFileMappingObject,
		DWORD dwDesiredAccess,
		DWORD dwFileOffsetHigh,
		DWORD dwFileOffsetLow,
		DWORD dwNumberOfBytesToMap,
		LPVOID lpBaseAddress
		);


extern WINBOOL
 PASCAL SetPriorityClass(
		 HANDLE hProcess,
		 DWORD dwPriorityClass
		 );


extern DWORD
 PASCAL GetPriorityClass(
		 HANDLE hProcess
		 );


extern WINBOOL
 PASCAL IsBadReadPtr(
	     CONST VOID *lp,
	     UINT ucb
	     );


extern WINBOOL
 PASCAL IsBadWritePtr(
	      LPVOID lp,
	      UINT ucb
	      );


extern WINBOOL
 PASCAL IsBadHugeReadPtr(
		 CONST VOID *lp,
		 UINT ucb
		 );


extern WINBOOL
 PASCAL IsBadHugeWritePtr(
		  LPVOID lp,
		  UINT ucb
		  );


extern WINBOOL
 PASCAL IsBadCodePtr(
	     FARPROC lpfn
	     );

extern WINBOOL
 PASCAL AllocateLocallyUniqueId(
			PLUID Luid
			);


extern WINBOOL
 PASCAL QueryPerformanceCounter(
			LARGE_INTEGER *lpPerformanceCount
			);


extern WINBOOL
 PASCAL QueryPerformanceFrequency(
			  LARGE_INTEGER *lpFrequency
			  );

extern VOID
 PASCAL MoveMemory(
	    PVOID Destination,
	    CONST VOID *Source,
	    DWORD Length
	     );

extern VOID
 PASCAL FillMemory(
	    PVOID Destination,
	    DWORD Length,
	    BYTE  Fill
	     );

extern VOID
 PASCAL ZeroMemory(
	    PVOID Destination,
	    DWORD Length
	     );

#ifdef WIN95
extern HKL
 PASCAL ActivateKeyboardLayout(
		       HKL hkl,
		       UINT Flags);
#else
extern WINBOOL
 PASCAL ActivateKeyboardLayout(
		       HKL hkl,
		       UINT Flags);
#endif /* WIN95 */

 
extern int
 PASCAL ToUnicodeEx(
	    UINT wVirtKey,
	    UINT wScanCode,
	    PBYTE lpKeyState,
	    LPWSTR pwszBuff,
	    int cchBuff,
	    UINT wFlags,
	    HKL dwhkl);

 
extern WINBOOL
 PASCAL UnloadKeyboardLayout(
		     HKL hkl);

 
extern int
 PASCAL GetKeyboardLayoutList(
		      int nBuff,
		      HKL *lpList);

 
extern HKL
 PASCAL GetKeyboardLayout(
		  DWORD dwLayout
		  );

 
extern HDESK
 PASCAL OpenInputDesktop(
		 DWORD dwFlags,
		 WINBOOL fInherit,
		 DWORD dwDesiredAccess);

extern WINBOOL
 PASCAL EnumDesktopWindows(
		   HDESK hDesktop,
		   ENUMWINDOWSPROC lpfn,
		   LPARAM lParam);

 
extern WINBOOL
 PASCAL SwitchDesktop(
	      HDESK hDesktop);

 
extern WINBOOL
 PASCAL SetThreadDesktop(
		 HDESK hDesktop);

 
extern WINBOOL
 PASCAL CloseDesktop(
	     HDESK hDesktop);

 
extern HDESK
 PASCAL GetThreadDesktop(
		 DWORD dwThreadId);

 
extern WINBOOL
 PASCAL CloseWindowStation(
		   HWINSTA hWinSta);

 
extern WINBOOL
 PASCAL SetProcessWindowStation(
			HWINSTA hWinSta);

 
extern HWINSTA
 PASCAL GetProcessWindowStation(
			VOID);

 
extern WINBOOL
 PASCAL SetUserObjectSecurity(
		      HANDLE hObj,
		      PSECURITY_INFORMATION pSIRequested,
		      PSECURITY_DESCRIPTOR pSID);

 
extern WINBOOL
 PASCAL GetUserObjectSecurity(
		      HANDLE hObj,
		      PSECURITY_INFORMATION pSIRequested,
		      PSECURITY_DESCRIPTOR pSID,
		      DWORD nLength,
		      LPDWORD lpnLengthNeeded);

 
extern WINBOOL
 PASCAL TranslateMessage(
		 CONST MSG *lpMsg);

extern WINBOOL
 PASCAL SetMessageQueue(
		int cMessagesMax);

extern WINBOOL
 PASCAL RegisterHotKey(
	       HWND hWnd ,
	       int anID,
	       UINT fsModifiers,
	       UINT vk);

 
extern WINBOOL
 PASCAL UnregisterHotKey(
		 HWND hWnd,
		 int anID);

 
extern WINBOOL
 PASCAL ExitWindowsEx(
	      UINT uFlags,
	      DWORD dwReserved);

 
extern WINBOOL
 PASCAL SwapMouseButton(
		WINBOOL fSwap);

 
extern DWORD
 PASCAL GetMessagePos(
	      VOID);

 
extern LONG
 PASCAL GetMessageTime(
	       VOID);

 
extern LONG
 PASCAL GetMessageExtraInfo(
		    VOID);

 
extern LPARAM
 PASCAL SetMessageExtraInfo(
		    LPARAM lParam);

 
extern long  
   PASCAL BroadcastSystemMessage(
		       DWORD, 
		       LPDWORD, 
		       UINT, 
		       WPARAM, 
		       LPARAM);

extern WINBOOL
 PASCAL AttachThreadInput(
		  DWORD idAttach,
		  DWORD idAttachTo,
		  WINBOOL fAttach);

 
extern WINBOOL
 PASCAL ReplyMessage(
	     LRESULT lResult);

 
extern WINBOOL
 PASCAL WaitMessage(
	    VOID);

 
extern DWORD
 PASCAL WaitForInputIdle(
		 HANDLE hProcess,
		 DWORD dwMilliseconds);

 
extern VOID
 PASCAL PostQuitMessage(
		int nExitCode);

extern WINBOOL
 PASCAL InSendMessage(
	      VOID);

 
extern UINT
 PASCAL GetDoubleClickTime(
		   VOID);

 
extern WINBOOL
 PASCAL SetDoubleClickTime(
		   UINT);

 
extern WINBOOL
 PASCAL IsWindow(
	 HWND hWnd);

 
extern WINBOOL
 PASCAL IsMenu(
       HMENU hMenu);

 
extern WINBOOL
 PASCAL IsChild(
	HWND hWndParent,
	HWND hWnd);

 
extern WINBOOL
 PASCAL DestroyWindow(
	      HWND hWnd);

 
extern WINBOOL
 PASCAL ShowWindow(
	   HWND hWnd,
	   int nCmdShow);

 
extern WINBOOL
 PASCAL ShowWindowAsync(
		HWND hWnd,
		int nCmdShow);

 
extern WINBOOL
 PASCAL FlashWindow(
	    HWND hWnd,
	    WINBOOL bInvert);

 
extern WINBOOL
 PASCAL ShowOwnedPopups(
		HWND hWnd,
		WINBOOL fShow);

 
extern WINBOOL
 PASCAL OpenIcon(
	 HWND hWnd);

 
extern WINBOOL
 PASCAL CloseWindow(
	    HWND hWnd);

 
extern WINBOOL
 PASCAL MoveWindow(
	   HWND hWnd,
	   int X,
	   int Y,
	   int nWidth,
	   int nHeight,
	   WINBOOL bRepaint);

 
extern WINBOOL
 PASCAL SetWindowPos(
	     HWND hWnd,
	     HWND hWndInsertAfter ,
	     int X,
	     int Y,
	     int cx,
	     int cy,
	     UINT uFlags);

 
extern WINBOOL
 PASCAL GetWindowPlacement(
		   HWND hWnd,
		   WINDOWPLACEMENT *lpwndpl);

 
extern WINBOOL
 PASCAL SetWindowPlacement(
		   HWND hWnd,
		   CONST WINDOWPLACEMENT *lpwndpl);

 
extern HDWP
 PASCAL BeginDeferWindowPos(
		    int nNumWindows);

 
extern HDWP
 PASCAL DeferWindowPos(
	       HDWP hWinPosInfo,
	       HWND hWnd,
	       HWND hWndInsertAfter,
	       int x,
	       int y,
	       int cx,
	       int cy,
	       UINT uFlags);

 
extern WINBOOL
 PASCAL EndDeferWindowPos(
		  HDWP hWinPosInfo);

 
extern WINBOOL
 PASCAL IsWindowVisible(
		HWND hWnd);

 
extern WINBOOL
 PASCAL IsIconic(
	 HWND hWnd);

 
extern WINBOOL
 PASCAL AnyPopup(
	 VOID);

 
extern WINBOOL
 PASCAL BringWindowToTop(
		 HWND hWnd);

 
extern WINBOOL
 PASCAL IsZoomed(
	 HWND hWnd);

 
extern WINBOOL
 PASCAL EndDialog(
	  HWND hDlg,
	  int nResult);

 
extern HWND
 PASCAL GetDlgItem(
	   HWND hDlg,
	   int nIDDlgItem);

 
extern WINBOOL
 PASCAL SetDlgItemInt(
	      HWND hDlg,
	      int nIDDlgItem,
	      UINT uValue,
	      WINBOOL bSigned);

 
extern UINT
 PASCAL GetDlgItemInt(
	      HWND hDlg,
	      int nIDDlgItem,
	      WINBOOL *lpTranslated,
	      WINBOOL bSigned);

 
extern WINBOOL
 PASCAL CheckDlgButton(
	       HWND hDlg,
	       int nIDButton,
	       UINT uCheck);

 
extern WINBOOL
 PASCAL CheckRadioButton(
		 HWND hDlg,
		 int nIDFirstButton,
		 int nIDLastButton,
		 int nIDCheckButton);

 
extern UINT
 PASCAL IsDlgButtonChecked(
		   HWND hDlg,
		   int nIDButton);

 
extern HWND
 PASCAL GetNextDlgGroupItem(
		    HWND hDlg,
		    HWND hCtl,
		    WINBOOL bPrevious);

 
extern HWND
 PASCAL GetNextDlgTabItem(
		  HWND hDlg,
		  HWND hCtl,
		  WINBOOL bPrevious);

 
extern int
 PASCAL GetDlgCtrlID(
	     HWND hWnd);

 
extern long
 PASCAL GetDialogBaseUnits(VOID);

extern WINBOOL
 PASCAL OpenClipboard(
	      HWND hWndNewOwner);

 
extern WINBOOL
 PASCAL CloseClipboard(
	       VOID);

 
extern HWND
 PASCAL GetClipboardOwner(
		  VOID);

 
extern HWND
 PASCAL SetClipboardViewer(
		   HWND hWndNewViewer);

 
extern HWND
 PASCAL GetClipboardViewer(
		   VOID);

 
extern WINBOOL
 PASCAL ChangeClipboardChain(
		     HWND hWndRemove,
		     HWND hWndNewNext);

 
extern HANDLE
 PASCAL SetClipboardData(
		 UINT uFormat,
		 HANDLE hMem);

 
extern HANDLE
 PASCAL GetClipboardData(
		 UINT uFormat);

 
 
extern int
 PASCAL CountClipboardFormats(
		      VOID);

 
extern UINT
 PASCAL EnumClipboardFormats(
		     UINT format);

 
extern WINBOOL
 PASCAL EmptyClipboard(
	       VOID);

 
extern WINBOOL
 PASCAL IsClipboardFormatAvailable(
			   UINT format);

 
extern int
 PASCAL GetPriorityClipboardFormat(
			   UINT *paFormatPriorityList,
			   int cFormats);

 
extern HWND
 PASCAL GetOpenClipboardWindow(
		       VOID);

 
/* Despite the A these are ASCII functions! */
extern LPSTR
 PASCAL CharNextExA(
	    WORD CodePage,
	    LPCSTR lpCurrentChar,
	    DWORD dwFlags);

 
extern LPSTR
 PASCAL CharPrevExA(
	    WORD CodePage,
	    LPCSTR lpStart,
	    LPCSTR lpCurrentChar,
	    DWORD dwFlags);

 
extern HWND
 PASCAL SetFocus(
	 HWND hWnd);

 
extern HWND
 PASCAL GetActiveWindow(
		VOID);

 
extern HWND
 PASCAL GetFocus(
	 VOID);

 
extern UINT
 PASCAL GetKBCodePage(
	      VOID);

 
extern SHORT
 PASCAL GetKeyState(
	    int nVirtKey);

 
extern SHORT
 PASCAL GetAsyncKeyState(
		 int vKey);

 
extern WINBOOL
 PASCAL GetKeyboardState(
		 PBYTE lpKeyState);

 
extern WINBOOL
 PASCAL SetKeyboardState(
		 LPBYTE lpKeyState);

 
extern int
 PASCAL GetKeyboardType(
		int nTypeFlag);

 
extern int
 PASCAL ToAscii(
	UINT uVirtKey,
	UINT uScanCode,
	PBYTE lpKeyState,
	LPWORD lpChar,
	UINT uFlags);

 
extern int
 PASCAL ToAsciiEx(
	  UINT uVirtKey,
	  UINT uScanCode,
	  PBYTE lpKeyState,
	  LPWORD lpChar,
	  UINT uFlags,
	  HKL dwhkl);

 
extern int
 PASCAL ToUnicode(
	  UINT wVirtKey,
	  UINT wScanCode,
	  PBYTE lpKeyState,
	  LPWSTR pwszBuff,
	  int cchBuff,
	  UINT wFlags);

 
extern DWORD
 PASCAL OemKeyScan(
	   WORD wOemChar);

 
extern VOID
 PASCAL keybd_event(
	    BYTE bVk,
	    BYTE bScan,
	    DWORD dwFlags,
	    DWORD dwExtraInfo);

 
extern VOID
 PASCAL mouse_event(
	    DWORD dwFlags,
	    DWORD dx,
	    DWORD dy,
	    DWORD cButtons,
	    DWORD dwExtraInfo);

extern WINBOOL
 PASCAL GetInputState(
	      VOID);

 
extern DWORD
 PASCAL GetQueueStatus(
	       UINT flags);

 
extern HWND
 PASCAL GetCapture(
	   VOID);

 
extern HWND
 PASCAL SetCapture(
	   HWND hWnd);

 
extern WINBOOL
 PASCAL ReleaseCapture(
	       VOID);

 
extern DWORD
 PASCAL MsgWaitForMultipleObjects(
			  DWORD nCount,
			  LPHANDLE pHandles,
			  WINBOOL fWaitAll,
			  DWORD dwMilliseconds,
			  DWORD dwWakeMask);

 
extern UINT
 PASCAL SetTimer(
	 HWND hWnd ,
	 UINT nIDEvent,
	 UINT uElapse,
	 TIMERPROC lpTimerFunc);

 
extern WINBOOL
 PASCAL KillTimer(
	  HWND hWnd,
	  UINT uIDEvent);

 
extern WINBOOL
 PASCAL IsWindowUnicode(
		HWND hWnd);

 
extern WINBOOL
 PASCAL EnableWindow(
	     HWND hWnd,
	     WINBOOL bEnable);

 
extern WINBOOL
 PASCAL IsWindowEnabled(
		HWND hWnd);

 
extern WINBOOL
 PASCAL DestroyAcceleratorTable(
			HACCEL hAccel);

extern int
 PASCAL GetSystemMetrics(
		 int nIndex);

extern HMENU
 PASCAL GetMenu(
	HWND hWnd);

 
extern WINBOOL
 PASCAL SetMenu(
	HWND hWnd,
	HMENU hMenu);

 
extern WINBOOL
 PASCAL HiliteMenuItem(
	       HWND hWnd,
	       HMENU hMenu,
	       UINT uIDHiliteItem,
	       UINT uHilite);

 
extern UINT
 PASCAL GetMenuState(
	     HMENU hMenu,
	     UINT uId,
	     UINT uFlags);

 
extern WINBOOL
 PASCAL DrawMenuBar(
	    HWND hWnd);

 
extern HMENU
 PASCAL GetSystemMenu(
	      HWND hWnd,
	      WINBOOL bRevert);

 
extern HMENU
 PASCAL CreateMenu(
	   VOID);

 
extern HMENU
 PASCAL CreatePopupMenu(
		VOID);

 
extern WINBOOL
 PASCAL DestroyMenu(
	    HMENU hMenu);

 
extern DWORD
 PASCAL CheckMenuItem(
	      HMENU hMenu,
	      UINT uIDCheckItem,
	      UINT uCheck);

 
extern WINBOOL
 PASCAL EnableMenuItem(
	       HMENU hMenu,
	       UINT uIDEnableItem,
	       UINT uEnable);

 
extern HMENU
 PASCAL GetSubMenu(
	   HMENU hMenu,
	   int nPos);

 
extern UINT
 PASCAL GetMenuItemID(
	      HMENU hMenu,
	      int nPos);

 
extern int
 PASCAL GetMenuItemCount(
		 HMENU hMenu);

extern WINBOOL
 PASCAL RemoveMenu(
		   HMENU hMenu,
		   UINT uPosition,
		   UINT uFlags);

 
extern WINBOOL
 PASCAL DeleteMenu(
	   HMENU hMenu,
	   UINT uPosition,
	   UINT uFlags);

 
extern WINBOOL
 PASCAL SetMenuItemBitmaps(
		   HMENU hMenu,
		   UINT uPosition,
		   UINT uFlags,
		   HBITMAP hBitmapUnchecked,
		   HBITMAP hBitmapChecked);

 
extern LONG
 PASCAL GetMenuCheckMarkDimensions(
			   VOID);

 
extern WINBOOL
 PASCAL TrackPopupMenu(
	       HMENU hMenu,
	       UINT uFlags,
	       int x,
	       int y,
	       int nReserved,
	       HWND hWnd,
	       CONST RECT *prcRect);

extern UINT
 PASCAL GetMenuDefaultItem(
		   HMENU hMenu, 
		   UINT fByPos, 
		   UINT gmdiFlags);

extern WINBOOL
 PASCAL SetMenuDefaultItem(
		   HMENU hMenu, 
		   UINT uItem, 
		   UINT fByPos);

extern WINBOOL
 PASCAL GetMenuItemRect(HWND hWnd, 
		HMENU hMenu, 
		UINT uItem, 
		LPRECT lprcItem);

extern int
 PASCAL MenuItemFromPoint(HWND hWnd, 
		  HMENU hMenu, 
		  POINT ptScreen);

 
extern DWORD
 PASCAL DragObject(HWND, HWND, UINT, DWORD, HCURSOR);

 
extern WINBOOL
 PASCAL DragDetect(HWND hwnd, 
	   POINT pt);

 
extern WINBOOL
 PASCAL DrawIcon(
	 HDC hDC,
	 int X,
	 int Y,
	 HICON hIcon);

extern WINBOOL
 PASCAL UpdateWindow(
	     HWND hWnd);

 
extern HWND
 PASCAL SetActiveWindow(
		HWND hWnd);

 
extern HWND
 PASCAL GetForegroundWindow(
		    VOID);

extern WINBOOL
 PASCAL PaintDesktop(HDC hdc);

 
extern WINBOOL
 PASCAL SetForegroundWindow(
		    HWND hWnd);

 
extern HWND
 PASCAL WindowFromDC(
	     HDC hDC);

 
extern HDC
 PASCAL GetDC(
      HWND hWnd);

 
extern HDC
 PASCAL GetDCEx(
	HWND hWnd ,
	HRGN hrgnClip,
	DWORD flags);

 
extern HDC
 PASCAL GetWindowDC(
	    HWND hWnd);

 
extern int
 PASCAL ReleaseDC(
	  HWND hWnd,
	  HDC hDC);

 
extern HDC
 PASCAL BeginPaint(
	   HWND hWnd,
	   LPPAINTSTRUCT lpPaint);

 
extern WINBOOL
 PASCAL EndPaint(
	 HWND hWnd,
	 CONST PAINTSTRUCT *lpPaint);

 
extern WINBOOL
 PASCAL GetUpdateRect(
	      HWND hWnd,
	      LPRECT lpRect,
	      WINBOOL bErase);

 
extern int
 PASCAL GetUpdateRgn(
	     HWND hWnd,
	     HRGN hRgn,
	     WINBOOL bErase);

 
extern int
 PASCAL SetWindowRgn(
	     HWND hWnd,
	     HRGN hRgn,
	     WINBOOL bRedraw);

 
extern int
 PASCAL GetWindowRgn(
	     HWND hWnd,
	     HRGN hRgn);

 
extern int
 PASCAL ExcludeUpdateRgn(
		 HDC hDC,
		 HWND hWnd);

 
extern WINBOOL
 PASCAL InvalidateRect(
	       HWND hWnd ,
	       CONST RECT *lpRect,
	       WINBOOL bErase);

 
extern WINBOOL
 PASCAL ValidateRect(
	     HWND hWnd ,
	     CONST RECT *lpRect);

 
extern WINBOOL
 PASCAL InvalidateRgn(
	      HWND hWnd,
	      HRGN hRgn,
	      WINBOOL bErase);

 
extern WINBOOL
 PASCAL ValidateRgn(
	    HWND hWnd,
	    HRGN hRgn);

 
extern WINBOOL
 PASCAL RedrawWindow(
	     HWND hWnd,
	     CONST RECT *lprcUpdate,
	     HRGN hrgnUpdate,
	     UINT flags);

 
extern WINBOOL
 PASCAL LockWindowUpdate(
		 HWND hWndLock);

 
extern WINBOOL
 PASCAL ScrollWindow(
	     HWND hWnd,
	     int XAmount,
	     int YAmount,
	     CONST RECT *lpRect,
	     CONST RECT *lpClipRect);

 
extern WINBOOL
 PASCAL ScrollDC(
	 HDC hDC,
	 int dx,
	 int dy,
	 CONST RECT *lprcScroll,
	 CONST RECT *lprcClip ,
	 HRGN hrgnUpdate,
	 LPRECT lprcUpdate);

 
extern int
 PASCAL ScrollWindowEx(
	       HWND hWnd,
	       int dx,
	       int dy,
	       CONST RECT *prcScroll,
	       CONST RECT *prcClip ,
	       HRGN hrgnUpdate,
	       LPRECT prcUpdate,
	       UINT flags);

 
extern int
 PASCAL SetScrollPos(
	     HWND hWnd,
	     int nBar,
	     int nPos,
	     WINBOOL bRedraw);

 
extern int
 PASCAL GetScrollPos(
	     HWND hWnd,
	     int nBar);

 
extern WINBOOL
 PASCAL SetScrollRange(
	       HWND hWnd,
	       int nBar,
	       int nMinPos,
	       int nMaxPos,
	       WINBOOL bRedraw);

 
extern WINBOOL
 PASCAL GetScrollRange(
	       HWND hWnd,
	       int nBar,
	       LPINT lpMinPos,
	       LPINT lpMaxPos);

 
extern WINBOOL
 PASCAL ShowScrollBar(
	      HWND hWnd,
	      int wBar,
	      WINBOOL bShow);

 
extern WINBOOL
 PASCAL EnableScrollBar(
		HWND hWnd,
		UINT wSBflags,
		UINT wArrows);

 
extern WINBOOL
 PASCAL GetClientRect(
	      HWND hWnd,
	      LPRECT lpRect);

 
extern WINBOOL
 PASCAL GetWindowRect(
	      HWND hWnd,
	      LPRECT lpRect);

 
extern WINBOOL
 PASCAL AdjustWindowRect(
		 LPRECT lpRect,
		 DWORD dwStyle,
		 WINBOOL bMenu);

 
extern WINBOOL
 PASCAL AdjustWindowRectEx(
		   LPRECT lpRect,
		   DWORD dwStyle,
		   WINBOOL bMenu,
		   DWORD dwExStyle);

extern WINBOOL
 PASCAL SetWindowContextHelpId(HWND, DWORD);

extern DWORD
 PASCAL GetWindowContextHelpId(HWND);

extern WINBOOL
 PASCAL SetMenuContextHelpId(HMENU, DWORD);

extern DWORD
 PASCAL GetMenuContextHelpId(HMENU);

 
extern WINBOOL
 PASCAL MessageBeep(
	    UINT uType);

 
extern int
 PASCAL ShowCursor(
	   WINBOOL bShow);

 
extern WINBOOL
 PASCAL SetCursorPos(
	     int X,
	     int Y);

 
extern HCURSOR
 PASCAL SetCursor(
	  HCURSOR hCursor);

 
extern WINBOOL
 PASCAL GetCursorPos(
	     LPPOINT lpPoint);

 
extern WINBOOL
 PASCAL ClipCursor(
	   CONST RECT *lpRect);

 
extern WINBOOL
 PASCAL GetClipCursor(
	      LPRECT lpRect);

 
extern HCURSOR
 PASCAL GetCursor(
	  VOID);

 
extern WINBOOL
 PASCAL CreateCaret(
	    HWND hWnd,
	    HBITMAP hBitmap ,
	    int nWidth,
	    int nHeight);

 
extern UINT
 PASCAL GetCaretBlinkTime(
		  VOID);

 
extern WINBOOL
 PASCAL SetCaretBlinkTime(
		  UINT uMSeconds);

 
extern WINBOOL
 PASCAL DestroyCaret(
	     VOID);

 
extern WINBOOL
 PASCAL HideCaret(
	  HWND hWnd);

 
extern WINBOOL
 PASCAL ShowCaret(
	  HWND hWnd);

 
extern WINBOOL
 PASCAL SetCaretPos(
	    int X,
	    int Y);

 
extern WINBOOL
 PASCAL GetCaretPos(
	    LPPOINT lpPoint);

 
extern WINBOOL
 PASCAL ClientToScreen(
	       HWND hWnd,
	       LPPOINT lpPoint);

 
extern WINBOOL
 PASCAL ScreenToClient(
	       HWND hWnd,
	       LPPOINT lpPoint);

 
extern int
 PASCAL MapWindowPoints(
		HWND hWndFrom,
		HWND hWndTo,
		LPPOINT lpPoints,
		UINT cPoints);

 
extern HWND
 PASCAL WindowFromPoint(
		POINT Point);

 
extern HWND
 PASCAL ChildWindowFromPoint(
		     HWND hWndParent,
		     POINT Point);

 
extern DWORD
 PASCAL GetSysColor(
	    int nIndex);

 
extern HBRUSH
 PASCAL GetSysColorBrush(
		 int nIndex);

 
extern WINBOOL
 PASCAL SetSysColors(
	     int cElements,
	     CONST INT * lpaElements,
	     CONST COLORREF * lpaRgbValues);

 
extern WINBOOL
 PASCAL DrawFocusRect(
	      HDC hDC,
	      CONST RECT * lprc);

 
extern int
 PASCAL FillRect(
	 HDC hDC,
	 CONST RECT *lprc,
	 HBRUSH hbr);

 
extern int
 PASCAL FrameRect(
	  HDC hDC,
	  CONST RECT *lprc,
	  HBRUSH hbr);

 
extern WINBOOL
 PASCAL InvertRect(
	   HDC hDC,
	   CONST RECT *lprc);

 
extern WINBOOL
 PASCAL SetRect(
	LPRECT lprc,
	int xLeft,
	int yTop,
	int xRight,
	int yBottom);

 
extern WINBOOL
 PASCAL SetRectEmpty(
	     LPRECT lprc);

 
extern WINBOOL
 PASCAL CopyRect(
	 LPRECT lprcDst,
	 CONST RECT *lprcSrc);

 
extern WINBOOL
 PASCAL InflateRect(
	    LPRECT lprc,
	    int dx,
	    int dy);

 
extern WINBOOL
 PASCAL IntersectRect(
	      LPRECT lprcDst,
	      CONST RECT *lprcSrc1,
	      CONST RECT *lprcSrc2);

 
extern WINBOOL
 PASCAL UnionRect(
	  LPRECT lprcDst,
	  CONST RECT *lprcSrc1,
	  CONST RECT *lprcSrc2);

 
extern WINBOOL
 PASCAL SubtractRect(
	     LPRECT lprcDst,
	     CONST RECT *lprcSrc1,
	     CONST RECT *lprcSrc2);

 
extern WINBOOL
 PASCAL OffsetRect(
	   LPRECT lprc,
	   int dx,
	   int dy);

 
extern WINBOOL
 PASCAL IsRectEmpty(
	    CONST RECT *lprc);

 
extern WINBOOL
 PASCAL EqualRect(
	  CONST RECT *lprc1,
	  CONST RECT *lprc2);

 
extern WINBOOL
 PASCAL PtInRect(
	 CONST RECT *lprc,
	 POINT pt);

 
extern WORD
 PASCAL GetWindowWord(
	      HWND hWnd,
	      int nIndex);

 
extern WORD
 PASCAL SetWindowWord(
	      HWND hWnd,
	      int nIndex,
	      WORD wNewWord);

 
extern WORD
 PASCAL GetClassWord(
	     HWND hWnd,
	     int nIndex);

 
extern WORD
 PASCAL SetClassWord(
	     HWND hWnd,
	     int nIndex,
	     WORD wNewWord);

extern HWND
 PASCAL GetDesktopWindow(
		 VOID);

 
extern HWND
 PASCAL GetParent(
	  HWND hWnd);

 
extern HWND
 PASCAL SetParent(
	  HWND hWndChild,
	  HWND hWndNewParent);

 
extern WINBOOL
 PASCAL EnumChildWindows(
		 HWND hWndParent,
		 ENUMWINDOWSPROC lpEnumFunc,
		 LPARAM lParam);

 
extern WINBOOL
 PASCAL EnumWindows(
	    ENUMWINDOWSPROC lpEnumFunc,
	    LPARAM lParam);

 
extern WINBOOL
 PASCAL EnumThreadWindows(
		  DWORD dwThreadId,
		  ENUMWINDOWSPROC lpfn,
		  LPARAM lParam);

extern HWND
 PASCAL GetTopWindow(
	     HWND hWnd);

 
extern DWORD
 PASCAL GetWindowThreadProcessId(
			 HWND hWnd,
			 LPDWORD lpdwProcessId);

#define GetWindowTask(hWnd) \
	((HANDLE)GetWindowThreadProcessId(hWnd, NULL))
 
extern HWND
 PASCAL GetLastActivePopup(
		   HWND hWnd);

 
extern HWND
 PASCAL GetWindow(
	  HWND hWnd,
	  UINT uCmd);

extern WINBOOL
 PASCAL UnhookWindowsHook(
		  int nCode,
		  HOOKPROC pfnFilterProc);

extern WINBOOL
 PASCAL UnhookWindowsHookEx(
		    HHOOK hhk);

 
extern LRESULT
 PASCAL CallNextHookEx(
	       HHOOK hhk,
	       int nCode,
	       WPARAM wParam,
	       LPARAM lParam);

 
extern WINBOOL
 PASCAL CheckMenuRadioItem(HMENU, UINT, UINT, UINT, UINT);

extern HCURSOR
 PASCAL CreateCursor(
	     HINSTANCE hInst,
	     int xHotSpot,
	     int yHotSpot,
	     int nWidth,
	     int nHeight,
	     CONST VOID *pvANDPlane,
	     CONST VOID *pvXORPlane);

 
extern WINBOOL
 PASCAL DestroyCursor(
	      HCURSOR hCursor);

 
extern WINBOOL
 PASCAL SetSystemCursor(
		HCURSOR hcur,
		DWORD   anID);

 
extern HICON
 PASCAL CreateIcon(
	   HINSTANCE hInstance,
	   int nWidth,
	   int nHeight,
	   BYTE cPlanes,
	   BYTE cBitsPixel,
	   CONST BYTE *lpbANDbits,
	   CONST BYTE *lpbXORbits);

 
extern WINBOOL
 PASCAL DestroyIcon(
	    HICON hIcon);

 
extern int
 PASCAL LookupIconIdFromDirectory(
			  PBYTE presbits,
			  WINBOOL fIcon);

 
extern int
 PASCAL LookupIconIdFromDirectoryEx(
			    PBYTE presbits,
			    WINBOOL  fIcon,
			    int   cxDesired,
			    int   cyDesired,
			    UINT  Flags);

 
extern HICON
 PASCAL CreateIconFromResource(
		       PBYTE presbits,
		       DWORD dwResSize,
		       WINBOOL fIcon,
		       DWORD dwVer);

 
extern HICON
 PASCAL CreateIconFromResourceEx(
			 PBYTE presbits,
			 DWORD dwResSize,
			 WINBOOL  fIcon,
			 DWORD dwVer,
			 int   cxDesired,
			 int   cyDesired,
			 UINT  Flags);

 
extern HICON
 PASCAL CopyImage(
	  HANDLE,
	  UINT,
	  int,
	  int,
	  UINT);

 
extern HICON
 PASCAL CreateIconIndirect(
		   PICONINFO piconinfo);

 
extern HICON
 PASCAL CopyIcon(
	 HICON hIcon);

 
extern WINBOOL
 PASCAL GetIconInfo(
	    HICON hIcon,
	    PICONINFO piconinfo);

 
extern WINBOOL
 PASCAL MapDialogRect(
	      HWND hDlg,
	      LPRECT lpRect);

extern int
 PASCAL SetScrollInfo(HWND, int, LPCSCROLLINFO, WINBOOL);

extern WINBOOL
 PASCAL GetScrollInfo(HWND, int, LPSCROLLINFO);

extern WINBOOL
 PASCAL TranslateMDISysAccel(
		     HWND hWndClient,
		     LPMSG lpMsg);

 
extern UINT
 PASCAL ArrangeIconicWindows(
		     HWND hWnd);

extern WORD
 PASCAL TileWindows(HWND hwndParent, UINT wHow, CONST RECT * lpRect, UINT cKids, const HWND *lpKids);

extern WORD
 PASCAL CascadeWindows(HWND hwndParent, UINT wHow, CONST RECT * lpRect, UINT cKids,  const HWND *lpKids);

 
extern VOID
 PASCAL SetLastErrorEx(
	       DWORD dwErrCode,
	       DWORD dwType
	       );

 
extern VOID
 PASCAL SetDebugErrorLevel(
		   DWORD dwLevel
		   );

extern WINBOOL
 PASCAL DrawEdge(HDC hdc, LPRECT qrc, UINT edge, UINT grfFlags);

extern WINBOOL
 PASCAL DrawFrameControl(HDC, LPRECT, UINT, UINT);

extern WINBOOL
 PASCAL DrawCaption(HWND, HDC, CONST RECT *, UINT);

extern WINBOOL
 PASCAL DrawAnimatedRects(HWND hwnd, int idAni, CONST RECT * lprcFrom, CONST RECT * lprcTo);

extern WINBOOL
 PASCAL TrackPopupMenuEx(HMENU, UINT, int, int, HWND, LPTPMPARAMS);

extern HWND
 PASCAL ChildWindowFromPointEx(HWND, POINT, UINT);

extern WINBOOL
 PASCAL DrawIconEx(HDC hdc, int xLeft, int yTop,
	   HICON hIcon, int cxWidth, int cyWidth,
	   UINT istepIfAniCur, HBRUSH hbrFlickerFreeDraw, UINT diFlags);

extern WINBOOL
 PASCAL AnimatePalette(HPALETTE, UINT, UINT, CONST PALETTEENTRY *);

extern WINBOOL
 PASCAL Arc(HDC, int, int, int, int, int, int, int, int);

extern WINBOOL
 PASCAL BitBlt(HDC, int, int, int, int, HDC, int, int, DWORD);

extern WINBOOL
 PASCAL CancelDC(HDC);

extern WINBOOL
 PASCAL Chord(HDC, int, int, int, int, int, int, int, int);

extern HMETAFILE
 PASCAL CloseMetaFile(HDC);

extern int
 PASCAL CombineRgn(HRGN, HRGN, HRGN, int);

extern HBITMAP
 PASCAL CreateBitmap(int, int, UINT, UINT, CONST VOID *);

extern HBITMAP
 PASCAL CreateBitmapIndirect(CONST BITMAP *);

extern HBRUSH
 PASCAL CreateBrushIndirect(CONST LOGBRUSH *);

extern HBITMAP
 PASCAL CreateCompatibleBitmap(HDC, int, int);

extern HBITMAP
 PASCAL CreateDiscardableBitmap(HDC, int, int);

extern HDC
 PASCAL CreateCompatibleDC(HDC);

extern HBITMAP
 PASCAL CreateDIBitmap(HDC, CONST BITMAPINFOHEADER *, DWORD, CONST VOID *, CONST BITMAPINFO *, UINT);

extern HBRUSH
 PASCAL CreateDIBPatternBrush(HGLOBAL, UINT);

extern HBRUSH
 PASCAL CreateDIBPatternBrushPt(CONST VOID *, UINT);

extern HRGN
 PASCAL CreateEllipticRgn(int, int, int, int);

extern HRGN
 PASCAL CreateEllipticRgnIndirect(CONST RECT *);

extern HBRUSH
 PASCAL CreateHatchBrush(int, COLORREF);

extern HPALETTE
 PASCAL CreatePalette(CONST LOGPALETTE *);

extern HPEN
 PASCAL CreatePen(int, int, COLORREF);

extern HPEN
 PASCAL CreatePenIndirect(CONST LOGPEN *);

extern HRGN
 PASCAL CreatePolyPolygonRgn(CONST POINT *, CONST INT *, int, int);

extern HBRUSH
 PASCAL CreatePatternBrush(HBITMAP);

extern HRGN
 PASCAL CreateRectRgn(int, int, int, int);

extern HRGN
 PASCAL CreateRectRgnIndirect(CONST RECT *);

extern HRGN
 PASCAL CreateRoundRectRgn(int, int, int, int, int, int);

extern HBRUSH
 PASCAL CreateSolidBrush(COLORREF);

extern WINBOOL
 PASCAL DeleteDC(HDC);

extern WINBOOL
 PASCAL DeleteMetaFile(HMETAFILE);

extern WINBOOL
 PASCAL DeleteObject(HGDIOBJ);

extern int
 PASCAL DrawEscape(HDC, int, int, LPCSTR);

extern WINBOOL
 PASCAL Ellipse(HDC, int, int, int, int);

extern int
 PASCAL EnumObjects(HDC, int, ENUMOBJECTSPROC, LPARAM);

extern WINBOOL
 PASCAL EqualRgn(HRGN, HRGN);

extern int
 PASCAL Escape(HDC, int, int, LPCSTR, LPVOID);

extern int
 PASCAL ExtEscape(HDC, int, int, LPCSTR, int, LPSTR);

extern int
 PASCAL ExcludeClipRect(HDC, int, int, int, int);

extern HRGN
 PASCAL ExtCreateRegion(CONST XFORM *, DWORD, CONST RGNDATA *);

extern WINBOOL
 PASCAL ExtFloodFill(HDC, int, int, COLORREF, UINT);

extern WINBOOL
 PASCAL FillRgn(HDC, HRGN, HBRUSH);

extern WINBOOL
 PASCAL FloodFill(HDC, int, int, COLORREF);

extern WINBOOL
 PASCAL FrameRgn(HDC, HRGN, HBRUSH, int, int);

extern int
 PASCAL GetROP2(HDC);

extern WINBOOL
 PASCAL GetAspectRatioFilterEx(HDC, LPSIZE);

extern COLORREF
 PASCAL GetBkColor(HDC);

extern int
 PASCAL GetBkMode(HDC);

extern LONG
 PASCAL GetBitmapBits(HBITMAP, LONG, LPVOID);

extern WINBOOL
 PASCAL GetBitmapDimensionEx(HBITMAP, LPSIZE);

extern UINT
 PASCAL GetBoundsRect(HDC, LPRECT, UINT);

extern WINBOOL
 PASCAL GetBrushOrgEx(HDC, LPPOINT);

extern int
 PASCAL GetClipBox(HDC, LPRECT);

extern int
 PASCAL GetClipRgn(HDC, HRGN);

extern int
 PASCAL GetMetaRgn(HDC, HRGN);

extern HGDIOBJ
 PASCAL GetCurrentObject(HDC, UINT);

extern WINBOOL
 PASCAL GetCurrentPositionEx(HDC, LPPOINT);

extern int
 PASCAL GetDeviceCaps(HDC, int);

extern int
 PASCAL GetDIBits(HDC, HBITMAP, UINT, UINT, LPVOID, LPBITMAPINFO, UINT);

extern DWORD
 PASCAL GetFontData(HDC, DWORD, DWORD, LPVOID, DWORD);

extern int
 PASCAL GetGraphicsMode(HDC);

extern int
 PASCAL GetMapMode(HDC);

extern UINT
 PASCAL GetMetaFileBitsEx(HMETAFILE, UINT, LPVOID);

extern COLORREF
 PASCAL GetNearestColor(HDC, COLORREF);

extern UINT
 PASCAL GetNearestPaletteIndex(HPALETTE, COLORREF);

extern DWORD
 PASCAL GetObjectType(HGDIOBJ h);

extern UINT
 PASCAL GetPaletteEntries(HPALETTE, UINT, UINT, LPPALETTEENTRY);

extern COLORREF
 PASCAL GetPixel(HDC, int, int);

extern int
 PASCAL GetPixelFormat(HDC);

extern int
 PASCAL GetPolyFillMode(HDC);

extern WINBOOL
 PASCAL GetRasterizerCaps(LPRASTERIZER_STATUS, UINT);

extern DWORD
 PASCAL GetRegionData(HRGN, DWORD, LPRGNDATA);

extern int
 PASCAL GetRgnBox(HRGN, LPRECT);

extern HGDIOBJ
 PASCAL GetStockObject(int);

extern int
 PASCAL GetStretchBltMode(HDC);

extern UINT
 PASCAL GetSystemPaletteEntries(HDC, UINT, UINT, LPPALETTEENTRY);

extern UINT
 PASCAL GetSystemPaletteUse(HDC);

extern int
 PASCAL GetTextCharacterExtra(HDC);

extern UINT
 PASCAL GetTextAlign(HDC);

extern COLORREF
 PASCAL GetTextColor(HDC);

extern int
 PASCAL GetTextCharset(HDC hdc);

extern int
 PASCAL GetTextCharsetInfo(HDC hdc, LPFONTSIGNATURE lpSig, DWORD dwFlags);

extern WINBOOL
 PASCAL TranslateCharsetInfo( DWORD *lpSrc, LPCHARSETINFO lpCs, DWORD dwFlags);

extern DWORD
 PASCAL GetFontLanguageInfo( HDC );

extern WINBOOL
 PASCAL GetViewportExtEx(HDC, LPSIZE);

extern WINBOOL
 PASCAL GetViewportOrgEx(HDC, LPPOINT);

extern WINBOOL
 PASCAL GetWindowExtEx(HDC, LPSIZE);

extern WINBOOL
 PASCAL GetWindowOrgEx(HDC, LPPOINT);

extern int
 PASCAL IntersectClipRect(HDC, int, int, int, int);

extern WINBOOL
 PASCAL InvertRgn(HDC, HRGN);

extern WINBOOL
 PASCAL LineDDA(int, int, int, int, LINEDDAPROC, LPARAM);

extern WINBOOL
 PASCAL LineTo(HDC, int, int);

extern WINBOOL
 PASCAL MaskBlt(HDC, int, int, int, int,
	HDC, int, int, HBITMAP, int, int, DWORD);

extern WINBOOL
 PASCAL PlgBlt(HDC, CONST POINT *, HDC, int, int, int,
       int, HBITMAP, int, int);

extern int
 PASCAL OffsetClipRgn(HDC, int, int);

extern int
 PASCAL OffsetRgn(HRGN, int, int);

extern WINBOOL
  PASCAL PatBlt(HDC, int, int, int, int, DWORD);

extern WINBOOL
 PASCAL Pie(HDC, int, int, int, int, int, int, int, int);

extern WINBOOL
 PASCAL PlayMetaFile(HDC, HMETAFILE);

extern WINBOOL
 PASCAL PaintRgn(HDC, HRGN);

extern WINBOOL
 PASCAL PolyPolygon(HDC, CONST POINT *, CONST INT *, int);

extern WINBOOL
 PASCAL PtInRegion(HRGN, int, int);

extern WINBOOL
 PASCAL PtVisible(HDC, int, int);

extern WINBOOL
 PASCAL RectInRegion(HRGN, CONST RECT *);

extern WINBOOL
 PASCAL RectVisible(HDC, CONST RECT *);

extern WINBOOL
 PASCAL Rectangle(HDC, int, int, int, int);

extern WINBOOL
 PASCAL RestoreDC(HDC, int);

extern UINT
 PASCAL RealizePalette(HDC);

extern WINBOOL
 PASCAL RoundRect(HDC, int, int, int, int, int, int);

extern WINBOOL
 PASCAL ResizePalette(HPALETTE, UINT);

extern int
 PASCAL SaveDC(HDC);

extern int
 PASCAL SelectClipRgn(HDC, HRGN);

extern int
 PASCAL ExtSelectClipRgn(HDC, HRGN, int);

extern int
 PASCAL SetMetaRgn(HDC);

extern HGDIOBJ
 PASCAL SelectObject(HDC, HGDIOBJ);

extern HPALETTE
 PASCAL SelectPalette(HDC, HPALETTE, WINBOOL);

extern COLORREF
 PASCAL SetBkColor(HDC, COLORREF);

extern int
 PASCAL SetBkMode(HDC, int);

extern LONG
 PASCAL SetBitmapBits(HBITMAP, DWORD, CONST VOID *);

extern UINT
 PASCAL SetBoundsRect(HDC, CONST RECT *, UINT);

extern int
 PASCAL SetDIBits(HDC, HBITMAP, UINT, UINT, CONST VOID *, CONST BITMAPINFO *, UINT);

extern int
 PASCAL SetDIBitsToDevice(HDC, int, int, DWORD, DWORD, int,
		  int, UINT, UINT, CONST VOID *, CONST BITMAPINFO *, UINT);

extern DWORD
 PASCAL SetMapperFlags(HDC, DWORD);

extern int
 PASCAL SetGraphicsMode(HDC hdc, int iMode);

extern int
 PASCAL SetMapMode(HDC, int);

extern HMETAFILE
 PASCAL SetMetaFileBitsEx(UINT, CONST BYTE *);

extern UINT
 PASCAL SetPaletteEntries(HPALETTE, UINT, UINT, CONST PALETTEENTRY *);

extern COLORREF
 PASCAL SetPixel(HDC, int, int, COLORREF);

extern WINBOOL
 PASCAL SetPixelV(HDC, int, int, COLORREF);

extern int
 PASCAL SetPolyFillMode(HDC, int);

extern WINBOOL
 PASCAL StretchBlt(HDC, int, int, int, int, HDC, int, int, int, int, DWORD);

extern WINBOOL
 PASCAL SetRectRgn(HRGN, int, int, int, int);
extern int
 PASCAL StretchDIBits(HDC, int, int, int, int, int, int, int, int, CONST
	      VOID *, CONST BITMAPINFO *, UINT, DWORD);

extern int
 PASCAL SetROP2(HDC, int);

extern int
 PASCAL SetStretchBltMode(HDC, int);

extern UINT
 PASCAL SetSystemPaletteUse(HDC, UINT);

extern int
 PASCAL SetTextCharacterExtra(HDC, int);

extern COLORREF
 PASCAL SetTextColor(HDC, COLORREF);

extern UINT
 PASCAL SetTextAlign(HDC, UINT);

extern WINBOOL
 PASCAL SetTextJustification(HDC, int, int);

extern WINBOOL
 PASCAL UpdateColors(HDC);

extern WINBOOL
 PASCAL PlayMetaFileRecord(HDC, LPHANDLETABLE, LPMETARECORD, UINT);

extern WINBOOL
 PASCAL EnumMetaFile(HDC, HMETAFILE, ENUMMETAFILEPROC, LPARAM);

extern HENHMETAFILE
 PASCAL CloseEnhMetaFile(HDC);

extern WINBOOL
 PASCAL DeleteEnhMetaFile(HENHMETAFILE);

extern WINBOOL
 PASCAL EnumEnhMetaFile(HDC, HENHMETAFILE, ENHMETAFILEPROC,
		LPVOID, CONST RECT *);

extern UINT
 PASCAL GetEnhMetaFileHeader(HENHMETAFILE, UINT, LPENHMETAHEADER );

extern UINT
 PASCAL GetEnhMetaFilePaletteEntries(HENHMETAFILE, UINT, LPPALETTEENTRY );

extern UINT
 PASCAL GetWinMetaFileBits(HENHMETAFILE, UINT, LPBYTE, INT, HDC);

extern WINBOOL
 PASCAL PlayEnhMetaFile(HDC, HENHMETAFILE, CONST RECT *);

extern WINBOOL
 PASCAL PlayEnhMetaFileRecord(HDC, LPHANDLETABLE, CONST ENHMETARECORD *, UINT);

extern HENHMETAFILE
 PASCAL SetEnhMetaFileBits(UINT, CONST BYTE *);

extern HENHMETAFILE
 PASCAL SetWinMetaFileBits(UINT, CONST BYTE *, HDC, CONST METAFILEPICT *);

extern WINBOOL
 PASCAL GdiComment(HDC, UINT, CONST BYTE *);

extern WINBOOL
 PASCAL AngleArc(HDC, int, int, DWORD, FLOAT, FLOAT);

extern WINBOOL
 PASCAL PolyPolyline(HDC, CONST POINT *, CONST DWORD *, DWORD);

extern WINBOOL
 PASCAL GetWorldTransform(HDC, LPXFORM);

extern WINBOOL
 PASCAL SetWorldTransform(HDC, CONST XFORM *);

extern WINBOOL
 PASCAL ModifyWorldTransform(HDC, CONST XFORM *, DWORD);

extern WINBOOL
 PASCAL CombineTransform(LPXFORM, CONST XFORM *, CONST XFORM *);

extern HBITMAP
 PASCAL CreateDIBSection(HDC, CONST BITMAPINFO *, UINT, VOID **, HANDLE, DWORD);

extern UINT
 PASCAL GetDIBColorTable(HDC, UINT, UINT, RGBQUAD *);

extern UINT
 PASCAL SetDIBColorTable(HDC, UINT, UINT, CONST RGBQUAD *);

extern WINBOOL
 PASCAL SetColorAdjustment(HDC, CONST COLORADJUSTMENT *);

extern WINBOOL
 PASCAL GetColorAdjustment(HDC, LPCOLORADJUSTMENT);

extern HPALETTE
  PASCAL CreateHalftonePalette(HDC);

extern int
 PASCAL EndDoc(HDC);

extern int
 PASCAL StartPage(HDC);

extern int
 PASCAL EndPage(HDC);

extern int
 PASCAL AbortDoc(HDC);

extern int
 PASCAL SetAbortProc(HDC, ABORTPROC);

extern WINBOOL
 PASCAL AbortPath(HDC);

extern WINBOOL
 PASCAL ArcTo(HDC, int, int, int, int, int, int,int, int);

extern WINBOOL
 PASCAL BeginPath(HDC);

extern WINBOOL
 PASCAL CloseFigure(HDC);

extern WINBOOL
 PASCAL EndPath(HDC);

extern WINBOOL
 PASCAL FillPath(HDC);

extern WINBOOL
 PASCAL FlattenPath(HDC);

extern int
 PASCAL GetPath(HDC, LPPOINT, LPBYTE, int);

extern HRGN
 PASCAL PathToRegion(HDC);

extern WINBOOL
 PASCAL PolyDraw(HDC, CONST POINT *, CONST BYTE *, int);

extern WINBOOL
 PASCAL SelectClipPath(HDC, int);

extern int
 PASCAL SetArcDirection(HDC, int);

extern WINBOOL
 PASCAL SetMiterLimit(HDC, FLOAT, PFLOAT);

extern WINBOOL
 PASCAL StrokeAndFillPath(HDC);

extern WINBOOL
 PASCAL StrokePath(HDC);

extern WINBOOL
 PASCAL WidenPath(HDC);

extern HPEN
 PASCAL ExtCreatePen(DWORD, DWORD, CONST LOGBRUSH *, DWORD, CONST DWORD *);

extern WINBOOL
 PASCAL GetMiterLimit(HDC, PFLOAT);

extern int
 PASCAL GetArcDirection(HDC);

extern WINBOOL
 PASCAL MoveToEx(HDC, int, int, LPPOINT);

extern HRGN
 PASCAL CreatePolygonRgn(CONST POINT *, int, int);

extern WINBOOL
 PASCAL DPtoLP(HDC, LPPOINT, int);

extern WINBOOL
 PASCAL LPtoDP(HDC, LPPOINT, int);
 
extern WINBOOL
 PASCAL Polygon(HDC, CONST POINT *, int);

extern WINBOOL
 PASCAL Polyline(HDC, CONST POINT *, int);

extern WINBOOL
 PASCAL PolyBezier(HDC, CONST POINT *, DWORD);

extern WINBOOL
 PASCAL PolyBezierTo(HDC, CONST POINT *, DWORD);

extern WINBOOL
 PASCAL PolylineTo(HDC, CONST POINT *, DWORD);

extern WINBOOL
 PASCAL SetViewportExtEx(HDC, int, int, LPSIZE);

extern WINBOOL
 PASCAL SetViewportOrgEx(HDC, int, int, LPPOINT);

extern WINBOOL
 PASCAL SetWindowExtEx(HDC, int, int, LPSIZE);

extern WINBOOL
 PASCAL SetWindowOrgEx(HDC, int, int, LPPOINT);

extern WINBOOL
 PASCAL OffsetViewportOrgEx(HDC, int, int, LPPOINT);

extern WINBOOL
 PASCAL OffsetWindowOrgEx(HDC, int, int, LPPOINT);

extern WINBOOL
 PASCAL ScaleViewportExtEx(HDC, int, int, int, int, LPSIZE);

extern WINBOOL
 PASCAL ScaleWindowExtEx(HDC, int, int, int, int, LPSIZE);

extern WINBOOL
 PASCAL SetBitmapDimensionEx(HBITMAP, int, int, LPSIZE);

extern WINBOOL
 PASCAL SetBrushOrgEx(HDC, int, int, LPPOINT);

extern WINBOOL
 PASCAL GetDCOrgEx(HDC,LPPOINT);

extern WINBOOL
 PASCAL FixBrushOrgEx(HDC,int,int,LPPOINT);

extern WINBOOL
 PASCAL UnrealizeObject(HGDIOBJ);

extern WINBOOL
 PASCAL GdiFlush();

extern DWORD
 PASCAL GdiSetBatchLimit(DWORD);

extern DWORD
 PASCAL GdiGetBatchLimit();

extern int
 PASCAL SetICMMode(HDC, int);

extern WINBOOL
 PASCAL CheckColorsInGamut(HDC,LPVOID,LPVOID,DWORD);

extern HANDLE
 PASCAL GetColorSpace(HDC);

extern WINBOOL
 PASCAL SetColorSpace(HDC,HCOLORSPACE);

extern WINBOOL
 PASCAL DeleteColorSpace(HCOLORSPACE);

extern WINBOOL
 PASCAL GetDeviceGammaRamp(HDC,LPVOID);

extern WINBOOL
 PASCAL SetDeviceGammaRamp(HDC,LPVOID);

extern WINBOOL
 PASCAL ColorMatchToTarget(HDC,HDC,DWORD);

extern HPROPSHEETPAGE
 PASCAL CreatePropertySheetPageA(LPCPROPSHEETPAGE lppsp);

extern WINBOOL
 PASCAL DestroyPropertySheetPage(HPROPSHEETPAGE hPSPage);

extern void
 PASCAL InitCommonControls();

#define  ImageList_AddIcon(himl, hicon) ImageList_ReplaceIcon(himl, -1, hicon)

extern HIMAGELIST
 PASCAL ImageList_Create(int cx, int cy, UINT flags, 
		 int cInitial, int cGrow);

extern WINBOOL
 PASCAL ImageList_Destroy(HIMAGELIST himl);

extern int
 PASCAL ImageList_GetImageCount(HIMAGELIST himl);

extern int
 PASCAL ImageList_Add(HIMAGELIST himl, HBITMAP hbmImage, 
	      HBITMAP hbmMask);

extern int
 PASCAL ImageList_ReplaceIcon(HIMAGELIST himl, int i, HICON hicon);

extern COLORREF
 PASCAL ImageList_SetBkColor(HIMAGELIST himl, COLORREF clrBk);

extern COLORREF
 PASCAL ImageList_GetBkColor(HIMAGELIST himl);

extern WINBOOL
 PASCAL ImageList_SetOverlayImage(HIMAGELIST himl, int iImage, 
			  int iOverlay);

extern WINBOOL
 PASCAL ImageList_Draw(HIMAGELIST himl, int i, HDC hdcDst, int x, int y, UINT fStyle);

extern WINBOOL
 PASCAL ImageList_Replace(HIMAGELIST himl, int i, HBITMAP hbmImage, HBITMAP hbmMask);

extern int
 PASCAL ImageList_AddMasked(HIMAGELIST himl, HBITMAP hbmImage, COLORREF crMask);

extern WINBOOL
 PASCAL ImageList_DrawEx(HIMAGELIST himl, int i, HDC hdcDst, int x, int y, int dx, int dy, COLORREF rgbBk, COLORREF rgbFg, UINT fStyle);

extern WINBOOL
 PASCAL ImageList_Remove(HIMAGELIST himl, int i);

extern HICON
 PASCAL ImageList_GetIcon(HIMAGELIST himl, int i, UINT flags);

extern WINBOOL
 PASCAL ImageList_BeginDrag(HIMAGELIST himlTrack, int iTrack, int dxHotspot, int dyHotspot);

extern void
 PASCAL ImageList_EndDrag();

extern WINBOOL
 PASCAL ImageList_DragEnter(HWND hwndLock, int x, int y);

extern WINBOOL
 PASCAL ImageList_DragLeave(HWND hwndLock);

extern WINBOOL
 PASCAL ImageList_DragMove(int x, int y);

extern WINBOOL
 PASCAL ImageList_SetDragCursorImage(HIMAGELIST himlDrag, int iDrag, int dxHotspot, int dyHotspot);

extern WINBOOL
 PASCAL ImageList_DragShowNolock(WINBOOL fShow);

extern HIMAGELIST
 PASCAL ImageList_GetDragImage(POINT * ppt,POINT * pptHotspot);

extern WINBOOL
 PASCAL ImageList_GetIconSize(HIMAGELIST himl, int *cx, int *cy);

extern WINBOOL
 PASCAL ImageList_SetIconSize(HIMAGELIST himl, int cx, int cy);

extern WINBOOL
 PASCAL ImageList_GetImageInfo(HIMAGELIST himl, int i, IMAGEINFO * pImageInfo);

extern HIMAGELIST
 PASCAL ImageList_Merge(HIMAGELIST himl1, int i1, HIMAGELIST himl2, int i2, int dx, int dy);

extern HWND
 PASCAL CreateToolbarEx(HWND hwnd, DWORD ws, UINT wID, int nBitmaps,
		HINSTANCE hBMInst, UINT wBMID, LPCTBBUTTON lpButtons,
		int iNumButtons, int dxButton, int dyButton,
		int dxBitmap, int dyBitmap, UINT uStructSize);

extern HBITMAP
 PASCAL CreateMappedBitmap(HINSTANCE hInstance, int idBitmap,
		   UINT wFlags, LPCOLORMAP lpColorMap,
		   int iNumMaps);


extern void
 PASCAL MenuHelp(UINT uMsg, WPARAM wParam, LPARAM lParam, HMENU hMainMenu, HINSTANCE hInst, HWND hwndStatus, UINT *lpwIDs);

extern WINBOOL
 PASCAL ShowHideMenuCtl(HWND hWnd, UINT uFlags, LPINT lpInfo);

extern void
 PASCAL GetEffectiveClientRect(HWND hWnd, LPRECT lprc, LPINT lpInfo);

extern WINBOOL
 PASCAL MakeDragList(HWND hLB);

extern void
 PASCAL DrawInsert(HWND handParent, HWND hLB, int nItem);

extern int
 PASCAL LBItemFromPt(HWND hLB, POINT pt, WINBOOL bAutoScroll);

extern HWND
 PASCAL CreateUpDownControl(DWORD dwStyle, int x, int y, int cx, int cy,
		    HWND hParent, int nID, HINSTANCE hInst,
		    HWND hBuddy,
		    int nUpper, int nLower, int nPos);

extern DWORD
 PASCAL CommDlgExtendedError(VOID);

/* Animation controls */

#define Animate_Create(hwndP, id, dwStyle, hInstance)   \
CreateWindow(ANIMATE_CLASS, NULL, dwStyle, 0, 0, 0, 0, hwndP, \
             (HMENU)(id), hInstance, NULL)

#define Animate_Open(hwnd, szName) \
SendMessage(hwnd, ACM_OPEN, 0, (LPARAM)(LPTSTR)(szName))

#define Animate_Play(hwnd, from, to, rep) \
SendMessage(hwnd, ACM_PLAY, (WPARAM)(UINT)(rep), (LPARAM)MAKELONG(from, to))

#define Animate_Stop(hwnd) \
SendMessage(hwnd, ACM_STOP, 0, 0)

#define Animate_Close(hwnd) \
Animate_Open(hwnd, NULL)

#define Animate_Seek(hwnd, frame) \
Animate_Play(hwnd, frame, frame, 1)

/* Property sheet macros */

#define PropSheet_AddPage(hPropSheetDlg, hpage) \
SendMessage(hPropSheetDlg, PSM_ADDPAGE, 0, (LPARAM)(HPROPSHEETPAGE)hpage)

#define PropSheet_Apply(hPropSheetDlg) \
SendMessage(hPropSheetDlg, PSM_APPLY, 0, 0)

#define PropSheet_CancelToClose(hPropSheetDlg) \
SendMessage(hPropSheetDlg, PSM_CANCELTOCLOSE, 0, 0)

#define PropSheet_Changed(hPropSheetDlg, hwndPage) \
SendMessage(hPropSheetDlg, PSM_CHANGED, (WPARAM)(HWND)hwndPage, 0)

#define PropSheet_GetCurrentPageHwnd(hDlg) \
SendMessage(hDlg, PSM_GETCURRENTPAGEHWND, 0, 0)

#define PropSheet_GetTabControl(hPropSheetDlg) \
SendMessage(hPropSheetDlg, PSM_GETTABCONTROL, 0, 0)

#define PropSheet_IsDialogMessage(hDlg, pMsg) \
SendMessage(hDlg, PSM_ISDIALOGMESSAGE, 0, (LPARAM)pMsg)

#define PropSheet_PressButton(hPropSheetDlg, iButton) \
SendMessage(hPropSheetDlg, PSM_PRESSBUTTON, (WPARAM)(int)iButton, 0)

#define PropSheet_QuerySiblings(hPropSheetDlg, param1, param2) \
SendMessage(hPropSheetDlg, PSM_QUERYSIBLINGS, (WPARAM)param1, (LPARAM)param2)

#define PropSheet_RebootSystem(hPropSheetDlg) \
SendMessage(hPropSheetDlg, PSM_REBOOTSYSTEM, 0, 0)

#define PropSheet_RemovePage(hPropSheetDlg, index, hpage) \
SendMessage(hPropSheetDlg, PSM_REMOVEPAGE, (WPARAM)(int)index, \
	    (LPARAM)(HPROPSHEETPAGE)hpage)

#define PropSheet_RestartWindows(hPropSheetDlg) \
SendMessage(hPropSheetDlg, PSM_RESTARTWINDOWS, 0, 0)

#define PropSheet_SetCurSel(hPropSheetDlg, hpage, index) \
SendMessage(hPropSheetDlg, PSM_SETCURSEL, (WPARAM)(int)index, \
	    (LPARAM)(HPROPSHEETPAGE)hpage)

#define PropSheet_SetCurSelByID(hPropSheetDlg, id) \
SendMessage(hPropSheetDlg, PSM_SETCURSELID, 0, (LPARAM)(int)id)

#define PropSheet_SetFinishText(hPropSheetDlg, lpszText) \
SendMessage(hPropSheetDlg, PSM_SETFINISHTEXT, 0, (LPARAM)(LPTSTR)lpszText)

#define PropSheet_SetTitle(hPropSheetDlg, dwStyle, lpszText) \
SendMessage(hPropSheetDlg, PSM_SETTITLE, (WPARAM)(DWORD)dwStyle, \
	    (LPARAM)(LPCTSTR)lpszText)

#define PropSheet_SetWizButtons(hPropSheetDlg, dwFlags) \
SendMessage(hPropSheetDlg, PSM_SETWIZBUTTONS, 0, (LPARAM)(DWORD)dwFlags)

#define PropSheet_UnChanged(hPropSheetDlg, hwndPage) \
SendMessage(hPropSheetDlg, PSM_UNCHANGED, (WPARAM)(HWND)hwndPage, 0)

/* Header control */
#define Header_DeleteItem(hwndHD, index)     \
      (BOOL)SendMessage((hwndHD), HDM_DELETEITEM, (WPARAM)(int)(index), 0L)  

#define Header_GetItem(hwndHD, index, phdi)      \
    (BOOL)SendMessage((hwndHD), HDM_GETITEM,   \
    (WPARAM)(int)(index), (LPARAM)(HD_ITEM FAR*)(phdi))
 
#define Header_GetItemCount(hwndHD)   \
       (int)SendMessage((hwndHD), HDM_GETITEMCOUNT, 0, 0L)

#define Header_InsertItem(hwndHD, index, phdi) \
    (int)SendMessage((hwndHD), HDM_INSERTITEM, (WPARAM)(int)(index), \
    (LPARAM)(const HD_ITEM FAR*)(phdi))
  
#define Header_Layout(hwndHD, playout) \
    (BOOL)SendMessage((hwndHD), HDM_LAYOUT, 0, \
    (LPARAM)(HD_LAYOUT FAR*)(playout))
  
#define Header_SetItem(hwndHD, index, phdi) \
    (BOOL)SendMessage((hwndHD), HDM_SETITEM,  \
    (WPARAM)(int)(index), (LPARAM)(const HD_ITEM FAR*)(phdi))

/* List View */
#define ListView_Arrange(hwndLV, code) \
SendMessage((hwndLV), LVM_ARRANGE, (WPARAM)(UINT)(code), 0)

#define ListView_CreateDragImage(hwnd, i, lpptUpLeft) \
SendMessage((hwnd), LVM_CREATEDRAGIMAGE, (WPARAM)(int)(i), \
	    (LPARAM)(LPPOINT)(lpptUpLeft))

#define ListView_DeleteAllItems(hwnd) \
SendMessage(hwnd, LVM_DELETEALLITEMS, 0, 0)

#define ListView_DeleteColumn(hwnd, iCol) \
SendMessage((hwnd), LVM_DELETECOLUMN, (WPARAM)(int)(iCol), 0)

#define ListView_DeleteItem(hwnd, iItem) \
SendMessage(hwnd, LVM_DELETEITEM, (WPARAM)(int)iItem, 0)

#define ListView_EditLabel(hwndLV, i) \
SendMessage((hwndLV), LVM_EDITLABEL, (WPARAM)(int)i, 0)

#define ListView_EnsureVisible(hwndLV, i, fPartialOK) \
SendMessage(hwndLV, LVM_ENSUREVISIBLE, (WPARAM)(int)i, \
	    MAKELPARAM((fPartialOK), 0))

#define ListView_FindItem(hwnd, iStart, plvfi) \
SendMessage(hwnd, LVM_FINDITEM, (WPARAM)(int)iStart, \
	    (LPARAM)(const LV_FINDINFO *)plvfi)

#define ListView_GetBkColor(hwnd) \
SendMessage((HWND)hwnd, LVM_GETBKCOLOR, 0, 0)

#define ListView_GetCallbackMask(hwnd) \
SendMessage(hwnd, LVM_GETCALLBACKMASK, 0, 0)

#define ListView_GetColumn(hwnd, iCol, pcol) \
SendMessage((hwnd), LVM_GETCOLUMN, (WPARAM)(int)(iCol), \
	    (LPARAM)(LV_COLUMN *)(pcol))

#define ListView_GetColumnWidth(hwnd, iCol) \
SendMessage((hwnd), LVM_GETCOLUMNWIDTH, (WPARAM)(int)(iCol), 0)

#define ListView_GetCountPerPage(hwndLV) \
SendMessage((hwndLV), LVM_GETCOUNTPERPAGE, 0, 0)

#define ListView_GetEditControl(hwndLV) \
SendMessage((hwndLV), LVM_GETEDITCONTROL, 0, 0)

#define ListView_GetImageList(hwnd, iImageList) \
SendMessage(hwnd, LVM_GETIMAGELIST, (WPARAM)(INT)iImageList, 0)

#define ListView_GetISearchString(hwndLV, lpsz) \
SendMessage((hwndLV), LVM_GETISEARCHSTRING, 0, (LPARAM)(LPTSTR)lpsz)

#define ListView_GetItem(hwnd, pitem) \
SendMessage(hwnd, LVM_GETITEM, 0, (LPARAM)(LV_ITEM *)(pitem))

#define ListView_GetItemCount(hwnd) \
SendMessage(hwnd, LVM_GETITEMCOUNT, 0, 0)

#define ListView_GetItemPosition(hwndLV, i, ppt) \
SendMessage(hwndLV, LVM_GETITEMPOSITION, (WPARAM)(int)i, \
	    (LPARAM)(POINT *)ppt)

#define ListView_GetItemRect(hwnd, i, prc, code) \
SendMessage(hwnd, LVM_GETITEMRECT, (WPARAM)(int)i, \
           ((prc) ? (((RECT *)(prc))->left = (code), \
		     (LPARAM)(RECT *)(prc)) : (LPARAM)(RECT *)NULL))

#define ListView_GetItemSpacing(hwndLV, fSmall) \
SendMessage((hwndLV), LVM_GETITEMSPACING, fSmall, 0)

#define ListView_GetItemState(hwndLV, i, mask) \
SendMessage((hwndLV), LVM_GETITEMSTATE, (WPARAM)i, (LPARAM)mask)

#define ListView_GetItemText(hwndLV, i, iSubItem_, pszText_, cchTextMax_) \
{ LV_ITEM _gnu_lvi;\
  _gnu_lvi.iSubItem = iSubItem_;\
  _gnu_lvi.cchTextMax = cchTextMax_;\
  _gnu_lvi.pszText = pszText_;\
  SendMessage((hwndLV), LVM_GETITEMTEXT, (WPARAM)i, \
	      (LPARAM)(LV_ITEM *)&_gnu_lvi);\
}

#define ListView_GetNextItem(hwnd, iStart, flags) \
SendMessage(hwnd, LVM_GETNEXTITEM, (WPARAM)(int)iStart, (LPARAM)flags)

#define ListView_GetOrigin(hwndLV, ppt) \
SendMessage((hwndLV), LVM_GETORIGIN, (WPARAM)0, (LPARAM)(POINT *)(ppt))

#define ListView_GetSelectedCount(hwndLV) \
SendMessage((hwndLV), LVM_GETSELECTEDCOUNT, 0, 0)

#define ListView_GetStringWidth(hwndLV, psz) \
SendMessage(hwndLV, LVM_GETSTRINGWIDTH, 0, (LPARAM)(LPCTSTR)psz)

#define ListView_GetTextBkColor(hwnd)  \
SendMessage((hwnd), LVM_GETTEXTBKCOLOR, 0, 0)

#define ListView_GetTextColor(hwnd)  \
SendMessage((hwnd), LVM_GETTEXTCOLOR, 0, 0)

#define ListView_GetTopIndex(hwndLV) \
SendMessage((hwndLV), LVM_GETTOPINDEX, 0, 0)

#define ListView_GetViewRect(hwnd, prc) \
SendMessage((hwnd), LVM_GETVIEWRECT, 0, (LPARAM)(RECT *)(prc))

#define ListView_HitTest(hwndLV, pinfo) \
SendMessage(hwndLV, LVM_HITTEST, 0, (LPARAM)(LV_HITTESTINFO *)pinfo)

#define ListView_InsertColumn(hwnd, iCol, pcol) \
SendMessage((hwnd), LVM_INSERTCOLUMN, (WPARAM)(int)(iCol), \
	    (LPARAM)(const LV_COLUMN *)(pcol))

#define ListView_InsertItem(hwnd, pitem) \
SendMessage(hwnd, LVM_INSERTITEM, 0, (LPARAM)(const LV_ITEM *)pitem)

#define ListView_RedrawItems(hwndLV, iFirst, iLast) \
SendMessage((hwndLV), LVM_REDRAWITEMS, (WPARAM)(int)iFirst, (LPARAM)(int)iLast)

#define ListView_Scroll(hwndLV, dx, dy) \
SendMessage((hwndLV), LVM_SCROLL, (WPARAM)(int)dx, (LPARAM)(int)dy)

#define ListView_SetBkColor(hwnd, clrBk) \
SendMessage(hwnd, LVM_SETBKCOLOR, 0, (LPARAM)(COLORREF)clrBk)

#define ListView_SetCallbackMask(hwnd, mask) \
SendMessage(hwnd, LVM_SETCALLBACKMASK, (WPARAM)(UINT)(mask), 0)

#define ListView_SetColumn(hwnd, iCol, pcol) \
SendMessage((hwnd), LVM_SETCOLUMN, (WPARAM)(int)(iCol), \
	    (LPARAM)(const LV_COLUMN *)(pcol))

#define ListView_SetColumnWidth(hwnd, iCol, cx) \
SendMessage((hwnd), LVM_SETCOLUMNWIDTH, (WPARAM)(int)(iCol), \
	    MAKELPARAM((cx), 0))


#define ListView_SetImageList(hwnd, himl, iImageList) \
SendMessage(hwnd, LVM_SETIMAGELIST, (WPARAM)(iImageList), \
	    (LPARAM)(UINT)(HIMAGELIST)(himl))

#define ListView_SetItem(hwnd, pitem) \
SendMessage(hwnd, LVM_SETITEM, 0, (LPARAM)(const LV_ITEM *)pitem)

#define ListView_SetItemCount(hwndLV, cItems) \
SendMessage((hwndLV), LVM_SETITEMCOUNT, (WPARAM)cItems, 0)

#define ListView_SetItemPosition(hwndLV, i, x, y) \
SendMessage(hwndLV, LVM_SETITEMPOSITION, (WPARAM)(int)(i), \
	    MAKELPARAM((x), (y)))

#define ListView_SetItemPosition32(hwndLV, i, x, y) \
{ POINT ptNewPos = {x,y}; \
    SendMessage((hwndLV), LVM_SETITEMPOSITION32, (WPARAM)(int)(i), \
		(LPARAM)&ptNewPos); \
}

#define ListView_SetItemState(hwndLV, i, data, mask) \
{ LV_ITEM _gnu_lvi;\
  _gnu_lvi.stateMask = mask;\
  _gnu_lvi.state = data;\
  SendMessage((hwndLV), LVM_SETITEMSTATE, (WPARAM)i, \
	      (LPARAM)(LV_ITEM *)&_gnu_lvi);\
}

#define ListView_SetItemText(hwndLV, i, iSubItem_, pszText_) \
{ LV_ITEM _gnu_lvi;\
  _gnu_lvi.iSubItem = iSubItem_;\
  _gnu_lvi.pszText = pszText_;\
  SendMessage((hwndLV), LVM_SETITEMTEXT, (WPARAM)i, \
	      (LPARAM)(LV_ITEM *)&_gnu_lvi);\
}

#define ListView_SetTextBkColor(hwnd, clrTextBk) \
SendMessage((hwnd), LVM_SETTEXTBKCOLOR, 0, (LPARAM)(COLORREF)(clrTextBk))

#define ListView_SetTextColor(hwnd, clrText) \
SendMessage((hwnd), LVM_SETTEXTCOLOR, 0, (LPARAM)(COLORREF)(clrText))

#define ListView_SortItems(hwndLV, _pfnCompare, _lPrm) \
SendMessage((hwndLV), LVM_SORTITEMS, (WPARAM)(LPARAM)_lPrm, \
	    (LPARAM)(PFNLVCOMPARE)_pfnCompare)

#define ListView_Update(hwndLV, i) \
SendMessage((hwndLV), LVM_UPDATE, (WPARAM)i, 0)

/* Tree View */
#define TreeView_InsertItem(hwnd, lpis) \
SendMessage((hwnd), TVM_INSERTITEM, 0, (LPARAM)(LPTV_INSERTSTRUCT)(lpis))

#define TreeView_DeleteItem(hwnd, hitem) \
SendMessage((hwnd), TVM_DELETEITEM, 0, (LPARAM)(HTREEITEM)(hitem))

#define TreeView_DeleteAllItems(hwnd) \
SendMessage((hwnd), TVM_DELETEITEM, 0, (LPARAM)TVI_ROOT)

#define TreeView_Expand(hwnd, hitem, code) \
SendMessage((hwnd), TVM_EXPAND, (WPARAM)code, (LPARAM)(HTREEITEM)(hitem))

#define TreeView_GetItemRect(hwnd, hitem, prc, code) \
 (*(HTREEITEM FAR *)prc = (hitem), SendMessage((hwnd), TVM_GETITEMRECT, (WPARAM)(code), (LPARAM)(RECT *)(prc)))

#define TreeView_GetCount(hwnd) \
SendMessage((hwnd), TVM_GETCOUNT, 0, 0)

#define TreeView_GetIndent(hwnd) \
SendMessage((hwnd), TVM_GETINDENT, 0, 0)

#define TreeView_SetIndent(hwnd, indent) \
SendMessage((hwnd), TVM_SETINDENT, (WPARAM)indent, 0)

#define TreeView_GetImageList(hwnd, iImage) \
SendMessage((hwnd), TVM_GETIMAGELIST, iImage, 0)

#define TreeView_SetImageList(hwnd, himl, iImage) \
SendMessage((hwnd), TVM_SETIMAGELIST, iImage, (LPARAM)(UINT)(HIMAGELIST)(himl))

#define TreeView_GetNextItem(hwnd, hitem, code) \
SendMessage((hwnd), TVM_GETNEXTITEM, (WPARAM)code, (LPARAM)(HTREEITEM)(hitem))

#define TreeView_GetChild(hwnd, hitem) \
TreeView_GetNextItem(hwnd, hitem, TVGN_CHILD)

#define TreeView_GetNextSibling(hwnd, hitem) \
TreeView_GetNextItem(hwnd, hitem, TVGN_NEXT)

#define TreeView_GetPrevSibling(hwnd, hitem) \
TreeView_GetNextItem(hwnd, hitem, TVGN_PREVIOUS)

#define TreeView_GetParent(hwnd, hitem) \
TreeView_GetNextItem(hwnd, hitem, TVGN_PARENT)

#define TreeView_GetFirstVisible(hwnd) \
TreeView_GetNextItem(hwnd, NULL,  TVGN_FIRSTVISIBLE)

#define TreeView_GetNextVisible(hwnd, hitem) \
TreeView_GetNextItem(hwnd, hitem, TVGN_NEXTVISIBLE)

#define TreeView_GetPrevVisible(hwnd, hitem) \
TreeView_GetNextItem(hwnd, hitem, TVGN_PREVIOUSVISIBLE)

#define TreeView_GetSelection(hwnd) \
TreeView_GetNextItem(hwnd, NULL,  TVGN_CARET)

#define TreeView_GetDropHilight(hwnd) \
TreeView_GetNextItem(hwnd, NULL,  TVGN_DROPHILITE)

#define TreeView_GetRoot(hwnd) \
TreeView_GetNextItem(hwnd, NULL,  TVGN_ROOT)

#define TreeView_Select(hwnd, hitem, code) \
SendMessage((hwnd), TVM_SELECTITEM, (WPARAM)code, (LPARAM)(HTREEITEM)(hitem))


#define TreeView_SelectItem(hwnd, hitem) \
TreeView_Select(hwnd, hitem, TVGN_CARET)

#define TreeView_SelectDropTarget(hwnd, hitem) \
TreeView_Select(hwnd, hitem, TVGN_DROPHILITE)

#define TreeView_SelectSetFirstVisible(hwnd, hitem) \
TreeView_Select(hwnd, hitem, TVGN_FIRSTVISIBLE)

#define TreeView_GetItem(hwnd, pitem) \
SendMessage((hwnd), TVM_GETITEM, 0, (LPARAM)(TV_ITEM *)(pitem))

#define TreeView_SetItem(hwnd, pitem) \
SendMessage((hwnd), TVM_SETITEM, 0, (LPARAM)(const TV_ITEM *)(pitem))

#define TreeView_EditLabel(hwnd, hitem) \
SendMessage((hwnd), TVM_EDITLABEL, 0, (LPARAM)(HTREEITEM)(hitem))

#define TreeView_GetEditControl(hwnd) \
SendMessage((hwnd), TVM_GETEDITCONTROL, 0, 0)

#define TreeView_GetVisibleCount(hwnd) \
SendMessage((hwnd), TVM_GETVISIBLECOUNT, 0, 0)

#define TreeView_HitTest(hwnd, lpht) \
SendMessage((hwnd), TVM_HITTEST, 0, (LPARAM)(LPTV_HITTESTINFO)(lpht))

#define TreeView_CreateDragImage(hwnd, hitem) \
SendMessage((hwnd), TVM_CREATEDRAGIMAGE, 0, (LPARAM)(HTREEITEM)(hitem))

#define TreeView_SortChildren(hwnd, hitem, recurse) \
SendMessage((hwnd), TVM_SORTCHILDREN, (WPARAM)recurse, \
            (LPARAM)(HTREEITEM)(hitem))

#define TreeView_EnsureVisible(hwnd, hitem) \
SendMessage((hwnd), TVM_ENSUREVISIBLE, 0, (LPARAM)(HTREEITEM)(hitem))

#define TreeView_SortChildrenCB(hwnd, psort, recurse) \
SendMessage((hwnd), TVM_SORTCHILDRENCB, (WPARAM)recurse, \
            (LPARAM)(LPTV_SORTCB)(psort))

#define TreeView_EndEditLabelNow(hwnd, fCancel) \
SendMessage((hwnd), TVM_ENDEDITLABELNOW, (WPARAM)fCancel, 0)

#define TreeView_GetISearchString(hwndTV, lpsz) \
SendMessage((hwndTV), TVM_GETISEARCHSTRING, 0, (LPARAM)(LPTSTR)lpsz)


/* Tab control */
#define TabCtrl_GetImageList(hwnd) \
SendMessage((hwnd), TCM_GETIMAGELIST, 0, 0)

#define TabCtrl_SetImageList(hwnd, himl) \
SendMessage((hwnd), TCM_SETIMAGELIST, 0, (LPARAM)(UINT)(HIMAGELIST)(himl))

#define TabCtrl_GetItemCount(hwnd) \
SendMessage((hwnd), TCM_GETITEMCOUNT, 0, 0)

#define TabCtrl_GetItem(hwnd, iItem, pitem) \
SendMessage((hwnd), TCM_GETITEM, (WPARAM)(int)iItem, \
            (LPARAM)(TC_ITEM *)(pitem))

#define TabCtrl_SetItem(hwnd, iItem, pitem) \
SendMessage((hwnd), TCM_SETITEM, (WPARAM)(int)iItem, \
            (LPARAM)(TC_ITEM *)(pitem))

#define TabCtrl_InsertItem(hwnd, iItem, pitem)   \
SendMessage((hwnd), TCM_INSERTITEM, (WPARAM)(int)iItem, \
            (LPARAM)(const TC_ITEM *)(pitem))

#define TabCtrl_DeleteItem(hwnd, i) \
SendMessage((hwnd), TCM_DELETEITEM, (WPARAM)(int)(i), 0)

#define TabCtrl_DeleteAllItems(hwnd) \
SendMessage((hwnd), TCM_DELETEALLITEMS, 0, 0)

#define TabCtrl_GetItemRect(hwnd, i, prc) \
SendMessage((hwnd), TCM_GETITEMRECT, (WPARAM)(int)(i), (LPARAM)(RECT *)(prc))

#define TabCtrl_GetCurSel(hwnd) \
SendMessage((hwnd), TCM_GETCURSEL, 0, 0)

#define TabCtrl_SetCurSel(hwnd, i) \
SendMessage((hwnd), TCM_SETCURSEL, (WPARAM)i, 0)

#define TabCtrl_HitTest(hwndTC, pinfo) \
SendMessage((hwndTC), TCM_HITTEST, 0, (LPARAM)(TC_HITTESTINFO *)(pinfo))

#define TabCtrl_SetItemExtra(hwndTC, cb) \
SendMessage((hwndTC), TCM_SETITEMEXTRA, (WPARAM)(cb), 0)

#define TabCtrl_AdjustRect(hwnd, bLarger, prc) \
SendMessage(hwnd, TCM_ADJUSTRECT, (WPARAM)(WINBOOL)bLarger, \
            (LPARAM)(RECT *)prc)

#define TabCtrl_SetItemSize(hwnd, x, y) \
SendMessage((hwnd), TCM_SETITEMSIZE, 0, MAKELPARAM(x,y))

#define TabCtrl_RemoveImage(hwnd, i) \
SendMessage((hwnd), TCM_REMOVEIMAGE, i, 0)

#define TabCtrl_SetPadding(hwnd,  cx, cy) \
SendMessage((hwnd), TCM_SETPADDING, 0, MAKELPARAM(cx, cy))

#define TabCtrl_GetRowCount(hwnd) \
SendMessage((hwnd), TCM_GETROWCOUNT, 0, 0)

#define TabCtrl_GetToolTips(hwnd) \
SendMessage((hwnd), TCM_GETTOOLTIPS, 0, 0)

#define TabCtrl_SetToolTips(hwnd, hwndTT) \
SendMessage((hwnd), TCM_SETTOOLTIPS, (WPARAM)hwndTT, 0)

#define TabCtrl_GetCurFocus(hwnd) \
SendMessage((hwnd), TCM_GETCURFOCUS, 0, 0)

#define TabCtrl_SetCurFocus(hwnd, i) \
SendMessage((hwnd),TCM_SETCURFOCUS, i, 0)

#define CommDlg_OpenSave_GetSpecA(_hdlg, _psz, _cbmax) \
SNDMSG(_hdlg, CDM_GETSPEC, (WPARAM)_cbmax, (LPARAM)(LPSTR)_psz)

#define CommDlg_OpenSave_GetSpecW(_hdlg, _psz, _cbmax) \
SNDMSG(_hdlg, CDM_GETSPEC, (WPARAM)_cbmax, (LPARAM)(LPWSTR)_psz)

#ifdef UNICODE
#define CommDlg_OpenSave_GetSpec  CommDlg_OpenSave_GetSpecW
#else
#define CommDlg_OpenSave_GetSpec  CommDlg_OpenSave_GetSpecA
#endif /* !UNICODE */

#define CommDlg_OpenSave_GetFilePathA(_hdlg, _psz, _cbmax) \
SNDMSG(_hdlg, CDM_GETFILEPATH, (WPARAM)_cbmax, (LPARAM)(LPSTR)_psz)

#define CommDlg_OpenSave_GetFilePathW(_hdlg, _psz, _cbmax) \
SNDMSG(_hdlg, CDM_GETFILEPATH, (WPARAM)_cbmax, (LPARAM)(LPWSTR)_psz)

#ifdef UNICODE
#define CommDlg_OpenSave_GetFilePath  CommDlg_OpenSave_GetFilePathW
#else
#define CommDlg_OpenSave_GetFilePath  CommDlg_OpenSave_GetFilePathA
#endif /* !UNICODE */

#define CommDlg_OpenSave_GetFolderPathA(_hdlg, _psz, _cbmax) \
SNDMSG(_hdlg, CDM_GETFOLDERPATH, (WPARAM)_cbmax, (LPARAM)(LPSTR)_psz)

#define CommDlg_OpenSave_GetFolderPathW(_hdlg, _psz, _cbmax) \
SNDMSG(_hdlg, CDM_GETFOLDERPATH, (WPARAM)_cbmax, (LPARAM)(LPWSTR)_psz)

#ifdef UNICODE
#define CommDlg_OpenSave_GetFolderPath  CommDlg_OpenSave_GetFolderPathW
#else
#define CommDlg_OpenSave_GetFolderPath  CommDlg_OpenSave_GetFolderPathA
#endif /* !UNICODE */

#define CommDlg_OpenSave_GetFolderIDList(_hdlg, _pidl, _cbmax) \
SNDMSG(_hdlg, CDM_GETFOLDERIDLIST, (WPARAM)_cbmax, (LPARAM)(LPVOID)_pidl)

#define CommDlg_OpenSave_SetControlText(_hdlg, _id, _text) \
SNDMSG(_hdlg, CDM_SETCONTROLTEXT, (WPARAM)_id, (LPARAM)(LPSTR)_text)

#define CommDlg_OpenSave_HideControl(_hdlg, _id) \
SNDMSG(_hdlg, CDM_HIDECONTROL, (WPARAM)_id, 0)

#define CommDlg_OpenSave_SetDefExt(_hdlg, _pszext) \
SNDMSG(_hdlg, CDM_SETDEFEXT, 0, (LPARAM)(LPSTR)_pszext)

extern LONG
 PASCAL RegCloseKey(
    HKEY hKey
    );

extern LONG
 PASCAL RegSetKeySecurity(
    HKEY hKey,
    SECURITY_INFORMATION SecurityInformation,
    PSECURITY_DESCRIPTOR pSecurityDescriptor
    );

extern LONG
 PASCAL RegFlushKey(
    HKEY hKey
    );

extern LONG
 PASCAL RegGetKeySecurity(
    HKEY hKey,
    SECURITY_INFORMATION SecurityInformation,
    PSECURITY_DESCRIPTOR pSecurityDescriptor,
    LPDWORD lpcbSecurityDescriptor
    );

extern LONG
 PASCAL RegNotifyChangeKeyValue(
    HKEY hKey,
    WINBOOL bWatchSubtree,
    DWORD dwNotifyFilter,
    HANDLE hEvent,
    WINBOOL fAsynchronus
    );

extern WINBOOL
 PASCAL IsValidCodePage(
    UINT  CodePage);


extern UINT
 PASCAL GetACP(void);


extern UINT
 PASCAL GetOEMCP(void);


extern WINBOOL
 PASCAL GetCPInfo(UINT, LPCPINFO);


extern WINBOOL
 PASCAL IsDBCSLeadByte(
    BYTE  TestChar);


extern WINBOOL
 PASCAL IsDBCSLeadByteEx(
    UINT  CodePage,
    BYTE  TestChar);


extern int
 PASCAL MultiByteToWideChar(
    UINT     CodePage,
    DWORD    dwFlags,
    LPCSTR   lpMultiByteStr,
    int      cchMultiByte,
    LPWSTR   lpWideCharStr,
    int      cchWideChar);


extern int
 PASCAL WideCharToMultiByte(
    UINT     CodePage,
    DWORD    dwFlags,
    LPCWSTR  lpWideCharStr,
    int      cchWideChar,
    LPSTR    lpMultiByteStr,
    int      cchMultiByte,
    LPCSTR   lpDefaultChar,
    LPBOOL   lpUsedDefaultChar);

extern WINBOOL
 PASCAL IsValidLocale(
    LCID   Locale,
    DWORD  dwFlags);


extern LCID
 PASCAL ConvertDefaultLocale(
    LCID   Locale);


extern LCID
 PASCAL GetThreadLocale(void);


extern WINBOOL
 PASCAL SetThreadLocale(
    LCID  Locale
    );


extern LANGID
 PASCAL GetSystemDefaultLangID(void);


extern LANGID
 PASCAL GetUserDefaultLangID(void);


extern LCID
 PASCAL GetSystemDefaultLCID(void);


extern LCID
 PASCAL GetUserDefaultLCID(void);


extern WINBOOL
 PASCAL ReadConsoleOutputAttribute(
    HANDLE hConsoleOutput,
    LPWORD lpAttribute,
    DWORD nLength,
    COORD dwReadCoord,
    LPDWORD lpNumberOfAttrsRead
    );


extern WINBOOL
 PASCAL WriteConsoleOutputAttribute(
    HANDLE hConsoleOutput,
    CONST WORD *lpAttribute,
    DWORD nLength,
    COORD dwWriteCoord,
    LPDWORD lpNumberOfAttrsWritten
    );


extern WINBOOL
 PASCAL FillConsoleOutputAttribute(
    HANDLE hConsoleOutput,
    WORD   wAttribute,
    DWORD  nLength,
    COORD  dwWriteCoord,
    LPDWORD lpNumberOfAttrsWritten
    );


extern WINBOOL
 PASCAL GetConsoleMode(
    HANDLE hConsoleHandle,
    LPDWORD lpMode
    );


extern WINBOOL
 PASCAL GetNumberOfConsoleInputEvents(
    HANDLE hConsoleInput,
    LPDWORD lpNumberOfEvents
    );


extern WINBOOL
 PASCAL GetConsoleScreenBufferInfo(
    HANDLE hConsoleOutput,
    PCONSOLE_SCREEN_BUFFER_INFO lpConsoleScreenBufferInfo
    );


extern COORD
 PASCAL GetLargestConsoleWindowSize(
    HANDLE hConsoleOutput
    );


extern WINBOOL
 PASCAL GetConsoleCursorInfo(
    HANDLE hConsoleOutput,
    PCONSOLE_CURSOR_INFO lpConsoleCursorInfo
    );


extern WINBOOL
 PASCAL GetNumberOfConsoleMouseButtons(
    LPDWORD lpNumberOfMouseButtons
    );


extern WINBOOL
 PASCAL SetConsoleMode(
    HANDLE hConsoleHandle,
    DWORD dwMode
    );


extern WINBOOL
 PASCAL SetConsoleActiveScreenBuffer(
    HANDLE hConsoleOutput
    );


extern WINBOOL
 PASCAL FlushConsoleInputBuffer(
    HANDLE hConsoleInput
    );


extern WINBOOL
 PASCAL SetConsoleScreenBufferSize(
    HANDLE hConsoleOutput,
    COORD dwSize
    );


extern WINBOOL
 PASCAL SetConsoleCursorPosition(
    HANDLE hConsoleOutput,
    COORD dwCursorPosition
    );


extern WINBOOL
 PASCAL SetConsoleCursorInfo(
    HANDLE hConsoleOutput,
    CONST CONSOLE_CURSOR_INFO *lpConsoleCursorInfo
    );

extern WINBOOL
 PASCAL SetConsoleWindowInfo(
    HANDLE hConsoleOutput,
    WINBOOL bAbsolute,
    CONST SMALL_RECT *lpConsoleWindow
    );


extern WINBOOL
 PASCAL SetConsoleTextAttribute(
    HANDLE hConsoleOutput,
    WORD wAttributes
    );


extern WINBOOL
 PASCAL SetConsoleCtrlHandler(
    PHANDLER_ROUTINE HandlerRoutine,
    WINBOOL Add
    );


extern WINBOOL
 PASCAL GenerateConsoleCtrlEvent(
    DWORD dwCtrlEvent,
    DWORD dwProcessGroupId
    );


extern WINBOOL
 PASCAL AllocConsole( VOID );


extern WINBOOL
 PASCAL FreeConsole( VOID );



extern HANDLE
 PASCAL CreateConsoleScreenBuffer(
    DWORD dwDesiredAccess,
    DWORD dwShareMode,
    CONST SECURITY_ATTRIBUTES *lpSecurityAttributes,
    DWORD dwFlags,
    LPVOID lpScreenBufferData
    );


extern UINT
 PASCAL GetConsoleCP( VOID );


extern WINBOOL
 PASCAL SetConsoleCP(
    UINT wCodePageID
    );


extern UINT
 PASCAL GetConsoleOutputCP( VOID );


extern WINBOOL
 PASCAL SetConsoleOutputCP(
    UINT wCodePageID
    );

extern DWORD  PASCAL WNetConnectionDialog(
    HWND  hwnd,
    DWORD dwType
    );

extern DWORD  PASCAL WNetDisconnectDialog(
    HWND  hwnd,
    DWORD dwType
    );

extern DWORD  PASCAL WNetCloseEnum(
    HANDLE   hEnum
    );

extern WINBOOL
 PASCAL CloseServiceHandle(
    SC_HANDLE   hSCObject
    );


extern WINBOOL
 PASCAL ControlService(
    SC_HANDLE           hService,
    DWORD               dwControl,
    LPSERVICE_STATUS    lpServiceStatus
    );

extern WINBOOL
 PASCAL DeleteService(
    SC_HANDLE   hService
    );

extern SC_LOCK
 PASCAL LockServiceDatabase(
    SC_HANDLE   hSCManager
    );


extern WINBOOL
 PASCAL NotifyBootConfigStatus(
    WINBOOL     BootAcceptable
    );

extern WINBOOL
 PASCAL QueryServiceObjectSecurity(
    SC_HANDLE               hService,
    SECURITY_INFORMATION    dwSecurityInformation,
    PSECURITY_DESCRIPTOR    lpSecurityDescriptor,
    DWORD                   cbBufSize,
    LPDWORD                 pcbBytesNeeded
    );


extern WINBOOL
 PASCAL QueryServiceStatus(
    SC_HANDLE           hService,
    LPSERVICE_STATUS    lpServiceStatus
    );

extern WINBOOL
 PASCAL SetServiceObjectSecurity(
    SC_HANDLE               hService,
    SECURITY_INFORMATION    dwSecurityInformation,
    PSECURITY_DESCRIPTOR    lpSecurityDescriptor
    );


extern WINBOOL
 PASCAL SetServiceStatus(
    SERVICE_STATUS_HANDLE   hServiceStatus,
    LPSERVICE_STATUS        lpServiceStatus
    );

extern WINBOOL
 PASCAL UnlockServiceDatabase(
    SC_LOCK     ScLock
    );


/* shellapi.h */

extern void
 PASCAL DragAcceptFiles(
	HWND,
	WINBOOL
	);


extern void
 PASCAL DragFinish(
	HDROP
	);


extern WINBOOL
 PASCAL DragQueryPoint(
	HDROP,
	LPPOINT
	);


extern HICON
 PASCAL DuplicateIcon(
	HINSTANCE,
	HICON
	);


/* ddeml.h */

extern HCONV  PASCAL DdeConnect(DWORD, HSZ, HSZ, CONVCONTEXT *);
extern WINBOOL  PASCAL DdeDisconnect(HCONV);
extern WINBOOL  PASCAL DdeFreeDataHandle(HDDEDATA);
extern DWORD  PASCAL DdeGetData(HDDEDATA, BYTE *, DWORD, DWORD);
extern UINT  PASCAL DdeGetLastError(DWORD);
extern HDDEDATA  PASCAL DdeNameService(DWORD, HSZ, HSZ, UINT);
extern WINBOOL  PASCAL DdePostAdvise(DWORD, HSZ, HSZ);
extern HCONV  PASCAL DdeReconnect(HCONV);
extern WINBOOL  PASCAL DdeUninitialize(DWORD);

extern DWORD  PASCAL NetUserEnum(LPWSTR, DWORD, DWORD, LPBYTE*, DWORD, LPDWORD,
				LPDWORD, LPDWORD);
extern DWORD  PASCAL NetApiBufferFree(LPVOID);
extern DWORD  PASCAL NetUserGetInfo(LPWSTR, LPWSTR, DWORD, LPBYTE);
extern DWORD  PASCAL NetGetDCName(LPWSTR, LPWSTR, LPBYTE*);
extern DWORD  PASCAL NetGroupEnum(LPWSTR, DWORD, LPBYTE*, DWORD, LPDWORD,
				LPDWORD, LPDWORD);
extern DWORD  PASCAL NetLocalGroupEnum(LPWSTR, DWORD, LPBYTE*, DWORD, LPDWORD,
				LPDWORD, LPDWORD);


/* Extensions to OpenGL */

extern int  PASCAL ChoosePixelFormat(HDC, CONST PIXELFORMATDESCRIPTOR *);	

extern int  PASCAL DescribePixelFormat(HDC, int, UINT, LPPIXELFORMATDESCRIPTOR);

extern UINT  PASCAL GetEnhMetaFilePixelFormat(HENHMETAFILE, DWORD,
			  CONST PIXELFORMATDESCRIPTOR *);

extern int  PASCAL GetPixelFormat(HDC);

extern WINBOOL  PASCAL SetPixelFormat(HDC, int, CONST PIXELFORMATDESCRIPTOR *);

extern WINBOOL  PASCAL SwapBuffers(HDC);

extern HGLRC  PASCAL wglCreateContext(HDC);

extern HGLRC  PASCAL wglCreateLayerContext(HDC, int);

extern WINBOOL  PASCAL wglCopyContext(HGLRC, HGLRC, UINT);

extern WINBOOL  PASCAL wglDeleteContext(HGLRC);

extern WINBOOL  PASCAL wglDescribeLayerPlane(HDC, int, int, UINT, LPLAYERPLANEDESCRIPTOR);

extern HGLRC  PASCAL wglGetCurrentContext(VOID);

extern HDC  PASCAL wglGetCurrentDC(VOID);

extern int  PASCAL wglGetLayerPaletteEntries(HDC, int, int, int, CONST COLORREF *);

extern PROC  PASCAL wglGetProcAddress(LPCSTR);

extern WINBOOL  PASCAL wglMakeCurrent(HDC, HGLRC);

extern WINBOOL  PASCAL wglRealizeLayerPalette(HDC, int, WINBOOL);

extern int  PASCAL wglSetLayerPaletteEntries(HDC, int, int, int, CONST COLORREF *);

extern WINBOOL  PASCAL wglShareLists(HGLRC, HGLRC);

extern WINBOOL  PASCAL wglSwapLayerBuffers(HDC, UINT);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* RC_INVOKED */

#endif /* _GNU_H_WINDOWS32_COMMONFUNCTIONS */
