//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <mmsystem.h>
#pragma hdrstop

#include "MainFrm.h"
#include "PopupFrm.h"
#include "Demo1Frm.h"
#include "Demo2Frm.h"
#include "Demo3Frm.h"
#include "Demo4Frm.h"
#include "Demo5Frm.h"
#include "Demo6Frm.h"
#include "Demo7Frm.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TfrmMain *frmMain;
//---------------------------------------------------------------------------
__fastcall TfrmMain::TfrmMain(TComponent* Owner)
    : TForm(Owner)
{
}

// Constants for text styles, rvs->TextStyles
#define snNormal  0
#define snHeading 1
#define snExit    3
#define snJump    4
void __fastcall TfrmMain::FormCreate(TObject *Sender)
{
  rvTop->BackgroundBitmap = rv->BackgroundBitmap;
  rvTop->AddNL("", snNormal, 1);
  rvTop->AddNL("RichView Demos", snHeading, 1);
  rvTop->AddNL("", snNormal, 1);
  rvTop->Format();
  rvTop->Height = rvTop->DocumentHeight;

  rv->AddNL("Click links for demos, click balls for hints", snNormal, 1);
  rv->AddHotspotExTag("", 0,1,il, 1, 1);
  rv->Add("1. ", snNormal);
  rv->AddTag("'Checkpoints'", snJump, 1);
  rv->AddHotspotExTag("", 0,1,il, 1, 2);
  rv->Add("2. ", snNormal);
  rv->AddTag("Customizing Styles", snJump, 2);
  rv->AddHotspotExTag("", 0,1,il, 1, 3);
  rv->Add("3. ", snNormal);
  rv->AddTag("Query Summary", snJump, 3);
  rv->AddHotspotExTag("", 0,1,il, 1, 4);
  rv->Add("4. ", snNormal);
  rv->AddTag("Interactive document", snJump, 4);
  rv->AddHotspotExTag("", 0,1,il, 1, 5);
  rv->Add("5. ", snNormal);
  rv->AddTag("Chat Simulation", snJump, 5);
  rv->AddHotspotExTag("", 0,1,il, 1, 6);
  rv->Add("6. ", snNormal);
  rv->AddTag("Credits Demo", snJump, 6);
  rv->AddHotspotExTag("", 0,1,il, 1, 7);
  rv->Add("7. ", snNormal);
  rv->AddTag("Search and mark", snJump, 7);
  rv->AddBreakEx(2, rvbsLine, clGreen);
  rv->AddNL("Exit", snExit, 1);
  rv->Format();
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::rvRVMouseMove(TObject *Sender, int id)
{
  if (id!=-1)
    PlaySound((ExtractFilePath(Application->ExeName)+"UCS.wav").c_str(),
              0, SND_ASYNC | SND_FILENAME);
}
//---------------------------------------------------------------------------
void __fastcall TfrmMain::rvJump(TObject *Sender, int id)
{
  int ItemNo  = rv->GetJumpPointItemNo(id);
  int StyleNo = rv->GetItemStyle(ItemNo);
  int ItemTag = rv->GetItemTag(ItemNo);
  if (StyleNo==rvsHotspot)
  {
    TfrmPopup* frm = new TfrmPopup(this);
    frm->ShowTopic(ItemTag);
  }
  else
  {
    TForm* frmDemo = NULL;
    switch (ItemTag)
    {

      case 1:
        frmDemo = new TfrmDemo1(Application);
        break;
      case 2:
        frmDemo = new TfrmDemo2(Application);
        break;
      case 3:
        frmDemo = new TfrmDemo3(Application);
        break;
      case 4:
        frmDemo = new TfrmDemo4(Application);
        break;
      case 5:
        frmDemo = new TfrmDemo5(Application);
        break;
      case 6:
        frmDemo = new TfrmDemo6(Application);
        break;
      case 7:
        frmDemo = new TfrmDemo7(Application);
        break;
      case 0:
        Close();
        break;
    }
    if (frmDemo)
    {
      frmDemo->ShowModal();
      delete frmDemo;
    }
  }
}
//---------------------------------------------------------------------------
