//<HTML><pre>
// KEHOME/java/Qname.java
// Aug/26/2003


import edu.stanford.TAP.Abbrev;

public class Qname
{
    public String label;
    public String tag;
    public Qname(String arglabel, String argtag)
    {
	label = arglabel;
	tag   = argtag;
    } // end Qname()

/*
*  example: "foaf:homepage" => new Qname("foaf","homepage")
*  example: "homepage"      => new Qname("","homepage")
*  example: "http://server/homepage" => new Qname("http","//server/homepage")
*/
    public static Qname GetQname(String name)
    {
    String debug = "no";
    int x;
    int n = name.length();
    for (x = 1; x < n; ++x) {
	if (!Character.isLetter(name.charAt(x))) {
	    // first non-letter
	    if (name.charAt(x) == ':') {
		// found label
		String arglabel = name.substring(0,x);
		String argtag = name.substring(x+1,n);
		if (debug == "yes") {
		    System.out.println("# arglabel = " + arglabel);
		    System.out.println("# argtag = " + argtag);
		}
		return new Qname(arglabel,argtag);
	    } else {
		return new Qname("",name);
	    }
	}
    }
    return new Qname("",name);
    } // end GetQname()

/*
*  example: "foaf:homepage" => foafuri + "homepage"
*  example: "homepage"      => tapuri  + "homepage"
*  example: "http://server/homepage" => "http://server/homepage"
*/
    public static String GetNameURI(String name)
    {
	String tapuri = "http://tap.stanford.edu/data/";
	Qname qname = Qname.GetQname(name);
	if (qname.label == "") {
	    if (!Abbrev.IsStandardTag(name)) {
		return tapuri + name;
	    } else {
		return name;
	    }
	} else if (qname.label == "http") {
	    return name;
	} else {
	    return Abbrev.GetStdLabelURL(qname.label) + qname.tag;
	}
    } // end GetNameURI()

} // end class Qname

//</pre></HTML>
