//<html><pre>
// KEHOME/java/getresource.java
// Sep/1/2003
// usage:
//	java getresource kbdata
//	genus name
//	...
//	CONTROL-Z
// example:
//	java getresource http://tap.stanford.edu/data/
//	Resource MacPherson
//	Athlete Jordan
//	CONTROL-Z

import java.io.*;
import java.util.regex.*;

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;

/**
*	read TAP KB location from command line
*	create TAP KB client
*	read genus-name pair(s) from standard input
*	parse to genus, name
*	get answer(s) from TAP KB
*/
public class getresource
{
    public static void main(String argv[])
    throws IOException
    {
	String info      = "# INFO: getresource: ";
	String error     = "# ERROR: getresource: ";
	String debug     = "no";

	String Subflag   = "includeSubClasses=yes";
	String Superflag = "includeSuperClasses=yes";
	String flags     = "";

	String kbdata = argv[0];
	Client tap = new Client(kbdata);

	BufferedReader in = new BufferedReader(
		new InputStreamReader(System.in));
	String line = "";
for (
	int linenumber = 0;
	line != null;
	++linenumber
) {
	System.err.print("gr$ ");
	try {
		line = in.readLine();
	} catch(IOException e) {
		return;
	}
	if (line == null) return;
	String[] sentence = Pattern.compile(" ").split(line);
	String genus = sentence[0];
	String name  = sentence[1];

	if (debug == "yes") {
	  System.err.println(info + "kbdata = " + kbdata);
	  System.err.println(info + "genus = "  + genus);
	  System.err.println(info + "name = "   + name);
	  System.err.println(info + "flags = "  + flags);
	}
	if (genus.equals("?") || name.equals("?"))
	{
		if (debug == "yes") System.err.println("# qtype = unknown");
		System.err.println(error +
			"genus <" + genus + "> " +
			"name <" + name + "> ");

		System.err.println("# usage: genus name");
		return;
	}

	Resource answer = get_resource(tap,genus,name);

	if (answer.count() == 0) {
		System.err.println("  " + info + "count = " + answer.count());
	} else {
		print_column(answer);
	}

} // end for
	return;
    } // end main()

/**
*	print one answer per line
*/
    public static void print_column(Resource answer)
    {
	for(int x = 0; x < answer.count(); ++x) {
	    System.out.println("  " + answer.item(x).value);
	}
    } // end print_column()

/**
*	translate Qname to URI
*	get answer(s) from TAP KB
*/
    public static Resource get_resource(
	Client tap,
	String genus,
	String name
    )
    {
	String info   = "# INFO: get_resource: ";
	String debug  = "no";
	String flags  = "";


	Abbrev.LoadNamespaces("namespaces.txt");
	String uriGenus = Qname.GetNameURI(genus);

	if (debug == "yes") {
	  System.out.println(info + " uriGenus = " + uriGenus);
	  System.out.println(info + " name = "     + name);
	  System.out.println(info + " flags = "    + flags);
	}

	//if () {
		//Resource answer = tap.GetResourcesNamed(name);
	//} else {
		Resource resource = new Resource(uriGenus);
		Resource answer = tap.GetResourcesNamed(name,resource);
	//}

	for(int x = 0; x < answer.count(); ++x) {
	    String tapAnswer = answer.item(x).value;
	    String mkrAnswer = XML.SplitNamespace(tapAnswer).tag;
	    answer.item(x).value = mkrAnswer;
	}
	return answer;
    } // end get_resource()


} // end class getresource

//</pre></html>
