/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.TAP;

import edu.stanford.TAP.Cursor;
import edu.stanford.TAP.Description;
import edu.stanford.TAP.Description_XML;
import edu.stanford.TAP.Error;
import edu.stanford.TAP.Restriction;
import edu.stanford.TAP.XML_Branch;
import edu.stanford.TAP.XML_Parser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Resource {
    public String value;
    String flags;
    Description desc;
    Vector items;
    Hashtable props;
    public int startAt;
    public int stepSize;

    private void __init() {
        this.value = null;
        this.items = null;
        this.desc = null;
        this.flags = null;
        this.props = null;
        this.startAt = -1;
        this.stepSize = -1;
    }

    public Resource(Object object) {
        this.__init();
        if (object != null) {
            this.setValue(object);
        }
    }

    public Resource() {
        this.__init();
    }

    public void setValue(Object object) {
        if (object != null) {
            if (object instanceof Cursor) {
                Cursor cursor = (Cursor)object;
                Vector vector = cursor.AsArray();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    this.addItem(new Resource(string));
                }
            } else if (object instanceof Vector) {
                this.items = (Vector)object;
                Resource resource = (Resource)this.items.elementAt(0);
                this.value = resource.value;
            } else if (object instanceof String) {
                String string = (String)object;
                String string2 = string.trim();
                if (string2.charAt(0) == '<') {
                    XML_Parser xML_Parser = new XML_Parser();
                    XML_Branch xML_Branch = xML_Parser.Parse(string);
                    if (xML_Branch != null) {
                        Description description = Description_XML.FromBranch(xML_Branch, "");
                        this.setDescription(description);
                    } else {
                        Error.Report("Failed to parse description " + string);
                    }
                } else {
                    this.value = string;
                }
            }
        }
    }

    public void setFlags(String string) {
        this.flags = string;
    }

    public String getFlags() {
        return this.flags;
    }

    public void addArc(String string, String string2) {
        if (this.desc == null) {
            this.desc = new Description(null);
        }
        this.desc.AddArcTarget(string, string2);
    }

    public void addArc(String string, Resource resource) {
        if (this.desc == null) {
            this.desc = new Description(null);
        }
        Description description = resource.desc;
        String string2 = resource.value;
        if (description != null) {
            if (string2 != null && description.GetRestrictionValue("oid") == null) {
                description.AddArcTarget("oid", string2);
            }
            this.desc.AddArcTarget(string, description);
        } else {
            this.desc.AddArcTarget(string, string2);
        }
    }

    public void addArc(String string, String string2, String string3) {
        if (this.desc == null) {
            this.desc = new Description(null);
        }
        Restriction restriction = new Restriction(string, string2);
        int n = string3.indexOf(61);
        restriction.SetParameter(string3.substring(0, n), string3.substring(n + 1));
        this.desc.AddRestriction(restriction);
    }

    public Description asDescription() {
        if (this.desc == null) {
            Description description = new Description(null);
            description.AddArcTarget("oid", this.value);
            return description;
        }
        return this.desc;
    }

    public void setDescription(Description description) {
        this.desc = description;
    }

    public void SetAnswerStep(int n) {
        this.stepSize = n;
    }

    public void SetFirstAnswer(int n) {
        this.startAt = n;
    }

    public void addProperty(String string, String string2) {
        string = Restriction.replaceAbbrs(string);
        Resource resource = new Resource(string);
        resource.setFlags(string2);
        this.addItem(resource);
    }

    public Resource property(String string) {
        if (this.props == null) {
            return null;
        }
        string = Restriction.replaceAbbrs(string);
        return (Resource)this.props.get(string);
    }

    public void setPropertyResponse(String string, Resource resource) {
        if (this.props == null) {
            this.props = new Hashtable();
        }
        this.props.put(string, resource);
    }

    public void addItem(Resource resource) {
        if (this.items == null) {
            this.items = new Vector();
        }
        this.items.addElement(resource);
        Resource resource2 = (Resource)this.items.elementAt(0);
        this.value = resource2.value;
    }

    public int count() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    public Vector items() {
        return this.items;
    }

    public Resource item(int n) {
        if (this.items == null || n >= this.items.size()) {
            return null;
        }
        return (Resource)this.items.elementAt(n);
    }

    public Vector asStrings() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.items.elements();
        while (enumeration.hasMoreElements()) {
            Resource resource = (Resource)enumeration.nextElement();
            vector.addElement(resource.value);
        }
        return vector;
    }
}

