unit SIBAPI;

// SuperIB
// Copyright  1999 David S. Becker
// dhbecker@jps.net
// www.jps.net/dhbecker/superib

interface
uses SIBGlobals;

type
  // data types used to interface with the InterBase API
  SIB_PVoid                 = ^Pointer;
  SIB_PPChar                = ^PChar;
  SIB_Long                  = LongInt;
  SIB_PLong                 = ^SIB_Long;
  SIB_UShort                = Word;
  SIB_DBHandle              = SIB_PVoid;
  SIB_PDBHandle             = ^SIB_DBHandle;
  SIB_Status                = SIB_Long;
  SIB_PStatus               = ^SIB_Status;
  SIB_PPStatus              = ^SIB_PStatus;
  SIB_StatusVector          = array[0..19] of SIB_Status;
  SIB_PStatusVector         = ^SIB_StatusVector;
  SIB_PPStatusVector        = ^SIB_PStatusVector;
  SIB_EventCallback         = procedure(P: Pointer; Length: SIB_UShort; Updated: PChar); cdecl;

//function SIB_InterpretError(Buffer: PChar; Status: SIB_PPStatusVector): SIB_Status; stdcall; external SIB_DLL name 'isc_interprete';
//function SIB_EventBlock(EventBuffer, ResultBuffer: SIB_PPChar; IDCount: SIB_UShort;
//  Event1, Event2, Event3, Event4, Event5, Event6, Event7, Event8, Event9, Event10, Event11, Event12, Event13, Event14, Event15: PChar): SIB_Long; cdecl; external SIB_DLL name 'isc_event_block';
//function SIB_Free(P: PChar): SIB_Long; stdcall; external SIB_DLL name 'isc_free';
//function SIB_QueEvents(Status: SIB_PStatusVector; DBHandle: SIB_PDBHandle; EventID: SIB_PLong; Length: SIB_UShort; EventBuffer: PChar; Callback: SIB_EventCallback; CallbackArg: Pointer): SIB_Status; stdcall; external SIB_DLL name 'isc_que_events';
//function SIB_CancelEvents(Status: SIB_PStatusVector; DBHandle: SIB_DBHandle; EventID: SIB_PLong): SIB_Status; stdcall; external SIB_DLL name 'isc_cancel_events';
//procedure SIB_EventCounts(Status: SIB_PStatusVector; Length: SIB_UShort; EventBuffer, ResultBuffer: PChar); stdcall; external SIB_DLL name 'isc_event_counts';

//
function SIB_InterpretError(Buffer: PChar; Status: SIB_PPStatusVector): SIB_Status;
function SIB_EventBlock(EventBuffer, ResultBuffer: SIB_PPChar; IDCount: SIB_UShort;
  Event1, Event2, Event3, Event4, Event5, Event6, Event7, Event8, Event9, Event10, Event11, Event12, Event13, Event14, Event15: PChar): SIB_Long;
function SIB_Free(P: PChar): SIB_Long;
function SIB_QueEvents(Status: SIB_PStatusVector; DBHandle: SIB_PDBHandle; EventID: SIB_PLong; Length: SIB_UShort; EventBuffer: PChar; Callback: SIB_EventCallback; CallbackArg: Pointer): SIB_Status;
function SIB_CancelEvents(Status: SIB_PStatusVector; DBHandle: SIB_DBHandle; EventID: SIB_PLong): SIB_Status;
procedure SIB_EventCounts(Status: SIB_PStatusVector; Length: SIB_UShort; EventBuffer, ResultBuffer: PChar);

implementation

uses ib_externals, IB_Intf, ibase;

//---------------------------------------------------------------------------

function SIB_QueEvents(Status: SIB_PStatusVector; DBHandle: SIB_PDBHandle; EventID: SIB_PLong; Length: SIB_UShort; EventBuffer: PChar; Callback: SIB_EventCallback; CallbackArg: Pointer): SIB_Status;
begin
  Result := isc_que_events( PISC_STATUS( Status ), PISC_DB_HANDLE( DBHandle ),
      PISC_LONG( EventID ),
      Length, EventBuffer,
      TISC_CALLBACK( Callback ), CallbackArg
      );
  Set8087CW(Default8087CW);      
end;

//---------------------------------------------------------------------------

function SIB_CancelEvents(Status: SIB_PStatusVector; DBHandle: SIB_DBHandle; EventID: SIB_PLong): SIB_Status;
begin
  Result := isc_cancel_events( PISC_STATUS( Status ), PISC_DB_HANDLE( DBHandle ), PISC_LONG( EventID ) );
  Set8087CW(Default8087CW);
end;

//---------------------------------------------------------------------------

procedure SIB_EventCounts(Status: SIB_PStatusVector; Length: SIB_UShort; EventBuffer, ResultBuffer: PChar);
begin
  isc_event_counts( PISC_STATUS( Status ), Length, EventBuffer, ResultBuffer );
  Set8087CW(Default8087CW);
end;

//---------------------------------------------------------------------------

function SIB_InterpretError(Buffer: PChar; Status: SIB_PPStatusVector): SIB_Status;
begin
  Result := isc_interprete( Buffer, PPISC_STATUS( Status ) );
  Set8087CW(Default8087CW);  
end;

{-----------------------------------------------------------------------}
type
  TDummy_isc_event_block = function(
        event_buffer    : SIB_PPChar;
        result_buffer   : SIB_PPChar;
        id_count        : SIB_UShort;
        event1          : PChar;
        event2          : PChar;
        event3          : PChar;
        event4          : PChar;
        event5          : PChar;
        event6          : PChar;
        event7          : PChar;
        event8          : PChar;
        event9          : PChar;
        event10          : PChar;
        event11          : PChar;
        event12          : PChar;
        event13          : PChar;
        event14          : PChar;
        event15          : PChar
        ): SIB_Long; cdecl;

function SIB_EventBlock(EventBuffer, ResultBuffer: SIB_PPChar; IDCount: SIB_UShort;
  Event1, Event2, Event3, Event4, Event5, Event6, Event7, Event8, Event9, Event10, Event11, Event12, Event13, Event14, Event15: PChar): SIB_Long;
begin
  Result := TDummy_isc_event_block(isc_event_block)(
        EventBuffer,
        ResultBuffer,
        IDCount,
        Event1, Event2, Event3, Event4, Event5, Event6, Event7, Event8, Event9, Event10,
        Event11, Event12, Event13, Event14, Event15
        );
  Set8087CW(Default8087CW);        
end;

function SIB_Free(P: PChar): SIB_Long;
begin
 if Assigned(P) then   
  Result := isc_free( P )
 else
  Result := 0   ;
  Set8087CW(Default8087CW);  
end;

end.

