{***************************************************************}
{ FIBPlus - component library for direct access to Firebird and }
{ Interbase databases                                           }
{                                                               }
{    FIBPlus is based in part on the product                    }
{    Free IB Components, written by Gregory H. Deatz for        }
{    Hoagland, Longo, Moran, Dunst & Doukas Company.            }
{    mailto:gdeatz@hlmdd.com                                    }
{                                                               }
{    Copyright (c) 1998-2001 Serge Buzadzhy                     }
{    Contact: buzz@devrace.com                                  }
{                                                               }
{ ------------------------------------------------------------- }
{    FIBPlus home page      : http://www.fibplus.net/           }
{    FIBPlus support e-mail : fibplus@devrace.com               }
{ ------------------------------------------------------------- }
{                                                               }
{  Please see the file License.txt for full license information }
{***************************************************************}
unit pFIBAutoUpdEditor;

interface

uses Classes, Controls, Forms, FIBDataSet, pFIBProps, StdCtrls, Db,
     pFIBDataSet;

type

  TpFIBAutoUpdateOptionForm = class(TForm)
    GroupBox1: TGroupBox;
    AllowChangeC: TCheckBox;
    AutoGenC: TCheckBox;
    ModFieldsC: TCheckBox;
    PrimaryKeyL: TLabel;
    KeyC: TComboBox;
    GroupBox2: TGroupBox;
    ModTableL: TLabel;
    TableC: TComboBox;
    GenNameL: TLabel;
    GenC: TComboBox;
    WhenGetC: TComboBox;
    OkB: TButton;
    CancelB: TButton;
    procedure AutoGenCClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    FDataSet: TFIBDataSet;
    procedure PrepareControls;
  public
    { Public declarations }
  end;

function EditAutoUpdateOptions(aDataSet: TFIBDataSet; Options: TAutoUpdateOptions): boolean;

implementation
uses SysUtils, SqlTxtRtns, pFIBQuery, pFIBDatabase, FIBQuery, FIBConsts;

{$R *.dfm}

function EditAutoUpdateOptions(aDataSet: TFIBDataSet; Options: TAutoUpdateOptions): boolean;
var aForm: TpFIBAutoUpdateOptionForm;
begin
  Result := False;
  if aDataSet = nil then exit;

  aForm := TpFIBAutoUpdateOptionForm.Create(Application);
  try
    with aForm do begin
      Caption := Format(Caption, [aDataSet.Name]);
      FDataSet := aDataSet;
      AllowChangeC.Checked := Options.CanChangeSQLs;
      AutoGenC.Checked := Options.AutoReWriteSqls;
      ModFieldsC.Checked := Options.UpdateOnlyModifiedFields;
      KeyC.Text := Options.KeyFields;
      TableC.Text := Options.UpdateTableName;
      GenC.Text := Options.GeneratorName;
      WhenGetC.ItemIndex := integer(Options.WhenGetGenID);

      PrepareControls;
    end;
    Result := aForm.ShowModal = mrOk;
    if Result then begin
    end;
  finally
    aForm.Free;
  end;
end;

procedure TpFIBAutoUpdateOptionForm.AutoGenCClick(Sender: TObject);
begin
  ModFieldsC.Enabled := AutoGenC.Checked;
  if not ModFieldsC.Enabled then ModFieldsC.Checked := False;
end;

procedure TpFIBAutoUpdateOptionForm.PrepareControls;
var
  Qry: TpFIBQuery;
  Trans: TpFIBTransaction;
  lSQLDA: TFIBXSQLDA;

begin
  AllTables(FDataSet.SelectSQL.Text, TableC.Items);

  if FDataSet.Database = nil then exit;
  GenC.Items.Clear;

  Qry := nil; Trans := nil;
  try
  Trans := TpFIBTransaction.Create(nil);
  Qry := TpFIBQuery.Create(nil);
  Qry.ParamCheck := false;
  Qry.Database := FDataSet.Database;
  Trans.DefaultDatabase := FDataSet.Database;
  Qry.Transaction := Trans;
  Qry.SQL.Text := 'select RDB$GENERATOR_NAME '+
                  'from RDB$GENERATORS '+
  'where (RDB$SYSTEM_FLAG is NULL) or (RDB$SYSTEM_FLAG = 0)'+
                  'order by RDB$GENERATOR_NAME';
  try
   Trans.StartTransaction;
   Qry.ExecQuery;
   lSQLDA := Qry.Current;
     while not Qry.Eof do begin
       GenC.Items.Add(Trim(lSQLDA.ByName['RDB$GENERATOR_NAME'].AsString));
       lSQLDA := Qry.Next;
     end;
   Qry.Close;
  finally
   Trans.Commit;
  end;

  finally
    Qry.Free;
    Trans.Free;
  end
end;

procedure TpFIBAutoUpdateOptionForm.FormCreate(Sender: TObject);
begin
  Caption := FPAutoOptEditorCaption;
  PrimaryKeyL.Caption := FPAutoOptEditorPrimaryKey;
  ModTableL.Caption := FPAutoOptEditorModTable;
  GroupBox1.Caption := FPAutoOptEditorSQL;
  AllowChangeC.Caption := FPAutoOptEditorAllowChange;
  AutoGenC.Caption := FPAutoOptEditorAutoGen;
  ModFieldsC.Caption := FPAutoOptEditorModFields;
  GroupBox2.Caption := FPAutoOptEditorAutoInc;
  GenNameL.Caption := FPAutoOptEditorGenName;
  WhenGetC.Items.Add(FPAutoOptEditorWhenGet1);
  WhenGetC.Items.Add(FPAutoOptEditorWhenGet2);
  WhenGetC.Items.Add(FPAutoOptEditorWhenGet3);

  OkB.Caption := SOKButton;
  CancelB.Caption := SCancelButton;
end;

end.
