/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class seGraph
extends JPanel
implements Runnable,
MouseListener,
MouseMotionListener,
AdjustmentListener,
Scrollable,
PopupMenuListener {
    int nnodes;
    scNode[] nodes = new scNode[1000];
    EdgeSet Edges;
    WeakHashMap menus;
    Thread relaxer;
    boolean stress;
    boolean random;
    Notepad scr = null;
    int Unit = 180;
    Graph G;
    double E0 = 0.0;
    double SpeedLimit = 700.0;
    double Inn = 0.2;
    double Km = 0.005;
    double E = -1.0;
    double dE;
    int iter = 0;
    int nn = 1;
    int nc = 1;
    double ashK = 1.0;
    int shl = 100;
    int nsh = 0;
    double[] sh = null;
    boolean shivers;
    static double dKrit = 0.001;
    boolean State = false;
    scNode pick;
    boolean pickfixed;
    Image offscreen;
    Dimension offscreensize;
    Graphics offgraphics;
    int[] tx = new int[3];
    int[] ty = new int[3];
    final Color edgeColor = Color.black;
    final Color stressColor = Color.darkGray;
    final Color arcColor1;
    final Color arcColor2 = this.arcColor1 = Color.black;
    final Color arcColor3 = this.arcColor1;
    int iljv = 0;
    int iljh = 0;
    scNode MenuOn = null;
    public File CurrentFile = null;

    public seGraph(Notepad _scr) {
        Database.make();
        this.Edges = new EdgeSet();
        this.menus = new WeakHashMap();
        this.scr = _scr;
        String nnn = "5.1.1.1";
        this.G = new Graph(5, 10);
        this.addMouseListener(this);
        this.setBackground(Color.white);
    }

    void Adjust() {
        this.adjust();
    }

    public int AskMessageBox(String s) {
        return JOptionPane.showConfirmDialog(this.scr, s, "Question", 0, 2);
    }

    void Compact() {
        boolean adjusted = false;
        dPoint c = this.getCenter();
        int l = 0;
        while (l < 24) {
            int k = 0;
            while (k < this.nnodes) {
                scNode n1 = this.nodes[k];
                double yy = n1.y;
                n1.y = n1.y < c.y ? (n1.y += n1.height) : (n1.y -= n1.height);
                n1.y = Math.round(n1.y / (double)sf.GRIDY) * (long)sf.GRIDY;
                if (this.can(n1)) {
                    adjusted = true;
                } else {
                    n1.y = yy;
                }
                double xx = n1.x;
                n1.x = n1.x < c.x ? (n1.x += (double)(3 * sf.X)) : (n1.x -= (double)(3 * sf.X));
                n1.x = Math.round(n1.x / (double)sf.GRIDX) * (long)sf.GRIDX;
                if (this.can(n1)) {
                    adjusted = true;
                } else {
                    n1.x = xx;
                }
                ++k;
            }
            if (!adjusted) break;
            ++l;
        }
        this.revalidate();
    }

    void Connect(String a, String b) {
        this.Connect(a, b, 0, 1.0);
    }

    void Connect(String a, String b, int flags) {
        this.Connect(a, b, flags, 1.0);
    }

    void Connect(String a, String b, int flags, double len) {
        this.Status("Connecting '" + a + "' - '" + b + "' F " + flags);
        System.out.println("Connecting '" + a + "' - '" + b + "' F " + flags);
        this.addEdge(a, b, len * (double)this.Unit / 2.0, flags);
        this.G.cn(a, b);
    }

    void Disconnect(String a, String b) {
        this.Status("Disconnecting '" + a + "' - '" + b + "'");
        this.removeEdge(a, b);
        this.G.discn(a, b);
    }

    double Energy() {
        Edge e;
        double E = 0.0;
        eIterator e_i = this.Edges.iterator();
        while ((e = (Edge)e_i.next()) != null) {
            double vx = this.nodes[e.to].x - this.nodes[e.from].x;
            double vy = this.nodes[e.to].y - this.nodes[e.from].y;
            double len = Math.sqrt(vx * vx + vy * vy);
            len = len == 0.0 ? 1.0E-4 : len;
            double f = (e.len - len) / len;
            E += Math.abs(f * vx) + Math.abs(f * vy);
        }
        return E / (double)this.Edges.size();
    }

    public void Load(File file) {
        String s = null;
        scNode n = null;
        try {
            try {
                FileInputStream fis = new FileInputStream(file);
                BufferedReader f = new BufferedReader(new InputStreamReader(fis));
                try {
                    this.rmGraph();
                    while (true) {
                        if ((s = f.readLine()).startsWith("NODE")) {
                            n = scNode.fromString(s);
                            if (n == null) continue;
                            this.Node(n);
                            continue;
                        }
                        if (s.startsWith("EDGE")) {
                            Edge.fromString(s, this);
                            continue;
                        }
                        if (s.startsWith("END")) break;
                    }
                }
                catch (IOException iOException) {}
                f.close();
                fis.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.MessageBox(String.valueOf(file.toString()) + " not found. ");
            }
        }
        catch (IOException ex) {
            this.MessageBox("Can't read " + file.toString() + ": " + ex.getMessage());
        }
        this.revalidate();
    }

    public void MessageBox(String s) {
        JOptionPane.showMessageDialog(this.scr, s, "Information", 1, new ImageIcon(this.getClass().getResource("resources/msg.gif")));
    }

    void Next() {
        String t = JOptionPane.showInputDialog(this.scr, (Object)"Please enter EC number, enzyme systematic name or substrate name");
        if (t != null) {
            new FindAction(t, this.scr).actionPerformed(null);
        }
    }

    void Node(scNode N) {
        this.Status("Adding " + N.lbl + ".");
        this.addNode(N);
        this.G.add(new Node(N.lbl));
    }

    public void Progress(int n) {
        this.scr.Bar.Progress(n);
        this.scr.Bar.progress.paint(this.scr.Bar.progress.getGraphics());
    }

    void Relax() {
        this.prepareRelax();
        this.relax();
    }

    public void Save(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            DataOutputStream f = new DataOutputStream(fos);
            int k = 0;
            while (k < this.nnodes) {
                f.writeBytes(this.nodes[k].toString());
                f.write(10);
                ++k;
            }
            this.Edges.Save(f, this);
            f.writeBytes("END\n");
            f.close();
            fos.close();
            this.CurrentFile = file;
        }
        catch (IOException ex) {
            this.MessageBox("Can't write " + file.toString() + ": " + ex.getMessage());
        }
    }

    public void Status(String s) {
        this.scr.Bar.setText(s);
        this.scr.Bar.paint(this.scr.Bar.getGraphics());
    }

    void addEdge(String from, String to, double len) {
        this.addEdge(from, to, len, 0);
    }

    void addEdge(String from, String to, double len, int flags) {
        int e_from = this.findNode(from);
        int e_to = this.findNode(to);
        Edge e = new Edge(e_from, e_to, len, flags);
        this.Edges.add(e);
    }

    void addGraph(Graph _G) {
        this.G = _G;
        if (this.G.Size == 1) {
            this.addNode(this.G.L[0].n);
            this.Edges.clear();
            this.nnodes = 1;
            return;
        }
        if (this.G == null) {
            System.err.println("Export variable null.");
            return;
        }
        adjMatrix m = new adjMatrix(this.G);
        adjMatrix width = m.longways();
        int[] R = m.getRing();
        int c = m.Central();
        String C = m.nodeName(c);
        int dirs = this.G.Size;
        double da = Math.PI * 2 / (double)dirs;
        this.addNode(C, this.Unit * 0 + 300, this.Unit * 0 + 200);
        int k = 0;
        while (k < dirs) {
            double dir = da * (double)k;
            Node a = m.Scale.L[m.Ring[k]];
            if (C.compareTo(a.n) != 0) {
                double r = width.M[c][k] / 2;
                if (r < 1.0) {
                    r = 1.0;
                }
                double y = r * Math.sin(dir);
                double x = r * Math.cos(dir);
                this.addNode(a.n, (int)((double)this.Unit * x + 300.0), (int)((double)this.Unit * y + 200.0));
            }
            ++k;
        }
        this.setEdgeData();
    }

    int addNode(String lbl) {
        scNode n;
        this.nodes[this.nnodes] = n = new scNode(lbl, 10.0 + 380.0 * Math.random(), 10.0 + 380.0 * Math.random());
        return this.nnodes++;
    }

    int addNode(String lbl, int x, int y) {
        scNode n;
        this.nodes[this.nnodes] = n = new scNode(lbl, x, y);
        return this.nnodes++;
    }

    int addNode(scNode n) {
        this.nodes[this.nnodes] = n;
        return this.nnodes++;
    }

    Dimension adjSize() {
        scNode n1;
        double maxx;
        double maxy;
        if (this.nnodes == 0) {
            return new Dimension(200, 200);
        }
        double miny = maxy = this.nodes[0].y;
        double minx = maxx = this.nodes[0].x;
        int k = 0;
        while (k < this.nnodes) {
            n1 = this.nodes[k];
            if (minx > n1.x - n1.width - (double)sf.X) {
                minx = n1.x - n1.width - (double)sf.X;
            }
            if (miny > n1.y - n1.height - (double)sf.Y) {
                miny = n1.y - n1.height - (double)sf.Y;
            }
            if (maxx < n1.x + n1.width + (double)sf.X) {
                maxx = n1.x + n1.width + (double)sf.X;
            }
            if (maxy < n1.y + n1.height + (double)sf.Y) {
                maxy = n1.y + n1.height + (double)sf.Y;
            }
            ++k;
        }
        int k2 = 0;
        while (k2 < this.nnodes) {
            n1 = this.nodes[k2];
            n1.x -= minx;
            n1.y -= miny;
            ++k2;
        }
        return new Dimension((int)(maxx -= minx), (int)(maxy -= miny));
    }

    void adjust() {
        int k;
        dPoint c = this.getCenter();
        int loop = 0;
        while (loop < 24) {
            boolean adjusted = true;
            k = 0;
            while (k < this.nnodes) {
                scNode n1 = this.nodes[k];
                if (!n1.yr(scNode.Fixed)) {
                    int l = 0;
                    while (l < this.nnodes) {
                        scNode n2;
                        if (k != l && !(n2 = this.nodes[l]).yr(scNode.Fixed) && n1.overlaps(n2)) {
                            scNode a2;
                            scNode a1;
                            adjusted = true;
                            if (n1.y < n2.y) {
                                a1 = n1;
                                a2 = n2;
                            } else {
                                a1 = n2;
                                a2 = n1;
                            }
                            double yy = a1.y;
                            a1.y = a2.y - ((a1.height + a2.height) / 2.0 + (double)sf.Y);
                            if (!this.can(a1)) {
                                a1.y = yy;
                                yy = a2.y;
                                a2.y = a1.y + ((a1.height + a2.height) / 2.0 + (double)sf.Y);
                                if (!this.can(a2)) {
                                    a2.y = yy;
                                    if (n1.x < n2.x) {
                                        a1 = n1;
                                        a2 = n2;
                                    } else {
                                        a1 = n2;
                                        a2 = n1;
                                    }
                                    double xx = a1.x;
                                    a1.x = a2.x - ((a1.width + a2.width) / 2.0 + (double)sf.X);
                                    if (!this.can(a1)) {
                                        a1.x = xx;
                                        xx = a2.x;
                                        a2.x = a1.x + ((a1.width + a2.width) / 2.0 + (double)sf.X);
                                        if (!this.can(a2)) {
                                            a2.x = xx;
                                            scNode n = Math.random() > 0.5 ? a1 : a2;
                                            dPoint d = this.getExpandDir(n);
                                            while (!this.can(n)) {
                                                n.mov(d);
                                            }
                                            adjusted = true;
                                        }
                                    }
                                }
                            }
                        }
                        ++l;
                    }
                }
                ++k;
            }
            if (!adjusted) break;
            ++loop;
        }
        double ny = 0.0;
        double nx = 0.0;
        k = 0;
        while (k < this.nnodes) {
            nx += this.nodes[k].x;
            ny += this.nodes[k].y;
            ++k;
        }
        double tx = (nx /= (double)this.nnodes) - c.x;
        double ty = (ny /= (double)this.nnodes) - c.y;
        int k2 = 0;
        while (k2 < this.nnodes) {
            this.nodes[k2].x -= tx;
            this.nodes[k2].y -= ty;
            ++k2;
        }
        if (this.scr.compact.isSelected()) {
            this.Compact();
        } else {
            this.revalidate();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
    }

    void antiShiver(double aE) {
        double d;
        int k;
        if (this.E0 <= 0.0) {
            return;
        }
        double E = aE / this.E0;
        int pp = 0;
        double ss = 0.0;
        double sx2 = 0.0;
        double sx22 = 0.0;
        if (E > 0.0) {
            double x;
            if (this.nsh <= this.shl) {
                this.sh[this.nsh++] = E;
                k = 0;
                while (k < this.nsh) {
                    x = this.sh[k];
                    sx2 += x;
                    sx22 += x * x;
                    ++k;
                }
                k = this.nsh;
            } else {
                k = 1;
                while (k <= this.shl) {
                    this.sh[k - 1] = x = this.sh[k];
                    sx2 += x;
                    sx22 += x * x;
                    ++k;
                }
                this.sh[this.shl] = E;
                sx2 += E;
                sx22 += E * E;
                k = this.shl + 1;
            }
            if (this.nsh > 2) {
                if ((sx22 /= (double)k) - (sx2 = sx2 * sx2 / (double)(k * k)) < dKrit * dKrit) {
                    double d2 = 0.0;
                    this.State = true;
                    return;
                }
                d = Math.sqrt(sx22 - sx2);
            }
        }
        boolean shivers = false;
        if (this.nsh < 4) {
            return;
        }
        int p = 2;
        while (p < this.nsh / 2) {
            double s = 0.0;
            k = 0;
            while (k < this.shl / 2) {
                d = this.sh[k] - this.sh[k + p];
                s += Math.abs(d);
                ++k;
            }
            if ((s /= (double)p) < 0.1 && s > 1.0E-4) {
                shivers = true;
                ss = s;
                pp = p;
                break;
            }
            ++p;
        }
        if (shivers) {
            this.State = true;
        }
    }

    boolean can(scNode n) {
        int k = 0;
        while (k < this.nnodes) {
            scNode nx = this.nodes[k];
            if (nx != n && nx.overlaps(n)) {
                return false;
            }
            ++k;
        }
        return true;
    }

    void collapseNode(scNode n) {
        boolean deleted;
        Node N = this.G.getNode(n.lbl);
        do {
            deleted = false;
            int k = 0;
            while (k < N.c.Size) {
                Node Nd = N.c.L[k];
                if (Nd.c.Size < 2) {
                    this.removeNode(this.nodes[this.findNode(Nd.n)]);
                    deleted = true;
                    --k;
                }
                ++k;
            }
        } while (deleted);
        n.clears(scNode.Expanded);
    }

    double dLimits(double _x) {
        double x = this.Km * _x;
        if (x > this.SpeedLimit) {
            return this.SpeedLimit;
        }
        if (x < -this.SpeedLimit) {
            return -this.SpeedLimit;
        }
        return x;
    }

    void expandNode(scNode n, Strings filter) {
        this.Progress(0);
        System.gc();
        if (n == null) {
            return;
        }
        if (n.yr(scNode.Expanded)) {
            this.Status("This node already expanded.");
            return;
        }
        String errmsg = n.expandNode(this, filter);
        if (errmsg == null) {
            if (this.scr.auto_adjust.isSelected()) {
                this.setEdgeData();
            } else {
                this.adjust();
                this.revalidate();
            }
            this.Status("Node expanded.");
        } else {
            this.Status(errmsg);
        }
        this.Progress(0);
    }

    int findNode(String lbl) {
        int i = this.nnodes - 1;
        while (i >= 0) {
            if (this.nodes[i].lbl.equals(lbl)) {
                return i;
            }
            --i;
        }
        return this.addNode(lbl);
    }

    dPoint getCenter() {
        double cy = 0.0;
        double cx = 0.0;
        int k = 0;
        while (k < this.nnodes) {
            cx += this.nodes[k].x;
            cy += this.nodes[k].y;
            ++k;
        }
        return new dPoint(cx /= (double)this.nnodes, cy /= (double)this.nnodes);
    }

    dPoint getExpandDir(scNode n) {
        dPoint c = this.getCenter();
        return new dPoint(this.sgn(n.x - c.x), this.sgn(n.y - c.y));
    }

    dPoint getExpandDir(scNode n, dPoint center) {
        return new dPoint(this.sgn(n.x - center.x), this.sgn(n.y - center.y));
    }

    double getInn(double Es) {
        return 0.5 * this.ashK;
    }

    double getKm(double Es) {
        double p = this.E0 > 1.0 ? this.E / this.E0 : 100.0;
        double x = Es - this.E0;
        if (x < 0.0) {
            x = 0.0;
        }
        return x *= this.ashK;
    }

    scNode getPick(int x, int y) {
        double bestdist = Double.MAX_VALUE;
        scNode p = this.nodes[0];
        int i = 0;
        while (i < this.nnodes) {
            scNode n = this.nodes[i];
            double nx = n.x;
            double ny = n.y;
            double dist = (nx - (double)x) * (nx - (double)x) + (ny - (double)y) * (ny - (double)y);
            if (dist < bestdist) {
                p = n;
                bestdist = dist;
            }
            ++i;
        }
        return p;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return this.adjSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    double getSpeedLimit(double Es) {
        double x = Es;
        x = x > 2.0 * this.E0 ? 5.0 : 7.0;
        return x;
    }

    int hasNode(String lbl) {
        if (lbl == null) {
            return -2;
        }
        int i = this.nnodes - 1;
        while (i >= 0) {
            if (this.nodes[i].lbl.compareTo(lbl) == 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    void initRelax() {
        this.Status("Preparing to relax...");
        this.prepareRelax();
        this.Status("Relaxing...");
        this.relax();
        this.Status("Adjusting...");
        this.adjust();
        this.revalidate();
        this.Status("Ready");
    }

    synchronized void look() {
    }

    public void mouseClicked(MouseEvent e) {
        scNode pick = null;
        int x = e.getX() - this.iljh;
        int y = e.getY() - this.iljv;
        pick = this.getPick(x, y);
        if ((e.getModifiers() & 0x10) == 0) {
            if (e.isControlDown()) {
                this.expandNode(pick, null);
            } else if (e.isShiftDown()) {
                new InfoAction("", pick, this.scr, SwissReader.All & ~SwissReader.References).actionPerformed(null);
            } else {
                this.Progress(0);
                myPopup m = (myPopup)this.menus.get(pick.Label());
                if (m == null) {
                    m = new myPopup();
                    JMenuItem header = new JMenuItem("Actions with " + pick.Label() + ":", pick.getIcon());
                    m.add(header);
                    m.addSeparator();
                    if (!pick.yr(scNode.Common)) {
                        m.add(new ExpandAction("Show all links Ctrl-Right", pick));
                    }
                    m.add(new ExpandAction("Show selected links", pick, m));
                    if (pick.is == scNode.ID) {
                        m.add(new InfoAction("More about this enzyme .. Shift-Right", pick, this.scr, SwissReader.All & ~SwissReader.References));
                    } else if (pick.is == scNode.CA) {
                        m.add(new InfoSelAction("Get info about selected enzyme..", m, this.scr, SwissReader.All & ~SwissReader.References));
                    } else {
                        m.addSeparator();
                    }
                    m.add(new CollapseAction("Collapse branches", pick));
                    m.add(new RemoveAction("Remove from graph", pick));
                    m.addSeparator();
                    pick.modifyLocalMenu(m);
                    m.pack();
                    m.addPopupMenuListener(this);
                    this.menus.put(pick.Label(), m);
                }
                this.add(m);
                m.show(this.scr, this.scr.scroller, x + 2, y + 2);
                this.MenuOn = pick;
                this.Progress(0);
            }
            pick.sets(scNode.Fixed, this.pickfixed);
            pick = null;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.pick != null) {
            this.pick.x = e.getX() - this.iljh;
            this.pick.y = e.getY() - this.iljv;
            this.repaint();
        }
        e.consume();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        this.revalidate();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 0) {
            return;
        }
        int x = e.getX() - this.iljh;
        int y = e.getY() - this.iljv;
        this.pick = this.getPick(x, y);
        if (this.pick.contains((int)((double)x + this.pick.width / 2.0), (int)((double)y + this.pick.height / 2.0))) {
            this.addMouseMotionListener(this);
            this.pickfixed = this.pick.yr(scNode.Fixed);
            if (Options.fixedAfterDrag) {
                this.pickfixed = true;
            }
            this.pick.sets(scNode.Fixed);
            this.pick.x = x;
            this.pick.y = y;
            this.repaint();
        } else {
            this.pick = null;
        }
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        this.removeMouseMotionListener(this);
        if (this.pick != null) {
            this.pick.x = e.getX() - this.iljh;
            this.pick.y = e.getY() - this.iljv;
            this.pick.sets(scNode.Fixed, this.pickfixed);
            this.pick = null;
        }
        this.repaint();
        e.consume();
    }

    scNode nHasNode(String lbl) {
        if (lbl == null) {
            return null;
        }
        int i = 0;
        while (i < this.nnodes) {
            if (this.nodes[i].lbl.compareTo(lbl) == 0) {
                return this.nodes[i];
            }
            ++i;
        }
        return null;
    }

    public void paint(Graphics g) {
        if (sf.fm == null) {
            sf.fm = g.getFontMetrics();
        }
        this.update(g);
    }

    public void paintNode(Graphics g, scNode n, FontMetrics fm) {
        if (fm == null) {
            fm = g.getFontMetrics();
        }
        n.paint(g, fm, this, n == this.pick);
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    void prepareRelax() {
        this.State = false;
        if (this.sh == null) {
            this.sh = new double[this.shl + 1];
        }
        int k = 0;
        while (k <= this.shl) {
            this.sh[k] = 100 * k;
            ++k;
        }
        this.ashK = 1.0;
        this.nsh = 0;
        this.shivers = false;
    }

    void relax() {
        long started = System.currentTimeMillis();
        while (!this.State && System.currentTimeMillis() - started < 5555L) {
            double dy;
            double dx;
            double len;
            double vy;
            double vx;
            Edge e;
            this.dE = this.E = this.Energy();
            this.antiShiver(this.E);
            this.Km = this.getKm(this.E);
            this.SpeedLimit = this.getSpeedLimit(this.E);
            this.Inn = this.getInn(this.E);
            eIterator e_i = this.Edges.iterator();
            while ((e = (Edge)e_i.next()) != null) {
                vx = this.nodes[e.to].x - this.nodes[e.from].x;
                vy = this.nodes[e.to].y - this.nodes[e.from].y;
                len = Math.sqrt(vx * vx + vy * vy);
                len = len == 0.0 ? 1.0E-4 : len;
                double f = (e.len - len) / len;
                dx = f * vx;
                dy = f * vy;
                this.nodes[e.to].dx += dx;
                this.nodes[e.to].dy += dy;
                this.nodes[e.from].dx += -dx;
                this.nodes[e.from].dy += -dy;
            }
            int i = 0;
            while (i < this.nnodes) {
                scNode n1 = this.nodes[i];
                dx = 0.0;
                dy = 0.0;
                int j = 0;
                while (j < this.nnodes) {
                    if (i != j) {
                        scNode n2 = this.nodes[j];
                        vx = n1.x - n2.x;
                        vy = n1.y - n2.y;
                        len = vx * vx + vy * vy;
                        if (len == 0.0) {
                            dx += Math.random();
                            dy += Math.random();
                        } else if (len < 10000.0) {
                            dx += vx / len;
                            dy += vy / len;
                        }
                    }
                    ++j;
                }
                double dlen = dx * dx + dy * dy;
                if (dlen > 0.0) {
                    dlen = Math.sqrt(dlen) / 2.0;
                    n1.dx += dx / dlen;
                    n1.dy += dy / dlen;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < this.nnodes) {
                scNode n = this.nodes[i2];
                if (!n.yr(scNode.Fixed)) {
                    n.mov(this.dLimits(n.dx), this.dLimits(n.dy));
                }
                n.dx *= this.Inn;
                n.dy *= this.Inn;
                ++i2;
            }
        }
    }

    void removeEdge(String from, String to) {
        Edge k;
        Edge e = new Edge();
        e.from = this.hasNode(from);
        e.to = this.hasNode(to);
        if (e.from < 0 && e.to < 0) {
            return;
        }
        Object ex = null;
        eIterator e_i = this.Edges.iterator();
        while ((k = (Edge)e_i.next()) != null) {
            if ((k.from != e.from || k.to != e.to) && (k.to != e.from || k.from != e.to)) continue;
            e_i.remove();
        }
    }

    void removeNode(scNode n) {
        Edge e;
        if (n == null) {
            return;
        }
        this.Status("Removing " + n.lbl);
        this.G.remove(n.lbl);
        int nn = -1;
        int k = 0;
        while (k < this.nnodes) {
            if (this.nodes[k] == n || this.nodes[k].showLabel().compareTo(n.lbl) == 0) {
                nn = k;
                break;
            }
            ++k;
        }
        if (nn < 0) {
            return;
        }
        if (nn < this.nnodes - 1) {
            k = nn + 1;
            while (k < this.nnodes) {
                this.nodes[k - 1] = this.nodes[k];
                ++k;
            }
        }
        --this.nnodes;
        eIterator e_i = this.Edges.iterator();
        while ((e = (Edge)e_i.next()) != null) {
            if (e.from == nn || e.to == nn) {
                e_i.remove();
                continue;
            }
            if (e.from > nn) {
                --e.from;
            }
            if (e.to <= nn) continue;
            --e.to;
        }
        this.repaint();
    }

    void rmGraph() {
        int k = 0;
        while (k < this.nnodes) {
            this.nodes[k] = null;
            ++k;
        }
        this.nnodes = 0;
        this.Edges.clear();
        this.G = new Graph(10, 20);
    }

    public void run() {
        Thread me = Thread.currentThread();
        this.State = false;
        this.look();
        while (this.relaxer == me) {
            this.repaint();
            if (!this.random || !(Math.random() < 0.03)) continue;
            scNode n = this.nodes[(int)(Math.random() * (double)this.nnodes)];
            n.yr(scNode.Fixed);
        }
    }

    void setEdgeData() {
        try {
            this.Status("Setting edge data...");
            adjMatrix m = new adjMatrix(this.G);
            adjMatrix width = m.longways();
            this.nc = 0;
            int k = 0;
            while (k < m.Size) {
                int l = k + 1;
                while (l < m.Size) {
                    if (m.M[k][l] != 0) {
                        ++this.nc;
                    }
                    ++l;
                }
                ++k;
            }
            this.nn = this.G.Size;
            this.E0 = Graph.estimateEnergy(this.nn, this.nc);
            int k2 = 0;
            while (k2 < m.Size) {
                int l = k2 + 1;
                while (l < m.Size) {
                    if (width.M[k2][l] != 0 && width.M[k2][l] <= 1000 && width.M[k2][l] <= Options.Far) {
                        double length = (double)this.Unit * (0.5 * (double)width.M[k2][l]) + 0.5;
                        int in1 = this.hasNode(m.nodeName(k2));
                        int in2 = this.hasNode(m.nodeName(l));
                        if (!this.nodes[in1].yr(scNode.Fixed) || !this.nodes[in1].yr(scNode.Fixed)) {
                            Edge e = this.Edges.findEdge(in1, in2);
                            if (e == null) {
                                this.addEdge(m.nodeName(k2), m.nodeName(l), length, Edge.Kvazi);
                            } else {
                                e.len = length;
                            }
                        }
                    }
                    ++l;
                }
                ++k2;
            }
            this.Status("Starting adjustment...");
            this.initRelax();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            this.Status("Not enough memory on this machine for relaxation.");
        }
    }

    double sgn(double x) {
        return x > 0.0 ? 1 : -1;
    }

    public synchronized void update(Graphics g) {
        Edge e;
        Dimension d = this.getSize();
        Rectangle2D.Double dd = new Rectangle2D.Double(0.0, 0.0, d.width, d.height);
        dd.x -= (double)this.iljh;
        dd.y -= (double)this.iljv;
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.offgraphics.setColor(this.getBackground());
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        eIterator e_i = this.Edges.iterator();
        while ((e = (Edge)e_i.next()) != null) {
            int yt;
            int xt;
            int yf;
            int xf;
            int x1 = this.nodes[e.from].get_X();
            int y1 = this.nodes[e.from].get_Y();
            int x2 = this.nodes[e.to].get_X();
            int y2 = this.nodes[e.to].get_Y();
            if (!dd.contains(x1, y1) && !dd.contains(x2, y2)) continue;
            int len = (int)Math.abs(Math.sqrt(((x1 += this.iljh) - (x2 += this.iljh)) * (x1 - x2) + ((y1 += this.iljv) - (y2 += this.iljv)) * (y1 - y2)) - e.len);
            e.paint(this.offgraphics, this.nodes[e.from], this.nodes[e.to]);
            if (e.yr(Edge.Kvazi) || this.nodes[e.from] != this.pick && this.nodes[e.to] != this.pick) continue;
            this.offgraphics.setColor(Color.red.darker());
            double hhh = sf.X / 2;
            if (this.nodes[e.to] == this.pick) {
                xf = x1;
                yf = y1;
                xt = x2;
                yt = y2;
            } else {
                xf = x2;
                yf = y2;
                xt = x1;
                yt = y1;
            }
            int[] tx = new int[3];
            int[] ty = new int[3];
            double rx = xt - xf;
            double ry = yt - yf;
            double r = Math.sqrt(rx * rx + ry * ry);
            double sina = rx / r;
            double cosa = ry / r;
            int dy = (int)(hhh * sina);
            int dx = (int)(hhh * cosa);
            tx[0] = xt;
            ty[0] = yt;
            tx[1] = xf - dx;
            ty[1] = yf + dy;
            tx[2] = xf + dx;
            ty[2] = yf - dy;
            this.offgraphics.fillPolygon(tx, ty, 3);
        }
        this.offgraphics.setColor(this.edgeColor);
        FontMetrics fm = sf.fm;
        if (fm == null) {
            fm = sf.fm = this.offgraphics.getFontMetrics();
        }
        int i = 0;
        while (i < this.nnodes) {
            scNode n = this.nodes[i];
            if (dd.contains(n.x - n.width, n.y - n.height) || dd.contains(n.x - n.width, n.y + n.height) || dd.contains(n.x + n.width, n.y - n.height) || dd.contains(n.x + n.width, n.y + n.height)) {
                this.paintNode(this.offgraphics, n, fm);
            }
            ++i;
        }
        if (g != null) {
            g.drawImage(this.offscreen, 0, 0, null);
        }
    }

    abstract class NodeAction
    extends AbstractAction {
        scNode n;
        Notepad own;

        public NodeAction(String nm, scNode _n) {
            this(nm, _n, null);
        }

        public NodeAction(String nm, scNode _n, Notepad _own) {
            super(nm);
            this.n = _n;
            this.own = _own;
        }
    }

    class RemoveAction
    extends NodeAction {
        RemoveAction(String nm, scNode _n) {
            super(nm, _n);
        }

        public void actionPerformed(ActionEvent e) {
            seGraph.this.collapseNode(this.n);
            seGraph.this.removeNode(this.n);
        }
    }

    class ExpandAction
    extends NodeAction {
        myPopup menu;

        ExpandAction(String nm, scNode _n) {
            super(nm, _n);
            this.menu = null;
        }

        ExpandAction(String nm, scNode _n, myPopup m) {
            super(nm, _n);
            this.menu = m;
        }

        public void actionPerformed(ActionEvent e) {
            Strings filter = null;
            if (this.menu != null) {
                filter = this.menu.getSelection();
            }
            seGraph.this.expandNode(this.n, filter);
        }
    }

    class CollapseAction
    extends NodeAction {
        CollapseAction(String nm, scNode _n) {
            super(nm, _n);
        }

        public void actionPerformed(ActionEvent e) {
            seGraph.this.collapseNode(this.n);
        }
    }

    class InfoAction
    extends NodeAction {
        int infoFilter = 0;

        InfoAction(String nm, scNode _n, Notepad _own, int _infoFilter) {
            super(nm, _n, _own);
            this.infoFilter = _infoFilter;
        }

        public void actionPerformed(ActionEvent e) {
            Dimension D = seGraph.this.scr.getSize();
            int x = D.width;
            int y = D.height;
            myPopup m = new myPopup();
            JMenuItem header = new JMenuItem("ExPASy information about " + this.n.Label() + ":");
            m.add(header);
            m.addSeparator();
            JComponent j = this.n.getInformation(this.infoFilter);
            Dimension di = j.getPreferredSize();
            di = new Dimension(x / 2, di.height < 20 ? 20 : di.height);
            j.setPreferredSize(di);
            m.add(j);
            m.addSeparator();
            if ((this.infoFilter & SwissReader.References) == 0) {
                m.add(new InfoAction("Prosite and SwissProt references...", this.n, seGraph.this.scr, SwissReader.References));
            }
            m.pack();
            this.own.add(m);
            m.show(this.own, x / 3, y / 3);
        }
    }

    class InfoSelAction
    extends InfoAction {
        myPopup menu = null;

        public InfoSelAction(String nm, myPopup _m, Notepad _own, int _infoFilter) {
            super(nm, null, _own, _infoFilter);
            this.menu = _m;
        }

        public void actionPerformed(ActionEvent e) {
            String sx2;
            Strings filter = null;
            if (this.menu != null) {
                filter = this.menu.getSelection();
            }
            System.out.println("Info on:" + filter.L[0]);
            if (filter != null && filter.Size > 0 && Enzyme.isECnumber(sx2 = filter.L[0])) {
                this.n = new ID_node(sx2);
                super.actionPerformed(null);
            }
        }
    }

    class FindAction
    extends AbstractAction {
        Notepad own;
        JTextField find = null;

        public FindAction(String _find, Notepad _own) {
            super("q");
            this.find = new JTextField(_find);
            this.own = _own;
        }

        public FindAction(String nm, JTextField _find, Notepad _own) {
            super(nm);
            this.find = _find;
            this.own = _own;
        }

        public void actionPerformed(ActionEvent e) {
            String afx;
            scNode nn = null;
            Strings a = null;
            String syname = null;
            String ec = null;
            String fx = this.find.getText();
            if (Enzyme.isECnumber(fx)) {
                a = Database.getDescription(fx);
            } else {
                ec = Database.AnSearch(fx);
                if (ec != null && (a = Database.getDescription(ec)) != null) {
                    syname = IdxReader.Label(a.L[1]);
                    if (syname.compareToIgnoreCase(fx) != 0) {
                        seGraph.this.MessageBox(String.valueOf(fx) + ", EC " + ec + ", is currently named as " + syname + ".");
                    }
                    fx = ec;
                }
            }
            if (a != null) {
                int flags = Integer.parseInt(IdxReader.Label(a.L[0]));
                if ((flags & Enzyme.DeletedEntry) != 0) {
                    seGraph.this.MessageBox(String.valueOf(fx) + " is marked as 'deleted entry.'");
                } else {
                    ID_node n = new ID_node(fx);
                    while (n.yr(Enzyme.TransferredEntry)) {
                        seGraph.this.MessageBox(String.valueOf(fx) + " is now transferred to " + n.DE);
                        System.out.println(String.valueOf(fx) + " is now transferred to " + n.DE);
                        nn = new ID_node(n.DE);
                    }
                    seGraph.this.Node(n);
                    a = Database.getAbout(n);
                    if (Options.autoExpandEnzymes) {
                        seGraph.this.expandNode(n, a);
                    }
                    nn = n;
                }
            } else if (Database.Compounds.getDataLine(fx) != null) {
                nn = new CA_node(fx);
                seGraph.this.Node(nn);
            }
            if (nn == null && (afx = Database.Compounds.getClosestMatch(fx)) != null) {
                if (seGraph.this.AskMessageBox("'" + fx + "' not found. Add '" + afx + "' ?") == 0) {
                    nn = new CA_node(afx);
                    seGraph.this.Node(nn);
                } else {
                    return;
                }
            }
            if (nn == null) {
                seGraph.this.MessageBox("Item '" + fx + "' not found in any local database.");
                return;
            }
            seGraph.this.revalidate();
        }
    }
}

