/* compare.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.09.14. JWi
 *  */
#include "flokecore.h"
//#include "chainmem.h"
unsigned char slash[]="\\";

void compare_file(struct fileentry *fileentrytocmp,struct direntry *inMem, struct direntry *inFile);
int isFileOkay(unsigned char fileToChk[MAX_PATH], struct direntry *inMem, struct fileentry *inFile);
void compare_dir(struct direntry *inFile, struct direntry *inMem);

void compare_start(struct direntry *inFile, struct direntry *inMem)
{
	if(inFile==NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELONE)
				{
					fprintf(errverboseout,"compare_start : inFile==NULL\n");

				}
			#endif

		}

	if(inMem==NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELONE)
				{
					fprintf(errverboseout,"compare_start : inMem==NULL\n");
				}
			#endif

		}
		//Dispatch compare_dir with first dir, to mark all OKAY == OKAY
		compare_dir(inFile, inMem);
		//Dispatch compare_find_deleted to mark missing files as deleted
		//Dispatch compare_find_new to mark added files as added
}

void compare_dir(struct direntry *inFile, struct direntry *inMem)
{

	if(inMem!=NULL)
		{
			#ifdef DEBUGHELPERS
			if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"compare_dir Dir Name %s \n", inMem->dirname);
				}
			#endif
			if(inMem->firstfile!=NULL)
				{
					compare_file(inMem->firstfile, inMem, inFile);
				}


			if(inMem->firstsub!=NULL)
				{
					compare_dir(inFile,inMem->firstsub);
				}
			if(inMem->next!=NULL)
				{
					compare_dir(inFile,inMem->next);
				}
		}
}

void compare_file(struct fileentry *fileentrytocmp,struct direntry *inMem, struct direntry *inFile)
{
	if(fileentrytocmp!=NULL)
		{
			if(fileentrytocmp->filename[0]!=NIL)
				{
					// Resolv dir and dispatch to isFileOKay
					unsigned int i;
					unsigned int j;
					unsigned char filename[MAX_PATH];
					i=0;
					j=0;

					while (inMem->dirname[j]!=NIL) // Maybe use NIL instead of CR
							{
								filename[j]=inMem->dirname[j];
								j++;
							}
					filename[j]=slash[0];

					while (fileentrytocmp->filename[i]!=NIL) // Maybe use NIL instead of CR
						{
							filename[j]=fileentrytocmp->filename[i];
							i++;
							j++;
						}
					filename[j]=NIL;
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFOUR)
						{
							fprintf(errverboseout,"compare_file : filename to look for %s \n", filename);
						}
					#endif
					isFileOkay(filename, inFile, fileentrytocmp); // Replaced inFile // Replaced inMem by inFile again
				}


				if(fileentrytocmp->next!=NULL)
					{
						compare_file(fileentrytocmp->next, inMem, inFile);
					}
		}
}


int isFileOkay(unsigned char fileToChk[MAX_PATH], struct direntry *inMem, struct fileentry *inFile)
{
	// fileToChk has total path
	struct direntry *tempdir;
	struct direntry *tempdirII;

	tempdir=inMem; // Set intial in dir
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELFOUR)
				{
					fprintf(errverboseout,"isFileOkay : started with dirname %s \n", tempdir->dirname);
				}
	#endif

	while(tempdir!=NULL)
		{
			unsigned char filename[MAX_PATH];
			struct fileentry *tempfile;
			struct fileentry *tempfileII;
			tempfile=tempdir->firstfile; // Set intial file in dir

			while(tempfile!=NULL)
				{
					unsigned int i;
					unsigned int j;
					i=0;
					j=0;

					while (tempdir->dirname[j]!=NIL) // Maybe use NIL instead of CR
							{
								filename[j]=tempdir->dirname[j];
								j++;
							}
					filename[j]=slash[0];

					while (tempfile->filename[i]!=NIL) // Maybe use NIL instead of CR
						{
							filename[j]=tempfile->filename[i];
							i++;
							j++;
						}
					filename[j]=NIL;
					#ifdef DEBUGHELPERS
					if (verbose>ERRVERBOSELEVELFOUR)
						{
							fprintf(errverboseout,"isFileOkay : filename to look for %s \n", filename);
						}
					#endif
					i=0;
					for(i=0;(i!=MAX_PATH);i++)
						{

							if(fileToChk[i]==NIL)
								{
									//OKAY to here
									if(filename[i]==NIL)
										{
											//OKAY to here
											#ifdef DEBUGHELPERS
											if (verbose>ERRVERBOSELEVELFOUR)
												{
													fprintf(errverboseout,"isFileOkay Hash %08x %08x %08x %08x %08x\n",tempfile->hash[0],tempfile->hash[1],tempfile->hash[2],tempfile->hash[3],tempfile->hash[4]);
													fprintf(errverboseout,"isFileOkay Hash %08x %08x %08x %08x %08x\n",inFile->hash[0],inFile->hash[1],inFile->hash[2],inFile->hash[3],inFile->hash[4]);
												}
											#endif


											// File same, resolv dir and chk if both files are in the same dir
											// If in same dir Chk if hash is the same
											// Mark status flag
											if(inFile->status==ACCES_DENIED)
												{
													return TRUE;
												}
											if(tempfile->status==ACCES_DENIED)
												{
													return TRUE;
												}
											inFile->status=CHANGED;
											tempfile->status=CHANGED;

											int cmpcount=0;
											BOOL cmpflag=TRUE;
											//verbose=50;
											//fprintf(errverboseout,"isFileOkay : outside loop %i %i\n", cmpcount,hashinfo->hashlenght);
											for(cmpcount=0;cmpcount!=hashinfo->hashlenght;cmpcount++)
												{
													//fprintf(errverboseout,"isFileOkay : inside loop %i %i\n", cmpcount,hashinfo->hashlenght);
													if(hash!=TIGER)
														{
															if(tempfile->hash[cmpcount]!=inFile->hash[cmpcount])
																{
																	cmpflag=FALSE;
																}

														}
													if(hash==TIGER)
														{
															if(tempfile->hashbig[cmpcount]!=inFile->hashbig[cmpcount])
																{
																	cmpflag=FALSE;
																}

														}

												}

												if(cmpflag==TRUE)
													{
														inFile->status=OKAY;
														tempfile->status=OKAY;
														#ifdef DEBUGHELPERS
														if (verbose>ERRVERBOSELEVELFOUR)
															{
																fprintf(errverboseout,"isFileOkay : OKAY %s\n", filename);
															}
														#endif
														return 1;
													}
												if(cmpflag==FALSE)
													{
														inFile->status=CHANGED;
														tempfile->status=CHANGED;
														#ifdef DEBUGHELPERS
														if (verbose>ERRVERBOSELEVELFOUR)
															{
																fprintf(errverboseout,"isFileOkay : CHANGED %s\n", filename);
															}
														#endif
														return 0;
													}

											/*
											if (tempfile->hash[0]==inFile->hash[0])
												{

													if (tempfile->hash[1]==inFile->hash[1])
														{
															if (tempfile->hash[2]==inFile->hash[2])
																{
																	if (tempfile->hash[3]==inFile->hash[3])
																		{
																			if (tempfile->hash[4]==inFile->hash[4])
																				{
																					if (tempfile->hash[4]==inFile->hash[4])
																						{
																							inFile->status=OKAY;
																							tempfile->status=OKAY;
																							if (verbose>ERRVERBOSELEVELFOUR)
																								{
																									fprintf(errverboseout,"isFileOkay : OKAY %s\n", filename);
																								}
																							return 1;


																						}
																				}
																		}
																}
														}


												//if (verbose>ERRVERBOSELEVELFOUR)
												//	{
											//			fprintf(errverboseout,"isFileOkay : CHANGED %s\n", filename);
												//	}

											} */
										}
								}

							if(fileToChk[i]!=filename[i])
								{
									i=(MAX_PATH-1);
								}

						}
					tempfileII=tempfile;
					tempfile=tempfileII->next;

				}

			//if(tempdir->firstsub!=NULL)
			//	{
			//		isFileOkay(fileToChk,tempdir->firstsub,inFile);
			//	}
			tempdirII=tempdir;
			tempdir=tempdirII->next;
			////if(tempdir->next!=NULL)
			////	{
			////		isFileOkay(fileToChk,tempdir->next,inFile);
			////	}

		if(inMem->firstsub!=NULL)
			{
				isFileOkay(fileToChk,inMem->firstsub,inFile);
			}
	}
return 0;
}
