/* init.c - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.09.14. JWi
 *  */
#include "flokecore.h"

BOOL deinit()
{
	#ifdef DEBUGHELPERS
	fclose(errverboseout);
	#endif
	free(hashinfo);
	free(report);
	databasefile[0]=0;
	return TRUE;
}
BOOL init()
{

	//Setting up debug helpers
	#ifdef DEBUGHELPERS
	FILE *f;
	verbose=ERRVERBOSELEVELFIVE+1;
	errverboseout=stdout;

	f=fopen("h:\\flokecore.err","a");
	errverboseout=f;
	#endif

	//Setup hash functions and confirm correct operation
	hashinfo=(struct hashinfostruct *)malloc(sizeof(struct hashinfostruct));
	hashinfo->any_hash_working=FALSE;


	if(md5_test()==TRUE)
		{
			hashinfo->any_hash_working=TRUE;
			hashinfo->md5_working=TRUE;
			hashinfo->hashlenght=4;
			hash=MD5;
		}


	if(rmd160_test()==TRUE)
		{
			hashinfo->any_hash_working=TRUE;
			hashinfo->rmd160_working=TRUE;
			hashinfo->hashlenght=5;
			hash=RMD160;
		}

	if(tiger_test()==TRUE)
		{
			hashinfo->any_hash_working=TRUE;
			hashinfo->sha1_working=TRUE;
			hashinfo->hashlenght=3;
			hash=TIGER;
		}

	if(sha1_test()==TRUE)
		{
			hashinfo->any_hash_working=TRUE;
			hashinfo->sha1_working=TRUE;
			hashinfo->hashlenght=5;
			hash=SHA1;
		}
	if(hashinfo->any_hash_working==FALSE)
		{
			//Handel error
			return FALSE;
		}

	//Setting up reporting tool
	report=(struct reportstuct *)malloc(sizeof(struct reportstuct));

	report->makeheader=TRUE;
	report->makeheader_time=TRUE;
	//strcpy(report->reportfile,"h:\\flokecore.rep");
	report->reportfile[0]=0;
	report->reportScannedFiles=FALSE;
	report->reportScannedFilesWithHashes=FALSE;
	report->reportCleardFiles=TRUE;
	report->reportCleardFilesWithHashes=TRUE;
	report->reportChangedFiles=TRUE;
	report->reportChangedFilesWithHashes=TRUE;
	report->reportDeletedFiles=TRUE;
	report->reportDeletedFilesWithHashes=TRUE;
	report->reportNewFiles=FALSE;
	report->reportNewFilesWithHashes=FALSE;
	report->reportAccesDeniedFiles=TRUE;
	report->makesummary=TRUE;

	strcpy(searchpattern,"*.exe|*.com|");
	strcpy(startpath,"c:\\");
	//Setting up file control elements
	dirmarker[0]=1;
	dirmarker[1]=2;
	endoffilemarker[0]=3;
	lineend[0]=0xA;



	return TRUE;
}
BOOL sha1_test()
{
/*  Test vectors:
 *
 *  "abc"
 *  A999 3E36 4706 816A BA3E  2571 7850 C26C 9CD0 D89D
 *
 *  "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq"
 *  8498 3E44 1C3B D26E BAAE  4AA1 F951 29E5 E546 70F1
 */

	BOOL test1=TRUE;
	BOOL test2=TRUE;
	unsigned char testvector1[]="abc";
	unsigned long correcthash1[]=0xA9993E36,0x4706816A,0xBA3E2571,0x7850C26C,0x9CD0D89D;
 	unsigned char testvector2[]="abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
 	unsigned long correcthash2[]=0x84983E44, 0x1C3BD26E, 0xBAAE4AA1, 0xF95129E5, 0xE54670F1;

 	SHA1_CONTEXT *tmp;

	tmp=(SHA1_CONTEXT *)malloc(sizeof(SHA1_CONTEXT));
	sha1_init(tmp);
	sha1_write(tmp,testvector1,strlen(testvector1));
	sha1_final(tmp);

	if(correcthash1[0]!=tmp->h0)
		{
			test1=FALSE;
		}

	if(correcthash1[1]!=tmp->h1)
		{
			test1=FALSE;
		}
	if(correcthash1[2]!=tmp->h2)
		{
			test1=FALSE;
		}
	if(correcthash1[3]!=tmp->h3)
		{
			test1=FALSE;
		}
	if(correcthash1[4]!=tmp->h4)
		{
			test1=FALSE;
		}

	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELONE)
		{
			if(test1==TRUE)
				{
					fprintf(errverboseout,"sha1_test 1 : OKAY\n");
				}

			if(test1==FALSE)
				{
					fprintf(errverboseout,"sha1_test 1 : FAULT\n");
				}
		}
	#endif
	free(tmp);

	tmp=(SHA1_CONTEXT *)malloc(sizeof(SHA1_CONTEXT));
	sha1_init(tmp);
	sha1_write(tmp,testvector2,strlen(testvector2));
	sha1_final(tmp);

	if(correcthash2[0]!=tmp->h0)
		{
			test2=FALSE;
		}

	if(correcthash2[1]!=tmp->h1)
		{
			test2=FALSE;
		}
	if(correcthash2[2]!=tmp->h2)
		{
			test2=FALSE;
		}
	if(correcthash2[3]!=tmp->h3)
		{
			test2=FALSE;
		}
	if(correcthash2[4]!=tmp->h4)
		{
			test2=FALSE;
		}
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELONE)
		{
			if(test2==TRUE)
				{
					fprintf(errverboseout,"sha1_test 2 : OKAY\n");
				}

			if(test2==FALSE)
				{
					fprintf(errverboseout,"sha1_test 2 : FAULT\n");
				}
		}
	#endif
	free(tmp);

	if(test1==TRUE)
		{
			if(test2==TRUE)
				{
					return TRUE;
				}
		}
	return FALSE;
}

BOOL md5_test()
{

/* Test values:
 * ""                  D4 1D 8C D9 8F 00 B2 04  E9 80 09 98 EC F8 42 7E
 * "a"                 0C C1 75 B9 C0 F1 B6 A8  31 C3 99 E2 69 77 26 61
 * "abc                90 01 50 98 3C D2 4F B0  D6 96 3F 7D 28 E1 7F 72
 * "message digest"    F9 6B 69 7D 7C B7 93 8D  52 5A 2F 31 AA F1 61 D0
 */


	BOOL test1=TRUE;
	BOOL test2=TRUE;
	unsigned char testvector1[]="";
	unsigned long correcthash1[]=0xD98C1DD4,0x04B2008F,0x980980E9,0x7E42F8EC; //Why?
								 //0xD41D8CD9,0x8F00B204,0xE9800998,0xECF8427E;
	unsigned char testvector2[]="a";
 	unsigned long correcthash2[]=0xB975C10C, 0xA8B6F1C0, 0xE299C331, 0x61267769; //Why?
							   //0x0CC175B9, 0xC0F1B6A8, 0x31C399E2, 0x69772661;

 	MD5_CONTEXT *tmp;

	tmp=(MD5_CONTEXT *)malloc(sizeof(MD5_CONTEXT));
	md5_init(tmp);
	md5_write(tmp,testvector1,strlen(testvector1));
	md5_final(tmp);

	//rol(tmp->A,32);
	if(correcthash1[0]!=tmp->A)
		{
			test1=FALSE;
		}

	if(correcthash1[1]!=tmp->B)
		{
			test1=FALSE;
		}
	if(correcthash1[2]!=tmp->C)
		{
			test1=FALSE;
		}
	if(correcthash1[3]!=tmp->D)
		{
			test1=FALSE;
		}

		#ifdef DEBUGHELPERS
		if (verbose>ERRVERBOSELEVELONE)
			{
				if(test1==TRUE)
					{
						fprintf(errverboseout,"md5_test 1 : OKAY\n");
					}

				if(test1==FALSE)
					{
						fprintf(errverboseout,"md5_test 1 : FAULT\n");
					}
			}
		#endif
	//print_hex(&tmp->buf,sizeof(unsigned long)*4);
	//memcpy(&tmp->A,&tmp->buf,sizeof(unsigned long)*4);
	//fprintf(stdout,"\nmd5_test Hash %02X %02x %02x %02x\n",tmp->A,tmp->B,tmp->C,tmp->D);
	//print_hex(&tmp->A,sizeof(unsigned long)*4,stdout);
	free(tmp);

	tmp=(MD5_CONTEXT *)malloc(sizeof(MD5_CONTEXT));
	md5_init(tmp);
	md5_write(tmp,testvector2,strlen(testvector2));
	md5_final(tmp);

	if(correcthash2[0]!=tmp->A)
		{
			test2=FALSE;
		}

	if(correcthash2[1]!=tmp->B)
		{
			test2=FALSE;
		}
	if(correcthash2[2]!=tmp->C)
		{
			test2=FALSE;
		}
	if(correcthash2[3]!=tmp->D)
		{
			test2=FALSE;
		}

		#ifdef DEBUGHELPERS
		if (verbose>ERRVERBOSELEVELONE)
			{
				if(test2==TRUE)
					{
						fprintf(errverboseout,"md5_test 2 : OKAY\n");
					}

				if(test2==FALSE)
					{
						fprintf(errverboseout,"md5_test 2 : FAULT\n");
					}
			}
		#endif
	free(tmp);

	if(test1==TRUE)
		{
			if(test2==TRUE)
				{
					return TRUE;
				}
		}
	return FALSE;
}



BOOL rmd160_test()
{

/* Some examples:
 * ""                    9c1185a5c5e9fc54612808977ee8f548b2258d31
 * "a"                   0bdc9d2d 256b3ee9 daae347b e6f4dc83 5a467ffe
*/


	BOOL test1=TRUE;
	BOOL test2=TRUE;
	unsigned char testvector1[]="";
	unsigned long correcthash1[]=0xA585119C,0x54FCE9C5,0x97082861,0x48F5E87E, 0x318D25B2; //Why?
						       //0xD41D8CD9,0x8F00B204,0xE9800998,0xECF8427E;
	unsigned char testvector2[]="a";
 	unsigned long correcthash2[]=0x2D9DDC0B, 0xE93E6B25, 0x7B34AEDA, 0x83DCF4E6, 0xFE7F465A; //Why?
							   //0x0CC175B9, 0xC0F1B6A8, 0x31C399E2, 0x69772661;

 	RMD160_CONTEXT *tmp;

	tmp=(RMD160_CONTEXT *)malloc(sizeof(RMD160_CONTEXT));
	rmd160_init(tmp);
	rmd160_write(tmp,testvector1,strlen(testvector1));
	rmd160_final(tmp);

	//rol(tmp->A,32);
	if(correcthash1[0]!=tmp->h0)
		{
			test1=FALSE;
		}

	if(correcthash1[1]!=tmp->h1)
		{
			test1=FALSE;
		}
	if(correcthash1[2]!=tmp->h2)
		{
			test1=FALSE;
		}
	if(correcthash1[3]!=tmp->h3)
		{
			test1=FALSE;
		}
	if(correcthash1[4]!=tmp->h4)
		{
			test1=FALSE;
		}
	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELONE)
		{
			if(test1==TRUE)
				{
					fprintf(errverboseout,"rmd160_test 1 : OKAY\n");
				}

			if(test1==FALSE)
				{
					fprintf(errverboseout,"rmd160_test 1 : FAULT\n");
				}
		}
	#endif
	//print_hex(&tmp->buf,sizeof(unsigned long)*4);
	//memcpy(&tmp->A,&tmp->buf,sizeof(unsigned long)*4);
	//fprintf(stdout,"\nmd5_test Hash %02X %02x %02x %02x\n",tmp->A,tmp->B,tmp->C,tmp->D);
	//print_hex(&tmp->A,sizeof(unsigned long)*4,stdout);
	free(tmp);

	tmp=(RMD160_CONTEXT *)malloc(sizeof(RMD160_CONTEXT));
	rmd160_init(tmp);
	rmd160_write(tmp,testvector2,strlen(testvector2));
	rmd160_final(tmp);

	if(correcthash2[0]!=tmp->h0)
		{
			test2=FALSE;
		}

	if(correcthash2[1]!=tmp->h1)
		{
			test2=FALSE;
		}
	if(correcthash2[2]!=tmp->h2)
		{
			test2=FALSE;
		}
	if(correcthash2[3]!=tmp->h3)
		{
			test2=FALSE;
		}
	if(correcthash2[4]!=tmp->h4)
		{
			test2=FALSE;
		}

		#ifdef DEBUGHELPERS
		if (verbose>ERRVERBOSELEVELONE)
			{
				if(test2==TRUE)
					{
						fprintf(errverboseout,"rmd160_test 2 : OKAY\n");
					}

				if(test2==FALSE)
					{
						fprintf(errverboseout,"rmd160_test 2 : FAULT\n");
					}
			}
		#endif
	free(tmp);

	if(test1==TRUE)
		{
			if(test2==TRUE)
				{
					return TRUE;
				}
		}
	return FALSE;
}

BOOL tiger_test()
{

/* Some examples:
 * "ABCDEFGHIJKLMNOPQRSTUVWXYZ=abcdefghijklmnopqrstuvwxyz+0123456789"
 *			467DB80863EBCE48 8DF1CD1261655DE9 57896565975F9197
 * "Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham"
 *			0C410A042968868A 1671DA5A3FD29A72 5EC1E457D3CDB303
*/


	BOOL test1=TRUE;
	BOOL test2=TRUE;
	unsigned char testvector1[]="ABCDEFGHIJKLMNOPQRSTUVWXYZ=abcdefghijklmnopqrstuvwxyz+0123456789";
	unsigned long long correcthash1[]=0x48CEEB6308B87D46, 0xE95D656112CDF18D, 0x97915F9765658957; //Why?
									//0x467DB80863EBCE48, 0x8DF1CD1261655DE9, 0x57896565975F9197; //Why?
						       //0xD41D8CD9,0x8F00B204,0xE9800998,0xECF8427E;
	unsigned char testvector2[]="Tiger - A Fast New Hash Function, by Ross Anderson and Eli Biham";
 	unsigned long long correcthash2[]=0x0C410A042968868A, 0x1671DA5A3FD29A72, 0x5EC1E457D3CDB303; //Why?
							   //0x0CC175B9, 0xC0F1B6A8, 0x31C399E2, 0x69772661;

 	TIGER_CONTEXT *tmp;

	tmp=(TIGER_CONTEXT *)malloc(sizeof(TIGER_CONTEXT));
	tiger_init(tmp);
	tiger_write(tmp,testvector1,strlen(testvector1));
	tiger_final(tmp);

	//rol(tmp->A,32);
	if(correcthash1[0]!=tmp->h0)
		{
			test1=FALSE;
		}

	if(correcthash1[1]!=tmp->h1)
		{
			test1=FALSE;
		}
	if(correcthash1[2]!=tmp->h2)
		{
			test1=FALSE;
		}

	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELONE)
		{
			if(test1==TRUE)
				{
					fprintf(errverboseout,"tiger_test 1 : OKAY\n");
				}

			if(test1==FALSE)
				{
					fprintf(errverboseout,"tiger_test 1 : FAULT\n");
				}
		}
	#endif
	if (verbose>ERRVERBOSELEVELONE)
		{
			int l;
			l=sizeof(unsigned long long);
			printf("unsigned long long = %i\n",l);
			print_hex(&tmp->buf,sizeof(unsigned long long)*3,stdout);
			//memcpy(&tmp->A,&tmp->buf,sizeof(unsigned long)*4);
			//fprintf(stdout,"\nmd5_test Hash %02X %02x %02x %02x\n",tmp->A,tmp->B,tmp->C,tmp->D);
			//print_hex(&tmp->A,sizeof(unsigned long)*4,stdout);
		}
	free(tmp);

	tmp=(TIGER_CONTEXT *)malloc(sizeof(TIGER_CONTEXT));
	tiger_init(tmp);
	tiger_write(tmp,testvector2,strlen(testvector2));
	tiger_final(tmp);

	if(correcthash2[0]!=tmp->h0)
		{
			test2=FALSE;
		}

	if(correcthash2[1]!=tmp->h1)
		{
			test2=FALSE;
		}
	if(correcthash2[2]!=tmp->h2)
		{
			test2=FALSE;
		}

	#ifdef DEBUGHELPERS
	if (verbose>ERRVERBOSELEVELONE)
		{
			if(test2==TRUE)
				{
					fprintf(errverboseout,"tiger_test 2 : OKAY\n");
				}

			if(test2==FALSE)
				{
					fprintf(errverboseout,"tiger_test 2 : FAULT\n");
				}
		}
	#endif
	free(tmp);

	if(test1==TRUE)
		{
			if(test2==TRUE)
				{
					return TRUE;
				}
		}
	return FALSE;
}

