/*
 * Decompiled with CFR 0.152.
 */
package com.speech4j.sound;

import com.speech4j.sound.AudioBuffer;
import com.speech4j.sound.SoundException;
import com.speech4j.sound.Util;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class AudioOutputStream {
    private AudioFormat format;
    private OutputStream out;
    private ByteArrayOutputStream outBuf;

    public AudioOutputStream(OutputStream outputStream, AudioFormat audioFormat) throws FileNotFoundException, IOException {
        this.out = outputStream;
        this.format = audioFormat;
        this.outBuf = new ByteArrayOutputStream();
    }

    public void write(AudioBuffer audioBuffer) throws IOException, SoundException {
        if (audioBuffer.getFormat().matches(this.format)) {
            this.outBuf.write(audioBuffer.getData());
        } else {
            int n = this.format.getChannels() * this.format.getSampleSizeInBits() / 8;
            AudioFormat audioFormat = audioBuffer.getFormat();
            byte[] byArray = audioBuffer.getData();
            int n2 = audioFormat.getChannels() * audioFormat.getSampleSizeInBits() / 8;
            int n3 = byArray.length / n2;
            int n4 = (int)((float)n3 * this.format.getSampleRate() / audioFormat.getSampleRate());
            byte[] byArray2 = new byte[n4 * n];
            int n5 = 0;
            while (n5 < n3) {
                int n6 = 0;
                int n7 = 0;
                int n8 = audioFormat.getSampleSizeInBits() / 8;
                block0 : switch (audioFormat.getChannels()) {
                    case 2: {
                        switch (audioFormat.getSampleSizeInBits()) {
                            case 16: {
                                n7 = (short)(byArray[n5 * n2 + 1 + n8] << 8 & 0xFF00);
                            }
                            case 8: {
                                n7 |= byArray[n5 * n2 + n8] & 0xFF;
                                break;
                            }
                            default: {
                                throw new SoundException("Unsupported sample size: " + audioFormat.getSampleSizeInBits());
                            }
                        }
                    }
                    case 1: {
                        switch (audioFormat.getSampleSizeInBits()) {
                            case 16: {
                                n6 = (short)(byArray[n5 * n2 + 1] << 8 & 0xFF00);
                            }
                            case 8: {
                                n6 |= byArray[n5 * n2] & 0xFF;
                                break block0;
                            }
                        }
                        throw new SoundException("Unsupported sample size: " + audioFormat.getSampleSizeInBits());
                    }
                    default: {
                        throw new SoundException("Unsupported number of channels: " + audioFormat.getChannels());
                    }
                }
                if (audioFormat.getChannels() == 1 && this.format.getChannels() == 2) {
                    n7 = n6;
                }
                switch (this.format.getSampleSizeInBits() - audioFormat.getSampleSizeInBits()) {
                    case -8: {
                        n7 = n7 >> 8 & 0xFF;
                        n6 = n6 >> 8 & 0xFF;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 8: {
                        n7 = n7 << 8 & 0xFF00;
                        n6 = n6 << 8 & 0xFF00;
                        break;
                    }
                    default: {
                        throw new SoundException("Unsupported sample size: " + audioFormat.getSampleSizeInBits());
                    }
                }
                int n9 = (int)((float)n5 * this.format.getSampleRate() / audioFormat.getSampleRate());
                int n10 = (int)((float)(n5 + 1) * this.format.getSampleRate() / audioFormat.getSampleRate());
                int n11 = n9;
                while (n11 < n10) {
                    int n12 = n11 * n;
                    block17 : switch (this.format.getChannels()) {
                        case 2: {
                            switch (this.format.getSampleSizeInBits()) {
                                case 16: {
                                    if (this.format.isBigEndian()) {
                                        byArray2[n12 + 2] = (byte)(n7 >> 8 & 0xFF);
                                        byArray2[n12 + 3] = (byte)(n7 & 0xFF);
                                        break;
                                    }
                                    byArray2[n12 + 2] = (byte)(n7 & 0xFF);
                                    byArray2[n12 + 3] = (byte)(n7 >> 8 & 0xFF);
                                    break;
                                }
                                case 8: {
                                    byArray2[n12 + 1] = (byte)(n7 & 0xFF);
                                    break;
                                }
                                default: {
                                    throw new SoundException("Unsupported sample size: " + this.format.getSampleSizeInBits());
                                }
                            }
                        }
                        case 1: {
                            switch (this.format.getSampleSizeInBits()) {
                                case 16: {
                                    if (this.format.isBigEndian()) {
                                        byArray2[n12] = (byte)(n6 >> 8 & 0xFF);
                                        byArray2[n12 + 1] = (byte)(n6 & 0xFF);
                                        break block17;
                                    }
                                    byArray2[n12] = (byte)(n6 & 0xFF);
                                    byArray2[n12 + 1] = (byte)(n6 >> 8 & 0xFF);
                                    break block17;
                                }
                                case 8: {
                                    byArray2[n12] = (byte)(n6 & 0xFF);
                                    break block17;
                                }
                            }
                            throw new SoundException("Unsupported sample size: " + this.format.getSampleSizeInBits());
                        }
                        default: {
                            throw new SoundException("Unsupported number of channels: " + this.format.getChannels());
                        }
                    }
                    ++n11;
                }
                ++n5;
            }
            this.outBuf.write(byArray2);
        }
    }

    public void write(AudioInputStream audioInputStream, int n) throws IOException, SoundException {
        if (audioInputStream.available() < n) {
            n = audioInputStream.available();
        }
        AudioBuffer audioBuffer = new AudioBuffer();
        audioBuffer.setData(new byte[n]);
        audioInputStream.read(audioBuffer.getData());
        audioBuffer.setFormat(audioInputStream.getFormat());
        this.write(audioBuffer);
    }

    public void close() throws IOException {
        int n = this.outBuf.size();
        this.out.write("RIFF".getBytes());
        int n2 = n + 44 - 8;
        this.out.write(n2 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
        this.out.write(n2 >> 16 & 0xFF);
        this.out.write(n2 >> 24 & 0xFF);
        this.out.write("WAVEfmt ".getBytes());
        this.out.write(16);
        this.out.write(0);
        this.out.write(0);
        this.out.write(0);
        this.out.write(1);
        this.out.write(0);
        this.out.write(this.format.getChannels());
        this.out.write(0);
        int n3 = (int)this.format.getSampleRate();
        this.out.write(n3 & 0xFF);
        this.out.write(n3 >> 8 & 0xFF);
        this.out.write(n3 >> 16 & 0xFF);
        this.out.write(n3 >> 24 & 0xFF);
        int n4 = n3 * this.format.getSampleSizeInBits() * this.format.getChannels() / 8;
        this.out.write(n4 & 0xFF);
        this.out.write(n4 >> 8 & 0xFF);
        this.out.write(n4 >> 16 & 0xFF);
        this.out.write(n4 >> 24 & 0xFF);
        int n5 = this.format.getSampleSizeInBits() * this.format.getChannels() / 8;
        this.out.write(n5 & 0xFF);
        this.out.write(n5 >> 8 & 0xFF);
        int n6 = this.format.getSampleSizeInBits();
        this.out.write(n6 & 0xFF);
        this.out.write(n6 >> 8 & 0xFF);
        this.out.write("data".getBytes());
        this.out.write(n & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n >> 16 & 0xFF);
        this.out.write(n >> 24 & 0xFF);
        this.out.write(this.outBuf.toByteArray());
        this.out.close();
    }

    public long length() throws IOException {
        return this.outBuf.size();
    }

    public double time() throws IOException {
        return Util.bytes2sec(this.format, this.outBuf.size());
    }
}

