REM     The personal text editor with internal BASIC language interpretter.
REM     Copyright (C) Sandul Yura Valentinovich.
REM     (R) Tuesday, 27 May 2003 year.
REM
REM     This program is free software; you can redistribute it and/or modify
REM it under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM     This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM     You should have received a copy of the GNU General Public License
REM along with this program; if not, write to the Free Software Foundation,
REM Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
REM
REM  ANSI.SYS 
REM   
REM
REM Defines functions that change display graphics, control cursor movement,
REM and reassign keys. The ANSI.SYS device driver supports the use of ANSI
REM escape sequences to control the system's screen and keyboard.
REM
REM Parameters used in ANSI escape sequences
REM Pn  Numeric paramter. Specifies a decimal number.
REM
REM Ps  Selective parameter. Specifies a decimal number that you use to
REM     select a function. You can specify more than one function by
REM     separating the parameters with semicolons.
REM
REM PL  Line parameter. Specifies a decimal number that represents one of
REM     the lines on your display or on another device.
REM
REM Pc  Column parameter. Specifies a decimal number that represents one
REM     of the columns on your screen or on another device.
REM
REM ANSI escape sequences
REM In the following list of ANSI escape sequences, the abbreviate ESC
REM represents the ASCII escape character 27 (1Bh), which appears at the
REM beginning of each escape sequence.
REM
REM ESC[PL;PcH or ESC[PL;Pcf
REM   Cursor Position. Moves the cursor to the specified location
REM   (coordinates). If you do not specify a position, the cursor moves
REM   to the home position (home 0, column 0).
REM
REM ESC[PnA
REM   Cursor Up. Moves the cursor up by the specified number of lines
REM   without changing columns.
REM
REM ESC[PnB
REM   Cursor Down. Moves the cursor down by the sepcified number of lines
REM   without changing columns.
REM
REM ESC[PnC
REM   Cursor Forward. Moves the cursor forward by the specified number of
REM   columns without changing lines.
REM
REM ESC[PnD
REM   Cursor Backward. Moves the cursor back by the specified number of
REM   columns without changing lines.
REM
REM ESC[s
REM   Save Cursor Position. Saves the current position. You can move the
REM   cursor to the saved cursor position by using the Restore Cursor
REM   Position sequence.
REM
REM ESC[u
REM   Restore Cursor Position. Returns the cursor to the position saved by
REM   the Save Cursor Position sequence.
REM
REM ESC[2J
REM   Erase Display. Clears the screen and moves the cursor to the home
REM   position (line 0, column 0).
REM
REM ESC[K
REM   Erase Line. Clears all characters from the cursor position to the
REM   end of the line.
REM
REM ESC[Ps;...;Psm
REM   Set Graphics Mode. Calls the graphics functions specified by the
REM   following values. These functions remain active until the next
REM   occurrence of this escape sequence.
REM
REM   Text attributes
REM          0    All attributes off
REM          1    Bold on
REM          4    Underscore (on monochrome display adapter only)
REM          5    Blink on
REM          7    Reverse video on
REM          8    Concealed on
REM
REM   Foreground colors
REM          30   Black
REM          31   Red
REM          32   Green
REM          33   Yellow
REM          34   Blue
REM          35   Magenta
REM          36   Cyan
REM          37   White
REM
REM   Background colors
REM          40   Black
REM          41   Red
REM          42   Green
REM          43   Yellow
REM          44   Blue
REM          45   Magenta
REM          46   Cyan
REM          47   White
REM
REM   Parameters 30 through 47 meet the ISO 6429 standard.
REM
REM $DYNAMIC
DECLARE SUB ScratchScreen ()
DECLARE SUB OutBox (Title$, Message$)
DECLARE SUB DeleteBackSymbol ()
DECLARE SUB InsertLine ()
DECLARE SUB Control ()
DECLARE SUB Calendar (DayValue%, MonthValue%, YearValue%, Title$, Message$)
DECLARE SUB ClearAll ()
DECLARE SUB RunLine (InLine$)
DECLARE SUB CursorRight ()
DECLARE SUB CursorUp ()
DECLARE SUB CursorDown ()
DECLARE SUB CursorLeft ()
DECLARE SUB CursorHome ()
DECLARE SUB CursorEnd ()
DECLARE SUB PageUp ()
DECLARE SUB PageDown ()
DECLARE SUB DeleteCurrentSymbol ()
DECLARE SUB ANSIOut (ANSISymbol$)
DECLARE SUB ClearANSI (ClearCursor%)
DECLARE SUB MakeWindow (WindowColumn%, WindowRow%, WindowWidth%, WindowHeight%, Title%, Title$, Message%, Message$, Status%, Status$)
DECLARE SUB Hang ()
DECLARE SUB OutTimerValue (NewValue&)
DECLARE SUB SetVariable (VariableName$, VariableType%, VariableData$)
DECLARE SUB WriteLine (OutLine$)
DECLARE FUNCTION Calculate$ (InLine$)
DECLARE FUNCTION CalendarBox% (DayValue%, MonthValue%, YearValue%, Title$, Message$)
DECLARE FUNCTION DayName$ (DayNumber%)
DECLARE FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DaysCount# (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION EvaluateCalculate$ (InLine$)
DECLARE FUNCTION EvaluateInMeaning$ (InLine$)
DECLARE FUNCTION EvaluateParseCalculate$ (InLine$)
DECLARE FUNCTION EvaluateParseInMeaning$ (InLine$)
DECLARE FUNCTION FindLine% (NumberOfLine%, LabelName$, NameNumber%)
DECLARE FUNCTION InDefFn$ (DefFnName$, DefFnType%, InLine$)
DECLARE FUNCTION InMeaning$ (InLine$)
DECLARE FUNCTION InName$ (InLine$)
DECLARE FUNCTION InNumber# (InLine$)
DECLARE FUNCTION InputBox% (Title$, Message$, InputLine$)
DECLARE FUNCTION InTimerValue& ()
DECLARE FUNCTION InVariable$ (VariableName$, VariableType%)
DECLARE FUNCTION LeapYear% (YearValue%)
DECLARE FUNCTION MenuBox% (ItemsCount%, Items$())
DECLARE FUNCTION MessageBox% (Title$, Message$)
DECLARE FUNCTION MonthDays% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthName$ (MonthNumber%)
DECLARE FUNCTION ParseCalculate$ (InLine$)
DECLARE FUNCTION ParseInMeaning$ (InLine$)
DECLARE FUNCTION ParseInNumber$ (InLine$)
DECLARE FUNCTION ParseRunLine$ (InLine$)
DECLARE FUNCTION SearchDefFn% (DefFnName$, DefFnType%)
DECLARE FUNCTION SquareRoot# (Meaning#)
DECLARE FUNCTION StandartStatus$ ()
DECLARE FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
OPTION BASE 1
CONST TextLines% = 100
CONST LineLength% = 256
CONST False% = 0
CONST True% = NOT False%
CONST DefFnSCount% = 4
CONST DefFnSArgsCount% = 4
CONST VariablesCount% = 4
CONST FilesCount% = 4
CONST WhilesCount% = 4
CONST FromsCount% = 4
CONST GoSubSCount% = 4
CONST ArgumentsCount% = 4
CONST Black% = 0
CONST Blue% = 1
CONST Green% = 2
CONST Cyan% = 3
CONST Red% = 4
CONST Magenta% = 5
CONST Brown% = 6
CONST White% = 7
CONST Gray% = 8
CONST LightBlue% = 9
CONST LightGreen% = 10
CONST LightCyan% = 11
CONST LightRed% = 12
CONST LightMagenta% = 13
CONST Yellow% = 14
CONST BrightWhite% = 15
DIM SHARED HelpText$(306)
DIM SHARED Text$(TextLines%)
DIM SHARED LinePosition%
DIM SHARED CursorPosition%
DIM SHARED TextPosition%
DIM SHARED PagePosition%
DIM SHARED StatusLine$
DIM SHARED DefFnS$(DefFnSCount%)
DIM SHARED DefFnSCountValue%
DIM SHARED DefFnSArgs$(DefFnSCount%, DefFnSArgsCount%)
DIM SHARED DefFnSArgsCountValue%(DefFnSCount%)
DIM SHARED CurrentDefFn%
DIM SHARED DefFnMode%
DIM SHARED Variables$(VariablesCount%)
DIM SHARED VariablesCountValue%
DIM SHARED OpenFiles$(FilesCount%)
DIM SHARED Whiles$(WhilesCount%)
DIM SHARED Froms$(FromsCount%)
DIM SHARED GoSubS%(GoSubSCount%)
DIM SHARED GoSubSCountValue%
DIM SHARED CurrentLine%
DIM SHARED NumStr%
DIM SHARED RunMode%
DIM SHARED TraceMode%
DIM SHARED CursorRow%
DIM SHARED CursorColumn%
DIM SHARED CursorSaved%
DIM SHARED NumberLine$
DIM SHARED ANSIMode%
DIM SHARED Arguments%(ArgumentsCount%)
DIM SHARED ArgumentsCountValue%
DIM SHARED Language%
DIM Errors$(95)
DIM LineNumber%
DIM Index%
DIM SubIndex%
DIM Key$
DIM English$
DIM Russian$
DIM TextFileName$
DIM PrinterName$
DIM LinesPerPage%
DIM OldSecond%
DIM WorkLine$
DIM Work%
DIM Work$
DIM WorkDay%
DIM WorkMonth%
DIM WorkYear%
DIM Days%(42)
DIM MenuItems$(21)
Errors$(1) = "NEXT without FROM"
Errors$(2) = "Syntax error"
Errors$(3) = "RETURN without GOSUB"
Errors$(4) = "Out of DATA"
Errors$(5) = "Illegal function call"
Errors$(6) = "Overflow"
Errors$(7) = "Out of memory"
Errors$(8) = "Label not defined"
Errors$(9) = "Subscript out of range"
Errors$(10) = "Duplicate definition"
Errors$(11) = "Division by zero"
Errors$(12) = "Illegal in direct mode"
Errors$(13) = "Type mismatch"
Errors$(14) = "Out of string space"
Errors$(15) = "User - defined function is not declare"
Errors$(16) = "String formula too complex"
Errors$(17) = "Cannot continue"
Errors$(18) = "Function not defined"
Errors$(19) = "No RESUME"
Errors$(20) = "RESUME without error"
Errors$(21) = "Too many calculated user - defined functions per one time"
Errors$(22) = "Too many arguments for the user - defined function"
Errors$(23) = "Unknown statement"
Errors$(24) = "Device timeout"
Errors$(25) = "Device fault"
Errors$(26) = "FROM without NEXT"
Errors$(27) = "Out of paper"
Errors$(28) = "File already closed"
Errors$(29) = "WHILE without WEND"
Errors$(30) = "WEND without WHILE"
Errors$(31) = "Too many declared user - defined functions"
Errors$(32) = "Cannot end not runned program"
Errors$(33) = "Duplicate label"
Errors$(34) = "Program already running"
Errors$(35) = "Subprogram not defined"
Errors$(36) = "Nothing to run"
Errors$(37) = "Argument - count mismatch"
Errors$(38) = "Array not defined"
Errors$(39) = "Invalid line"
Errors$(40) = "Variable required"
Errors$(41) = "Invalid return type"
Errors$(42) = "Cannot call the user - defined subroutine without program is running"
Errors$(43) = "DEF FN without END DEF"
Errors$(44) = "Cannot skip user - defined subroutine without program is running"
Errors$(45) = "Variable type mismatch"
Errors$(46) = "Invalid line number"
Errors$(47) = "Too many lines"
Errors$(48) = "User - defined function must begin with FN"
Errors$(49) = "Line not found"
Errors$(50) = "FIELD overflow"
Errors$(51) = "Internal error"
Errors$(52) = "Bad file name or number"
Errors$(53) = "File not found"
Errors$(54) = "Bad file mode"
Errors$(55) = "File already open"
Errors$(56) = "FIELD statement active"
Errors$(57) = "Device I/O error"
Errors$(58) = "File already exists"
Errors$(59) = "Bad record length"
Errors$(60) = "EXIT FROM without FROM"
Errors$(61) = "Disk full"
Errors$(62) = "Input past end of file"
Errors$(63) = "Bad record number"
Errors$(64) = "Bad file name"
Errors$(65) = "Too many running FROM's per one time"
Errors$(66) = "Cannot run FROM cycle without program is running"
Errors$(67) = "Too many files"
Errors$(68) = "Device unavailable"
Errors$(69) = "Communication - buffer overflow"
Errors$(70) = "Permission denied"
Errors$(71) = "Disk not ready"
Errors$(72) = "Disk - media error"
Errors$(73) = "Feature unavailable"
Errors$(74) = "Rename across disks"
Errors$(75) = "Path/File access error"
Errors$(76) = "Path not found"
Errors$(77) = "Too many running GO SUB's per one time"
Errors$(78) = "Cannot run GO TO or GO SUB, or RETURN without program is running"
Errors$(79) = "Invalid line number range"
Errors$(80) = "Blank line in file"
Errors$(81) = "BASIC lines in input file must be begin with line number"
Errors$(82) = "Nothing to save"
Errors$(83) = "Too many running WHILE's per one time"
Errors$(84) = "Cannot run WHILE cycle without program is running"
Errors$(85) = "Invalid year"
Errors$(86) = "Invalid month"
Errors$(87) = "Invalid day number in the month of the year"
Errors$(88) = "Too many variables"
Errors$(89) = "Cannot run multiline IF without program is running"
Errors$(90) = "IF statement block without END IF"
Errors$(91) = "Cannot run SELECT CASE statement without program is running"
Errors$(92) = "SELECT CASE without END SELECT"
Errors$(93) = "Cannot exit from the WHILE cycle without program is running"
Errors$(94) = "Cannot exit from the FROM cycle without program is running"
Errors$(95) = "EXIT WHILE without WHILE"
HelpText$(1) = "Statements:"
HelpText$(2) = "       BEEP"
HelpText$(3) = "Generates a beep sound from your computer's speaker."
HelpText$(4) = "       CALL FNSubroutineName(Arg[,Arg...])"
HelpText$(5) = "Transfers control to a user - defined subroutine."
HelpText$(6) = "       CHDIR DirectoryName$"
HelpText$(7) = "Changes a drive's default directory."
HelpText$(8) = "       CLOSE #FileNumber%"
HelpText$(9) = "Closes one open file or device."
HelpText$(10) = "       CLS"
HelpText$(11) = "Clears the screen."
HelpText$(12) = "       COLOR ForeGroundColor% ON BackGroundColor%"
HelpText$(13) = "Sets the screen display color."
HelpText$(14) = "       DEF FNName[(Arg[,Arg...])]=Expression"
HelpText$(15) = "       [Statement"
HelpText$(16) = "        ..."
HelpText$(17) = "        [FNName=Value]"
HelpText$(18) = "        [EXIT DEF]"
HelpText$(19) = "       END DEF]"
HelpText$(20) = "Defines a user subroutine. Subroutines can call as procedures or,"
HelpText$(21) = "if you want, you can use subroutines as functions."
HelpText$(22) = "       END [DEF|SELECT|IF]"
HelpText$(23) = "Ends a program or end line of the control structure."
HelpText$(24) = "       EXIT DEF|WHILE|FROM"
HelpText$(25) = "Perform exit from the current execution block."
HelpText$(26) = "       FILES FileMask$"
HelpText$(27) = "FILES displays the contents of the current directory or a specified"
HelpText$(28) = "directory."
HelpText$(29) = "       FROM VariableName%=StartValue TO EndValue [STEP=Value]"
HelpText$(30) = "       NEXT VariableName%"
HelpText$(31) = "Repeats a block of statements a specified number of times."
HelpText$(32) = "       GO TO|SUB LineNumber%"
HelpText$(33) = "Perform call GO TO or GO SUB statement."
HelpText$(34) = "       HANG"
HelpText$(35) = "Hang a computer."
HelpText$(36) = "       HELP"
HelpText$(37) = "Out this help."
HelpText$(38) = "       IF Conditional% THEN Statement [ELSE Statement]"
HelpText$(39) = "       IF Conditional% THEN"
HelpText$(40) = "        Statement"
HelpText$(41) = "         ..."
HelpText$(42) = "       [ELSE"
HelpText$(43) = "        Statement"
HelpText$(44) = "        ...]"
HelpText$(45) = "       END IF"
HelpText$(46) = "Executes a statement or statement block depending on specified"
HelpText$(47) = "conditions."
HelpText$(48) = "       KEY {LIST|ON|OFF}|KeyNumber%,Line$"
HelpText$(49) = "Assigns string values to function keys and, optionally, displays"
HelpText$(50) = "key values."
HelpText$(51) = "       KILL FileMask$"
HelpText$(52) = "Deletes files from the disk."
HelpText$(53) = "       LABEL LabelName$"
HelpText$(54) = "Define a line label."
HelpText$(55) = "       LET VariableName=Value"
HelpText$(56) = "Assigns the value of an expression to a variable."
HelpText$(57) = "       LOCATE Column% IN Row%"
HelpText$(58) = "Moves the cursor to a specified position on the screen."
HelpText$(59) = "       MID$(StringVariable$,Position%,Count%)=Meaning$"
HelpText$(60) = "The MID$ statement replaces part of a string variable with another"
HelpText$(61) = "string."
HelpText$(62) = "       MKDIR DirectoryName$"
HelpText$(63) = "Creates a subdirectory."
HelpText$(64) = "       NAME OldFileOrDirectoryName$ AS NewFileOrDirectoryName$"
HelpText$(65) = "Renames a file or the directory."
HelpText$(66) = "       OPEN FileName$ FOR INPUT|OUTPUT|APPEND AS #FileNumber%"
HelpText$(67) = "Open the file or device."
HelpText$(68) = "       PRINT [#FileNumber%,]Value"
HelpText$(69) = "Write data to the screen or to a file."
HelpText$(70) = "       REBOOT"
HelpText$(71) = "Reboot the computer."
HelpText$(72) = "       REM Comment."
HelpText$(73) = "Allows explanatory remarks to be inserted in a program."
HelpText$(74) = "       RETURN"
HelpText$(75) = "Return form the GO SUB subroutine."
HelpText$(76) = "       RMDIR DirectoryName$"
HelpText$(77) = "Removes a subdirectory."
HelpText$(78) = "       SCREEN FOURTY|EIGHTY|MONO|COLOR"
HelpText$(79) = "If argument is: FOURTY, then sets screen resolution on: 40x25, else"
HelpText$(80) = "- 80x25. MONO - Set mode: 80x25 monocrome, COLOR - 80x25 16-colors."
HelpText$(81) = "       SELECT CASE Meaning"
HelpText$(82) = "       CASE Value"
HelpText$(83) = "         Statement"
HelpText$(84) = "         ..."
HelpText$(85) = "       [CASE Value"
HelpText$(86) = "        Statement"
HelpText$(87) = "        ...]"
HelpText$(88) = "        ..."
HelpText$(89) = "       [CASE ELSE"
HelpText$(90) = "         Statement"
HelpText$(91) = "         ...]"
HelpText$(92) = "       END SELECT"
HelpText$(93) = "Executes one of several statement blocks depending on the value of"
HelpText$(94) = "an expression."
HelpText$(95) = "       SHELL Command$"
HelpText$(96) = "Suspends execution of a Basic program to run a DOS command or batch"
HelpText$(97) = "file."
HelpText$(98) = "       SLEEP Seconds&"
HelpText$(99) = "Suspends program execution."
HelpText$(100) = "       SOUND Frequency% WITH Duration%"
HelpText$(101) = "Generates a sound through your computer's speaker. The frequency of"
HelpText$(102) = "the sound in hertz; a value in the range 37 through 32767. The"
HelpText$(103) = "number of system clock ticks the sound lasts; a value in the range"
HelpText$(104) = "0 through 65535. There are 18.20648193359375 clock ticks per"
HelpText$(105) = "second."
HelpText$(106) = "       STOP"
HelpText$(107) = "Halts a program."
HelpText$(108) = "       SWAP Variable AS Variable"
HelpText$(109) = "Swap variable values."
HelpText$(110) = "       SYSTEM"
HelpText$(111) = "Closes all open files and returns control to the operating system."
HelpText$(112) = "       TROFF"
HelpText$(113) = "Turn to off trace mode."
HelpText$(114) = "       TRON"
HelpText$(115) = "Turn to on trace mode."
HelpText$(116) = "       WHILE Conditional%"
HelpText$(117) = "       WEND"
HelpText$(118) = "Executes a series of statements as long as a specified condition is"
HelpText$(119) = "true."
HelpText$(120) = "System variables:"
HelpText$(121) = "       DATE$"
HelpText$(122) = "The DATE$ system variable contain the computer's current system"
HelpText$(123) = "date in the format: MM-DD-YYYY."
HelpText$(124) = "       TIME$"
HelpText$(125) = "The TIME$ system variable contain the computer's current system"
HelpText$(126) = "time in the format: HH:MM:SS."
HelpText$(127) = "       RANDOM"
HelpText$(128) = "If get value from this variable, then getting a single - precision"
HelpText$(129) = "random number between 0 and 1. If set value to this variable, then"
HelpText$(130) = "initializes the random - number generator."
HelpText$(131) = "       TIMERDATA"
HelpText$(132) = "This system variable contain the current timer ticks count elapsed"
HelpText$(133) = "since midnight."
HelpText$(134) = "       ENVIRONMENT$"
HelpText$(135) = "If set value to this system variable, then changes or adds an"
HelpText$(136) = "environment string in the DOS environment table. Assigned value"
HelpText$(137) = "must be:"
HelpText$(138) = "VariableName=Value"
HelpText$(139) = "Constants:"
HelpText$(140) = "       FALSE%=0,TRUE%=-1,PI#=3.1415926535897932384626433832795,"
HelpText$(141) = "       BLACK%=0,BLUE%=1,BRIGHTWHITE%=15,BROWN%=6,CYAN%=3,GRAY%=8,"
HelpText$(142) = "       GREEN%=2,LIGHTBLUE%=9,LIGHTCYAN%=11,LIGHTGREEN%=10,"
HelpText$(143) = "       LIGHTMAGENTA%=13,LIGHTRED%=12,MAGENTA%=5,RED%=4,WHITE%=7,"
HelpText$(144) = "       YELLOW%=14"
HelpText$(145) = "String functions:"
HelpText$(146) = "       CHR$(SymbolCode%)"
HelpText$(147) = "Returns the character corresponding to a specified ASCII code."
HelpText$(148) = "       DAYNAME$(DayNumber%)"
HelpText$(149) = "Returns the day name (1-Monday,... 7-Sunday)."
HelpText$(150) = "       DAYOFWEEKNAME$(Day%,Month%,Year%)"
HelpText$(151) = "Return day of the week name."
HelpText$(152) = "       ENVIRONMENT$(VariableName$|VariableNumber%)"
HelpText$(153) = "Returns a DOS environment string."
HelpText$(154) = "       HEX$(Value%)"
HelpText$(155) = "Returns a hexadecimal string representation of a number."
HelpText$(156) = "       INKEY$"
HelpText$(157) = "Reads a character from the keyboard. INKEY$ returns a null string"
HelpText$(158) = "if there is no character to return. For standard keys, INKEY$"
HelpText$(159) = "returns a 1-byte length string containing the character read. For"
HelpText$(160) = "extended keys, INKEY$ returns a 2-byte string made up of the null"
HelpText$(161) = "character (ASCII 0) and the keyboard scan code."
HelpText$(162) = "       INPUT$[(#FileNumber%)]"
HelpText$(163) = "Returns a string of characters read from a specified file, or, if"
HelpText$(164) = "file number in parenthis is not specified, returns the string of"
HelpText$(165) = "characters read from a keyboard."
HelpText$(166) = "       LCASE$(Line$)"
HelpText$(167) = "Convert strings to all lowercase letters."
HelpText$(168) = "       LTRIM$(Line$)"
HelpText$(169) = "Remove leading spaces from a string."
HelpText$(170) = "       LEFT$(Line$,Count%)"
HelpText$(171) = "Return a specified number of leftmost or rightmost characters in a"
HelpText$(172) = "string."
HelpText$(173) = "       MAX$(Line$[,Line$...])"
HelpText$(174) = "Return the maximal line."
HelpText$(175) = "       MID$(Line$,Position%,Count%)"
HelpText$(176) = "The MID$ function returns part of a string (a substring)."
HelpText$(177) = "       MIN$(Line$[,Line$...])"
HelpText$(178) = "Return the minimal line."
HelpText$(179) = "       MONTHNAME$(MonthNumber%)"
HelpText$(180) = "Returns the month name (1-January,... 12-December)."
HelpText$(181) = "       OCT$(Number%)"
HelpText$(182) = "Returns an octal string representation of a number."
HelpText$(183) = "       RTRIM$(Line$)"
HelpText$(184) = "Remove trailing spaces from a string."
HelpText$(185) = "       RIGHT$(Line$,Count%)"
HelpText$(186) = "Return a specified number of leftmost or rightmost characters in a"
HelpText$(187) = "string."
HelpText$(188) = "       SPACE$(Count%)"
HelpText$(189) = "Returns a string of spaces."
HelpText$(190) = "       STR$(Value#)"
HelpText$(191) = "Returns a string representation of a number."
HelpText$(192) = "       STRING$(Count%,Line$|SymbolCode%)"
HelpText$(193) = "Returns a string of a specified length made up of a repeating"
HelpText$(194) = "character."
HelpText$(195) = "       TRIM$(Line$)"
HelpText$(196) = "Returns the string without leading and trailing spaces."
HelpText$(197) = "       UCASE$(Line$)"
HelpText$(198) = "Convert strings to all uppercase letters."
HelpText$(199) = "Numeric functions:"
HelpText$(200) = "       ATN(Value#)"
HelpText$(201) = "Returns the arctangent of a specified numeric expression."
HelpText$(202) = "       ABS(Value#)"
HelpText$(203) = "Returns the absolute value of a number."
HelpText$(204) = "       ASC(Line$)"
HelpText$(205) = "Returns the ASCII code for the first character in a string"
HelpText$(206) = "expression."
HelpText$(207) = "       AVG(Value#[,Value#...])"
HelpText$(208) = "Returns the average value of arguments."
HelpText$(209) = "       COS(Value#)"
HelpText$(210) = "Returns the cosine of a specified numeric expression."
HelpText$(211) = "       CRC(Line$)"
HelpText$(212) = "Returns the CRC-32 code of line."
HelpText$(213) = "       CSRLIN"
HelpText$(214) = "Returns the current row position of the cursor."
HelpText$(215) = "       DAYOFWEEK(Day%,Month%,Year%)"
HelpText$(216) = "Return the day of week number (1-Monday,... 7-Sunday)."
HelpText$(217) = "       EOF(#FileNumber%)"
HelpText$(218) = "Tests for the end of a file. EOF returns true (nonzero) if the end"
HelpText$(219) = "of a file has been reached."
HelpText$(220) = "       EXP(Value#)"
HelpText$(221) = "EXP returns e raised to a specified power, where e is the base of"
HelpText$(222) = "natural logarithms."
HelpText$(223) = "       FIX(Value#)"
HelpText$(224) = "Truncates a floating-point expression to its integer portion."
HelpText$(225) = "       INSTR(Line$,SubLine$)"
HelpText$(226) = "Returns the position of the first occurrence of a string in another"
HelpText$(227) = "string."
HelpText$(228) = "       INT(Value#)"
HelpText$(229) = "Returns the largest integer less than or equal to a numeric"
HelpText$(230) = "expression."
HelpText$(231) = "       ISLEAPYEAR(Year%)"
HelpText$(232) = "Returns the True, if year is leap, and False if year is not leap."
HelpText$(233) = "       LEN(Line$)"
HelpText$(234) = "Returns the number of characters in a string."
HelpText$(235) = "       LOF(#FileNumber%)"
HelpText$(236) = "Returns the length of a file in bytes."
HelpText$(237) = "       LOG(Value#)"
HelpText$(238) = "Returns the natural logarithm of a numeric expression."
HelpText$(239) = "       MAX(Value#[,Value#...])"
HelpText$(240) = "Returns the maximal value."
HelpText$(241) = "       MIN(Value#[,Value#...])"
HelpText$(242) = "Returns the minimal value."
HelpText$(243) = "       POS(AnyExpressionOfAnyType)"
HelpText$(244) = "Returns the current column position of the cursor."
HelpText$(245) = "       SCREEN(Row%,Column%,SYMBOL|COLOR)"
HelpText$(246) = "Returns the ASCII value or color attribute of a character at a"
HelpText$(247) = "specified screen location."
HelpText$(248) = "       SGN(Value#)"
HelpText$(249) = "Returns a value indicating the sign of a numeric expression (1 if"
HelpText$(250) = "the expression is positive, 0 if it is zero, or -1 if it is"
HelpText$(251) = "negative)."
HelpText$(252) = "       SIN(Value#)"
HelpText$(253) = "Returns the sine of a specified angle."
HelpText$(254) = "       SQR(Value#)"
HelpText$(255) = "Returns the square root of a numeric expression."
HelpText$(256) = "       TAN(Value#)"
HelpText$(257) = "Returns the tangent of a specified angle."
HelpText$(258) = "       TIMER"
HelpText$(259) = "Returns the number of seconds elapsed since midnight."
HelpText$(260) = "       VAL(Line$)"
HelpText$(261) = "Converts a string representation of a number to a number."
HelpText$(262) = "       WEEKNUMBER(Day%,Month%,Year%)"
HelpText$(263) = "Returns the week number for the specified date from the start of"
HelpText$(264) = "the specified year."
HelpText$(265) = "Operators:"
HelpText$(266) = "       Meaning[!|@|#|%|&]   *   Meaning[!|@|#|%|&]"
HelpText$(267) = "       Meaning[!|@|#|$|%|&] +   Meaning[!|@|#|%|&]"
HelpText$(268) = "       Meaning[!|@|#|%|&]   -   Meaning[!|@|#|%|&]"
HelpText$(269) = "       Meaning[!|@|#|%|&]   \   Meaning[!|@|#|%|&]"
HelpText$(270) = "       Meaning[!|@|#|%|&]   /   Meaning[!|@|#|%|&]"
HelpText$(271) = "       Meaning[!|@|#|%|&]   ^   Meaning[!|@|#|%|&]"
HelpText$(272) = "       Meaning[!|@|#|$|%|&] =   Meaning[!|@|#|$|%|&]"
HelpText$(273) = "       Meaning[!|@|#|$|%|&] <>  Meaning[!|@|#|$|%|&]"
HelpText$(274) = "       Meaning[!|@|#|$|%|&] <   Meaning[!|@|#|$|%|&]"
HelpText$(275) = "       Meaning[!|@|#|$|%|&] >   Meaning[!|@|#|$|%|&]"
HelpText$(276) = "       Meaning[!|@|#|$|%|&] <=  Meaning[!|@|#|$|%|&]"
HelpText$(277) = "       Meaning[!|@|#|$|%|&] =>  Meaning[!|@|#|$|%|&]"
HelpText$(278) = "       Meaning[!|@|#|$|%|&] =<  Meaning[!|@|#|$|%|&]"
HelpText$(279) = "       Meaning[!|@|#|$|%|&] >=  Meaning[!|@|#|$|%|&]"
HelpText$(280) = "       Meaning[!|@|#|%|&]   AND Meaning[!|@|#|%|&]"
HelpText$(281) = "       Meaning[!|@|#|%|&]   MOD Meaning[!|@|#|%|&]"
HelpText$(282) = "       Meaning[!|@|#|%|&]   OR  Meaning[!|@|#|%|&]"
HelpText$(283) = "       Meaning[!|@|#|%|&]   XOR Meaning[!|@|#|%|&]"
HelpText$(284) = "                            NOT Meaning[!|@|#|%|&]"
HelpText$(285) = "System settings:"
HelpText$(286) = "       BASIC lines numbers range: 1 - " + LTRIM$(STR$(TextLines%)) + "."
HelpText$(287) = "       Maximal count of user - defined functions (DEF FN) is: " + LTRIM$(STR$(DefFnSCount%)) + "."
HelpText$(288) = "       Maximal count of arguments for the user - defined"
HelpText$(289) = "       function is: " + LTRIM$(STR$(DefFnSArgsCount%)) + "."
HelpText$(290) = "       Maximal count of variables is: " + LTRIM$(STR$(VariablesCount%)) + "."
HelpText$(291) = "       File numbers range is: 1 - " + LTRIM$(STR$(FilesCount%)) + "."
HelpText$(292) = "       Maximal count of WHILE cycles running per one time is: " + LTRIM$(STR$(WhilesCount%)) + "."
HelpText$(293) = "       Maximal count of FROM cycles running per one time is: " + LTRIM$(STR$(FromsCount%)) + "."
HelpText$(294) = "       Maximal count of called per one time GO SUB subroutines"
HelpText$(295) = "       is: " + LTRIM$(STR$(GoSubSCount%)) + "."
HelpText$(296) = "       Maximal arguments count for ANSI sequences is: " + LTRIM$(STR$(ArgumentsCount%)) + "."
HelpText$(297) = "Notes:"
HelpText$(298) = "1.). In this BASIC language interpretter have internal ANSI escape"
HelpText$(299) = "     sequences interpretter, and so on, you can include ANSI escape"
HelpText$(300) = "     sequences into the outputted text for output to the screen"
HelpText$(301) = "     with the PRINT statement."
HelpText$(302) = "2.). Maximal length of all lines are 256 symbols."
HelpText$(303) = "3.). Line numbers are not required."
HelpText$(304) = "####################################################################"
HelpText$(305) = "             The Personal BASIC Language Interpretter."
HelpText$(306) = "           Copyright (C) 2003, Sandul Yura Valentinovich."
SCREEN 0, 1, 0, 0
LinePosition% = 1
CursorPosition% = 1
TextPosition% = 1
PagePosition% = 1
TextFileName$ = "Text.txt"
PrinterName$ = "Prn"
LinesPerPage% = 55
English$ = "`1234567890-=qwertyuiop[]asdfghjkl;'zxcvbnm,./\~!@#$%^&*()_+QWERTYUIOP{}ASDFGHJKL:" + CHR$(34) + "ZXCVBNM<>?|"
Russian$ = "1234567890-=㪥뢠஫ᬨ.\!" + CHR$(34) + ";%:?*()_+,/"
Language% = False%
OldSecond% = VAL(MID$(TIME$, 7, 2))
StatusLine$ = StandartStatus$
CALL ScratchScreen
CALL OutBox("Text editor.", "The personal text editor. (C) Copyright Sandul Yura Valentinovich. (R) Tuesday, 27 May 2003 year. All rights reserved. This text editor is Public Domain FreeWare. It's based on the GNU General Public License.")
CALL ScratchScreen
DO
 Key$ = ""
 WHILE Key$ = ""
  IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
   OldSecond% = VAL(MID$(TIME$, 7, 2))
   StatusLine$ = StandartStatus$
   CALL ScratchScreen
  END IF
  Key$ = INKEY$
 WEND
 SELECT CASE LEN(Key$)
 CASE 1
   IF Language% THEN IF INSTR(English$, Key$) > 0 THEN Key$ = MID$(Russian$, INSTR(English$, Key$), 1)
   SELECT CASE Key$
   CASE CHR$(8)
     CALL DeleteBackSymbol
   CASE CHR$(13)
     CALL InsertLine
   CASE CHR$(27)
     MenuItems$(1) = "Save file (" + TextFileName$ + ".)."
     MenuItems$(2) = "Save file as."
     MenuItems$(3) = "Load file."
     MenuItems$(4) = "Print."
     MenuItems$(5) = "Change printer name (current=" + PrinterName$ + ".)."
     MenuItems$(6) = "Change lines per page count for printing (current=" + LTRIM$(STR$(LinesPerPage%)) + ".)."
     MenuItems$(7) = "Find text."
     MenuItems$(8) = "Replace text."
     MenuItems$(9) = "New file."
     MenuItems$(10) = "Change system date."
     MenuItems$(11) = "Change system time."
     MenuItems$(12) = "Reboot computer."
     MenuItems$(13) = "Calendar."
     MenuItems$(14) = "Insert calendar."
     MenuItems$(15) = "Calculate line."
     MenuItems$(16) = "Help on internal language interpretter."
     MenuItems$(17) = "Parse text."
     MenuItems$(18) = "Run current line."
     MenuItems$(19) = "Run program."
     IF Language% THEN MenuItems$(20) = "Change language (current=Russian.)." ELSE MenuItems$(20) = "Change language (current=English.)."
     MenuItems$(21) = "Quit."
     SELECT CASE MenuBox%(20, MenuItems$())
     CASE 1
       StatusLine$ = "Saving file. Please waith..."
       CALL ScratchScreen
       ON ERROR GOTO CannotOpenFileForSave
       OPEN TextFileName$ FOR OUTPUT AS #1
       ON ERROR GOTO 0
       FOR Index% = 1 TO TextLines%
        ON ERROR GOTO CannotWriteToFileForSave
        PRINT #1, Text$(Index%)
        ON ERROR GOTO 0
       NEXT Index%
       CLOSE #1
     CASE 2
       StatusLine$ = "Saving file as other name. Please waith..."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Saving file as other name.", "Please enter new file name.", WorkLine$) THEN
        CALL ScratchScreen
        WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
        WorkLine$ = UCASE$(LEFT$(WorkLine$, 1)) + LCASE$(MID$(WorkLine$, 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
         CALL OutBox("Saving file as other name.", "Invalid file name.")
        ELSE
         ON ERROR GOTO CannotOpenFileForSaveAs
         OPEN WorkLine$ FOR OUTPUT AS #1
         ON ERROR GOTO 0
         FOR Index% = 1 TO TextLines%
          ON ERROR GOTO CannotWriteToFileForSaveAs
          PRINT #1, Text$(Index%)
          ON ERROR GOTO 0
         NEXT Index%
         CLOSE #1
         TextFileName$ = WorkLine$
        END IF
       END IF
     CASE 3
       StatusLine$ = "Load file. Please waith..."
       CALL ScratchScreen
       IF MessageBox%("Load file.", "Save current file before load new?") THEN
        StatusLine$ = "Saving file. Please waith..."
        CALL ScratchScreen
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextFileName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO TextLines%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
        StatusLine$ = "Load file. Please waith..."
        CALL ScratchScreen
       END IF
       WorkLine$ = ""
       IF InputBox%("Load file.", "Please enter file name for load it.", WorkLine$) THEN
        CALL ScratchScreen
        WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
        WorkLine$ = UCASE$(LEFT$(WorkLine$, 1)) + LCASE$(MID$(WorkLine$, 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN
         CALL OutBox("Load file.", "Invalid file name.")
        ELSE
         ON ERROR GOTO CannotOpenFileForLoad
         OPEN WorkLine$ FOR INPUT AS #1
         ON ERROR GOTO 0
         FOR Index% = 1 TO TextLines%
          Text$(Index%) = ""
         NEXT Index%
         Index% = 1
         DO WHILE NOT EOF(1)
          ON ERROR GOTO CannotReadFromFileForLoad
          LINE INPUT #1, Work$
          ON ERROR GOTO 0
          Text$(Index%) = ""
          Work$ = LEFT$(RTRIM$(Work$), LineLength%)
          WHILE Work$ <> ""
           IF ASC(Work$) < ASC(SPACE$(1)) THEN Text$(Index%) = Text$(Index%) + SPACE$(1) ELSE Text$(Index%) = Text$(Index%) + LEFT$(Work$, 1)
           Work$ = MID$(Work$, 2)
          WEND
          Index% = Index% + 1
          IF Index% = TextLines% + 1 THEN
           CALL OutBox("Load file.", "Input file is too big. Loaded first " + LTRIM$(STR$(TextLines%)) + " lines.")
           CALL ScratchScreen
           EXIT DO
          END IF
         LOOP
         CLOSE #1
         TextFileName$ = WorkLine$
         LinePosition% = 1
         CursorPosition% = 1
         TextPosition% = 1
         PagePosition% = 1
        END IF
       END IF
     CASE 4
       StatusLine$ = "Printing text. Please waith..."
       CALL ScratchScreen
       ON ERROR GOTO CannotOpenPrinter
       OPEN PrinterName$ FOR OUTPUT AS #1
       ON ERROR GOTO 0
       CALL OutBox("Print.", "Please insert paper.")
       CALL ScratchScreen
       Work% = 0
       FOR Index% = 1 TO TextLines%
        ON ERROR GOTO CannotWriteToPrinter
        PRINT #1, Text$(Index%)
        ON ERROR GOTO 0
        Work% = Work% + 1
        IF Work% = LinesPerPage% THEN
         ON ERROR GOTO CannotWriteToPrinter
         PRINT #1, CHR$(12)
         ON ERROR GOTO 0
         CALL OutBox("Print.", "Please insert paper.")
         CALL ScratchScreen
         Work% = 0
        END IF
       NEXT Index%
       CLOSE #1
     CASE 5
       StatusLine$ = "Change printer name."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Change printer name.", "Please enter new printer name.", WorkLine$) THEN
        CALL ScratchScreen
        WorkLine$ = LTRIM$(RTRIM$(WorkLine$))
        WorkLine$ = UCASE$(LEFT$(WorkLine$, 1)) + LCASE$(MID$(WorkLine$, 2))
        IF (WorkLine$ = "") OR (LEN(WorkLine$) > 12) OR (INSTR(WorkLine$, "\") > 0) OR (INSTR(WorkLine$, "/") > 0) OR (INSTR(WorkLine$, "?") > 0) OR (INSTR(WorkLine$, "*") > 0) THEN CALL OutBox("Change printer name.", "Invalid printer name.") ELSE PrinterName$ = WorkLine$
       END IF
     CASE 6
       StatusLine$ = "Change lines per page count for printing."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Change lines per page count for printing.", "Please enter new value from 0 to 32767 as count of lines per page.", WorkLine$) THEN
        CALL ScratchScreen
        WorkLine$ = LTRIM$(RTRIM$(UCASE$(WorkLine$)))
        IF (VAL(WorkLine$) < 0) OR (VAL(WorkLine$) > 32767) THEN CALL OutBox("Change printer name.", "Invalid printer name.") ELSE LinesPerPage% = VAL(WorkLine$)
       END IF
     CASE 7
       StatusLine$ = "Find text."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Find text.", "Please enter text line for find it.", WorkLine$) THEN
        CALL ScratchScreen
        FOR Index% = 1 TO TextLines% + 1
         IF Index% = TextLines% + 1 THEN
          CALL OutBox("Find text.", "Text is not found.")
          EXIT FOR
         END IF
         IF INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) > 0 THEN
          LinePosition% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
          CursorPosition% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
          TextPosition% = Index%
          PagePosition% = Index%
          CALL Control
          EXIT FOR
         END IF
        NEXT Index%
       END IF
     CASE 8
       StatusLine$ = "Replace text."
       CALL ScratchScreen
       WorkLine$ = ""
       IF InputBox%("Replace text.", "Please enter text line for find it.", WorkLine$) THEN
        CALL ScratchScreen
        Work$ = ""
        IF InputBox%("Replace text.", "Please enter text line for replace it.", Work$) THEN
         CALL ScratchScreen
         Work% = False%
         FOR Index% = 1 TO TextLines% + 1
          IF Index% = TextLines% + 1 THEN
           CALL OutBox("Replace text.", "Replacement is ended.")
           EXIT FOR
          END IF
          IF INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) > 0 THEN
           IF Work% THEN
            Text$(Index%) = MID$(Text$(Index%), 1, INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))) + Work$ + MID$(Text$(Index%), INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) + LEN(WorkLine$))
           ELSE
            LinePosition% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
            CursorPosition% = INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))
            TextPosition% = Index%
            PagePosition% = Index%
            CALL Control
            StatusLine$ = "Replace this occurence? (Enter=Yes,Tab=Skip,SpaceBar=All,Esc=Cancel."
            CALL ScratchScreen
            DO
             Key$ = INKEY$
            LOOP UNTIL (Key$ = CHR$(13)) OR (Key$ = CHR$(9)) OR (Key$ = SPACE$(1)) OR (Key$ = CHR$(27))
            SELECT CASE Key$
            CASE CHR$(13)
              Text$(Index%) = MID$(Text$(Index%), 1, INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))) + Work$ + MID$(Text$(Index%), INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) + LEN(WorkLine$))
            CASE SPACE$(1)
              Work% = True%
              Text$(Index%) = MID$(Text$(Index%), 1, INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$))) + Work$ + MID$(Text$(Index%), INSTR(UCASE$(Text$(Index%)), UCASE$(WorkLine$)) + LEN(WorkLine$))
            CASE CHR$(27)
              EXIT FOR
            END SELECT
           END IF
          END IF
         NEXT Index%
        END IF
       END IF
     CASE 9
       StatusLine$ = "New file."
       CALL ScratchScreen
       IF MessageBox%("New file.", "Save file before new?") THEN
        StatusLine$ = "Saving file. Please waith..."
        CALL ScratchScreen
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextFileName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO TextLines%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
       END IF
       StatusLine$ = "New file."
       CALL ScratchScreen
       FOR Index% = 1 TO TextLines%
        Text$(Index%) = ""
       NEXT Index%
       LinePosition% = 1
       CursorPosition% = 1
       TextPosition% = 1
       PagePosition% = 1
     CASE 10
       StatusLine$ = "Change system date."
       CALL ScratchScreen
       WorkDay% = VAL(MID$(DATE$, 4, 2))
       WorkMonth% = VAL(LEFT$(DATE$, 2))
       WorkYear% = VAL(MID$(DATE$, 7, 4))
       IF CalendarBox%(WorkDay%, WorkMonth%, WorkYear%, "Change system date.", "Please select new date.") THEN
        IF (WorkYear% < 1980) OR (WorkYear% > 2099) THEN
         CALL OutBox("Change system date.", "Invalid year.")
        ELSE
         DATE$ = STRING$(2 - LEN(LTRIM$(STR$(WorkMonth%))), "0") + LTRIM$(STR$(WorkMonth%)) + "-" + STRING$(2 - LEN(LTRIM$(STR$(WorkDay%))), "0") + LTRIM$(STR$(WorkDay%)) + "-" + STRING$(4 - LEN(LTRIM$(STR$(WorkYear%))), "0") + LTRIM$(STR$(WorkYear%))
         CALL OutBox("Change system date.", "System date is succefully changed.")
         OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
        END IF
       END IF
     CASE 11
       StatusLine$ = "Change system time."
       CALL ScratchScreen
       WorkLine$ = TIME$
       IF InputBox%("Change system time.", "Please enter new time.", WorkLine$) THEN
        WorkLine$ = LTRIM$(RTRIM$(UCASE$(WorkLine$)))
        IF (WorkLine$ = "") OR (INSTR(WorkLine$, ":") = 0) THEN
         CALL OutBox("Change system time.", "Invalid time line.")
        ELSE
         IF (VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1))) < 0) OR (VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)) > 23) THEN
          CALL OutBox("Change system time.", "Invalid hour value.")
         ELSE
          Work$ = STRING$(2 - LEN(LTRIM$(STR$(VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)))))), "0") + LTRIM$(STR$(VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)))))
          WorkLine$ = LTRIM$(MID$(WorkLine$, INSTR(WorkLine$, ":") + 1))
          IF (WorkLine$ = "") OR (INSTR(WorkLine$, ":") = 0) THEN
           CALL OutBox("Change system time.", "Invalid time line.")
          ELSE
           IF (VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1))) < 0) OR (VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)) > 59) THEN
            CALL OutBox("Change system time.", "Invalid minute value.")
           ELSE
            Work$ = Work$ + ":" + STRING$(2 - LEN(LTRIM$(STR$(VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)))))), "0") + LTRIM$(STR$(VAL(RTRIM$(MID$(WorkLine$, 1, INSTR(WorkLine$, ":") - 1)))))
            WorkLine$ = LTRIM$(MID$(WorkLine$, INSTR(WorkLine$, ":") + 1))
            IF WorkLine$ = "" THEN
             CALL OutBox("Change system time.", "Invalid time line.")
            ELSE
             IF (VAL(WorkLine$) < 0) OR (VAL(WorkLine$) > 59) THEN
              CALL OutBox("Change system time.", "Invalid second value.")
             ELSE
              Work$ = Work$ + ":" + STRING$(2 - LEN(LTRIM$(STR$(VAL(WorkLine$)))), "0") + LTRIM$(STR$(VAL(WorkLine$)))
              TIME$ = Work$
              CALL OutBox("Change system time.", "System time is succefully changed.")
              OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
             END IF
            END IF
           END IF
          END IF
         END IF
        END IF
       END IF
     CASE 12
       StatusLine$ = "Reboot computer."
       CALL ScratchScreen
       IF MessageBox%("Reboot computer.", "Save file before reboot?") THEN
        StatusLine$ = "Saving file. Please waith..."
        CALL ScratchScreen
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextFileName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO TextLines%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
       END IF
       StatusLine$ = "Rebooting computer."
       CALL ScratchScreen
       COLOR 7, 0
       CLS
       LOCATE 1, 1, 1, 7, 8
       DEF SEG = &HF000
       CALL Absolute(&HFFF0)
     CASE 13
       StatusLine$ = "Calendar."
       CALL ScratchScreen
       CALL Calendar(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)), "Calendar.", "")
     CASE 14
       StatusLine$ = "Insert calendar."
       CALL ScratchScreen
       WorkDay% = VAL(MID$(DATE$, 4, 2))
       WorkMonth% = VAL(LEFT$(DATE$, 2))
       WorkYear% = VAL(MID$(DATE$, 7, 4))
       IF CalendarBox%(WorkDay%, WorkMonth%, WorkYear%, "Insert calendar.", "Please select date for the calendar.") THEN
        IF (TextLines% - TextPosition%) < 10 THEN
         CALL OutBox("Insert calendar.", "Current line is too big.")
        ELSE
         CALL ScratchScreen
         Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, LinePosition% - 1) + SPACE$(INT((23 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".")) / 2)) + MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + "." + SPACE$(INT((23 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".")) / 2)) + MID$(Text$(TextPosition%), LinePosition%)
         IF LEN(Text$(TextPosition% + 1)) < LinePosition% THEN Text$(TextPosition% + 1) = Text$(TextPosition% + 1) + SPACE$(LinePosition% - LEN(Text$(TextPosition% + 1)))
         Text$(TextPosition% + 1) = MID$(Text$(TextPosition% + 1), 1, LinePosition% - 1) + " Mo Tu We Th Fr Sa Su " + MID$(Text$(TextPosition% + 1), LinePosition%)
         FOR Index% = 1 TO 42
          Days%(Index%) = 0
         NEXT Index%
         Work% = 1
         FOR Index% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 42
          Days%(Index%) = Work%
          Work% = Work% + 1
          IF Work% = MonthDaysCount%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
         NEXT Index%
         WorkLine$ = ""
         Work% = 2
         FOR Index% = 1 TO 42
          IF Days%(Index%) = 0 THEN
           WorkLine$ = WorkLine$ + SPACE$(3)
          ELSE
           IF Days%(Index%) = WorkDay% THEN WorkLine$ = WorkLine$ + "*" + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%))) ELSE WorkLine$ = WorkLine$ + SPACE$(1) + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%)))
          END IF
          IF LEN(WorkLine$) = 21 THEN
           IF LEN(Text$(TextPosition% + Work%)) < LinePosition% THEN Text$(TextPosition% + Work%) = Text$(TextPosition% + Work%) + SPACE$(LinePosition% - LEN(Text$(TextPosition% + Work%)))
           Text$(TextPosition% + Work%) = MID$(Text$(TextPosition% + Work%), 1, LinePosition% - 1) + WorkLine$ + SPACE$(1) + MID$(Text$(TextPosition% + Work%), LinePosition%)
           WorkLine$ = ""
           Work% = Work% + 1
          END IF
         NEXT Index%
         IF LEN(Text$(TextPosition% + Work%)) < LinePosition% THEN Text$(TextPosition% + Work%) = Text$(TextPosition% + Work%) + SPACE$(LinePosition% - LEN(Text$(TextPosition% + Work%)))
         Text$(TextPosition% + Work%) = MID$(Text$(TextPosition% + Work%), 1, LinePosition% - 1) + "Current date: " + DayName$(DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + SPACE$(1) + MonthName$(VAL(LEFT$(DATE$, 2))) + SPACE$(1) + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + "." + MID$(Text$(TextPosition% + Work%), LinePosition%)
        END IF
       END IF
     CASE 15
       StatusLine$ = "Calculate line."
       CALL ScratchScreen
       CALL ClearAll
       ON ERROR GOTO CannotCalculateLine
       IF LTRIM$(RTRIM$(Text$(TextPosition%))) <> "" THEN
        WorkLine$ = LTRIM$(RTRIM$(Text$(TextPosition%)))
        WorkLine$ = EvaluateParseCalculate$(WorkLine$)
        Work$ = WorkLine$
        Text$(TextPosition%) = Work$ + "=" + EvaluateCalculate$(WorkLine$)
       ELSE
        Text$(TextPosition%) = ""
       END IF
       ON ERROR GOTO 0
       LinePosition% = 1
       CursorPosition% = 1
       CALL ClearAll
     CASE 16
       StatusLine$ = "Help."
       CALL ScratchScreen
       CALL MakeWindow(5, 2, 68, 19, True%, "BASIC language help.", False%, "", True%, "ENTER=Continue. ESC=Cancel.")
       Work% = 0
       COLOR Blue%, White%
       FOR Index% = 1 TO 300
        LOCATE 5 + Work%, 6, 0
        PRINT HelpText$(Index%)
        Work% = Work% + 1
        IF Work% = 15 THEN
         DO
          Work$ = INKEY$
         LOOP UNTIL (Work$ = CHR$(13)) OR (Work$ = CHR$(27))
         IF Work$ = CHR$(27) THEN EXIT DO
         CALL MakeWindow(5, 2, 68, 19, True%, "BASIC language help.", False%, "", True%, "ENTER=Continue. ESC=Cancel.")
         COLOR Blue%, White%
         Work% = 0
        END IF
       NEXT Index%
       CALL MakeWindow(5, 2, 68, 19, True%, "BASIC language help.", False%, "", True%, "ENTER=Continue.")
       Work% = 0
       COLOR Blue%, White%
       FOR Index% = 301 TO 304
        LOCATE 5 + Work%, 6, 0
        PRINT HelpText$(Index%)
        Work% = Work% + 1
       NEXT Index%
       COLOR Yellow%, White%
       FOR Index% = 305 TO 306
        LOCATE 5 + Work%, 6, 0
        PRINT HelpText$(Index%)
        Work% = Work% + 1
       NEXT Index%
       WHILE INKEY$ <> CHR$(13)
       WEND
     CASE 17
       StatusLine$ = "Parse text."
       CALL ScratchScreen
       CALL ClearAll
       ON ERROR GOTO CannotParseText
       FOR Index% = 1 TO TextLines%
        IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
         WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
         SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
         CASE "0" TO "9"
           LineNumber% = INT(InNumber#(WorkLine$))
           WorkLine$ = LTRIM$(WorkLine$)
           IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
           IF WorkLine$ = "" THEN ERROR 39
           IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
           Text$(Index%) = ParseRunLine$(WorkLine$)
         CASE "A" TO "Z"
           Text$(Index%) = ParseRunLine$(WorkLine$)
         CASE ELSE
           ERROR 39
         END SELECT
        ELSE
         Text$(Index%) = ""
        END IF
       NEXT Index%
       CALL ClearAll
       LinePosition% = 1
       CursorPosition% = 1
       ON ERROR GOTO 0
       CALL OutBox("Parse text.", "Text is succefully parsed.")
     CASE 18
       StatusLine$ = "Run current line."
       CALL ScratchScreen
       CALL ClearAll
       COLOR White%, Black%
       CLS
       LOCATE 1, 1, 1, 7, 8
       ON ERROR GOTO CannotRunCurrentLine
       IF LTRIM$(RTRIM$(Text$(TextPosition%))) <> "" THEN
        WorkLine$ = LTRIM$(RTRIM$(Text$(TextPosition%)))
        SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
        CASE "0" TO "9"
          LineNumber% = INT(InNumber#(WorkLine$))
          WorkLine$ = LTRIM$(WorkLine$)
          IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
          IF WorkLine$ = "" THEN ERROR 39
          IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
          WorkLine$ = ParseRunLine$(WorkLine$)
          CALL RunLine(WorkLine$)
        CASE "A" TO "Z"
          WorkLine$ = ParseRunLine$(WorkLine$)
          CALL RunLine(WorkLine$)
        CASE ELSE
          ERROR 39
        END SELECT
       END IF
       ON ERROR GOTO 0
       RESET
       CALL ClearAll
       COLOR White%, Black%
       LOCATE 25, 1, 1, 7, 8
       PRINT SPACE$(80);
       LOCATE 25, 1, 0
       PRINT "Press the ENTER key for return.";
       WHILE INKEY$ <> CHR$(13)
       WEND
       KEY OFF
       SCREEN 0, 1, 0, 0
       WIDTH 80
     CASE 19
       StatusLine$ = "Run program."
       CALL ScratchScreen
       CALL ClearAll
       COLOR White%, Black%
       CLS
       LOCATE 1, 1, 1, 7, 8
       CurrentLine% = 1
       RunMode% = True%
       DO
        ON ERROR GOTO CannotRunProgram
        IF LTRIM$(RTRIM$(Text$(CurrentLine%))) <> "" THEN
         WorkLine$ = LTRIM$(RTRIM$(Text$(CurrentLine%)))
         SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
         CASE "0" TO "9"
           LineNumber% = INT(InNumber#(WorkLine$))
           WorkLine$ = LTRIM$(WorkLine$)
           IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
           IF WorkLine$ = "" THEN ERROR 39
           IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
           IF TraceMode% THEN PRINT "[" + LTRIM$(STR$(LineNumber%)) + "]";
           WorkLine$ = ParseRunLine$(WorkLine$)
           CALL RunLine(WorkLine$)
         CASE "A" TO "Z"
           WorkLine$ = ParseRunLine$(WorkLine$)
           CALL RunLine(WorkLine$)
         CASE ELSE
           ERROR 39
         END SELECT
        END IF
        ON ERROR GOTO 0
        CurrentLine% = CurrentLine% + 1
       LOOP UNTIL (CurrentLine% > TextLines%) OR (NOT RunMode%)
       RESET
       CALL ClearAll
       COLOR White%, Black%
       LOCATE 25, 1, 1, 7, 8
       PRINT SPACE$(80);
       LOCATE 25, 1, 0
       PRINT "Press the ENTER key for return.";
       WHILE INKEY$ <> CHR$(13)
       WEND
       KEY OFF
       SCREEN 0, 1, 0, 0
       WIDTH 80
     CASE 20
       Language% = NOT Language%
     CASE 21
       StatusLine$ = "Quit."
       CALL ScratchScreen
       IF MessageBox%("Quit.", "Save file before quit?") THEN
        StatusLine$ = "Saving file. Please waith..."
        CALL ScratchScreen
        ON ERROR GOTO CannotOpenFileForSave
        OPEN TextFileName$ FOR OUTPUT AS #1
        ON ERROR GOTO 0
        FOR Index% = 1 TO TextLines%
         ON ERROR GOTO CannotWriteToFileForSave
         PRINT #1, Text$(Index%)
         ON ERROR GOTO 0
        NEXT Index%
        CLOSE #1
       END IF
       EXIT DO
     END SELECT
     StatusLine$ = StandartStatus$
     CALL ScratchScreen
   CASE ELSE
     IF LinePosition% = LineLength% THEN
      IF TextPosition% < TextLines% THEN
       LinePosition% = 1
       CursorPosition% = 1
       TextPosition% = TextPosition% + 1
       PagePosition% = PagePosition% + 1
       Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, CursorPosition% - 1) + Key$ + MID$(Text$(TextPosition%), CursorPosition%)
       CALL CursorRight
      END IF
     ELSE
      IF LEN(Text$(TextPosition%)) < LineLength% THEN
       Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, CursorPosition% - 1) + Key$ + MID$(Text$(TextPosition%), CursorPosition%)
       CALL CursorRight
      END IF
     END IF
   END SELECT
 CASE 2
   SELECT CASE RIGHT$(Key$, 1)
   CASE CHR$(72)
     CALL CursorUp
   CASE CHR$(80)
     CALL CursorDown
   CASE CHR$(75)
     CALL CursorLeft
   CASE CHR$(77)
     CALL CursorRight
   CASE CHR$(71)
     CALL CursorHome
   CASE CHR$(79)
     CALL CursorEnd
   CASE CHR$(73)
     CALL PageUp
   CASE CHR$(81)
     CALL PageDown
   CASE CHR$(83)
     CALL DeleteCurrentSymbol
   END SELECT
 END SELECT
TextWork:
LOOP
COLOR 7, 0
CLS
LOCATE 1, 1, 1, 7, 8
END
CannotOpenFileForSave:
 IF MessageBox%("Save file.", "Cannot open file for save. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotWriteToFileForSave:
 IF MessageBox%("Save file.", "Cannot write to file for save. Retry writing?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  KILL TextFileName$
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotOpenFileForSaveAs:
 IF MessageBox%("Saving file as other name.", "Cannot open file for save. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotWriteToFileForSaveAs:
 IF MessageBox%("Saving file as other name.", "Cannot write to file for save. Retry writing?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  KILL WorkLine$
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotOpenFileForLoad:
 IF MessageBox%("Load file.", "Cannot open file for load. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotReadFromFileForLoad:
 IF MessageBox%("Load file.", "Cannot read from file for load. Retry reading?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  FOR Index% = 1 TO TextLines%
   Text$(Index%) = ""
  NEXT Index%
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotOpenPrinter:
 IF MessageBox%("Print text.", "Cannot open printer. Retry opening?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotWriteToPrinter:
 IF MessageBox%("Print text.", "Cannot write to printer. Retry writing?") THEN
  CALL ScratchScreen
  RESUME
 ELSE
  CLOSE #1
  CALL ScratchScreen
  RESUME TextWork
 END IF
CannotParseCurrentLine:
 CALL OutBox("Parse current line.", "Error parsing line. Error is: " + Errors$(ERR) + ".")
 CALL ClearAll
 RESUME TextWork
CannotParseText:
 CALL OutBox("Parse text.", "Error parsing text in line: " + LTRIM$(STR$(Index%)) + ". Error is: " + Errors$(ERR) + ".")
 CALL ClearAll
 RESUME TextWork
CannotRunCurrentLine:
 RESET
 KEY OFF
 SCREEN 0, 1, 0, 0
 WIDTH 80
 CALL ScratchScreen
 CALL OutBox("Run current line.", "Error run line. Error is: " + Errors$(ERR) + ".")
 CALL ClearAll
 RESUME TextWork
CannotRunProgram:
 RESET
 KEY OFF
 SCREEN 0, 1, 0, 0
 WIDTH 80
 CALL ScratchScreen
 CALL OutBox("Run program.", "Error run line in: " + LTRIM$(STR$(CurrentLine%)) + ". Error is: " + Errors$(ERR) + ".")
 CALL ClearAll
 RESUME TextWork
CannotCalculateLine:
 CALL OutBox("Calculate line.", "Error calculate line. Error is: " + Errors$(ERR) + ".")
 CALL ClearAll
 RESUME TextWork

SUB ANSIOut (ANSISymbol$)
 DIM Index%
 IF ANSISymbol$ = "" THEN EXIT SUB
 SELECT CASE ANSIMode%
 CASE 0
   SELECT CASE ANSISymbol$
   CASE CHR$(27)
     ANSIMode% = 1
   CASE ELSE
     SELECT CASE ASC(ANSISymbol$)
     CASE 10
       PRINT
     CASE IS > (ASC(SPACE$(1)) - 1)
       PRINT ANSISymbol$;
     END SELECT
     CALL ClearANSI(False%)
   END SELECT
 CASE 1
   SELECT CASE ANSISymbol$
   CASE "["
     ANSIMode% = 2
   CASE ELSE
     CALL ClearANSI(False%)
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 2
   SELECT CASE ANSISymbol$
   CASE "H"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF Arguments%(2) < 1 THEN Arguments%(2) = 1
     IF Arguments%(1) > 25 THEN Arguments%(1) = 25
     IF Arguments%(2) > 80 THEN Arguments%(2) = 80
     SELECT CASE ArgumentsCountValue%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       LOCATE Arguments%(1), 1, 7, 8
     CASE IS > 1
       LOCATE Arguments%(1), Arguments%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI(False%)
   CASE "f"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF Arguments%(2) < 1 THEN Arguments%(2) = 1
     IF Arguments%(1) > 25 THEN Arguments%(1) = 25
     IF Arguments%(2) > 80 THEN Arguments%(2) = 80
     SELECT CASE ArgumentsCountValue%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       LOCATE Arguments%(1), 1, 7, 8
     CASE IS > 1
       LOCATE Arguments%(1), Arguments%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI(False%)
   CASE "A"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF (CSRLIN - Arguments%(1)) > 0 THEN LOCATE CSRLIN - Arguments%(1), POS(0), 1, 7, 8
     CALL ClearANSI(False%)
   CASE "B"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF (CSRLIN + Arguments%(1)) < 26 THEN LOCATE CSRLIN + Arguments%(1), POS(0), 1, 7, 8
     CALL ClearANSI(False%)
   CASE "C"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF (POS(0) + Arguments%(1)) < 81 THEN LOCATE CSRLIN, POS(0) + Arguments%(1), 1, 7, 8
     CALL ClearANSI(False%)
   CASE "D"
     IF Arguments%(1) < 1 THEN Arguments%(1) = 1
     IF (POS(0) - Arguments%(1)) > 0 THEN LOCATE CSRLIN, POS(0) - Arguments%(1), 1, 7, 8
     CALL ClearANSI(False%)
   CASE "s"
     CursorRow% = CSRLIN
     CursorColumn% = POS(0)
     CursorSaved% = True%
     CALL ClearANSI(False%)
   CASE "u"
     IF CursorSaved% THEN
      LOCATE CursorRow%, CursorColumn%, 1, 7, 8
      CursorSaved% = False%
     END IF
     CALL ClearANSI(False%)
   CASE "J"
     IF Arguments%(1) = 2 THEN
      CLS
      LOCATE 1, 1, 1, 7, 8
     END IF
     CALL ClearANSI(False%)
   CASE "K"
     Index% = POS(0)
     PRINT SPACE$(80 - POS(0));
     LOCATE CSRLIN, Index%, 1, 7, 8
     CALL ClearANSI(False%)
   CASE "m"
     IF ArgumentsCountValue% > 0 THEN
      FOR Index% = 1 TO ArgumentsCountValue%
       SELECT CASE Arguments%(Index%)
       CASE 0
         COLOR White%, Black%
       CASE 1
         COLOR BrightWhite%
       CASE 4
         COLOR Blue%
       CASE 5
         COLOR White%
       CASE 7
         COLOR Black%, White%
       CASE 8
         COLOR Black%, Black%
       CASE 30
         COLOR Black%
       CASE 31
         COLOR Red%
       CASE 32
         COLOR Green%
       CASE 33
         COLOR Brown%
       CASE 34
         COLOR Blue%
       CASE 35
         COLOR Magenta%
       CASE 36
         COLOR Cyan%
       CASE 37
         COLOR BrightWhite%
       CASE 40
         COLOR , Black%
       CASE 41
         COLOR , Red%
       CASE 42
         COLOR , Green%
       CASE 43
         COLOR , Brown%
       CASE 44
         COLOR , Blue%
       CASE 45
         COLOR , Magenta%
       CASE 46
         COLOR , Cyan%
       CASE 47
         COLOR , White%
       END SELECT
      NEXT Index%
     ELSE
      COLOR White%, Black%
     END IF
     CALL ClearANSI(False%)
   CASE "0" TO "9"
     CALL ClearANSI(False%)
     ANSIMode% = 3
     CALL ANSIOut(ANSISymbol$)
   CASE ";"
     CALL ClearANSI(False%)
     ANSIMode% = 3
     CALL ANSIOut(ANSISymbol$)
   CASE ELSE
     ANSIMode% = 0
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 3
   SELECT CASE ANSISymbol$
   CASE "0" TO "9"
     IF LEN(NumberLine$) < 2 THEN NumberLine$ = NumberLine$ + ANSISymbol$
   CASE ";"
     IF ArgumentsCountValue% < ArgumentsCount% THEN
      ArgumentsCountValue% = ArgumentsCountValue% + 1
      Arguments%(ArgumentsCountValue%) = VAL(NumberLine$)
     END IF
     NumberLine$ = ""
   CASE ELSE
     IF ArgumentsCountValue% < ArgumentsCount% THEN
      ArgumentsCountValue% = ArgumentsCountValue% + 1
      Arguments%(ArgumentsCountValue%) = VAL(NumberLine$)
     END IF
     ANSIMode% = 2
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 END SELECT
END SUB

FUNCTION Calculate$ (InLine$)
 DIM Result$
 DIM Value$
 DIM WorkLine$
 DIM ControlNumStr%
 Result$ = InMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "*"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) * VAL(Value$)))
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    ControlNumStr% = NumStr%
    Value$ = InMeaning$(InLine$)
    IF ControlNumStr% <> NumStr% THEN ERROR 13
    IF NumStr% THEN Result$ = Result$ + Value$ ELSE Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
  CASE "-"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) - VAL(Value$)))
  CASE "/"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "\"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "^"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) ^ VAL(Value$)))
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ >= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) >= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ = Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) = VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <> Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <> VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ >= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) >= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ > Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) > VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <> Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <> VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = InMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ < Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) < VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    WorkLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) AND VAL(Value$)))
    CASE "MOD"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) MOD VAL(Value$)))
    CASE "OR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) OR VAL(Value$)))
    CASE "XOR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) XOR VAL(Value$)))
    CASE ELSE
      InLine$ = WorkLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 Calculate$ = Result$
END FUNCTION

SUB Calendar (DayValue%, MonthValue%, YearValue%, Title$, Message$)
 DIM WorkDay%
 DIM WorkMonth%
 DIM WorkYear%
 DIM Days%(42)
 DIM WorkLine$
 DIM Index%
 DIM Work%
 DIM Key$
 DIM OldSecond%
 WorkDay% = DayValue%
 WorkMonth% = MonthValue%
 WorkYear% = YearValue%
 IF WorkYear% < 0 THEN WorkYear% = 0
 IF WorkMonth% < 1 THEN WorkMonth% = 1
 IF WorkMonth% > 12 THEN WorkMonth% = 12
 IF WorkDay% < 1 THEN WorkDay% = 1
 IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
 CALL MakeWindow(7, 3, 64, 18, True%, Title$, True%, Message$, True%, "ESC=Quit.")
 COLOR 4, 7
 LOCATE 11, 30, 0
 PRINT "Mo Tu We Th Fr Sa Su";
 COLOR 0, 7
 LOCATE 18, 7, 0
 PRINT CHR$(204) + STRING$(64, CHR$(205)) + CHR$(185);
 OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
 GOSUB OutPutCalendar
 DO
  Key$ = ""
  WHILE Key$ = ""
   IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
    OldSecond% = VAL(MID$(TIME$, 7, 2))
    GOSUB OutPutCalendar
   END IF
   Key$ = INKEY$
  WEND
  SELECT CASE LEN(Key$)
  CASE 1
    IF Key$ = CHR$(27) THEN EXIT DO
  CASE 2
    SELECT CASE RIGHT$(Key$, 1)
    CASE CHR$(72)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 0 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(80)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 32767 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(75)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 0 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(77)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 32767 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(73)
      WorkMonth% = WorkMonth% - 1
      IF WorkMonth% < 1 THEN
       IF WorkYear% = 0 THEN
        WorkMonth% = 1
       ELSE
        WorkYear% = WorkYear% - 1
        WorkMonth% = 12
       END IF
      ELSE
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(81)
      WorkMonth% = WorkMonth% + 1
      IF WorkMonth% > 12 THEN
       IF WorkYear% = 32767 THEN
        WorkMonth% = 12
       ELSE
        WorkYear% = WorkYear% + 1
        WorkMonth% = 1
       END IF
      ELSE
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(71)
      IF WorkYear% > 0 THEN
       WorkYear% = WorkYear% - 1
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutPutCalendar
    CASE CHR$(79)
      IF WorkYear% < 32767 THEN
       WorkYear% = WorkYear% + 1
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutPutCalendar
    END SELECT
  END SELECT
 LOOP
 LOCATE 6, 8, 0
 COLOR 0, 7
 EXIT SUB
OutPutCalendar:
 LOCATE 10, 8, 0
 COLOR 7, 7
 PRINT STRING$(64, CHR$(0));
 LOCATE 10, 8, 0
 COLOR 2, 7
 PRINT STRING$(INT((64 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".")) / 2), CHR$(0)) + MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".";
 COLOR 1, 7
 FOR Index% = 1 TO 42
  Days%(Index%) = 0
 NEXT Index%
 Work% = 1
 FOR Index% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 42
  Days%(Index%) = Work%
  Work% = Work% + 1
  IF Work% = MonthDaysCount%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
 NEXT Index%
 WorkLine$ = ""
 Work% = 1
 FOR Index% = 1 TO 42
  IF Days%(Index%) = 0 THEN
   WorkLine$ = WorkLine$ + SPACE$(3)
  ELSE
   IF Days%(Index%) = WorkDay% THEN WorkLine$ = WorkLine$ + "*" + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%))) ELSE WorkLine$ = WorkLine$ + SPACE$(1) + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%)))
  END IF
  IF LEN(WorkLine$) = 21 THEN
   LOCATE 11 + Work%, 29, 0
   COLOR 7, 7
   PRINT STRING$(21, CHR$(0));
   COLOR 1, 7
   LOCATE 11 + Work%, 29, 0
   WHILE WorkLine$ <> ""
    SELECT CASE LEFT$(WorkLine$, 1)
    CASE "*"
      COLOR 14, 6
      PRINT SPACE$(1) + MID$(WorkLine$, 2, 3);
      COLOR 1, 7
      WorkLine$ = MID$(WorkLine$, 5)
    CASE ELSE
      PRINT LEFT$(WorkLine$, 1);
      WorkLine$ = MID$(WorkLine$, 2)
    END SELECT
   WEND
   PRINT WorkLine$;
   WorkLine$ = ""
   Work% = Work% + 1
  END IF
 NEXT Index%
 LOCATE 19, 8, 0
 COLOR 7, 7
 PRINT STRING$(64, CHR$(0));
 LOCATE 19, 8, 0
 COLOR 4, 7
 PRINT "Current date: " + DayName$(DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + SPACE$(1) + MonthName$(VAL(LEFT$(DATE$, 2))) + SPACE$(1) + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + ".";
 RETURN
END SUB

FUNCTION CalendarBox% (DayValue%, MonthValue%, YearValue%, Title$, Message$)
 DIM WorkDay%
 DIM WorkMonth%
 DIM WorkYear%
 DIM Days%(42)
 DIM WorkLine$
 DIM Index%
 DIM Work%
 DIM Key$
 DIM OldSecond%
 WorkDay% = DayValue%
 WorkMonth% = MonthValue%
 WorkYear% = YearValue%
 IF WorkYear% < 0 THEN WorkYear% = 0
 IF WorkMonth% < 1 THEN WorkMonth% = 1
 IF WorkMonth% > 12 THEN WorkMonth% = 12
 IF WorkDay% < 1 THEN WorkDay% = 1
 IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
 CALL MakeWindow(7, 3, 64, 18, True%, Title$, True%, Message$, True%, "ENTER=Yes, ESC=No.")
 COLOR 4, 7
 LOCATE 11, 30, 0
 PRINT "Mo Tu We Th Fr Sa Su";
 COLOR 0, 7
 LOCATE 18, 7, 0
 PRINT CHR$(204) + STRING$(64, CHR$(205)) + CHR$(185);
 OldSecond% = NOT VAL(MID$(TIME$, 7, 2))
 GOSUB OutCalendar
 DO
  Key$ = ""
  WHILE Key$ = ""
   IF OldSecond% <> VAL(MID$(TIME$, 7, 2)) THEN
    OldSecond% = VAL(MID$(TIME$, 7, 2))
    GOSUB OutCalendar
   END IF
   Key$ = INKEY$
  WEND
  SELECT CASE LEN(Key$)
  CASE 1
    SELECT CASE Key$
    CASE CHR$(13)
      DayValue% = WorkDay%
      MonthValue% = WorkMonth%
      YearValue% = WorkYear%
      CalendarBox% = True%
      EXIT DO
    CASE CHR$(27)
      CalendarBox% = False%
      EXIT DO
    END SELECT
  CASE 2
    SELECT CASE RIGHT$(Key$, 1)
    CASE CHR$(72)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 0 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(80)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 32767 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(75)
      WorkDay% = WorkDay% - 1
      IF WorkDay% < 1 THEN
       WorkMonth% = WorkMonth% - 1
       IF WorkMonth% < 1 THEN
        IF WorkYear% = 0 THEN
         WorkMonth% = 1
         WorkDay% = 1
        ELSE
         WorkYear% = WorkYear% - 1
         WorkMonth% = 12
         WorkDay% = 31
        END IF
       ELSE
        WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(77)
      WorkDay% = WorkDay% + 1
      IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN
       WorkMonth% = WorkMonth% + 1
       IF WorkMonth% > 12 THEN
        IF WorkYear% = 32767 THEN
         WorkMonth% = 12
         WorkDay% = 31
        ELSE
         WorkYear% = WorkYear% + 1
         WorkMonth% = 1
         WorkDay% = 1
        END IF
       ELSE
        WorkDay% = 1
       END IF
      END IF
      GOSUB OutCalendar
    CASE CHR$(73)
      WorkMonth% = WorkMonth% - 1
      IF WorkMonth% < 1 THEN
       IF WorkYear% = 0 THEN
        WorkMonth% = 1
       ELSE
        WorkYear% = WorkYear% - 1
        WorkMonth% = 12
       END IF
      ELSE
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutCalendar
    CASE CHR$(81)
      WorkMonth% = WorkMonth% + 1
      IF WorkMonth% > 12 THEN
       IF WorkYear% = 32767 THEN
        WorkMonth% = 12
       ELSE
        WorkYear% = WorkYear% + 1
        WorkMonth% = 1
       END IF
      ELSE
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutCalendar
    CASE CHR$(71)
      IF WorkYear% > 0 THEN
       WorkYear% = WorkYear% - 1
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutCalendar
    CASE CHR$(79)
      IF WorkYear% < 32767 THEN
       WorkYear% = WorkYear% + 1
       IF WorkDay% > MonthDaysCount%(WorkMonth%, WorkYear%) THEN WorkDay% = MonthDaysCount%(WorkMonth%, WorkYear%)
      END IF
      GOSUB OutCalendar
    END SELECT
  END SELECT
 LOOP
 LOCATE 6, 8, 0
 COLOR 0, 7
 EXIT FUNCTION
OutCalendar:
 LOCATE 10, 8, 0
 COLOR 7, 7
 PRINT STRING$(64, CHR$(0));
 LOCATE 10, 8, 0
 COLOR 2, 7
 PRINT STRING$(INT((64 - LEN(MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".")) / 2), CHR$(0)) + MonthName$(WorkMonth%) + ", " + LTRIM$(STR$(WorkYear%)) + ".";
 COLOR 1, 7
 FOR Index% = 1 TO 42
  Days%(Index%) = 0
 NEXT Index%
 Work% = 1
 FOR Index% = DayOfWeek%(1, WorkMonth%, WorkYear%) TO 42
  Days%(Index%) = Work%
  Work% = Work% + 1
  IF Work% = MonthDaysCount%(WorkMonth%, WorkYear%) + 1 THEN EXIT FOR
 NEXT Index%
 WorkLine$ = ""
 Work% = 1
 FOR Index% = 1 TO 42
  IF Days%(Index%) = 0 THEN
   WorkLine$ = WorkLine$ + SPACE$(3)
  ELSE
   IF Days%(Index%) = WorkDay% THEN WorkLine$ = WorkLine$ + "*" + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%))) ELSE WorkLine$ = WorkLine$ + SPACE$(1) + STRING$(2 - LEN(LTRIM$(STR$(Days%(Index%)))), ASC(SPACE$(1))) + LTRIM$(STR$(Days%(Index%)))
  END IF
  IF LEN(WorkLine$) = 21 THEN
   LOCATE 11 + Work%, 29, 0
   COLOR 7, 7
   PRINT STRING$(21, CHR$(0));
   COLOR 1, 7
   LOCATE 11 + Work%, 29, 0
   WHILE WorkLine$ <> ""
    SELECT CASE LEFT$(WorkLine$, 1)
    CASE "*"
      COLOR 14, 6
      PRINT SPACE$(1) + MID$(WorkLine$, 2, 3);
      COLOR 1, 7
      WorkLine$ = MID$(WorkLine$, 5)
    CASE ELSE
      PRINT LEFT$(WorkLine$, 1);
      WorkLine$ = MID$(WorkLine$, 2)
    END SELECT
   WEND
   PRINT WorkLine$;
   WorkLine$ = ""
   Work% = Work% + 1
  END IF
 NEXT Index%
 LOCATE 19, 8, 0
 COLOR 7, 7
 PRINT STRING$(64, CHR$(0));
 LOCATE 19, 8, 0
 COLOR 4, 7
 PRINT "Current date: " + DayName$(DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + SPACE$(1) + MonthName$(VAL(LEFT$(DATE$, 2))) + SPACE$(1) + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + ".";
 RETURN
END FUNCTION

SUB ClearAll
 DIM Index%
 DIM SubIndex%
 FOR Index% = 1 TO DefFnSCount%
  DefFnS$(Index%) = ""
  DefFnSArgsCountValue%(Index%) = 0
  FOR SubIndex% = 1 TO DefFnSArgsCount%
   DefFnSArgs$(Index%, SubIndex%) = ""
  NEXT SubIndex%
 NEXT Index%
 FOR Index% = 1 TO VariablesCount%
  Variables$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO FilesCount%
  OpenFiles$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO WhilesCount%
  Whiles$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO FromsCount%
  Froms$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO GoSubSCount%
  GoSubS%(Index%) = 0
 NEXT Index%
 GoSubSCountValue% = 0
 CurrentLine% = 0
 DefFnSCountValue% = 0
 CurrentDefFn% = 0
 VariablesCountValue% = 0
 NumStr% = False%
 RunMode% = False%
 TraceMode% = False%
 DefFnMode% = False%
 CALL ClearANSI(True%)
END SUB

SUB ClearANSI (ClearCursor%)
 DIM Index%
 IF ClearCursor% THEN
  CursorRow% = 0
  CursorColumn% = 0
  CursorSaved% = False%
 END IF
 FOR Index% = 1 TO ArgumentsCount%
  Arguments%(Index%) = 0
 NEXT Index%
 ArgumentsCountValue% = 0
 NumberLine$ = ""
 ANSIMode% = 0
END SUB

SUB Control
 IF TextPosition% < 1 THEN TextPosition% = 1
 IF PagePosition% < 1 THEN PagePosition% = 1
 IF LinePosition% < 1 THEN LinePosition% = 1
 IF CursorPosition% < 1 THEN CursorPosition% = 1
 IF TextPosition% > TextLines% THEN TextPosition% = TextLines%
 IF PagePosition% > 20 THEN PagePosition% = 20
 IF LinePosition% > LEN(Text$(TextPosition%)) + 1 THEN LinePosition% = LEN(Text$(TextPosition%)) + 1
 IF LEN(Text$(TextPosition%)) < 78 THEN IF CursorPosition% > LEN(Text$(TextPosition%)) + 1 THEN CursorPosition% = LEN(Text$(TextPosition%)) + 1
 IF LEN(Text$(TextPosition%)) > 76 THEN IF CursorPosition% > 77 THEN CursorPosition% = 77
 CALL ScratchScreen
END SUB

SUB CursorDown
 TextPosition% = TextPosition% + 1
 PagePosition% = PagePosition% + 1
 CALL Control
END SUB

SUB CursorEnd
 LinePosition% = LEN(Text$(TextPosition%)) + 1
 CursorPosition% = LEN(Text$(TextPosition%)) + 1
 CALL Control
END SUB

SUB CursorHome
 LinePosition% = 1
 CursorPosition% = 1
 CALL ScratchScreen
END SUB

SUB CursorLeft
 IF LinePosition% = 1 THEN
  IF TextPosition% = 1 THEN EXIT SUB
  TextPosition% = TextPosition% - 1
  PagePosition% = PagePosition% - 1
  LinePosition% = LEN(Text$(TextPosition%)) + 1
  CursorPosition% = LEN(Text$(TextPosition%)) + 1
 ELSE
  LinePosition% = LinePosition% - 1
  CursorPosition% = CursorPosition% - 1
 END IF
 CALL Control
END SUB

SUB CursorRight
 IF LinePosition% = LEN(Text$(TextPosition%)) + 1 THEN
  IF TextPosition% > TextLines% - 1 THEN EXIT SUB
  TextPosition% = TextPosition% + 1
  PagePosition% = PagePosition% + 1
  LinePosition% = 1
  CursorPosition% = 1
 ELSE
  LinePosition% = LinePosition% + 1
  CursorPosition% = CursorPosition% + 1
 END IF
 CALL Control
END SUB

SUB CursorUp
 TextPosition% = TextPosition% - 1
 PagePosition% = PagePosition% - 1
 CALL Control
END SUB

FUNCTION DayName$ (DayNumber%)
 SELECT CASE DayNumber%
 CASE 1
   DayName$ = "Monday"
 CASE 2
   DayName$ = "Tuesday"
 CASE 3
   DayName$ = "Wednesday"
 CASE 4
   DayName$ = "Thursday"
 CASE 5
   DayName$ = "Friday"
 CASE 6
   DayName$ = "Saturday"
 CASE 7
   DayName$ = "Sunday"
 END SELECT
END FUNCTION

FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
 SELECT CASE DaysCount#(DayValue%, MonthValue%, YearValue%) - (INT(DaysCount#(DayValue%, MonthValue%, YearValue%) / 7) * 7)
 CASE 0
   DayOfWeek% = 6
 CASE 1
   DayOfWeek% = 7
 CASE 2
   DayOfWeek% = 1
 CASE 3
   DayOfWeek% = 2
 CASE 4
   DayOfWeek% = 3
 CASE 5
   DayOfWeek% = 4
 CASE 6
   DayOfWeek% = 5
 END SELECT
END FUNCTION

FUNCTION DaysCount# (DayValue%, MonthValue%, YearValue%)
 DaysCount# = MonthDays%(MonthValue%, YearValue%) + (YearValue% * 365!) + INT(YearValue% / 4) + INT(YearValue% / 100) + DayValue%
END FUNCTION

SUB DeleteBackSymbol
 DIM Length%
 DIM Index%
 IF LinePosition% = 1 THEN
  IF TextPosition% = 1 THEN EXIT SUB
  IF LEN(Text$(TextPosition%)) = LineLength% THEN EXIT SUB
  Length% = LEN(Text$(TextPosition% - 1))
  Text$(TextPosition% - 1) = Text$(TextPosition% - 1) + LEFT$(Text$(TextPosition%), LineLength% - LEN(Text$(TextPosition% - 1)))
  Text$(TextPosition%) = MID$(Text$(TextPosition%), LineLength% - Length%)
  IF Text$(TextPosition%) = "" THEN
   FOR Index% = TextPosition% TO TextLines% - 1
    Text$(Index%) = Text$(Index% + 1)
    Text$(Index% + 1) = ""
   NEXT Index%
  END IF
  TextPosition% = TextPosition% - 1
  PagePosition% = PagePosition% - 1
  LinePosition% = Length% + 1
  CursorPosition% = Length% + 1
  CALL Control
 ELSE
  LinePosition% = LinePosition% - 1
  CursorPosition% = CursorPosition% - 1
  Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, LinePosition% - 1) + MID$(Text$(TextPosition%), LinePosition% + 1)
  CALL ScratchScreen
 END IF
END SUB

SUB DeleteCurrentSymbol
 DIM Length%
 DIM Index%
 IF LinePosition% = LEN(Text$(TextPosition%)) + 1 THEN
  IF TextPosition% > TextLines% - 1 THEN EXIT SUB
  IF LEN(Text$(TextPosition%)) = LineLength% THEN EXIT SUB
  Length% = LEN(Text$(TextPosition%))
  Text$(TextPosition%) = Text$(TextPosition%) + LEFT$(Text$(TextPosition% + 1), LineLength% - LEN(Text$(TextPosition%)))
  Text$(TextPosition% + 1) = MID$(Text$(TextPosition% + 1), LineLength% - Length%)
  IF Text$(TextPosition% + 1) = "" THEN
   FOR Index% = TextPosition% + 1 TO TextLines% - 1
    Text$(Index%) = Text$(Index% + 1)
    Text$(Index% + 1) = ""
   NEXT Index%
  END IF
 ELSE
  Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, LinePosition% - 1) + MID$(Text$(TextPosition%), LinePosition% + 1)
 END IF
 CALL ScratchScreen
END SUB

FUNCTION EvaluateCalculate$ (InLine$)
 DIM Result$
 DIM Value$
 DIM WorkLine$
 DIM ControlNumStr%
 Result$ = EvaluateInMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "*"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = EvaluateInMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) * VAL(Value$)))
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    ControlNumStr% = NumStr%
    Value$ = EvaluateInMeaning$(InLine$)
    IF ControlNumStr% <> NumStr% THEN ERROR 13
    IF NumStr% THEN Result$ = Result$ + Value$ ELSE Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
  CASE "-"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = EvaluateInMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) - VAL(Value$)))
  CASE "/"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = EvaluateInMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "\"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = EvaluateInMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "^"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = EvaluateInMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) ^ VAL(Value$)))
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ >= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) >= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ = Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) = VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <> Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <> VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ >= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) >= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ > Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) > VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    ControlNumStr% = NumStr%
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <> Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <> VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ <= Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) <= VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    CASE ELSE
      Value$ = EvaluateInMeaning$(InLine$)
      IF ControlNumStr% <> NumStr% THEN ERROR 13
      IF NumStr% THEN
       IF Result$ < Value$ THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      ELSE
       IF VAL(Result$) < VAL(Value$) THEN Result$ = LTRIM$(STR$(True%)) ELSE Result$ = LTRIM$(STR$(False%))
      END IF
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    WorkLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      IF NumStr% THEN ERROR 13
      Value$ = EvaluateInMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) AND VAL(Value$)))
    CASE "MOD"
      IF NumStr% THEN ERROR 13
      Value$ = EvaluateInMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) MOD VAL(Value$)))
    CASE "OR"
      IF NumStr% THEN ERROR 13
      Value$ = EvaluateInMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) OR VAL(Value$)))
    CASE "XOR"
      IF NumStr% THEN ERROR 13
      Value$ = EvaluateInMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) XOR VAL(Value$)))
    CASE ELSE
      InLine$ = WorkLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 EvaluateCalculate$ = Result$
END FUNCTION

FUNCTION EvaluateInMeaning$ (InLine$)
 DIM Crc32Table&(256)
 DIM Crc&
 DIM CrcIndex%
 DIM Count%
 DIM Index%
 DIM WorkValue%
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   EvaluateInMeaning$ = MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
   NumStr% = True%
 CASE "+"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   Result$ = EvaluateCalculate$(InLine$)
   IF NumStr% THEN ERROR 13
   EvaluateInMeaning$ = LTRIM$(STR$(0# + VAL(Result$)))
 CASE "-"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   Result$ = EvaluateCalculate$(InLine$)
   IF NumStr% THEN ERROR 13
   EvaluateInMeaning$ = LTRIM$(STR$(0# - VAL(Result$)))
 CASE "."
   NumStr% = False%
   EvaluateInMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "&"
   NumStr% = False%
   EvaluateInMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "0" TO "9"
   NumStr% = False%
   EvaluateInMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "("
   InLine$ = MID$(InLine$, 2)
   EvaluateInMeaning$ = EvaluateCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    Result$ = EvaluateCalculate$(InLine$)
    IF NumStr% THEN ERROR 13
    EvaluateInMeaning$ = LTRIM$(STR$(NOT VAL(Result$)))
   ELSE
    NumStr% = False%
    SELECT CASE LEFT$(InLine$, 1)
    CASE "$"
      NumStr% = True%
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "!"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "@"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "%"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "&"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    END SELECT
    IF NumStr% THEN
     SELECT CASE WorkName$
     CASE "CHR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = CHR$(VAL(Result$))
       NumStr% = True%
     CASE "DATE"
       EvaluateInMeaning$ = DATE$
     CASE "DAYNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = DayName$(VAL(Result$))
       NumStr% = True%
     CASE "DAYOFWEEKNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       EvaluateInMeaning$ = DayName$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$)))
       NumStr% = True%
     CASE "ENVIRONMENT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN EvaluateInMeaning$ = ENVIRON$(Result$) ELSE EvaluateInMeaning$ = ENVIRON$(VAL(Result$))
       NumStr% = True%
     CASE "HEX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = HEX$(VAL(Result$))
       NumStr% = True%
     CASE "INPUT"
       Result$ = ""
       IF InputBox%("GNU BASIC Interpretter.", "Please enter line.", Result$) THEN EvaluateInMeaning$ = Result$ ELSE EvaluateInMeaning$ = ""
     CASE "LCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LCASE$(Result$)
     CASE "LTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(Result$)
     CASE "LEFT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LEFT$(Result$, VAL(Value$))
       NumStr% = True%
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = EvaluateCalculate$(InLine$)
          IF NOT NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF Value$ > Result$ THEN Result$ = Value$
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = Result$
     CASE "MID"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = MID$(Result$, VAL(Value$), VAL(Meaning$))
       NumStr% = True%
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = EvaluateCalculate$(InLine$)
          IF NOT NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF Value$ < Result$ THEN Result$ = Value$
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = Result$
     CASE "MONTHNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = MonthName$(VAL(Result$))
       NumStr% = True%
     CASE "OCT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = OCT$(VAL(Result$))
       NumStr% = True%
     CASE "RTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = RTRIM$(Result$)
     CASE "RIGHT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = RIGHT$(Result$, VAL(Value$))
       NumStr% = True%
     CASE "SPACE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = SPACE$(VAL(Result$))
       NumStr% = True%
     CASE "STR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(VAL(Result$)))
       NumStr% = True%
     CASE "STRING"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = EvaluateCalculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN EvaluateInMeaning$ = STRING$(VAL(Result$), Value$) ELSE EvaluateInMeaning$ = STRING$(VAL(Result$), VAL(Value$))
       NumStr% = True%
     CASE "TIME"
       EvaluateInMeaning$ = TIME$
     CASE "TRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(RTRIM$(Result$))
     CASE "UCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = UCASE$(Result$)
     END SELECT
    ELSE
     SELECT CASE WorkName$
     CASE "FALSE"
       EvaluateInMeaning$ = LTRIM$(STR$(False%))
     CASE "TRUE"
       EvaluateInMeaning$ = LTRIM$(STR$(True%))
     CASE "PI"
       EvaluateInMeaning$ = "3.1415926535897932384626433832795"
     CASE "BLACK"
       EvaluateInMeaning$ = LTRIM$(STR$(Black%))
     CASE "BLUE"
       EvaluateInMeaning$ = LTRIM$(STR$(Blue%))
     CASE "BRIGHTWHITE"
       EvaluateInMeaning$ = LTRIM$(STR$(BrightWhite%))
     CASE "BROWN"
       EvaluateInMeaning$ = LTRIM$(STR$(Brown%))
     CASE "CYAN"
       EvaluateInMeaning$ = LTRIM$(STR$(Cyan%))
     CASE "GRAY"
       EvaluateInMeaning$ = LTRIM$(STR$(Gray%))
     CASE "GREEN"
       EvaluateInMeaning$ = LTRIM$(STR$(Green%))
     CASE "LIGHTBLUE"
       EvaluateInMeaning$ = LTRIM$(STR$(LightBlue%))
     CASE "LIGHTCYAN"
       EvaluateInMeaning$ = LTRIM$(STR$(LightCyan%))
     CASE "LIGHTGREEN"
       EvaluateInMeaning$ = LTRIM$(STR$(LightGreen%))
     CASE "LIGHTMAGENTA"
       EvaluateInMeaning$ = LTRIM$(STR$(LightMagenta%))
     CASE "LIGHTRED"
       EvaluateInMeaning$ = LTRIM$(STR$(LightRed%))
     CASE "MAGENTA"
       EvaluateInMeaning$ = LTRIM$(STR$(Magenta%))
     CASE "RED"
       EvaluateInMeaning$ = LTRIM$(STR$(Red%))
     CASE "WHITE"
       EvaluateInMeaning$ = LTRIM$(STR$(White%))
     CASE "YELLOW"
       EvaluateInMeaning$ = LTRIM$(STR$(Yellow%))
     CASE "ATN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(ATN(VAL(Result$))))
     CASE "ABS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(ABS(VAL(Result$))))
     CASE "ASC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF Result$ = "" THEN ERROR 5
       EvaluateInMeaning$ = LTRIM$(STR$(ASC(Result$)))
       NumStr% = False%
     CASE "AVG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       Count% = 1
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = EvaluateCalculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
          Count% = Count% + 1
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(VAL(Result$) / Count%))
     CASE "COS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(COS(VAL(Result$))))
     CASE "CRC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       FOR Index% = 1 TO 256
        Crc& = Index% - 1
        FOR CrcIndex% = 1 TO 8
         IF ((INT(Crc& / 2) * 2) <> Crc&) THEN Crc& = INT(Crc& / 2) XOR &HEDB88320 ELSE Crc& = INT(Crc& / 2)
        NEXT CrcIndex%
        Crc32Table&(Index%) = Crc&
       NEXT Index%
       Crc& = &HFFFFFFFF
       WHILE Result$ <> ""
        WorkValue% = ABS((Crc& MOD &H100) XOR ASC(Result$))
        Result$ = MID$(Result$, 2)
        IF WorkValue% < 0 THEN WorkValue% = 0
        IF WorkValue% > 255 THEN WorkValue% = 255
        Crc& = Crc32Table&(WorkValue% + 1) XOR INT(Crc& / &H100)
       WEND
       EvaluateInMeaning$ = LTRIM$(STR$(Crc&))
       NumStr% = False%
     CASE "DAYOFWEEK"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       EvaluateInMeaning$ = LTRIM$(STR$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "EXP"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(EXP(VAL(Result$))))
     CASE "FIX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(FIX(VAL(Result$))))
     CASE "INSTR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(INSTR(Result$, Value$)))
       NumStr% = False%
     CASE "INT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(INT(VAL(Result$))))
     CASE "ISLEAPYEAR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (INT(INT(VAL(Result$)) / 4) * 4) = INT(VAL(Result$)) THEN EvaluateInMeaning$ = LTRIM$(STR$(True%)) ELSE EvaluateInMeaning$ = LTRIM$(STR$(False%))
     CASE "LEN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(LEN(Result$)))
       NumStr% = False%
     CASE "LOG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(LOG(VAL(Result$))))
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = EvaluateCalculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF VAL(Value$) > VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = Result$
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = EvaluateCalculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF VAL(Value$) < VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = Result$
     CASE "RANDOM"
       EvaluateInMeaning$ = LTRIM$(STR$(RND))
     CASE "SGN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(SGN(VAL(Result$))))
     CASE "SIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(SIN(VAL(Result$))))
     CASE "SQR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(SquareRoot#(VAL(Result$))))
     CASE "TAN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(TAN(VAL(Result$))))
     CASE "TIMER"
       EvaluateInMeaning$ = LTRIM$(STR$(TIMER))
     CASE "TIMERDATA"
       EvaluateInMeaning$ = LTRIM$(STR$(InTimerValue&))
     CASE "VAL"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       EvaluateInMeaning$ = LTRIM$(STR$(VAL(Result$)))
       NumStr% = False%
     CASE "WEEKNUMBER"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = EvaluateCalculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       EvaluateInMeaning$ = LTRIM$(STR$(WeekNumber%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     END SELECT
    END IF
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION EvaluateParseCalculate$ (InLine$)
 DIM Result$
 DIM WorkLine$
 Result$ = EvaluateParseInMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "*"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "*" + EvaluateParseInMeaning$(InLine$)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "+" + EvaluateParseInMeaning$(InLine$)
  CASE "-"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "-" + EvaluateParseInMeaning$(InLine$)
  CASE "/"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + EvaluateParseInMeaning$(InLine$)
  CASE "\"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + EvaluateParseInMeaning$(InLine$)
  CASE "^"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "^" + EvaluateParseInMeaning$(InLine$)
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + EvaluateParseInMeaning$(InLine$)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + EvaluateParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "=" + EvaluateParseInMeaning$(InLine$)
    END SELECT
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + EvaluateParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + EvaluateParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + ">" + EvaluateParseInMeaning$(InLine$)
    END SELECT
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + EvaluateParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + EvaluateParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "<" + EvaluateParseInMeaning$(InLine$)
    END SELECT
  CASE "A" TO "Z"
    WorkLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      Result$ = Result$ + " And " + EvaluateParseInMeaning$(InLine$)
    CASE "MOD"
      Result$ = Result$ + " Mod " + EvaluateParseInMeaning$(InLine$)
    CASE "OR"
      Result$ = Result$ + " Or " + EvaluateParseInMeaning$(InLine$)
    CASE "XOR"
      Result$ = Result$ + " XOr " + EvaluateParseInMeaning$(InLine$)
    CASE ELSE
      InLine$ = WorkLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 EvaluateParseCalculate$ = Result$
END FUNCTION

FUNCTION EvaluateParseInMeaning$ (InLine$)
 DIM Result$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   EvaluateParseInMeaning$ = CHR$(34) + MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1) + CHR$(34)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   EvaluateParseInMeaning$ = EvaluateParseCalculate$(InLine$)
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   EvaluateParseInMeaning$ = "-" + EvaluateParseCalculate$(InLine$)
 CASE "."
   EvaluateParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "&"
   EvaluateParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "0" TO "9"
   EvaluateParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   EvaluateParseInMeaning$ = "(" + EvaluateParseCalculate$(InLine$) + ")"
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF Result$ = "NOT" THEN
    EvaluateParseInMeaning$ = "Not " + EvaluateParseCalculate$(InLine$)
   ELSE
    Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
    SELECT CASE LEFT$(InLine$, 1)
    CASE "$"
      Result$ = Result$ + "$"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "!"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "@"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "%"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "&"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    END SELECT
    IF LEFT$(InLine$, 1) = "(" THEN
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "("
     DO WHILE InLine$ <> ""
      Result$ = Result$ + EvaluateParseCalculate$(InLine$)
      InLine$ = LTRIM$(InLine$)
      SELECT CASE LEFT$(InLine$, 1)
      CASE ","
        InLine$ = MID$(InLine$, 2)
        Result$ = Result$ + ","
      CASE ")"
        Result$ = Result$ + ")"
        EXIT DO
      CASE ELSE
        ERROR 2
      END SELECT
      InLine$ = LTRIM$(InLine$)
     LOOP
     IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
     InLine$ = MID$(InLine$, 2)
    END IF
    EvaluateParseInMeaning$ = Result$
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION FindLine% (NumberOfLine%, LabelName$, NameNumber%)
 DIM Index%
 DIM LineNumber%
 DIM WorkLine$
 DIM Work$
 FOR Index% = 1 TO TextLines% + 1
  IF Index% = TextLines% + 1 THEN ERROR 49
  IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
   WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
   SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
   CASE "0" TO "9"
     LineNumber% = INT(InNumber#(WorkLine$))
     WorkLine$ = LTRIM$(WorkLine$)
     IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
     IF WorkLine$ = "" THEN ERROR 39
     IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
     WorkLine$ = ParseRunLine$(WorkLine$)
     IF NameNumber% THEN
      IF InName$(WorkLine$) = "LABEL" THEN
       Work$ = Calculate$(WorkLine$)
       IF NOT NumStr% THEN ERROR 13
       IF Work$ = LabelName$ THEN EXIT FOR
      END IF
     ELSE
      IF LineNumber% = NumberOfLine% THEN EXIT FOR
     END IF
   CASE "A" TO "Z"
     WorkLine$ = ParseRunLine$(WorkLine$)
     IF InName$(WorkLine$) = "LABEL" THEN
      Work$ = Calculate$(WorkLine$)
      IF NOT NumStr% THEN ERROR 13
      IF Work$ = LabelName$ THEN EXIT FOR
     END IF
   CASE ELSE
     ERROR 39
   END SELECT
  END IF
 NEXT Index%
 FindLine% = Index%
END FUNCTION

SUB Hang
 DIM HangCode%(32)
 DIM Index%
 DIM HangCode$
 HangCode$ = "BA0000529DBF40008EC7BF000026C6050083C70181FF010475F3B80000509D"
 HangCode$ = HangCode$ + "BB0000B90000BA0000BD0000BC0000BE0000BF00008EDA8EC7"
 HangCode$ = HangCode$ + "8ED4F0F4CD20CB"
 Index% = 0
 DEF SEG = VARSEG(HangCode%(1))
 WHILE HangCode$ <> ""
  POKE VARPTR(HangCode%(1)) + Index%, VAL("&H" + LEFT$(HangCode$, 2))
  Index% = Index% + 1
  HangCode$ = MID$(HangCode$, 3)
 WEND
 CALL Absolute(VARPTR(HangCode%(1)))
END SUB

FUNCTION InDefFn$ (DefFnName$, DefFnType%, InLine$)
 DIM Index%
 DIM LineNumber%
 DIM WorkDefFn$
 DIM OldDefFnMode%
 DIM WorkLine$
 DIM Work%
 DIM Work$
 DIM FunctionName$
 DIM OldCurrentLine%
 DIM DefFnLine%
 DIM DefFnResult$
 IF SearchDefFn%(DefFnName$, DefFnType%) = 0 THEN
  IF NOT RunMode% THEN ERROR 15
  FOR Index% = 1 TO TextLines% + 1
   IF Index% = TextLines% + 1 THEN ERROR 15
   IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
    WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
    SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
    CASE "0" TO "9"
      LineNumber% = INT(InNumber#(WorkLine$))
      WorkLine$ = LTRIM$(WorkLine$)
      IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
      IF WorkLine$ = "" THEN ERROR 39
      IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
      WorkDefFn$ = ParseRunLine$(WorkLine$)
    CASE "A" TO "Z"
      WorkDefFn$ = ParseRunLine$(WorkLine$)
    CASE ELSE
      ERROR 39
    END SELECT
    IF InName$(WorkDefFn$) = "DEF" THEN
     FunctionName$ = InName$(WorkDefFn$)
     IF LEFT$(FunctionName$, 2) <> "FN" THEN ERROR 48
     WorkDefFn$ = LTRIM$(WorkDefFn$)
     Work% = False%
     SELECT CASE LEFT$(WorkDefFn$, 1)
     CASE "$"
       Work% = True%
       WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
     CASE "!"
       WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
     CASE "@"
       WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
     CASE "#"
       WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
     CASE "%"
       WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
     CASE "&"
       WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
     END SELECT
     IF (FunctionName$ = DefFnName$) AND (Work% = DefFnType%) THEN EXIT FOR
    END IF
   END IF
  NEXT Index%
  DefFnLine% = Index%
  IF CurrentDefFn% = DefFnSCount% THEN ERROR 21
  CurrentDefFn% = CurrentDefFn% + 1
  DefFnSArgsCountValue%(CurrentDefFn%) = 0
  FOR Index% = 1 TO DefFnSArgsCount%
   DefFnSArgs$(CurrentDefFn%, Index%) = ""
  NEXT Index%
  IF LEFT$(WorkDefFn$, 1) = "(" THEN
   WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   DefFnSArgsCountValue%(CurrentDefFn%) = 1
   DO WHILE WorkDefFn$ <> ""
    Work$ = InName$(WorkDefFn$)
    WorkDefFn$ = LTRIM$(WorkDefFn$)
    Work% = False%
    SELECT CASE LEFT$(WorkDefFn$, 1)
    CASE "$"
      Work% = True%
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "!"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "@"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "#"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "%"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "&"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    END SELECT
    DefFnSArgs$(CurrentDefFn%, DefFnSArgsCountValue%(CurrentDefFn%)) = Work$ + "[" + LTRIM$(STR$(ABS(Work%))) + "]="
    SELECT CASE LEFT$(WorkDefFn$, 1)
    CASE ","
      IF DefFnSArgsCountValue%(CurrentDefFn%) = DefFnSArgsCount% THEN ERROR 22
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
      DefFnSArgsCountValue%(CurrentDefFn%) = DefFnSArgsCountValue%(CurrentDefFn%) + 1
    CASE ")"
      EXIT DO
    CASE ELSE
      ERROR 2
    END SELECT
   LOOP
   IF DefFnSArgs$(CurrentDefFn%, DefFnSArgsCountValue%(CurrentDefFn%)) = "" THEN ERROR 2
   IF LEFT$(WorkDefFn$, 1) <> ")" THEN ERROR 2
   WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   Index% = 1
   DO WHILE InLine$ <> ""
    Work$ = Calculate$(InLine$)
    IF ABS(NumStr%) <> VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) THEN ERROR 13
    DefFnSArgs$(CurrentDefFn%, Index%) = DefFnSArgs$(CurrentDefFn%, Index%) + Work$
    InLine$ = LTRIM$(InLine$)
    SELECT CASE LEFT$(InLine$, 1)
    CASE ","
      IF Index% = DefFnSArgsCountValue%(CurrentDefFn%) THEN ERROR 37
      InLine$ = MID$(InLine$, 2)
      Index% = Index% + 1
    CASE ")"
      IF Index% <> DefFnSArgsCountValue%(CurrentDefFn%) THEN ERROR 37
      EXIT DO
    CASE ELSE
      ERROR 2
    END SELECT
   LOOP
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
  END IF
  OldDefFnMode% = DefFnMode%
  DefFnMode% = True%
  IF LEFT$(WorkDefFn$, 1) = "=" THEN
   WorkDefFn$ = MID$(WorkDefFn$, 2)
   InDefFn$ = Calculate$(WorkDefFn$)
   IF NumStr% <> DefFnType% THEN ERROR 13
  ELSE
   OldCurrentLine% = CurrentLine%
   CurrentLine% = DefFnLine% + 1
   IF DefFnType% THEN DefFnResult$ = "" ELSE DefFnResult$ = "0.0"
   DO
    IF LTRIM$(RTRIM$(Text$(CurrentLine%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(CurrentLine%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       WorkLine$ = LTRIM$(WorkLine$)
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
       IF WorkLine$ = "" THEN ERROR 39
       IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
       WorkLine$ = ParseRunLine$(WorkLine$)
       IF TraceMode% THEN PRINT "[" + LTRIM$(STR$(LineNumber%)) + "]";
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE ELSE
       ERROR 39
     END SELECT
     Work$ = InName$(WorkLine$)
     WorkLine$ = LTRIM$(WorkLine$)
     SELECT CASE Work$
     CASE "EXIT"
       IF WorkLine$ <> "" THEN IF InName$(WorkLine$) = "DEF" THEN EXIT DO
     CASE "END"
       IF WorkLine$ <> "" THEN IF InName$(WorkLine$) = "DEF" THEN EXIT DO
     CASE ELSE
       IF Work$ = DefFnName$ THEN
        Work% = False%
        SELECT CASE LEFT$(WorkLine$, 1)
        CASE "$"
          Work% = True%
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "!"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "@"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "#"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "%"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "&"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        END SELECT
        IF LEFT$(WorkLine$, 1) <> "=" THEN ERROR 2
        WorkLine$ = MID$(WorkLine$, 2)
        IF Work% <> DefFnType% THEN ERROR 41
        DefFnResult$ = Calculate$(WorkLine$)
        IF NumStr% <> Work% THEN ERROR 13
       ELSE
        IF LTRIM$(RTRIM$(Text$(CurrentLine%))) <> "" THEN
         WorkLine$ = LTRIM$(RTRIM$(Text$(CurrentLine%)))
         SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
         CASE "0" TO "9"
           LineNumber% = INT(InNumber#(WorkLine$))
           WorkLine$ = LTRIM$(WorkLine$)
           IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
           IF WorkLine$ = "" THEN ERROR 39
           IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
           WorkLine$ = ParseRunLine$(WorkLine$)
         CASE "A" TO "Z"
           WorkLine$ = ParseRunLine$(WorkLine$)
         CASE ELSE
           ERROR 39
         END SELECT
         CALL RunLine(WorkLine$)
        END IF
       END IF
     END SELECT
    END IF
    CurrentLine% = CurrentLine% + 1
   LOOP UNTIL (CurrentLine% > TextLines%) OR (NOT RunMode%)
   CurrentLine% = OldCurrentLine%
   InDefFn$ = DefFnResult$
  END IF
  DefFnMode% = OldDefFnMode%
  DefFnSArgsCountValue%(CurrentDefFn%) = 0
  FOR Index% = 1 TO DefFnSArgsCount%
   DefFnSArgs$(CurrentDefFn%, Index%) = ""
  NEXT Index%
  CurrentDefFn% = CurrentDefFn% - 1
  NumStr% = DefFnType%
 ELSE
  WorkDefFn$ = DefFnS$(SearchDefFn%(DefFnName$, DefFnType%))
  WorkLine$ = InName$(WorkDefFn$)
  WorkDefFn$ = LTRIM$(WorkDefFn$)
  Work% = False%
  SELECT CASE LEFT$(WorkDefFn$, 1)
  CASE "$"
    Work% = True%
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "!"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "@"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "#"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "%"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "&"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  END SELECT
  IF CurrentDefFn% = DefFnSCount% THEN ERROR 21
  CurrentDefFn% = CurrentDefFn% + 1
  DefFnSArgsCountValue%(CurrentDefFn%) = 0
  FOR Index% = 1 TO DefFnSArgsCount%
   DefFnSArgs$(CurrentDefFn%, Index%) = ""
  NEXT Index%
  IF LEFT$(WorkDefFn$, 1) = "(" THEN
   WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   DefFnSArgsCountValue%(CurrentDefFn%) = 1
   DO WHILE WorkDefFn$ <> ""
    WorkLine$ = InName$(WorkDefFn$)
    WorkDefFn$ = LTRIM$(WorkDefFn$)
    Work% = False%
    SELECT CASE LEFT$(WorkDefFn$, 1)
    CASE "$"
      Work% = True%
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "!"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "@"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "#"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "%"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    CASE "&"
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
    END SELECT
    DefFnSArgs$(CurrentDefFn%, DefFnSArgsCountValue%(CurrentDefFn%)) = WorkLine$ + "[" + LTRIM$(STR$(ABS(Work%))) + "]="
    SELECT CASE LEFT$(WorkDefFn$, 1)
    CASE ","
      IF DefFnSArgsCountValue%(CurrentDefFn%) = DefFnSArgsCount% THEN ERROR 22
      WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
      DefFnSArgsCountValue%(CurrentDefFn%) = DefFnSArgsCountValue%(CurrentDefFn%) + 1
    CASE ")"
      EXIT DO
    CASE ELSE
      ERROR 2
    END SELECT
   LOOP
   IF DefFnSArgs$(CurrentDefFn%, DefFnSArgsCountValue%(CurrentDefFn%)) = "" THEN ERROR 2
   IF LEFT$(WorkDefFn$, 1) <> ")" THEN ERROR 2
   WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   Index% = 1
   DO WHILE InLine$ <> ""
    WorkLine$ = Calculate$(InLine$)
    IF ABS(NumStr%) <> VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) THEN ERROR 13
    DefFnSArgs$(CurrentDefFn%, Index%) = DefFnSArgs$(CurrentDefFn%, Index%) + WorkLine$
    InLine$ = LTRIM$(InLine$)
    SELECT CASE LEFT$(InLine$, 1)
    CASE ","
      IF Index% = DefFnSArgsCountValue%(CurrentDefFn%) THEN ERROR 37
      InLine$ = MID$(InLine$, 2)
      Index% = Index% + 1
    CASE ")"
      IF Index% <> DefFnSArgsCountValue%(CurrentDefFn%) THEN ERROR 37
      EXIT DO
    CASE ELSE
      ERROR 2
    END SELECT
   LOOP
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
  END IF
  IF LEFT$(WorkDefFn$, 1) <> "=" THEN ERROR 2
  WorkDefFn$ = MID$(WorkDefFn$, 2)
  OldDefFnMode% = DefFnMode%
  DefFnMode% = True%
  InDefFn$ = Calculate$(WorkDefFn$)
  IF NumStr% <> DefFnType% THEN ERROR 13
  DefFnMode% = OldDefFnMode%
  DefFnSArgsCountValue%(CurrentDefFn%) = 0
  FOR Index% = 1 TO DefFnSArgsCount%
   DefFnSArgs$(CurrentDefFn%, Index%) = ""
  NEXT Index%
  CurrentDefFn% = CurrentDefFn% - 1
 END IF
END FUNCTION

FUNCTION InMeaning$ (InLine$)
 DIM Crc32Table&(256)
 DIM Crc&
 DIM CrcIndex%
 DIM Count%
 DIM Index%
 DIM WorkValue%
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   InMeaning$ = MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
   NumStr% = True%
 CASE "+"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InMeaning$ = LTRIM$(STR$(0# + VAL(Result$)))
 CASE "-"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InMeaning$ = LTRIM$(STR$(0# - VAL(Result$)))
 CASE "."
   NumStr% = False%
   InMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "&"
   NumStr% = False%
   InMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "0" TO "9"
   NumStr% = False%
   InMeaning$ = LTRIM$(STR$(InNumber#(InLine$)))
 CASE "("
   InLine$ = MID$(InLine$, 2)
   InMeaning$ = Calculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    InMeaning$ = LTRIM$(STR$(NOT VAL(Result$)))
   ELSE
    NumStr% = False%
    SELECT CASE LEFT$(InLine$, 1)
    CASE "$"
      NumStr% = True%
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "!"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "@"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "%"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "&"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    END SELECT
    IF NumStr% THEN
     SELECT CASE WorkName$
     CASE "CHR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = CHR$(VAL(Result$))
       NumStr% = True%
     CASE "DATE"
       InMeaning$ = DATE$
     CASE "DAYNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = DayName$(VAL(Result$))
       NumStr% = True%
     CASE "DAYOFWEEKNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = DayName$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$)))
       NumStr% = True%
     CASE "ENVIRONMENT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaning$ = ENVIRON$(Result$) ELSE InMeaning$ = ENVIRON$(VAL(Result$))
       NumStr% = True%
     CASE "HEX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = HEX$(VAL(Result$))
       NumStr% = True%
     CASE "INKEY"
       InMeaning$ = INKEY$
     CASE "INPUT"
       IF LEFT$(InLine$, 1) = "(" THEN
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
        InLine$ = MID$(InLine$, 2)
        Result$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
        InLine$ = MID$(InLine$, 2)
        IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
        IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 52
        IF MID$(OpenFiles$(INT(VAL(Result$))), 1, INSTR(OpenFiles$(INT(VAL(Result$))), "=") - 1) = "OUT" THEN ERROR 54
        LINE INPUT #INT(VAL(Result$)), Result$
        NumStr% = True%
       ELSE
        LINE INPUT Result$
       END IF
       InMeaning$ = Result$
     CASE "LCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LCASE$(Result$)
     CASE "LTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(Result$)
     CASE "LEFT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LEFT$(Result$, VAL(Value$))
       NumStr% = True%
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NOT NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF Value$ > Result$ THEN Result$ = Value$
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = Result$
     CASE "MID"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = MID$(Result$, VAL(Value$), VAL(Meaning$))
       NumStr% = True%
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NOT NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF Value$ < Result$ THEN Result$ = Value$
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = Result$
     CASE "MONTHNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = MonthName$(VAL(Result$))
       NumStr% = True%
     CASE "OCT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = OCT$(VAL(Result$))
       NumStr% = True%
     CASE "RTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = RTRIM$(Result$)
     CASE "RIGHT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = RIGHT$(Result$, VAL(Value$))
       NumStr% = True%
     CASE "SPACE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = SPACE$(VAL(Result$))
       NumStr% = True%
     CASE "STR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(VAL(Result$)))
       NumStr% = True%
     CASE "STRING"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaning$ = STRING$(VAL(Result$), Value$) ELSE InMeaning$ = STRING$(VAL(Result$), VAL(Value$))
       NumStr% = True%
     CASE "TIME"
       InMeaning$ = TIME$
     CASE "TRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(RTRIM$(Result$))
     CASE "UCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = UCASE$(Result$)
     CASE ELSE
       IF LEFT$(WorkName$, 2) = "FN" THEN InMeaning$ = InDefFn$(WorkName$, True%, InLine$) ELSE InMeaning = InVariable$(WorkName$, True%)
       IF NOT NumStr% THEN ERROR 13
     END SELECT
    ELSE
     SELECT CASE WorkName$
     CASE "FALSE"
       InMeaning$ = LTRIM$(STR$(False%))
     CASE "TRUE"
       InMeaning$ = LTRIM$(STR$(True%))
     CASE "PI"
       InMeaning$ = "3.1415926535897932384626433832795"
     CASE "BLACK"
       InMeaning$ = LTRIM$(STR$(Black%))
     CASE "BLUE"
       InMeaning$ = LTRIM$(STR$(Blue%))
     CASE "BRIGHTWHITE"
       InMeaning$ = LTRIM$(STR$(BrightWhite%))
     CASE "BROWN"
       InMeaning$ = LTRIM$(STR$(Brown%))
     CASE "CYAN"
       InMeaning$ = LTRIM$(STR$(Cyan%))
     CASE "GRAY"
       InMeaning$ = LTRIM$(STR$(Gray%))
     CASE "GREEN"
       InMeaning$ = LTRIM$(STR$(Green%))
     CASE "LIGHTBLUE"
       InMeaning$ = LTRIM$(STR$(LightBlue%))
     CASE "LIGHTCYAN"
       InMeaning$ = LTRIM$(STR$(LightCyan%))
     CASE "LIGHTGREEN"
       InMeaning$ = LTRIM$(STR$(LightGreen%))
     CASE "LIGHTMAGENTA"
       InMeaning$ = LTRIM$(STR$(LightMagenta%))
     CASE "LIGHTRED"
       InMeaning$ = LTRIM$(STR$(LightRed%))
     CASE "MAGENTA"
       InMeaning$ = LTRIM$(STR$(Magenta%))
     CASE "RED"
       InMeaning$ = LTRIM$(STR$(Red%))
     CASE "WHITE"
       InMeaning$ = LTRIM$(STR$(White%))
     CASE "YELLOW"
       InMeaning$ = LTRIM$(STR$(Yellow%))
     CASE "ATN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(ATN(VAL(Result$))))
     CASE "ABS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(ABS(VAL(Result$))))
     CASE "ASC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF Result$ = "" THEN ERROR 5
       InMeaning$ = LTRIM$(STR$(ASC(Result$)))
       NumStr% = False%
     CASE "AVG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       Count% = 1
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
          Count% = Count% + 1
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(VAL(Result$) / Count%))
     CASE "COS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(COS(VAL(Result$))))
     CASE "CRC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       FOR Index% = 1 TO 256
        Crc& = Index% - 1
        FOR CrcIndex% = 1 TO 8
         IF ((INT(Crc& / 2) * 2) <> Crc&) THEN Crc& = INT(Crc& / 2) XOR &HEDB88320 ELSE Crc& = INT(Crc& / 2)
        NEXT CrcIndex%
        Crc32Table&(Index%) = Crc&
       NEXT Index%
       Crc& = &HFFFFFFFF
       WHILE Result$ <> ""
        WorkValue% = ABS((Crc& MOD &H100) XOR ASC(Result$))
        Result$ = MID$(Result$, 2)
        IF WorkValue% < 0 THEN WorkValue% = 0
        IF WorkValue% > 255 THEN WorkValue% = 255
        Crc& = Crc32Table&(WorkValue% + 1) XOR INT(Crc& / &H100)
       WEND
       InMeaning$ = LTRIM$(STR$(Crc&))
       NumStr% = False%
     CASE "CSRLIN"
       InMeaning$ = LTRIM$(STR$(CSRLIN))
     CASE "DAYOFWEEK"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = LTRIM$(STR$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "EOF"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = LTRIM$(MID$(InLine$, 2))
       IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
       IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 52
       IF MID$(OpenFiles$(INT(VAL(Result$))), 1, INSTR(OpenFiles$(INT(VAL(Result$))), "=") - 1) = "OUT" THEN ERROR 54
       IF EOF(INT(VAL(Result$))) THEN InMeaning$ = LTRIM$(STR$(True%)) ELSE InMeaning$ = LTRIM$(STR$(False%))
     CASE "EXP"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(EXP(VAL(Result$))))
     CASE "FIX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(FIX(VAL(Result$))))
     CASE "INSTR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(INSTR(Result$, Value$)))
       NumStr% = False%
     CASE "INT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(INT(VAL(Result$))))
     CASE "ISLEAPYEAR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (INT(INT(VAL(Result$)) / 4) * 4) = INT(VAL(Result$)) THEN InMeaning$ = LTRIM$(STR$(True%)) ELSE InMeaning$ = LTRIM$(STR$(False%))
     CASE "LEN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(LEN(Result$)))
       NumStr% = False%
     CASE "LOF"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = LTRIM$(MID$(InLine$, 2))
       IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
       IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 52
       InMeaning$ = LTRIM$(STR$(LOF(INT(VAL(Result$)))))
     CASE "LOG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(LOG(VAL(Result$))))
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF VAL(Value$) > VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = Result$
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
          Value$ = Calculate$(InLine$)
          IF NumStr% THEN ERROR 13
          InLine$ = LTRIM$(InLine$)
          IF VAL(Value$) < VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
        CASE ")"
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
       LOOP
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = Result$
     CASE "POS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(POS(0)))
       NumStr% = False%
     CASE "RANDOM"
       InMeaning$ = LTRIM$(STR$(RND))
     CASE "SCREEN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = InName$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       SELECT CASE Meaning$
       CASE "SYMBOL"
         InMeaning$ = LTRIM$(STR$(SCREEN(VAL(Result$), VAL(Value$), 0)))
       CASE "COLOR"
         InMeaning$ = LTRIM$(STR$(SCREEN(VAL(Result$), VAL(Value$), 1)))
       CASE ELSE
         ERROR 2
       END SELECT
     CASE "SGN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(SGN(VAL(Result$))))
     CASE "SIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(SIN(VAL(Result$))))
     CASE "SQR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(SquareRoot#(VAL(Result$))))
     CASE "TAN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(TAN(VAL(Result$))))
     CASE "TIMER"
       InMeaning$ = LTRIM$(STR$(TIMER))
     CASE "TIMERDATA"
       InMeaning$ = LTRIM$(STR$(InTimerValue&))
     CASE "VAL"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(VAL(Result$)))
       NumStr% = False%
     CASE "WEEKNUMBER"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 0) OR (VAL(Meaning$) > 32767) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDaysCount%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = LTRIM$(STR$(WeekNumber%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE ELSE
       IF LEFT$(WorkName$, 2) = "FN" THEN InMeaning$ = InDefFn$(WorkName$, False%, InLine$) ELSE InMeaning = InVariable$(WorkName$, False%)
       IF NumStr% THEN ERROR 13
     END SELECT
    END IF
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InName$ (InLine$)
 DIM OutName$
 OutName$ = ""
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "A" TO "Z"
    OutName$ = OutName$ + LEFT$(UCASE$(InLine$), 1)
    InLine$ = MID$(InLine$, 2)
  CASE "0" TO "9"
    OutName$ = OutName$ + LEFT$(InLine$, 1)
    InLine$ = MID$(InLine$, 2)
  CASE ELSE
    EXIT DO
  END SELECT
 LOOP
 IF OutName$ = "" THEN ERROR 2
 InName$ = OutName$
END FUNCTION

FUNCTION InNumber# (InLine$)
 DIM OutNumber$
 DIM PointPresent%
 OutNumber$ = ""
 PointPresent% = False%
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "&"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "H"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "9"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "A" TO "F"
        OutNumber$ = OutNumber$ + LEFT$(UCASE$(InLine$), 1)
        InLine$ = MID$(InLine$, 2)
      CASE "G" TO "Z"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR ((NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) AND (NOT ((ASC(UCASE$(InLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(InLine$)) < (ASC("F") + 1))))) OR ((ASC(UCASE$(InLine$)) > ASC("G")) AND (ASC(UCASE$(InLine$)) < (ASC("Z") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&H" + OutNumber$)
   CASE "O"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(InLine$, 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR ((ASC(InLine$) > (ASC("8") - 1)) AND (ASC(InLine$) < (ASC("9") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&O" + OutNumber$)
   CASE "0" TO "7"
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(InLine$, 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR ((ASC(InLine$) > (ASC("8") - 1)) AND (ASC(InLine$) < (ASC("9") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&O" + OutNumber$)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "0" TO "9"
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(InLine$, 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      InLine$ = LTRIM$(MID$(InLine$, 2))
      IF InLine$ = "" THEN ERROR 2
      IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) THEN ERROR 2
      PointPresent% = True%
      IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   InNumber# = VAL(OutNumber$)
 CASE "."
   PointPresent% = True%
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(InLine$, 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      ERROR 2
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   InNumber# = VAL("0." + OutNumber$)
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InputBox% (Title$, Message$, InputLine$)
 DIM Key$
 DIM WorkLine$
 DIM InputLinePosition%
 DIM InputCursorPosition%
 CALL MakeWindow(7, 7, 64, 9, True%, Title$, True%, Message$, True%, "ENTER=Yes, ESC=No.")
 InputLinePosition% = 1
 InputCursorPosition% = 1
 WorkLine$ = LEFT$(InputLine$, 256)
 GOSUB OutInputLine
 DO
  Key$ = INKEY$
  SELECT CASE LEN(Key$)
  CASE 1
    SELECT CASE Key$
    CASE CHR$(8)
      IF InputLinePosition% > 1 THEN
       InputLinePosition% = InputLinePosition% - 1
       InputCursorPosition% = InputCursorPosition% - 1
       IF InputLinePosition% < 1 THEN InputLinePosition% = 1
       IF InputCursorPosition% < 1 THEN InputCursorPosition% = 1
       WorkLine$ = MID$(WorkLine$, 1, InputLinePosition% - 1) + MID$(WorkLine$, InputLinePosition% + 1)
       GOSUB OutInputLine
      END IF
    CASE CHR$(13)
      InputBox% = True%
      InputLine$ = WorkLine$
      EXIT DO
    CASE CHR$(27)
      InputBox% = False%
      EXIT DO
    CASE ELSE
      IF LEN(WorkLine$) < 256 THEN
       WorkLine$ = MID$(WorkLine$, 1, InputLinePosition% - 1) + Key$ + MID$(WorkLine$, InputLinePosition%)
       InputLinePosition% = InputLinePosition% + 1
       InputCursorPosition% = InputCursorPosition% + 1
       IF InputLinePosition% > LEN(WorkLine$) + 1 THEN InputLinePosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) < 65 THEN IF InputCursorPosition% > LEN(WorkLine$) + 1 THEN InputCursorPosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) > 63 THEN IF InputCursorPosition% > 64 THEN InputCursorPosition% = 64
       GOSUB OutInputLine
      END IF
    END SELECT
  CASE 2
    SELECT CASE RIGHT$(Key$, 1)
    CASE CHR$(75)
      IF InputLinePosition% <> 1 THEN
       InputLinePosition% = InputLinePosition% - 1
       InputCursorPosition% = InputCursorPosition% - 1
       IF InputLinePosition% < 1 THEN InputLinePosition% = 1
       IF InputCursorPosition% < 1 THEN InputCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(77)
      IF InputLinePosition% < LEN(WorkLine$) + 1 THEN
       InputLinePosition% = InputLinePosition% + 1
       InputCursorPosition% = InputCursorPosition% + 1
       IF InputLinePosition% > LEN(WorkLine$) + 1 THEN InputLinePosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) < 65 THEN IF InputCursorPosition% > LEN(WorkLine$) + 1 THEN InputCursorPosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) > 63 THEN IF InputCursorPosition% > 64 THEN InputCursorPosition% = 64
       GOSUB OutInputLine
      END IF
    CASE CHR$(71)
      IF InputLinePosition% <> 1 THEN
       InputLinePosition% = 1
       InputCursorPosition% = 1
       GOSUB OutInputLine
      END IF
    CASE CHR$(79)
      IF InputLinePosition% < LEN(WorkLine$) + 1 THEN
       InputLinePosition% = LEN(WorkLine$) + 1
       InputCursorPosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) < 65 THEN IF InputCursorPosition% > LEN(WorkLine$) + 1 THEN InputCursorPosition% = LEN(WorkLine$) + 1
       IF LEN(WorkLine$) > 63 THEN IF InputCursorPosition% > 64 THEN InputCursorPosition% = 64
       GOSUB OutInputLine
      END IF
    CASE CHR$(83)
      IF WorkLine$ <> "" THEN
       WorkLine$ = MID$(WorkLine$, 1, InputLinePosition% - 1) + MID$(WorkLine$, InputLinePosition% + 1)
       GOSUB OutInputLine
      END IF
    END SELECT
  END SELECT
 LOOP
 COLOR 0, 7
 LOCATE 8, 8, 0
 EXIT FUNCTION
OutInputLine:
 LOCATE 14, 8, 0
 COLOR 15, 3
 PRINT STRING$(64, CHR$(0));
 LOCATE 14, 8, 0
 PRINT MID$(WorkLine$, (InputLinePosition% - InputCursorPosition%) + 1, 64);
 LOCATE 14, 8 + (InputCursorPosition% - 1), 1, 7, 8
 RETURN
END FUNCTION

SUB InsertLine
 DIM Index%
 IF (Text$(TextLines%) <> "") OR (TextPosition% > TextLines% - 1) THEN EXIT SUB
 FOR Index% = TextLines% - 1 TO TextPosition% + 1 STEP -1
  Text$(Index% + 1) = Text$(Index%)
  Text$(Index%) = ""
 NEXT Index%
 Text$(TextPosition% + 1) = MID$(Text$(TextPosition%), LinePosition%)
 Text$(TextPosition%) = MID$(Text$(TextPosition%), 1, LinePosition% - 1)
 LinePosition% = 1
 CursorPosition% = 1
 TextPosition% = TextPosition% + 1
 PagePosition% = PagePosition% + 1
 CALL ScratchScreen
END SUB

FUNCTION InTimerValue&
 DIM ValueBytes%(4)
 DIM Index%
 DIM Value&
 DEF SEG = &H0
 FOR Index% = 1 TO 4
  ValueBytes%(Index%) = PEEK(&H46C + (Index% - 1))
 NEXT Index%
 DEF SEG = VARSEG(Value&)
 FOR Index% = 1 TO 4
  POKE VARPTR(Value&) + (Index% - 1), ValueBytes%(Index%)
 NEXT Index%
 DEF SEG
 InTimerValue& = Value&
END FUNCTION

FUNCTION InVariable$ (VariableName$, VariableType%)
 DIM Index%
 IF DefFnMode% THEN
  IF DefFnSArgsCountValue%(CurrentDefFn%) = 0 THEN
   DefFnMode% = False%
   InVariable$ = InVariable$(VariableName$, VariableType%)
   DefFnMode% = True%
  ELSE
   FOR Index% = 1 TO DefFnSArgsCountValue%(CurrentDefFn%) + 1
    IF Index% = DefFnSArgsCountValue%(CurrentDefFn%) + 1 THEN
     DefFnMode% = False%
     InVariable$ = InVariable$(VariableName$, VariableType%)
     DefFnMode% = True%
     EXIT FOR
    END IF
    IF (MID$(DefFnSArgs$(CurrentDefFn%, Index%), 1, INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") - 1) = VariableName$) AND (VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 ELSE
  IF VariablesCountValue% = 0 THEN
   IF VariableType% THEN
    CALL SetVariable(VariableName$, True%, "")
    InVariable$ = ""
   ELSE
    CALL SetVariable(VariableName$, False%, "0.0")
    InVariable$ = "0.0"
   END IF
  ELSE
   FOR Index% = 1 TO VariablesCountValue% + 1
    IF Index% = VariablesCountValue% + 1 THEN
     IF VariableType% THEN
      CALL SetVariable(VariableName$, True%, "")
      InVariable$ = ""
     ELSE
      CALL SetVariable(VariableName$, False%, "0.0")
      InVariable$ = "0.0"
     END IF
     EXIT FOR
    END IF
    IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(Variables$(Index%), INSTR(Variables$(Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 END IF
END FUNCTION

FUNCTION LeapYear% (YearValue%)
 LeapYear% = ABS((INT(YearValue% / 4) * 4) = YearValue%)
END FUNCTION

SUB MakeWindow (WindowColumn%, WindowRow%, WindowWidth%, WindowHeight%, Title%, Title$, Message%, Message$, Status%, Status$)
 DIM Index%
 DIM Msg$
 IF (WindowColumn% < 1) OR (WindowRow% < 1) OR (WindowWidth% < 1) OR (WindowHeight% < 1) OR (WindowWidth% > 77) OR (WindowHeight% > 22) OR (WindowWidth% + (WindowColumn% - 1) > 80) OR (WindowHeight% + (WindowRow% - 1) > 25) THEN EXIT SUB
 COLOR 0, 7
 LOCATE WindowRow%, WindowColumn%, 0
 PRINT CHR$(201) + STRING$(WindowWidth%, CHR$(205)) + CHR$(187);
 FOR Index% = 1 TO WindowHeight%
  LOCATE WindowRow% + Index%, WindowColumn%, 0
  PRINT CHR$(186) + STRING$(WindowWidth%, CHR$(0)) + CHR$(186);
  COLOR 0, 0
  PRINT CHR$(0);
  COLOR 0, 7
 NEXT Index%
 LOCATE WindowRow% + (WindowHeight% + 1), WindowColumn%, 0
 PRINT CHR$(200) + STRING$(WindowWidth%, CHR$(205)) + CHR$(188);
 COLOR 0, 0
 PRINT CHR$(0);
 COLOR 0, 7
 LOCATE WindowRow% + (WindowHeight% + 2), WindowColumn% + 1, 0
 COLOR 0, 0
 PRINT STRING$(WindowWidth% + 2, CHR$(0));
 IF Title% THEN
  COLOR 0, 7
  LOCATE WindowRow% + 1, WindowColumn% + 1, 0
  COLOR 4, 7
  PRINT STRING$(INT((WindowWidth% - LEN(LEFT$(Title$, WindowWidth%))) / 2), CHR$(0)) + LEFT$(Title$, WindowWidth%);
  LOCATE WindowRow% + 2, WindowColumn%, 0
  COLOR 0, 7
  PRINT CHR$(204) + STRING$(WindowWidth%, CHR$(205)) + CHR$(185);
 END IF
 IF Message% THEN
  IF Title% THEN Index% = WindowRow% + 3 ELSE Index% = WindowRow% + 1
  Msg$ = LEFT$(Message$, 256)
  COLOR 1, 7
  DO WHILE Msg$ <> ""
   LOCATE Index%, WindowColumn% + 1, 0
   PRINT LEFT$(Msg$, WindowWidth%);
   Msg$ = MID$(Msg$, WindowWidth% + 1)
   Index% = Index% + 1
  LOOP
 END IF
 IF Status% THEN
  COLOR 0, 7
  LOCATE WindowRow% + (WindowHeight% - 1), WindowColumn%, 0
  PRINT CHR$(204) + STRING$(WindowWidth%, CHR$(205)) + CHR$(185);
  LOCATE WindowRow% + WindowHeight%, WindowColumn% + 1, 0
  COLOR 2, 7
  PRINT STRING$(INT((WindowWidth% - LEN(LEFT$(Status$, WindowWidth%))) / 2), CHR$(0)) + LEFT$(Status$, WindowWidth%);
 END IF
 COLOR 0, 7
 LOCATE WindowRow% + 3, WindowColumn% + 1, 0
END SUB

FUNCTION MenuBox% (ItemsCount%, Items$())
 DIM Index%
 DIM Length%
 DIM CurrentItem%
 DIM Key$
 IF (ItemsCount% < 1) OR (ItemsCount% > UBOUND(Items$)) OR (ItemsCount% > 20) THEN
  MenuBox% = -1
  EXIT FUNCTION
 END IF
 Length% = 0
 FOR Index% = 1 TO ItemsCount%
  IF LEN(Items$(Index%)) > Length% THEN Length% = LEN(Items$(Index%))
 NEXT Index%
 IF Length% < 23 THEN Length% = 23
 IF Length% > 70 THEN Length% = 70
 CALL MakeWindow(INT((80 - (Length% + 10)) / 2) + 1, INT((25 - (ItemsCount% + 5)) / 2) + 1, Length% + 7, ItemsCount% + 2, False%, "", False%, "", True%, "ENTER=Select item, ESC=Cancel.")
 CurrentItem% = 1
 GOSUB OutMenu
 DO
  Key$ = INKEY$
  SELECT CASE LEN(Key$)
  CASE 1
    SELECT CASE UCASE$(Key$)
    CASE CHR$(13)
      MenuBox% = CurrentItem%
      EXIT DO
    CASE CHR$(27)
      MenuBox% = 0
      EXIT DO
    CASE "A" TO CHR$(ASC("A") + (ItemsCount% - 1))
      IF CurrentItem% <> (ASC(UCASE$(Key$)) - ASC("A")) + 1 THEN
       CurrentItem% = (ASC(UCASE$(Key$)) - ASC("A")) + 1
       GOSUB OutMenu
      END IF
    END SELECT
  CASE 2
    SELECT CASE RIGHT$(Key$, 1)
    CASE CHR$(72)
      IF CurrentItem% <> 1 THEN
       CurrentItem% = CurrentItem% - 1
       GOSUB OutMenu
      END IF
    CASE CHR$(80)
      IF CurrentItem% <> ItemsCount% THEN
       CurrentItem% = CurrentItem% + 1
       GOSUB OutMenu
      END IF
    END SELECT
  END SELECT
 LOOP
 LOCATE INT((25 - (ItemsCount% + 2)) / 2) + 1, INT((80 - (Length% + 7)) / 2) + 1, 0
 COLOR 0, 7
 EXIT FUNCTION
OutMenu:
 FOR Index% = 1 TO ItemsCount%
  LOCATE INT((25 - (ItemsCount% + 5)) / 2) + Index% + 1, INT((80 - (Length% + 10)) / 2) + 2, 0
  COLOR 4, 7
  PRINT STRING$(2 - LEN(LTRIM$(STR$(Index%))), "0") + LTRIM$(STR$(Index%));
  COLOR 14, 7
  PRINT "#";
  COLOR 1, 7
  PRINT "(";
  COLOR 15, 7
  PRINT CHR$(ASC("A") + (Index% - 1));
  COLOR 1, 7
  PRINT ")";
  COLOR 2, 7
  PRINT "=";
  IF Index% = CurrentItem% THEN COLOR 14, 1 ELSE COLOR 1, 7
  PRINT LEFT$(Items$(Index%), Length%) + STRING$(Length% - LEN(LEFT$(Items$(Index%), Length%)), CHR$(0));
 NEXT Index%
 RETURN
END FUNCTION

FUNCTION MessageBox% (Title$, Message$)
 DIM Key$
 CALL MakeWindow(7, 8, 64, 8, True%, Title$, True%, Message$, True%, "ENTER=Yes, ESC=No.")
 DO
  Key$ = INKEY$
 LOOP UNTIL (Key$ = CHR$(13)) OR (Key$ = CHR$(27))
 MessageBox% = Key$ = CHR$(13)
END FUNCTION

FUNCTION MonthDays% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDays% = 0
 CASE 2
   MonthDays% = 31
 CASE 3
   MonthDays% = 59 + LeapYear%(YearValue%)
 CASE 4
   MonthDays% = 90 + LeapYear%(YearValue%)
 CASE 5
   MonthDays% = 120 + LeapYear%(YearValue%)
 CASE 6
   MonthDays% = 151 + LeapYear%(YearValue%)
 CASE 7
   MonthDays% = 181 + LeapYear%(YearValue%)
 CASE 8
   MonthDays% = 212 + LeapYear%(YearValue%)
 CASE 9
   MonthDays% = 243 + LeapYear%(YearValue%)
 CASE 10
   MonthDays% = 273 + LeapYear%(YearValue%)
 CASE 11
   MonthDays% = 304 + LeapYear%(YearValue%)
 CASE 12
   MonthDays% = 334 + LeapYear%(YearValue%)
 END SELECT
END FUNCTION

FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDaysCount% = 31
 CASE 2
   MonthDaysCount% = 28 + LeapYear%(YearValue%)
 CASE 3
   MonthDaysCount% = 31
 CASE 4
   MonthDaysCount% = 30
 CASE 5
   MonthDaysCount% = 31
 CASE 6
   MonthDaysCount% = 30
 CASE 7
   MonthDaysCount% = 31
 CASE 8
   MonthDaysCount% = 31
 CASE 9
   MonthDaysCount% = 30
 CASE 10
   MonthDaysCount% = 31
 CASE 11
   MonthDaysCount% = 30
 CASE 12
   MonthDaysCount% = 31
 END SELECT
END FUNCTION

FUNCTION MonthName$ (MonthNumber%)
 SELECT CASE MonthNumber%
 CASE 1
   MonthName$ = "January"
 CASE 2
   MonthName$ = "February"
 CASE 3
   MonthName$ = "March"
 CASE 4
   MonthName$ = "April"
 CASE 5
   MonthName$ = "May"
 CASE 6
   MonthName$ = "June"
 CASE 7
   MonthName$ = "July"
 CASE 8
   MonthName$ = "August"
 CASE 9
   MonthName$ = "September"
 CASE 10
   MonthName$ = "October"
 CASE 11
   MonthName$ = "November"
 CASE 12
   MonthName$ = "December"
 END SELECT
END FUNCTION

SUB OutBox (Title$, Message$)
 CALL MakeWindow(7, 8, 64, 8, True%, Title$, True%, Message$, True%, "Press the Enter key to quit.")
 WHILE INKEY$ <> CHR$(13)
 WEND
END SUB

SUB OutTimerValue (NewValue&)
 DIM ValueBytes%(4)
 DIM Index%
 DIM Value&
 Value& = NewValue&
 DEF SEG = VARSEG(Value&)
 FOR Index% = 1 TO 4
  ValueBytes%(Index%) = PEEK(VARPTR(Value&) + (Index% - 1))
 NEXT Index%
 DEF SEG = &H0
 FOR Index% = 1 TO 4
  POKE &H46C + (Index% - 1), ValueBytes%(Index%)
 NEXT Index%
 DEF SEG
END SUB

SUB PageDown
 TextPosition% = TextPosition% + 20
 PagePosition% = PagePosition% + 20
 CALL Control
END SUB

SUB PageUp
 TextPosition% = TextPosition% - 20
 PagePosition% = PagePosition% - 20
 CALL Control
END SUB

FUNCTION ParseCalculate$ (InLine$)
 DIM Result$
 DIM WorkLine$
 Result$ = ParseInMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "*"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "*" + ParseInMeaning$(InLine$)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "+" + ParseInMeaning$(InLine$)
  CASE "-"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "-" + ParseInMeaning$(InLine$)
  CASE "/"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaning$(InLine$)
  CASE "\"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaning$(InLine$)
  CASE "^"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "^" + ParseInMeaning$(InLine$)
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaning$(InLine$)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "=" + ParseInMeaning$(InLine$)
    END SELECT
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + ">" + ParseInMeaning$(InLine$)
    END SELECT
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "<" + ParseInMeaning$(InLine$)
    END SELECT
  CASE "A" TO "Z"
    WorkLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      Result$ = Result$ + " And " + ParseInMeaning$(InLine$)
    CASE "MOD"
      Result$ = Result$ + " Mod " + ParseInMeaning$(InLine$)
    CASE "OR"
      Result$ = Result$ + " Or " + ParseInMeaning$(InLine$)
    CASE "XOR"
      Result$ = Result$ + " XOr " + ParseInMeaning$(InLine$)
    CASE ELSE
      InLine$ = WorkLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 ParseCalculate$ = Result$
END FUNCTION

FUNCTION ParseInMeaning$ (InLine$)
 DIM Result$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   ParseInMeaning$ = CHR$(34) + MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1) + CHR$(34)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = ParseCalculate$(InLine$)
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = "-" + ParseCalculate$(InLine$)
 CASE "."
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "&"
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "0" TO "9"
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = "(" + ParseCalculate$(InLine$) + ")"
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF Result$ = "NOT" THEN
    ParseInMeaning$ = "Not " + ParseCalculate$(InLine$)
   ELSE
    Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
    SELECT CASE LEFT$(InLine$, 1)
    CASE "$"
      Result$ = Result$ + "$"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "!"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "@"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "%"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "&"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    END SELECT
    IF LEFT$(InLine$, 1) = "(" THEN
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "("
     DO WHILE InLine$ <> ""
      IF LEFT$(InLine$, 1) = "#" THEN
       Result$ = Result$ + "#"
       InLine$ = MID$(InLine$, 2)
      END IF
      Result$ = Result$ + ParseCalculate$(InLine$)
      InLine$ = LTRIM$(InLine$)
      SELECT CASE LEFT$(InLine$, 1)
      CASE ","
        InLine$ = MID$(InLine$, 2)
        Result$ = Result$ + ","
      CASE ")"
        Result$ = Result$ + ")"
        EXIT DO
      CASE ELSE
        ERROR 2
      END SELECT
      InLine$ = LTRIM$(InLine$)
     LOOP
     IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
     InLine$ = MID$(InLine$, 2)
    END IF
    ParseInMeaning$ = Result$
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseInNumber$ (InLine$)
 DIM OutNumber$
 DIM PointPresent%
 OutNumber$ = ""
 PointPresent% = False%
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "&"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "H"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "9"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "A" TO "F"
        OutNumber$ = OutNumber$ + LEFT$(UCASE$(InLine$), 1)
        InLine$ = MID$(InLine$, 2)
      CASE "G" TO "Z"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR ((NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) AND (NOT ((ASC(UCASE$(InLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(InLine$)) < (ASC("F") + 1))))) OR ((ASC(UCASE$(InLine$)) > ASC("G")) AND (ASC(UCASE$(InLine$)) < (ASC("Z") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&H" + OutNumber$
   CASE "O"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(InLine$, 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR ((ASC(InLine$) > (ASC("8") - 1)) AND (ASC(InLine$) < (ASC("9") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&O" + OutNumber$
   CASE "0" TO "7"
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(InLine$, 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF InLine$ = "" THEN ERROR 2
        IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR ((ASC(InLine$) > (ASC("8") - 1)) AND (ASC(InLine$) < (ASC("9") + 1))) THEN ERROR 2
        PointPresent% = True%
        IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&O" + OutNumber$
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "0" TO "9"
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(InLine$, 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      InLine$ = LTRIM$(MID$(InLine$, 2))
      IF InLine$ = "" THEN ERROR 2
      IF PointPresent% OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) THEN ERROR 2
      PointPresent% = True%
      IF OutNumber$ = "" THEN OutNumber$ = "0." ELSE OutNumber$ = OutNumber$ + "."
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   ParseInNumber$ = OutNumber$
 CASE "."
   PointPresent% = True%
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(InLine$, 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      ERROR 2
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   ParseInNumber$ = "0." + OutNumber$
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseRunLine$ (InLine$)
 DIM Statement$
 DIM WorkLine$
 DIM Work$
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM Index%
 DIM Work%
 Statement$ = InName$(InLine$)
 InLine$ = LTRIM$(InLine$)
 SELECT CASE Statement$
 CASE "BEEP"
   ParseRunLine$ = "Beep"
 CASE "CALL"
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 48
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) = "(" THEN
    Result$ = Result$ + "("
    InLine$ = LTRIM$(MID$(InLine$, 2))
    Index% = 0
    DO WHILE InLine$ <> ""
     Result$ = Result$ + ParseCalculate$(InLine$)
     IF Index% = DefFnSArgsCount% THEN ERROR 22
     Index% = Index% + 1
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       Result$ = Result$ + ","
       InLine$ = MID$(InLine$, 2)
     CASE ")"
       Result$ = Result$ + ")"
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
    IF (Index% = 0) OR (LEFT$(InLine$, 1) <> ")") THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
   END IF
   ParseRunLine$ = "Call " + Result$
 CASE "CASE"
   Work$ = InLine$
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "A" TO "Z"
     IF InName$(InLine$) = "ELSE" THEN
      ParseRunLine$ = "Case Else"
     ELSE
      ParseRunLine$ = "Case " + ParseCalculate$(Work$)
     END IF
   CASE ELSE
     ParseRunLine$ = "Case " + ParseCalculate$(InLine$)
   END SELECT
 CASE "CHDIR"
   ParseRunLine$ = "ChDir " + ParseCalculate$(InLine$)
 CASE "CLOSE"
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Close #" + ParseCalculate$(InLine$)
 CASE "CLS"
   ParseRunLine$ = "Cls"
 CASE "COLOR"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "ON" THEN ERROR 2
   ParseRunLine$ = "Color " + Result$ + " On " + ParseCalculate$(InLine$)
 CASE "DEF"
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 48
   Result$ = LEFT$(UCASE$(Result$), 3) + MID$(LCASE$(Result$), 4)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) = "(" THEN
    InLine$ = LTRIM$(MID$(InLine$, 2))
    Result$ = Result$ + "("
    Index% = 0
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Result$ = Result$ + LEFT$(UCASE$(Value$), 1) + MID$(LCASE$(Value$), 2)
     IF Index% = DefFnSArgsCount% THEN ERROR 22
     Index% = Index% + 1
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       Result$ = Result$ + "$"
     CASE "!"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "@"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "#"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "%"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "&"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     END SELECT
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       InLine$ = MID$(InLine$, 2)
       Result$ = Result$ + ","
     CASE ")"
       Result$ = Result$ + ")"
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
    IF (Index% = 0) OR (LEFT$(InLine$, 1) <> ")") THEN ERROR 2
    InLine$ = LTRIM$(MID$(InLine$, 2))
   END IF
   IF LEFT$(InLine$, 1) = "=" THEN
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "Def " + Result$ + "=" + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "Def " + Result$
   END IF
 CASE "ELSE"
   ParseRunLine$ = "Else"
 CASE "END"
   IF InLine$ <> "" THEN
    SELECT CASE InName$(InLine$)
    CASE "DEF"
      ParseRunLine$ = "End Def"
    CASE "IF"
      ParseRunLine$ = "End If"
    CASE "SELECT"
      ParseRunLine$ = "End Select"
    CASE ELSE
      ERROR 2
    END SELECT
   ELSE
    ParseRunLine$ = "End"
   END IF
 CASE "EXIT"
   SELECT CASE InName$(InLine$)
   CASE "DEF"
     ParseRunLine$ = "Exit Def"
   CASE "FROM"
     ParseRunLine$ = "Exit From"
   CASE "WHILE"
     ParseRunLine$ = "Exit While"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "FILES"
   ParseRunLine$ = "Files " + ParseCalculate$(InLine$)
 CASE "FROM"
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 45
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "TO" THEN ERROR 2
   Meaning$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "STEP" THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "From " + Result$ + "=" + Value$ + " To " + Meaning$ + " Step=" + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "From " + Result$ + "=" + Value$ + " To " + Meaning$
   END IF
 CASE "GO"
   SELECT CASE InName$(InLine$)
   CASE "TO"
     ParseRunLine$ = "Go To " + ParseCalculate$(InLine$)
   CASE "SUB"
     ParseRunLine$ = "Go Sub " + ParseCalculate$(InLine$)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "HANG"
   ParseRunLine$ = "Hang"
 CASE "HELP"
   IF LEFT$(InLine$, 1) = "!" THEN InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Help!"
 CASE "IF"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "THEN" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    Value$ = ParseRunLine$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF InLine$ <> "" THEN
     IF InName$(InLine$) <> "ELSE" THEN ERROR 2
     ParseRunLine$ = "If " + Result$ + " Then " + Value$ + " Else " + ParseRunLine$(InLine$)
    ELSE
     ParseRunLine$ = "If " + Result$ + " Then " + Value$
    END IF
   ELSE
    ParseRunLine$ = "If " + Result$ + " Then"
   END IF
 CASE "KEY"
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "A" TO "Z"
     Work$ = InLine$
     SELECT CASE InName$(InLine$)
     CASE "ON"
       ParseRunLine$ = "Key On"
     CASE "OFF"
       ParseRunLine$ = "Key Off"
     CASE "LIST"
       ParseRunLine$ = "Key List"
     CASE ELSE
       Result$ = ParseCalculate$(Work$)
       Work$ = LTRIM$(Work$)
       IF LEFT$(Work$, 1) <> "," THEN ERROR 2
       Work$ = MID$(Work$, 2)
       ParseRunLine$ = "Key " + Result$ + "," + ParseCalculate$(Work$)
     END SELECT
   CASE ELSE
     Result$ = ParseCalculate$(InLine$)
     InLine$ = LTRIM$(InLine$)
     IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
     InLine$ = MID$(InLine$, 2)
     ParseRunLine$ = "Key " + Result$ + "," + ParseCalculate$(InLine$)
   END SELECT
 CASE "KILL"
   ParseRunLine$ = "Kill " + ParseCalculate$(InLine$)
 CASE "LET"
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Let " + Result$ + "=" + ParseCalculate$(InLine$)
 CASE "LOCATE"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "IN" THEN ERROR 2
   ParseRunLine$ = "Locate " + Result$ + " In " + ParseCalculate$(InLine$)
 CASE "MID"
   IF LEFT$(InLine$, 1) <> "$" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "$" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Meaning$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Mid$(" + Result$ + "$," + Value$ + "," + Meaning$ + ")=" + ParseCalculate$(InLine$)
 CASE "MKDIR"
   ParseRunLine$ = "MkDir " + ParseCalculate$(InLine$)
 CASE "NAME"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   ParseRunLine$ = "Name " + Result$ + " As " + ParseCalculate$(InLine$)
 CASE "NEXT"
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 45
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   ParseRunLine$ = "Next " + Result$
 CASE "OPEN"
   Result$ = ParseCalculate$(InLine$) + " For "
   IF InName$(InLine$) <> "FOR" THEN ERROR 2
   SELECT CASE InName$(InLine$)
   CASE "INPUT"
     Result$ = Result$ + "InPut"
   CASE "OUTPUT"
     Result$ = Result$ + "OutPut"
   CASE "APPEND"
     Result$ = Result$ + "Append"
   CASE ELSE
     ERROR 2
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Open " + Result$ + " As #" + ParseCalculate$(InLine$)
 CASE "PRINT"
   IF LEFT$(InLine$, 1) = "#" THEN
    InLine$ = MID$(InLine$, 2)
    Result$ = ParseCalculate$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "Print #" + Result$ + "," + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "Print " + ParseCalculate$(InLine$)
   END IF
 CASE "REBOOT"
   ParseRunLine$ = "Reboot"
 CASE "REM"
   IF InLine$ <> "" THEN ParseRunLine$ = "Rem " + RTRIM$(InLine$) ELSE ParseRunLine$ = "Rem"
 CASE "RETURN"
   ParseRunLine$ = "Return"
 CASE "RMDIR"
   ParseRunLine$ = "RmDir " + ParseCalculate$(InLine$)
 CASE "SCREEN"
   SELECT CASE InName$(InLine$)
   CASE "FOURTY"
     ParseRunLine$ = "Screen Fourty"
   CASE "EIGHTY"
     ParseRunLine$ = "Screen Eighty"
   CASE "MONO"
     ParseRunLine$ = "Screen Mono"
   CASE "COLOR"
     ParseRunLine$ = "Screen Color"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "SELECT"
   IF InName$(InLine$) <> "CASE" THEN ERROR 2
   ParseRunLine$ = "Select Case " + ParseCalculate$(InLine$)
 CASE "SHELL"
   ParseRunLine$ = "Shell " + ParseCalculate$(InLine$)
 CASE "SLEEP"
   ParseRunLine$ = "Sleep " + ParseCalculate$(InLine$)
 CASE "STOP"
   ParseRunLine$ = "Stop"
 CASE "SOUND"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "WITH" THEN ERROR 2
   ParseRunLine$ = "Sound " + Result$ + " With " + ParseCalculate$(InLine$)
 CASE "SWAP"
   Result$ = InName$(InLine$)
   Result$ = LEFT$(UCASE$(Result$), 1) + MID$(LCASE$(Result$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   Value$ = InName$(InLine$)
   Value$ = LEFT$(UCASE$(Value$), 1) + MID$(LCASE$(Value$), 2)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Value$ = Value$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   ParseRunLine$ = "Swap " + Result$ + " As " + Value$
 CASE "SYSTEM"
   ParseRunLine$ = "System"
 CASE "TROFF"
   ParseRunLine$ = "TrOff"
 CASE "TRON"
   ParseRunLine$ = "TrOn"
 CASE "WEND"
   ParseRunLine$ = "WEnd"
 CASE "WHILE"
   ParseRunLine$ = "While " + ParseCalculate$(InLine$)
 CASE ELSE
   IF LEFT$(Statement$, 2) = "FN" THEN
    Result$ = Statement$
    Result$ = LEFT$(UCASE$(Result$), 3) + MID$(LCASE$(Result$), 4)
    SELECT CASE LEFT$(InLine$, 1)
    CASE "$"
      Result$ = Result$ + "$"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "!"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "@"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "%"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    CASE "&"
      InLine$ = LTRIM$(MID$(InLine$, 2))
    END SELECT
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = Result$ + "=" + ParseCalculate$(InLine$)
   ELSE
    ERROR 23
   END IF
 END SELECT
END FUNCTION

SUB RunLine (InLine$)
 DIM Statement$
 DIM WorkLine$
 DIM Work$
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM Index%
 DIM SubIndex%
 DIM LineNumber%
 DIM Work%
 DIM Key$
 DIM PageIndex%
 DIM WorkValue%
 DIM Count%
 DIM StartValue#
 DIM EndValue#
 DIM StepValue#
 DIM CurrentValue#
 DIM StartLine%
 DIM EndLine%
 DIM VariableName$
 DIM Conditional$
 DIM FunctionName$
 DIM FunctionType%
 Statement$ = InName$(InLine$)
 InLine$ = LTRIM$(InLine$)
 SELECT CASE Statement$
 CASE "BEEP"
   BEEP
 CASE "CALL"
   IF NOT RunMode% THEN ERROR 42
   FunctionName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   FunctionType% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     FunctionType% = True%
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   Result$ = InDefFn$(FunctionName$, FunctionType%, InLine$)
 CASE "CASE"
   IF NOT RunMode% THEN ERROR 91
   Count% = 0
   FOR Index% = CurrentLine% + 1 TO TextLines% + 1
    IF Index% = TextLines% + 1 THEN ERROR 92
    IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       WorkLine$ = LTRIM$(WorkLine$)
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
       IF WorkLine$ = "" THEN ERROR 39
       IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE ELSE
       ERROR 39
     END SELECT
     SELECT CASE InName$(WorkLine$)
     CASE "SELECT"
       IF InName$(WorkLine$) <> "CASE" THEN ERROR 2
       Count% = Count% + 1
     CASE "END"
       WorkLine$ = LTRIM$(WorkLine$)
       IF WorkLine$ <> "" THEN
        IF InName$(WorkLine$) = "SELECT" THEN
         IF Count% = 0 THEN EXIT FOR ELSE Count% = Count% - 1
        END IF
       END IF
     END SELECT
    END IF
   NEXT Index%
   CurrentLine% = Index%
 CASE "CHDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   CHDIR Result$
 CASE "CLOSE"
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
   IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 28
   CLOSE #INT(VAL(Result$))
   OpenFiles$(INT(VAL(Result$))) = ""
 CASE "CLS"
   CLS
 CASE "COLOR"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "ON" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   COLOR VAL(Result$), VAL(Value$)
 CASE "DEF"
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 48
   Result$ = LEFT$(UCASE$(Result$), 3) + MID$(LCASE$(Result$), 4)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     Result$ = Result$ + "$"
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) = "(" THEN
    InLine$ = LTRIM$(MID$(InLine$, 2))
    Result$ = Result$ + "("
    Index% = 1
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Result$ = Result$ + LEFT$(UCASE$(Value$), 1) + MID$(LCASE$(Value$), 2)
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       Result$ = Result$ + "$"
     CASE "!"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "@"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "#"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "%"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     CASE "&"
       InLine$ = LTRIM$(MID$(InLine$, 2))
     END SELECT
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       IF Index% = DefFnSArgsCount% THEN ERROR 22
       Index% = Index% + 1
       InLine$ = MID$(InLine$, 2)
       Result$ = Result$ + ","
     CASE ")"
       Result$ = Result$ + ")"
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
    IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
    InLine$ = LTRIM$(MID$(InLine$, 2))
   END IF
   IF LEFT$(InLine$, 1) = "=" THEN
    InLine$ = MID$(InLine$, 2)
    IF DefFnSCountValue% = DefFnSCount% THEN ERROR 31
    DefFnSCountValue% = DefFnSCountValue% + 1
    DefFnS$(DefFnSCountValue%) = Result$ + "=" + ParseCalculate$(InLine$)
   ELSE
    IF NOT RunMode% THEN ERROR 44
    Count% = 0
    FOR Index% = CurrentLine% + 1 TO TextLines% + 1
     IF Index% = TextLines% + 1 THEN ERROR 43
     IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
      WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
      SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
      CASE "0" TO "9"
        LineNumber% = INT(InNumber#(WorkLine$))
        WorkLine$ = LTRIM$(WorkLine$)
        IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
        IF WorkLine$ = "" THEN ERROR 39
        IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
        WorkLine$ = ParseRunLine$(WorkLine$)
      CASE "A" TO "Z"
        WorkLine$ = ParseRunLine$(WorkLine$)
      CASE ELSE
        ERROR 39
      END SELECT
      SELECT CASE InName$(WorkLine$)
      CASE "DEF"
        Result$ = InName$(WorkLine$)
        IF LEFT$(Result$, 2) <> "FN" THEN ERROR 48
        Result$ = LEFT$(UCASE$(Result$), 3) + MID$(LCASE$(Result$), 4)
        WorkLine$ = LTRIM$(WorkLine$)
        SELECT CASE LEFT$(WorkLine$, 1)
        CASE "$"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
          Result$ = Result$ + "$"
        CASE "!"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "@"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "#"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "%"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        CASE "&"
          WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        END SELECT
        IF LEFT$(WorkLine$, 1) = "(" THEN
         WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
         Result$ = Result$ + "("
         Index% = 1
         DO WHILE WorkLine$ <> ""
          Value$ = InName$(WorkLine$)
          Result$ = Result$ + LEFT$(UCASE$(Value$), 1) + MID$(LCASE$(Value$), 2)
          WorkLine$ = LTRIM$(WorkLine$)
          SELECT CASE LEFT$(WorkLine$, 1)
          CASE "$"
            WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
            Result$ = Result$ + "$"
          CASE "!"
            WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
          CASE "@"
            WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
          CASE "#"
            WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
          CASE "%"
            WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
          CASE "&"
            WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
          END SELECT
          SELECT CASE LEFT$(WorkLine$, 1)
          CASE ","
            IF Index% = DefFnSArgsCount% THEN ERROR 22
            Index% = Index% + 1
            WorkLine$ = MID$(WorkLine$, 2)
            Result$ = Result$ + ","
          CASE ")"
            Result$ = Result$ + ")"
            EXIT DO
          CASE ELSE
            ERROR 2
          END SELECT
         LOOP
         IF LEFT$(WorkLine$, 1) <> ")" THEN ERROR 2
         WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
        END IF
        IF WorkLine$ = "" THEN Count% = Count% + 1
      CASE "END"
        WorkLine$ = LTRIM$(WorkLine$)
        IF WorkLine$ <> "" THEN
         IF InName$(WorkLine$) = "DEF" THEN
          IF Count% = 0 THEN EXIT FOR ELSE Count% = Count% - 1
         END IF
        END IF
      END SELECT
     END IF
    NEXT Index%
    CurrentLine% = Index%
   END IF
 CASE "ELSE"
   IF NOT RunMode% THEN ERROR 89
   Count% = 0
   FOR Index% = CurrentLine% + 1 TO TextLines% + 1
    IF Index% = TextLines% + 1 THEN ERROR 90
    IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       WorkLine$ = LTRIM$(WorkLine$)
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
       IF WorkLine$ = "" THEN ERROR 39
       IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE ELSE
       ERROR 39
     END SELECT
     SELECT CASE InName$(WorkLine$)
     CASE "IF"
       Value$ = ParseCalculate$(WorkLine$)
       IF InName$(WorkLine$) <> "THEN" THEN ERROR 2
       WorkLine$ = LTRIM$(WorkLine$)
       IF WorkLine$ = "" THEN Count% = Count% + 1
     CASE "END"
       WorkLine$ = LTRIM$(WorkLine$)
       IF WorkLine$ <> "" THEN
        IF InName$(WorkLine$) = "IF" THEN
         IF Count% = 0 THEN EXIT FOR ELSE Count% = Count% - 1
        END IF
       END IF
     END SELECT
    END IF
   NEXT Index%
   CurrentLine% = Index%
 CASE "END"
   IF InLine$ <> "" THEN
    Statement$ = InName$(InLine$)
    IF (Statement$ <> "IF") AND (Statement$ <> "SELECT") AND (Statement$ <> "DEF") THEN ERROR 2
   ELSE
    IF NOT RunMode% THEN ERROR 32
    RunMode% = False%
   END IF
 CASE "EXIT"
   SELECT CASE InName$(InLine$)
   CASE "DEF"
     ERROR 2
   CASE "WHILE"
     IF NOT RunMode% THEN ERROR 93
     FOR Index% = 1 TO WhilesCount% + 1
      IF Index% = WhilesCount% + 1 THEN ERROR 95
      IF Whiles$(Index%) <> "" THEN
       WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
       StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       Conditional$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
       IF (CurrentLine% >= StartLine%) AND (CurrentLine% <= EndLine%) THEN EXIT FOR
      END IF
     NEXT Index%
     Whiles$(Index%) = ""
     CurrentLine% = EndLine%
   CASE "FROM"
     IF NOT RunMode% THEN ERROR 94
     FOR Index% = 1 TO FromsCount% + 1
      IF Index% = FromsCount% + 1 THEN ERROR 60
       IF Froms$(Index%) <> "" THEN
       WorkLine$ = MID$(Froms$(Index%), INSTR(Froms$(Index%), "(") + 1)
       StartValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       StepValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       CurrentValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       VariableName$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
       IF (CurrentLine% >= StartLine%) AND (CurrentLine% <= EndLine%) THEN EXIT FOR
      END IF
     NEXT Index%
     Froms$(Index%) = ""
     CurrentLine% = EndLine%
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "FILES"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   FILES Result$
 CASE "FROM"
   IF NOT RunMode% THEN ERROR 66
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 45
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "TO" THEN ERROR 2
   Meaning$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "STEP" THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    Work$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
   ELSE
    Work$ = "1.0"
   END IF
   FOR Index% = 1 TO FromsCount% + 1
    IF Index% = FromsCount% + 1 THEN ERROR 65
    IF Froms$(Index%) = "" THEN EXIT FOR
   NEXT Index%
   Count% = 0
   FOR Work% = CurrentLine% + 1 TO TextLines% + 1
    IF Work% = TextLines% + 1 THEN ERROR 26
    IF LTRIM$(RTRIM$(Text$(Work%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Work%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       WorkLine$ = LTRIM$(WorkLine$)
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
       IF WorkLine$ = "" THEN ERROR 39
       IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE ELSE
       ERROR 39
     END SELECT
     SELECT CASE InName$(WorkLine$)
     CASE "FROM"
       Count% = Count% + 1
     CASE "NEXT"
       IF Count% = 0 THEN EXIT FOR
       Count% = Count% - 1
     END SELECT
    END IF
   NEXT Work%
   IF VAL(Value$) < VAL(Meaning$) THEN
    IF VAL(Work$) > 0# THEN
     Froms$(Index%) = "Start value=(" + LTRIM$(STR$(VAL(Value$))) + "). End value=(" + LTRIM$(STR$(VAL(Meaning$))) + "). Step=(" + LTRIM$(STR$(VAL(Work$))) + "). Value=(" + LTRIM$(STR$(VAL(Value$))) + "). StartLine=(" + LTRIM$(STR$(CurrentLine%)) + "). EndLine=(" + LTRIM$(STR$(Work%)) + "). VariableName=" + Result$
     CALL SetVariable(Result$, False%, LTRIM$(STR$(VAL(Value$))))
    ELSE
     CurrentLine% = Work%
    END IF
   ELSEIF VAL(Value$) > VAL(Meaning$) THEN
    IF VAL(Work$) < 0# THEN
     Froms$(Index%) = "Start value=(" + LTRIM$(STR$(VAL(Value$))) + "). End value=(" + LTRIM$(STR$(VAL(Meaning$))) + "). Step=(" + LTRIM$(STR$(VAL(Work$))) + "). Value=(" + LTRIM$(STR$(VAL(Value$))) + "). StartLine=(" + LTRIM$(STR$(CurrentLine%)) + "). EndLine=(" + LTRIM$(STR$(Work%)) + "). VariableName=" + Result$
     CALL SetVariable(Result$, False%, LTRIM$(STR$(VAL(Value$))))
    ELSE
     CurrentLine% = Work%
    END IF
   END IF
 CASE "GO"
   IF NOT RunMode% THEN ERROR 78
   SELECT CASE InName$(InLine$)
   CASE "TO"
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN CurrentLine% = FindLine%(0, Result$, True%) - 1 ELSE CurrentLine% = FindLine%(INT(VAL(Result$)), "", False%)
   CASE "SUB"
     Result$ = Calculate$(InLine$)
     IF GoSubSCountValue% = GoSubSCount% THEN ERROR 77
     GoSubSCountValue% = GoSubSCountValue% + 1
     GoSubS%(GoSubSCountValue%) = CurrentLine%
     IF NumStr% THEN CurrentLine% = FindLine%(0, Result$, True%) - 1 ELSE CurrentLine% = FindLine%(INT(VAL(Result$)), "", False%)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "HANG"
   CALL Hang
 CASE "HELP"
   IF LEFT$(InLine$, 1) = "!" THEN InLine$ = MID$(InLine$, 2)
   COLOR White%, Black%
   CLS
   LOCATE 1, 1, 1, 7, 8
   PageIndex% = 0
   FOR Index% = 1 TO 306
    PRINT HelpText$(Index%)
    PageIndex% = PageIndex% + 1
    IF PageIndex% = 23 THEN
     PageIndex% = 0
     PRINT "ENTER=Continue, ESC=Exit.";
     DO
      Key$ = INKEY$
     LOOP UNTIL (Key$ = CHR$(13)) OR (Key$ = CHR$(27))
     PRINT
     IF Key$ = CHR$(27) THEN EXIT FOR
    END IF
   NEXT Index%
 CASE "IF"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "THEN" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF InLine$ = "" THEN
    IF NOT RunMode% THEN ERROR 89
    IF NOT VAL(Result$) THEN
     Count% = 0
     FOR Index% = CurrentLine% + 1 TO TextLines% + 1
      IF Index% = TextLines% + 1 THEN ERROR 90
      IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
       WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
       SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
       CASE "0" TO "9"
         LineNumber% = INT(InNumber#(WorkLine$))
         WorkLine$ = LTRIM$(WorkLine$)
         IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
         IF WorkLine$ = "" THEN ERROR 39
         IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
         WorkLine$ = ParseRunLine$(WorkLine$)
       CASE "A" TO "Z"
         WorkLine$ = ParseRunLine$(WorkLine$)
       CASE ELSE
         ERROR 39
       END SELECT
       SELECT CASE InName$(WorkLine$)
       CASE "IF"
         Value$ = ParseCalculate$(WorkLine$)
         IF InName$(WorkLine$) <> "THEN" THEN ERROR 2
         WorkLine$ = LTRIM$(WorkLine$)
         IF WorkLine$ = "" THEN Count% = Count% + 1
       CASE "ELSE"
         IF Count% = 0 THEN EXIT FOR
       CASE "END"
         WorkLine$ = LTRIM$(WorkLine$)
         IF WorkLine$ <> "" THEN
          IF InName$(WorkLine$) = "IF" THEN
           IF Count% = 0 THEN EXIT FOR ELSE Count% = Count% - 1
          END IF
         END IF
       END SELECT
      END IF
     NEXT Index%
     CurrentLine% = Index%
    END IF
   ELSE
    Value$ = ParseRunLine$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF InLine$ <> "" THEN
     IF InName$(InLine$) <> "ELSE" THEN ERROR 2
     Meaning$ = ParseRunLine$(InLine$)
     IF VAL(Result$) THEN CALL RunLine(Value$) ELSE CALL RunLine(Meaning$)
    ELSE
     IF VAL(Result$) THEN CALL RunLine(Value$)
    END IF
   END IF
 CASE "KEY"
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "A" TO "Z"
     Work$ = InLine$
     SELECT CASE InName$(InLine$)
     CASE "ON"
       KEY ON
     CASE "OFF"
       KEY OFF
     CASE "LIST"
       KEY LIST
     CASE ELSE
       Result$ = Calculate$(Work$)
       IF NumStr% THEN ERROR 13
       Work$ = LTRIM$(Work$)
       IF LEFT$(Work$, 1) <> "," THEN ERROR 2
       Work$ = MID$(Work$, 2)
       Value$ = Calculate$(Work$)
       IF NOT NumStr% THEN ERROR 13
       KEY VAL(Result$), Value$
     END SELECT
   CASE ELSE
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN ERROR 13
     InLine$ = LTRIM$(InLine$)
     IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
     InLine$ = MID$(InLine$, 2)
     Value$ = Calculate$(InLine$)
     IF NOT NumStr% THEN ERROR 13
     KEY VAL(Result$), Value$
   END SELECT
 CASE "KILL"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   KILL Result$
 CASE "LET"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Work% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Work% = True%
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% <> Work% THEN ERROR 13
   CALL SetVariable(Result$, Work%, Value$)
 CASE "LOCATE"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "IN" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   LOCATE VAL(Value$), VAL(Result$), 1, 7, 8
 CASE "MID"
   IF LEFT$(InLine$, 1) <> "$" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "$" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Meaning$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = LTRIM$(MID$(InLine$, 2))
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Work$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   WorkLine$ = InVariable$(Result$, True%)
   MID$(WorkLine$, VAL(Value$), VAL(Meaning$)) = Work$
   CALL SetVariable(Result$, True%, WorkLine$)
 CASE "MKDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   MKDIR Result$
 CASE "NAME"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   NAME Result$ AS Value$
 CASE "NEXT"
   IF NOT RunMode% THEN ERROR 66
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 45
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   FOR Index% = 1 TO FromsCount% + 1
    IF Index% = FromsCount% + 1 THEN ERROR 1
    IF Froms$(Index%) <> "" THEN
     WorkLine$ = MID$(Froms$(Index%), INSTR(Froms$(Index%), "(") + 1)
     StartValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     StepValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     CurrentValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     VariableName$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
     IF (EndLine% = CurrentLine%) AND (VariableName$ = Result$) THEN EXIT FOR
    END IF
   NEXT Index%
   CurrentValue# = CurrentValue# + StepValue#
   IF StartValue# < EndValue# THEN
    IF CurrentValue# > EndValue# THEN
     Froms$(Index%) = ""
    ELSE
     Froms$(Index%) = "Start value=(" + LTRIM$(STR$(StartValue#)) + "). End value=(" + LTRIM$(STR$(EndValue#)) + "). Step=(" + LTRIM$(STR$(StepValue#)) + "). Value=(" + LTRIM$(STR$(CurrentValue#)) + "). StartLine=(" + LTRIM$(STR$(StartLine%)) + "). EndLine=(" + LTRIM$(STR$(EndLine%)) + "). VariableName=" + VariableName$
     CALL SetVariable(Result$, False%, LTRIM$(STR$(CurrentValue#)))
     CurrentLine% = StartLine%
    END IF
   ELSEIF StartValue# > EndValue# THEN
    IF CurrentValue# < EndValue# THEN
     Froms$(Index%) = ""
    ELSE
     Froms$(Index%) = "Start value=(" + LTRIM$(STR$(StartValue#)) + "). End value=(" + LTRIM$(STR$(EndValue#)) + "). Step=(" + LTRIM$(STR$(StepValue#)) + "). Value=(" + LTRIM$(STR$(CurrentValue#)) + "). StartLine=(" + LTRIM$(STR$(StartLine%)) + "). EndLine=(" + LTRIM$(STR$(EndLine%)) + "). VariableName=" + VariableName$
     CALL SetVariable(Result$, False%, LTRIM$(STR$(CurrentValue#)))
     CurrentLine% = StartLine%
    END IF
   END IF
 CASE "OPEN"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "FOR" THEN ERROR 2
   Work$ = InName$(InLine$)
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF (INT(VAL(Value$)) < 1) OR (INT(VAL(Value$)) > FilesCount%) THEN ERROR 52
   IF OpenFiles$(INT(VAL(Value$))) <> "" THEN ERROR 55
   SELECT CASE Work$
   CASE "INPUT"
     OPEN Result$ FOR INPUT AS #INT(VAL(Value$))
     OpenFiles$(INT(VAL(Value$))) = "IN=" + Result$
   CASE "OUTPUT"
     OPEN Result$ FOR OUTPUT AS #INT(VAL(Value$))
     OpenFiles$(INT(VAL(Value$))) = "OUT=" + Result$
   CASE "APPEND"
     OPEN Result$ FOR APPEND AS #INT(VAL(Value$))
     OpenFiles$(INT(VAL(Value$))) = "OUT=" + Result$
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "PRINT"
   IF LEFT$(InLine$, 1) = "#" THEN
    InLine$ = MID$(InLine$, 2)
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    IF (INT(VAL(Result$)) < 1) OR (INT(VAL(Result$)) > FilesCount%) THEN ERROR 52
    IF OpenFiles$(INT(VAL(Result$))) = "" THEN ERROR 52
    IF MID$(OpenFiles$(INT(VAL(Result$))), 1, INSTR(OpenFiles$(INT(VAL(Result$))), "=") - 1) = "IN" THEN ERROR 54
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    PRINT #INT(VAL(Result$)), Calculate$(InLine$);
   ELSE
    CALL WriteLine(Calculate$(InLine$))
   END IF
 CASE "REBOOT"
   DEF SEG = &HF000
   CALL Absolute(&HFFF0)
 CASE "REM"
   EXIT SUB
 CASE "RETURN"
   IF NOT RunMode% THEN ERROR 78
   IF GoSubSCountValue% = 0 THEN ERROR 3
   CurrentLine% = GoSubS%(GoSubSCountValue%)
   GoSubS%(GoSubSCountValue%) = 0
   GoSubSCountValue% = GoSubSCountValue% - 1
 CASE "RMDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   RMDIR Result$
 CASE "SCREEN"
   SELECT CASE InName$(InLine$)
   CASE "FOURTY"
     WIDTH 40
     COLOR White%, Black%
     CLS
     LOCATE 1, 1, 1, 7, 8
   CASE "EIGHTY"
     WIDTH 80
     COLOR White%, Black%
     CLS
     LOCATE 1, 1, 1, 7, 8
   CASE "MONO"
     WIDTH 80
     SCREEN 0, 0, 0, 0
     COLOR White%, Black%
     CLS
     LOCATE 1, 1, 1, 7, 8
   CASE "COLOR"
     WIDTH 80
     SCREEN 0, 1, 0, 0
     COLOR White%, Black%
     CLS
     LOCATE 1, 1, 1, 7, 8
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "SELECT"
   IF NOT RunMode% THEN ERROR 91
   IF InName$(InLine$) <> "CASE" THEN ERROR 2
   Result$ = Calculate$(InLine$)
   Work% = NumStr%
   Count% = 0
   FOR Index% = CurrentLine% + 1 TO TextLines% + 1
    IF Index% = TextLines% + 1 THEN ERROR 92
    IF LTRIM$(RTRIM$(Text$(Index%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Index%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       WorkLine$ = LTRIM$(WorkLine$)
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
       IF WorkLine$ = "" THEN ERROR 39
       IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE ELSE
       ERROR 39
     END SELECT
     SELECT CASE InName$(WorkLine$)
     CASE "SELECT"
       IF InName$(WorkLine$) <> "CASE" THEN ERROR 2
       Count% = Count% + 1
     CASE "CASE"
       IF Count% = 0 THEN
        Work$ = WorkLine$
        WorkLine$ = LTRIM$(WorkLine$)
        SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
        CASE "A" TO "Z"
          SELECT CASE InName$(WorkLine$)
          CASE "ELSE"
            EXIT FOR
          CASE ELSE
            Value$ = Calculate$(Work$)
            IF NumStr% <> Work% THEN ERROR 13
            Work$ = LTRIM$(Work$)
            IF NumStr% THEN
             IF Result$ = Value$ THEN EXIT FOR
            ELSE
             IF VAL(Result$) = VAL(Value$) THEN EXIT FOR
            END IF
          END SELECT
        CASE ELSE
          Value$ = Calculate$(WorkLine$)
          IF NumStr% <> Work% THEN ERROR 13
          WorkLine$ = LTRIM$(WorkLine$)
          IF NumStr% THEN
           IF Result$ = Value$ THEN EXIT FOR
          ELSE
           IF VAL(Result$) = VAL(Value$) THEN EXIT FOR
          END IF
        END SELECT
       END IF
     CASE "END"
       WorkLine$ = LTRIM$(WorkLine$)
       IF WorkLine$ <> "" THEN
        IF InName$(WorkLine$) = "SELECT" THEN
         IF Count% = 0 THEN EXIT FOR ELSE Count% = Count% - 1
        END IF
       END IF
     END SELECT
    END IF
   NEXT Index%
   CurrentLine% = Index%
 CASE "SHELL"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 2
   SHELL Result$
 CASE "SLEEP"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 2
   SLEEP VAL(Result$)
 CASE "STOP"
   STOP
 CASE "SOUND"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "WITH" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   SOUND INT(VAL(Result$)), INT(VAL(Value$))
 CASE "SWAP"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Work% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Work% = True%
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   Value$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   WorkValue% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     WorkValue% = True%
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "!"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "@"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "#"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "%"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   CASE "&"
     InLine$ = LTRIM$(MID$(InLine$, 2))
   END SELECT
   IF Work% <> WorkValue% THEN ERROR 45
   Meaning$ = InVariable$(Result$, Work%)
   CALL SetVariable(Result$, Work%, InVariable$(Value$, Work%))
   CALL SetVariable(Value$, WorkValue%, Meaning$)
 CASE "SYSTEM"
   WIDTH 80
   COLOR 7, 0
   CLS
   LOCATE 1, 1, 1, 7, 8
   SYSTEM
 CASE "TROFF"
   TraceMode% = False%
   PRINT "Trace mode is turned to OFF."
 CASE "TRON"
   TraceMode% = True%
   PRINT "Trace mode is turned to ON."
 CASE "WEND"
   IF NOT RunMode% THEN ERROR 84
   FOR Index% = 1 TO WhilesCount% + 1
    IF Index% = WhilesCount% + 1 THEN ERROR 30
    IF Whiles$(Index%) <> "" THEN
     WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
     StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     Conditional$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
     IF EndLine% = CurrentLine% THEN EXIT FOR
    END IF
   NEXT Index%
   Result$ = Calculate$(Conditional$)
   IF NumStr% THEN ERROR 13
   IF VAL(Result$) THEN CurrentLine% = StartLine% ELSE Whiles$(Index%) = ""
 CASE "WHILE"
   IF NOT RunMode% THEN ERROR 84
   Conditional$ = InLine$
   Conditional$ = ParseCalculate$(Conditional$)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   FOR Index% = 1 TO WhilesCount% + 1
    IF Index% = WhilesCount% + 1 THEN ERROR 83
    IF Whiles$(Index%) = "" THEN EXIT FOR
   NEXT Index%
   Count% = 0
   FOR Work% = CurrentLine% + 1 TO TextLines% + 1
    IF Work% = TextLines% + 1 THEN ERROR 29
    IF LTRIM$(RTRIM$(Text$(Work%))) <> "" THEN
     WorkLine$ = LTRIM$(RTRIM$(Text$(Work%)))
     SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
     CASE "0" TO "9"
       LineNumber% = INT(InNumber#(WorkLine$))
       WorkLine$ = LTRIM$(WorkLine$)
       IF (LineNumber% < 1) OR (LineNumber% > TextLines%) THEN ERROR 46
       IF WorkLine$ = "" THEN ERROR 39
       IF NOT ((ASC(UCASE$(WorkLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(WorkLine$)) < (ASC("Z") + 1))) THEN ERROR 39
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE "A" TO "Z"
       WorkLine$ = ParseRunLine$(WorkLine$)
     CASE ELSE
       ERROR 39
     END SELECT
     SELECT CASE InName$(WorkLine$)
     CASE "WHILE"
       Count% = Count% + 1
     CASE "WEND"
       IF Count% = 0 THEN EXIT FOR
       Count% = Count% - 1
     END SELECT
    END IF
   NEXT Work%
   IF VAL(Result$) THEN Whiles$(Index%) = "StartLine=(" + LTRIM$(STR$(CurrentLine%)) + "). EndLine=(" + LTRIM$(STR$(Work%)) + "). Conditional=" + Conditional$ ELSE CurrentLine% = Work%
 CASE ELSE
   ERROR 23
 END SELECT
END SUB

SUB ScratchScreen
 DIM Index%
 COLOR 0, 2
 CLS
 COLOR 0, 7
 LOCATE 1, 1, 0
 PRINT CHR$(201) + STRING$(77, CHR$(205)) + CHR$(187);
 FOR Index% = 2 TO 21
  LOCATE Index%, 1, 0
  PRINT CHR$(186) + STRING$(77, CHR$(0)) + CHR$(186) + CHR$(219);
  COLOR 1, 7
  LOCATE Index%, 2, 0
  PRINT MID$(Text$((TextPosition% - PagePosition%) + (Index% - 1)), (LinePosition% - CursorPosition%) + 1, 77);
  COLOR 0, 7
 NEXT Index%
 LOCATE 22, 1, 0
 PRINT CHR$(200) + STRING$(77, CHR$(205)) + CHR$(188) + CHR$(219);
 LOCATE 23, 2, 0
 PRINT STRING$(79, CHR$(219));
 LOCATE 25, 2, 0
 COLOR 15, 4
 PRINT STRING$(78, CHR$(0));
 LOCATE 25, 2, 0
 PRINT LEFT$(StatusLine$, 78);
 COLOR 1, 7
 LOCATE PagePosition% + 1, CursorPosition% + 1, 1, 7, 8
END SUB

FUNCTION SearchDefFn% (DefFnName$, DefFnType%)
 DIM Index%
 DIM WorkDefFn$
 DIM WorkLine$
 DIM Work%
 IF DefFnSCountValue% = 0 THEN
  SearchDefFn% = 0
  EXIT FUNCTION
 END IF
 FOR Index% = 1 TO DefFnSCountValue% + 1
  IF Index% = DefFnSCountValue% + 1 THEN
   SearchDefFn% = 0
   EXIT FUNCTION
  END IF
  WorkDefFn$ = DefFnS$(Index%)
  WorkLine$ = InName$(WorkDefFn$)
  WorkDefFn$ = LTRIM$(WorkDefFn$)
  Work% = False%
  SELECT CASE LEFT$(WorkDefFn$, 1)
  CASE "$"
    Work% = True%
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "!"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "@"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "#"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "%"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  CASE "&"
    WorkDefFn$ = LTRIM$(MID$(WorkDefFn$, 2))
  END SELECT
  IF (WorkLine$ = DefFnName$) AND (Work% = DefFnType%) THEN EXIT FOR
 NEXT Index%
 SearchDefFn% = Index%
END FUNCTION

SUB SetVariable (VariableName$, VariableType%, VariableData$)
 DIM Index%
 IF (VariableName$ = "DATE") AND VariableType% THEN
  DATE$ = VariableData$
 ELSEIF (VariableName$ = "TIME") AND VariableType% THEN
  TIME$ = VariableData$
 ELSEIF (VariableName$ = "ENVIRONMENT") AND VariableType% THEN
  ENVIRON VariableData$
 ELSEIF (VariableName$ = "RANDOM") AND (NOT VariableType%) THEN
  RANDOMIZE VAL(VariableData$)
 ELSEIF (VariableName$ = "TIMERDATA") AND (NOT VariableType%) THEN
  CALL OutTimerValue(INT(VAL(VariableData$)))
 ELSE
  IF VariablesCountValue% = 0 THEN
   VariablesCountValue% = 1
   Variables$(VariablesCountValue%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableData$
  ELSE
   FOR Index% = 1 TO VariablesCountValue% + 1
    IF Index% = VariablesCountValue% + 1 THEN
     IF VariablesCountValue% = VariablesCount% THEN ERROR 88
     VariablesCountValue% = VariablesCountValue% + 1
     Variables$(VariablesCountValue%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableData$
     EXIT FOR
    END IF
    IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     Variables$(Index%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableData$
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 END IF
END SUB

FUNCTION SquareRoot# (Meaning#)
 DIM Value#
 DIM ControlValue#
 Value# = 1#
 ControlValue# = 0#
 WHILE Value# <> ControlValue#
  ControlValue# = Value#
  Value# = ((Meaning# / Value#) + Value#) / 2#
 WEND
 SquareRoot# = Value#
END FUNCTION

FUNCTION StandartStatus$
 DIM WorkLine$
 WorkLine$ = "ESC=Menu. Row=" + LTRIM$(STR$(TextPosition%)) + ". Column=" + LTRIM$(STR$(LinePosition%)) + ". Date: "
 SELECT CASE DayOfWeek%(VAL(MID$(DATE$, 4, 2)), VAL(LEFT$(DATE$, 2)), VAL(MID$(DATE$, 7, 4)))
 CASE 1
   WorkLine$ = WorkLine$ + "Mon"
 CASE 2
   WorkLine$ = WorkLine$ + "Tue"
 CASE 3
   WorkLine$ = WorkLine$ + "Wed"
 CASE 4
   WorkLine$ = WorkLine$ + "Thu"
 CASE 5
   WorkLine$ = WorkLine$ + "Fri"
 CASE 6
   WorkLine$ = WorkLine$ + "Sat"
 CASE 7
   WorkLine$ = WorkLine$ + "Sun"
 END SELECT
 WorkLine$ = WorkLine$ + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + " "
 SELECT CASE VAL(LEFT$(DATE$, 2))
 CASE 1
   WorkLine$ = WorkLine$ + "Jan"
 CASE 2
   WorkLine$ = WorkLine$ + "Feb"
 CASE 3
   WorkLine$ = WorkLine$ + "Mar"
 CASE 4
   WorkLine$ = WorkLine$ + "Apr"
 CASE 5
   WorkLine$ = WorkLine$ + "May"
 CASE 6
   WorkLine$ = WorkLine$ + "Jun"
 CASE 7
   WorkLine$ = WorkLine$ + "Jul"
 CASE 8
   WorkLine$ = WorkLine$ + "Aug"
 CASE 9
   WorkLine$ = WorkLine$ + "Sep"
 CASE 10
   WorkLine$ = WorkLine$ + "Oct"
 CASE 11
   WorkLine$ = WorkLine$ + "Nov"
 CASE 12
   WorkLine$ = WorkLine$ + "Dec"
 END SELECT
 WorkLine$ = WorkLine$ + " " + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + "."
 IF Language% THEN StandartStatus$ = WorkLine$ + SPACE$(1) + "RU" ELSE StandartStatus$ = WorkLine$ + SPACE$(1) + "EN"
END FUNCTION

FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
 WeekNumber% = INT((MonthDays%(MonthValue%, YearValue%) + DayValue%) / 7) + 1
END FUNCTION

SUB WriteLine (OutLine$)
 DIM Index%
 FOR Index% = 1 TO LEN(OutLine$)
  CALL ANSIOut(MID$(OutLine$, Index%, 1))
 NEXT Index%
END SUB

SUB WriteLineCRLF (OutLine$)
 CALL WriteLine(OutLine$ + CHR$(10))
END SUB

