// ------------------------------------------------------------------------
// System       : MS-DOS
// Program      : which.c
// Description  : search for a file using the searchpath in the environment.
//                return a dos errorlevel that can be used by a batch file.
// Written by   : Bill Buckels
// Date Written : January 19, 1995
// Revision     : 1.1 First Release
//                1.2 Added Support For Long FileNames - Feb 2000
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define _FIRST_ 0
#define ASCIIZ  0
#define SUCCESS 0
#define FAILURE 1
#define DEBUG   1
#define TRUE    1
#define FALSE   0

#define MAX_BUFFER_SIZE (256 + 1)

int bQUIET = FALSE;
char *lpTitle =
         "which(C) CopyLeft Bill Buckels 1995-2000. All Rights Reversed.";
char *lpUsage =
         "Usage is : \"which [filename] [environmentvarname] QUIET\"";

int SearchPath(char *lpszFileName, char *lpszVarName)
{
    unsigned char szPath[MAX_BUFFER_SIZE], *lpPath, c;
    int i;

    for(i=0;lpszVarName[i]!=ASCIIZ;i++)
    {
      c=lpszVarName[i];
      lpszVarName[i]=toupper(c);
    }
    lpPath=getenv(lpszVarName);
    if(lpPath==NULL)
    {
        if(bQUIET==FALSE)printf("%s\n%s not set!\n",lpTitle,lpszVarName);
        return FAILURE;

    }

    szPath[_FIRST_]=ASCIIZ;
    _searchenv(lpszFileName,lpszVarName,szPath);
    if(szPath[_FIRST_]==ASCIIZ)
    {
        if(bQUIET==FALSE)printf("%s\n%s not found!\n",lpTitle,lpszFileName);
        return FAILURE;
    }

    if(bQUIET==FALSE)
    {
        puts(lpTitle);
        puts(szPath);
    }
    return SUCCESS;
}


char szFileName[MAX_BUFFER_SIZE];

void main(int argc, char **argv)
{
    if (argc > 1)
      strcpy(szFileName, argv[1]);

    switch(argc)
    {
      case 4: if(strcmpi(argv[3],"QUIET")!=0)break;
              bQUIET = TRUE;
      case 3: if(strcmpi(argv[2],"QUIET")!=0)
                exit(SearchPath(szFileName,argv[2]));
              bQUIET = TRUE;
      case 2: exit(SearchPath(szFileName,"PATH"));

    }
    puts(lpTitle);
    puts(lpUsage);

exit(FAILURE);
}
