// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : dict.c
// Description  : Filter to list individual words, one word per line.
//                Only alphabetic characters are retained - no case
//                changes are performed. Words must be longer than 1
//                character.
//
//                Output can be piped through sort to group duplicates,
//                then through uniq to remove duplicates, to build
//                unique word lists.
//
// Written by   : Bill Buckels
// Based On     : translat.asm
//                used with permission
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------

#include <stdio.h>

void main(int argc, char **argv)
{
    int c, d, cnt = 0;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "r");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;

      // alpha only (and hyphens)
      if(c > 64 && c < 91 || c > 96 && c < 123 || c == '-' && cnt > 0) {
        if (cnt == 0)
          d = c;
        if (cnt == 1)
          putchar(d);
        if (cnt > 0)
          putchar(c);
        cnt++;
        continue;
      }
      // non alpha is the end of the word
      if (cnt > 1)
        putchar('\n');
      cnt = 0;
    }

    if (cnt > 1)
      putchar('\n');

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
