// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : truncate.c
// Description  : Filter to truncate each line at the character
//                specified on the command line or the eol char. If no
//                command line then each line will be truncated at the
//                first space (which includes leading spaces as well.)
//
//                Useful to strip trailing comments from a shell-script,
//                or to create a fixed length line with trailing white
//                spaces for flat file creation by stripping a "pound
//                sign" or some other eol token.
//
// Written by   : Bill Buckels
// Based On     : trunc.asm
//                used with permission
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>

char infile[_MAX_PATH] = "\0";

void main(int argc, char **argv)
{
    int c, d = ' ', i, action = 1;
    FILE *fp = NULL;

    if (argc > 1) {
      for (i = 1; i < argc; i++) {
        if (argv[i][0] > 0 && argv[i][1] == 0) {
          d = argv[i][0];   /* 1 character in length */
        }
        else {
          if (infile[0] == 0)
            strcpy(infile, argv[i]);
        }
      }
    }

    if (argc > 1)
      fp = fopen(infile, "r");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;

      if (c == '\n')
        action = 1;

      if (c == d)
        action = 0;

      if (c == '\r')
        continue;

      if (action == 1)
        putchar(c);
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
