// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : untab.c
// Description  : A tabstop filter which takes a command line argument
//                of the number of spaces per tabstop.
//                Default is 8.
//                Use this to pipe tabfree output to stdout or a file.
//
// Written by   : Bill Buckels
// Date Written : 1996
// Revision     : 2.0 March 2000
// ------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>

char infile[_MAX_PATH] = "\0";
FILE *fp = NULL;

main(int argc, char **argv)
{
    int c,
        i,
        spaces,
        tabstop = 8;    // default to 8 space max per tab

    // if a valid numeric argument use the tabstop
    // value that was entered on the command line

    if (argc > 1) {
      for (i = 1; i < argc; i++) {
        if (argv[i][0] >= '1' && argv[i][0] <= '9') {
          tabstop = atoi(argv[i]);
        }
        else {
          if (infile[0] == 0)
            strcpy(infile, argv[i]);
        }
      }
    }
    if (infile[0] != 0) {
      fp = fopen(infile, "r");
    }

    spaces = tabstop;   // initialize spaces to a full tab
    for(;;)
    {
        if (NULL == fp)
          c = getchar();
        else
          c = fgetc(fp);

        if (c==EOF)break;

        if(c=='\n')   // eol found, so reset spaces to a full tabstop
        {
          spaces = tabstop;
        }
        else
        {
          if(c=='\t') // tab found, so print remaining spaces
          {
            for(i=0;i<spaces;i++)putchar(32);
            spaces = tabstop;
            continue;
          }
          spaces--;   // other character found, one less space required
                      // until next tabstop

          if(spaces == 0)spaces = tabstop; // spaces are all used so
                                           // reset to a full tabstop
        }
        putchar(c);
    }
    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
