/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.JdbTable;
import com.borland.dx.dataset.CustomPaintSite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class TableFastStringRenderer
extends Component
implements TableCellRenderer,
CustomPaintSite,
Serializable {
    private String value;
    private int horizontalAlignment = 2;
    private int verticalAlignment = 0;
    private Color foreground;
    private Color background;
    private int alignment;
    private Insets margins;
    private Border border;
    private int x = 0;
    private int y = 0;
    private int width = 0;
    private int height = 0;
    private Border noFocusBorder = new EmptyBorder(1, 2, 1, 2);
    private int defaultAlignment;
    private Color defaultForeground;
    private Color defaultBackground;
    private Insets defaultMargins;
    private Font defaultFont;

    public TableFastStringRenderer() {
        this.setDefaultMargins(new Insets(2, 2, 2, 2));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.defaultForeground == null) {
            this.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
        }
        if (this.defaultBackground == null) {
            this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        }
        this.setDefaultFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column) && table instanceof JdbTable) {
                JdbTable jdbTable = (JdbTable)table;
                if (jdbTable.getEditableFocusedCellForeground() != null) {
                    this.setDefaultForeground(jdbTable.getEditableFocusedCellForeground());
                }
                if (jdbTable.getEditableFocusedCellBackground() != null) {
                    this.setDefaultBackground(jdbTable.getEditableFocusedCellBackground());
                }
            }
        } else {
            this.setBorder(this.noFocusBorder);
        }
        this.setValue(value);
        return this;
    }

    public void setDefaultForeground(Color foreground) {
        this.defaultForeground = foreground;
        this.setForeground(foreground);
    }

    public void setDefaultBackground(Color background) {
        this.defaultBackground = background;
        this.setBackground(background);
    }

    public void setDefaultAlignment(int alignment) {
        this.defaultAlignment = alignment;
        this.convertAlignment(alignment);
    }

    private void convertAlignment(int alignment) {
        this.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(alignment, true));
        this.setVerticalAlignment(DBUtilities.convertJBCLToSwingAlignment(alignment, false));
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
        this.setFont(font);
    }

    public void setDefaultMargins(Insets margins) {
        this.defaultMargins = margins;
        this.setItemMargins(margins);
    }

    public void reset() {
        this.setForeground(this.defaultForeground);
        this.setBackground(this.defaultBackground);
        this.setFont(this.defaultFont);
        this.convertAlignment(this.defaultAlignment);
        this.setItemMargins(this.defaultMargins);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.convertAlignment(alignment);
    }

    public void setItemMargins(Insets margins) {
        this.setMargins(margins);
    }

    public boolean isTransparent() {
        return false;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Insets getItemMargins() {
        return this.margins;
    }

    public Component getSiteComponent() {
        return this;
    }

    public void setBounds(int x2, int y2, int width, int height) {
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
    }

    public void setValue(Object value) {
        this.value = value == null ? "" : value.toString();
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public Border getBorder() {
        return this.border;
    }

    public void paint(Graphics g2) {
        int yOffset;
        int xOffset;
        Font oldFont = g2.getFont();
        Color oldColor = g2.getColor();
        g2.setFont(this.getFont());
        FontMetrics fm = g2.getFontMetrics(this.getFont());
        switch (this.horizontalAlignment) {
            default: {
                xOffset = this.margins.left;
                break;
            }
            case 0: {
                xOffset = (this.width - fm.stringWidth(this.value)) / 2;
                break;
            }
            case 4: {
                xOffset = this.width - fm.stringWidth(this.value) - this.margins.right;
            }
        }
        switch (this.verticalAlignment) {
            default: {
                yOffset = this.margins.top;
                break;
            }
            case 0: {
                yOffset = (this.height - fm.getHeight()) / 2;
                break;
            }
            case 3: {
                yOffset = this.height - fm.getHeight() - this.margins.bottom;
            }
        }
        yOffset += fm.getLeading() + fm.getAscent();
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.width, this.height);
        if (this.value != null) {
            g2.setColor(this.getForeground());
            g2.drawString(this.value, xOffset, yOffset);
        }
        this.border.paintBorder(this, g2, 0, 0, this.width, this.height);
        g2.setFont(oldFont);
        g2.setColor(oldColor);
    }
}

