/*
 * Decompiled with CFR 0.152.
 */
package com.borland.dbswing;

import com.borland.dbswing.DBExceptionHandler;
import com.borland.dbswing.DBPlainDocument;
import com.borland.dbswing.DBTableModel;
import com.borland.dbswing.DBUtilities;
import com.borland.dbswing.Res;
import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.ValidationException;
import com.borland.dx.dataset.Variant;
import com.borland.dx.text.InvalidFormatException;
import com.borland.dx.text.ItemEditMask;
import com.borland.dx.text.ItemEditMaskState;
import com.borland.dx.text.VariantFormatter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;

public class TableMaskCellEditor
extends JTextField
implements TableCellEditor,
DocumentListener,
ActionListener,
CustomPaintSite,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    protected VariantFormatter formatter;
    protected boolean touched;
    protected int columnIndex;
    protected Variant variantValue;
    protected transient ChangeEvent changeEvent = new ChangeEvent(this);
    protected boolean ignoreModelChange;
    protected int alignment;
    protected int defaultAlignment;
    protected Color defaultForeground;
    protected Color defaultBackground;
    protected Insets defaultMargins = new Insets(0, 0, 0, 0);
    protected Font defaultFont;
    protected ItemEditMask ems;
    protected ItemEditMaskState state;
    protected Variant maskVariant;
    protected int type;
    protected JTable table;
    protected DBTableModel dbTableModel;
    protected ActionEvent tabEvent;
    protected boolean ignoreEndEdit = false;
    protected boolean allowCellSelection = true;
    protected boolean acceptKeyReleasedEvent;
    static Class class$javax$swing$event$CellEditorListener;

    public TableMaskCellEditor() {
        this.setMargin(this.defaultMargins);
        this.getDocument().addDocumentListener(this);
        this.addActionListener(this);
        this.variantValue = new Variant();
    }

    protected Document createDefaultModel() {
        return new DBPlainDocument();
    }

    public void setMaxLength(int maxLength) {
        if (this.getDocument() instanceof DBPlainDocument) {
            ((DBPlainDocument)this.getDocument()).setMaxLength(maxLength);
        }
    }

    public void setFormatter(VariantFormatter formatter) {
        this.formatter = formatter;
    }

    public Object getCellEditorValue() {
        if (this.ems != null) {
            return this.maskVariant;
        }
        return this.variantValue;
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            if (((MouseEvent)anEvent).getClickCount() > 1) {
                return true;
            }
        } else if (anEvent == null || anEvent instanceof KeyEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TableMaskCellEditor.this.requestFocus();
                    TableMaskCellEditor.this.setCaretPosition(TableMaskCellEditor.this.getDocument().getLength());
                }
            });
            return true;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this.allowCellSelection;
    }

    public boolean stopCellEditing() {
        if (!this.touched) {
            this.table.removeEditor();
            return true;
        }
        if (this.isValidValue()) {
            if (!this.ignoreEndEdit) {
                this.ignoreEndEdit = true;
                this.fireEditingStopped();
                this.ignoreEndEdit = false;
            }
            return true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TableMaskCellEditor.this.requestFocus();
            }
        });
        this.allowCellSelection = false;
        return false;
    }

    public void cancelCellEditing() {
        this.fireEditingCancelled();
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.table = table;
        if (table.getModel() instanceof DBTableModel) {
            this.dbTableModel = (DBTableModel)table.getModel();
        }
        this.columnIndex = column;
        this.touched = false;
        this.acceptKeyReleasedEvent = true;
        this.setValue(value);
        return this;
    }

    public void setValue(Object value) {
        this.ignoreModelChange = true;
        if (this.ems != null) {
            if (value != null) {
                this.variantValue.setFromString(this.type, value.toString());
                this.state = this.ems.prepare(this.variantValue);
            } else {
                this.state = this.ems.prepare(null);
            }
            this.ems.move(this.state, 35);
            this.updateDisplay();
        } else if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        this.ignoreModelChange = false;
    }

    public void insertUpdate(DocumentEvent e2) {
        this.textModified(e2);
    }

    public void removeUpdate(DocumentEvent e2) {
        this.textModified(e2);
    }

    public void changedUpdate(DocumentEvent e2) {
        this.textModified(e2);
    }

    private void textModified(DocumentEvent e2) {
        if (!this.ignoreModelChange && !this.touched && this.dbTableModel != null) {
            try {
                this.dbTableModel.getDataSet().startEdit(this.dbTableModel.getColumn(this.table.convertColumnIndexToModel(this.columnIndex)));
            }
            catch (DataSetException ex) {
                DBExceptionHandler.handleException(this.dbTableModel.getDataSet(), ex);
            }
            this.touched = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidValue() {
        if (this.ems != null) {
            if (this.maskVariant == null) {
                this.maskVariant = new Variant();
            }
            try {
                if (!this.ems.isComplete(this.state)) {
                    throw new InvalidFormatException(Res.bundle.getString(23));
                }
                this.ems.getFinalValue(this.state, this.maskVariant);
                return true;
            }
            catch (Exception ex) {
                if (ex instanceof InvalidFormatException) {
                    this.state.cursorPos = ((InvalidFormatException)ex).getErrorOffset();
                }
                this.updateSelection();
                try {
                    ValidationException.invalidFormat(ex, null, null);
                    return false;
                }
                catch (ValidationException ex2) {
                    DBExceptionHandler.handleException(this.dbTableModel.getDataSet(), ex2);
                }
                return false;
            }
        }
        if (this.formatter == null) {
            this.variantValue.setString(this.getText());
            return true;
        }
        try {
            String oldPattern = null;
            Object widePattern = null;
            try {
                try {
                    this.formatter.parse(this.getText(), this.variantValue);
                }
                catch (Exception e2) {
                    ValidationException.invalidFormat(e2, null, null);
                    Object var5_10 = null;
                    if (widePattern == null) return true;
                    this.formatter.setPattern(oldPattern);
                    return true;
                }
                Object var5_9 = null;
                if (widePattern == null) return true;
                this.formatter.setPattern(oldPattern);
                return true;
            }
            catch (Throwable throwable) {
                Object var5_11 = null;
                if (widePattern == null) throw throwable;
                this.formatter.setPattern(oldPattern);
                throw throwable;
            }
        }
        catch (Exception ex) {
            try {
                ValidationException.invalidFormat(ex, null, null);
                return false;
            }
            catch (ValidationException ex2) {
                DBExceptionHandler.handleException(this.dbTableModel.getDataSet(), this, ex2);
            }
            return false;
        }
    }

    public void actionPerformed(ActionEvent e2) {
        if (this.isValidValue()) {
            this.fireEditingStopped();
        }
    }

    public void addCellEditorListener(CellEditorListener l2) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = TableMaskCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l2);
    }

    public void removeCellEditorListener(CellEditorListener l2) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = TableMaskCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l2);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != (class$javax$swing$event$CellEditorListener == null ? TableMaskCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
            ((CellEditorListener)listeners[i2 + 1]).editingStopped(this.changeEvent);
        }
    }

    protected void fireEditingCancelled() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i2 = listeners.length - 2; i2 >= 0; i2 -= 2) {
            if (listeners[i2] != (class$javax$swing$event$CellEditorListener == null ? TableMaskCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) continue;
            ((CellEditorListener)listeners[i2 + 1]).editingCanceled(this.changeEvent);
        }
    }

    public void setDefaultForeground(Color foreground) {
        this.defaultForeground = foreground;
        this.setForeground(foreground);
    }

    public void setDefaultBackground(Color background) {
        this.defaultBackground = background;
        this.setBackground(background);
    }

    public void setDefaultAlignment(int alignment) {
        this.defaultAlignment = alignment;
        this.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(alignment, true));
    }

    public void setDefaultFont(Font font) {
        this.defaultFont = font;
        this.setFont(font);
    }

    public void reset() {
        this.setForeground(this.defaultForeground);
        this.setBackground(this.defaultBackground);
        this.setFont(this.defaultFont);
        this.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(this.defaultAlignment, true));
        this.setMargin(this.defaultMargins);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
        this.setHorizontalAlignment(DBUtilities.convertJBCLToSwingAlignment(alignment, true));
    }

    public void setItemMargins(Insets margins) {
        this.setMargin(margins);
    }

    public boolean isTransparent() {
        return false;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public Insets getItemMargins() {
        return this.getMargin();
    }

    public Component getSiteComponent() {
        return this;
    }

    public void setEditMasker(ItemEditMask ems) {
        this.ems = ems;
    }

    public void setVariantType(int type) {
        this.type = type;
    }

    protected void processKeyEvent(KeyEvent e2) {
        if (e2.getKeyCode() == 9) {
            if (!this.isValidValue()) {
                e2.consume();
                return;
            }
            if (this.tabEvent == null) {
                this.tabEvent = new ActionEvent(this.table, 1001, null);
            }
            if (e2.isShiftDown()) {
                this.table.getActionForKeyStroke(KeyStroke.getKeyStroke(9, 1)).actionPerformed(this.tabEvent);
            } else {
                this.table.getActionForKeyStroke(KeyStroke.getKeyStroke(9, 0)).actionPerformed(this.tabEvent);
            }
        } else if (e2.getKeyCode() == 10 && !e2.isControlDown()) {
            if (this.isValidValue()) {
                this.fireEditingStopped();
                e2.consume();
                return;
            }
        } else if (this.ems != null) {
            this.handleKeyEvent(e2);
        }
        super.processKeyEvent(e2);
    }

    private void handleKeyEvent(KeyEvent e2) {
        int id = e2.getID();
        int keyCode = e2.getKeyCode();
        if (!this.acceptKeyReleasedEvent && id != 401 && id != 400) {
            return;
        }
        switch (keyCode) {
            case 35: 
            case 36: 
            case 37: 
            case 39: {
                this.ems.move(this.state, keyCode);
                this.updateSelection();
                break;
            }
            case 8: {
                if (!this.ems.move(this.state, 37)) break;
                this.updateSelection();
                this.deleteSelection(false);
                this.updateDisplay();
                break;
            }
            case 127: {
                this.deleteSelection(false);
                this.ems.move(this.state, 39);
                this.updateDisplay();
                break;
            }
            case 9: 
            case 10: {
                if (id == 400) break;
                return;
            }
            case 27: {
                this.cancelCellEditing();
                break;
            }
            default: {
                if (e2.isControlDown() && keyCode == 86 || e2.isShiftDown() && keyCode == 155) {
                    Clipboard clipboard = this.getToolkit().getSystemClipboard();
                    Transferable content = clipboard.getContents(this);
                    if (content != null) {
                        try {
                            String data = (String)content.getTransferData(DataFlavor.stringFlavor);
                            if (data.length() > 0) {
                                this.deleteSelection(true);
                            }
                            int end = data.length();
                            for (int i2 = 0; i2 < end; ++i2) {
                                this.ems.insert(this.state, data.charAt(i2));
                            }
                            this.updateDisplay();
                        }
                        catch (Exception ex) {
                            this.getToolkit().beep();
                        }
                    }
                    e2.consume();
                    return;
                }
                char ch = e2.getKeyChar();
                if (!this.acceptKeyReleasedEvent && id != 400 || ch >= '\u0000' && ch < ' ') {
                    if (ch == '\b') {
                        e2.consume();
                    }
                    return;
                }
                this.deleteSelection(true);
                this.ems.insert(this.state, ch);
                this.updateDisplay();
            }
        }
        if (this.acceptKeyReleasedEvent) {
            this.acceptKeyReleasedEvent = false;
        }
        e2.consume();
    }

    private void updateSelection() {
        if (this.state != null) {
            this.select(this.state.cursorPos, this.state.cursorPos + 1);
        }
    }

    private void updateDisplay() {
        if (this.state != null) {
            this.setText(this.state.displayString.toString());
            this.updateSelection();
        }
    }

    private void deleteSelection(boolean preserveAtCursor) {
        int selStart = this.getSelectionStart();
        int selEnd = this.getSelectionEnd();
        int nChars = selEnd - selStart;
        if (nChars > 1 || !preserveAtCursor) {
            this.ems.delete(this.state, selStart, nChars);
        }
    }

    protected void processMouseEvent(MouseEvent e2) {
        if (this.ems != null && e2.getID() == 500) {
            this.handleMouseClicked(e2);
        } else {
            super.processMouseEvent(e2);
        }
    }

    private void handleMouseClicked(MouseEvent e2) {
        this.state.cursorPos = this.viewToModel(e2.getPoint());
        this.ems.move(this.state, 500);
        this.updateSelection();
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }
}

