;DIAL-RES v2.0		assembled with TASM 3

; Usually, no action when you hit Enter the 1st time, but then
; retry or ALT-R works, and OK after that...

;Problem w/ITRACK on long dist: space ends number !  Intelligent scan
; (if 1st=1 then next 10 can incl space after 1st, 4th if total = 11 ??)

; Nice if it hilited what it was going to dial, and cursor keys moved to
; next possible number to dial...and Tab moved to next field.
; And it would remind you to hit Esc !

;Needs a better way to set COM port:
; Run /? shows instructions, auto-finds modem & sets port, & changes hot keys ?
;  (need not take these parts resident)

;Add Dial to the PMS Editor menu ??  Takes very little code, need not be TSR...
; Use Alt-T(elephone) or Alt-M(odem)
; Have PMS install the dialer so can dial in any pgm run from PMS ?
; Add Options Port ?

cr	EQU	0Dh
lf	EQU	0Ah

CSEG	segment	byte public
	assume	CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

	ORG	0100h

Start:	JMP	Begin			;get command line params
					; (at end in case stack overwrites)
ParamsDone:
	MOV	BX,OFFSET EndPgm+160	;DECIMAL
	MOV	SP,BX
	MOV	CL,4
	SHR	BX,CL			;divide by 16d
	INC	BX
	PUSH	BX
	PUSH	ES
	MOV	AX,3516h
	INT	21h			;Get Int 16h vector
	MOV	OldInt16Offset,BX
	MOV	OldInt16Seg,ES
	POP	ES
	POP	BX
	MOV	AX,2516h
	MOV	DX,OFFSET NewInt16h
	INT	21h
	MOV	AX,3100h		;go resident
	MOV	DX,BX
	INT	21h

		DB	'Dial and Redial keys:'
DialKey		DW	2000h		;ALT-D
RedialKey	DW	1300h		;ALT-R
PhoneNoChars	DB	'1234567890,-()*#',0
ATDT_str	DB	'ATDT',0,'more modem dial commands'
CRstr		DB	cr,0
ATH0_Str	DB	'ATH0',cr,0,'and hangup commands'
NumberBuffer	DB	50h DUP (0)
PortNo		DW	0
VideoMode	DB	0
VideoPage	DB	0
LastColumn	DB	0
LastRow		DB	0
OldInt16Offset	DW	0
OldInt16Seg	DW	0
SavedSP		DW	0
SavedSS		DW	0
SavedSP_2	DW	0
SavedSS_2	DW	0
PathPointer	DW	0
INT16func	DB	0
RowAndColumn	DW	0
CursorScanLines	DW	0
ScanCode	DW	0
PrevPos		DW	0A14h		;row 10d, column 20d

NewInt16h:
	STI
	MOV	CS:INT16func,AH
	OR	AH,AH
	JZ	ReadChar
	CMP	AH,10h
	JZ	ReadChar
	JMP	SHORT OtherFuncs

ReadChar:
	PUSHF
	CALL	DWORD PTR CS:OldInt16Offset
	CMP	AX,DialKey		;default 2000h, Alt-D
	JZ	ALT_hit
	CMP	AX,RedialKey		;default 1300h, Alt-R
	JZ	ALT_hit
	IRET

OtherFuncs:
	PUSHF
	CALL	DWORD PTR CS:OldInt16Offset
	JZ	Retf1			;Z set if no character available
	PUSHF
	CMP	AX,2000h
	JZ	ALT_hit2
	CMP	AX,1300h
	JZ	ALT_hit2
	POPF
Retf1:	RETF	2

;ALT-D or ALT-R has been hit
ALT_hit2:
	ADD	SP,2			;take care of the PUSHF
	PUSH	AX			;has scan code for ALT-R or ALT-D
	SUB	AH,AH			;read kbd character
	PUSHF
	CALL	DWORD PTR CS:OldInt16Offset
	MOV	AH,1			;get kbd status (returns Z set if char)
	MOV	CS:INT16func,1
	POP	AX			;scan code
ALT_hit:
	MOV	CS:SavedSS_2,SS
	MOV	CS:SavedSP_2,SP
	PUSH	CS
	POP	SS
	MOV	SP,OFFSET EndPgm+90	;DECIMAL
	PUSHF
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSH	SI
	PUSH	BP
	PUSH	DS
	PUSH	ES
	PUSH	CS
	POP	DS
	PUSH	CS
	POP	ES
	CLD
	MOV	ScanCode,AX
	PUSH	AX
	PUSH	BX
;get screen rows & columns
	MOV	AH,0Fh			;Get display mode
	CALL	DoVideoInt
	MOV	VideoMode,AL
	DEC	AH			;no of columns-1 = last column
	MOV	LastColumn,AH
	MOV	VideoPage,BH
	PUSH	ES
	XOR	BX,BX
	MOV	ES,BX
	MOV	BH,BYTE PTR ES:0484h
	POP	ES
	MOV	LastRow,BH
;save cursor location and size
	PUSH	CX
	MOV	AH,3			;Read cursor position and size
	MOV	BH,VideoPage
	CALL	DoVideoInt
	MOV	RowAndColumn,DX
	MOV	CursorScanLines,CX
	POP	CX
	POP	BX
	POP	AX
;now DX still has cursor location
	CMP	ScanCode,1300h 		;ALT-R, redial ?
	JNZ	GetAndDial		;if not ALT-R, must be ALT-D, dial
	JMP	Redial

GetAndDial:
;check for cursor off screen (as in PMS editor)
	CMP	DH,LastRow
	JBE	RowOK
	MOV	DX,PrevPos
RowOK:	CMP	DL,LastColumn
	JBE	ColOK
	MOV	DX,PrevPos
ColOK:	MOV	AH,1			;Set cursor type
	MOV	CX,0207h		;scan lines for cursor
	CALL	DoVideoInt
GetCursorKey:
	CALL	SetCrsrPos		;DH=row, DL=column
	SUB	AH,AH
	PUSHF
	CALL	DWORD PTR DS:OldInt16Offset
	CMP	AX,4800h
	JZ	UpArrow
	CMP	AX,5000h
	JZ	DownArrrow
	CMP	AX,4B00h
	JZ	LeftArrow
	CMP	AX,4D00h
	JZ	RightArrow
	CMP	AX,4700h
	JZ	Home
	CMP	AX,4F00h
	JZ	LineEnd
	CMP	AX,4900h		;PgUp
	JZ	PgUp
	CMP	AX,7700h		;Ctrl-Home does same thing
	JZ	PgUp
	CMP	AX,5100h		;PgDn
	JZ	PgDn
	CMP	AX,7500h		;Ctrl-End does same thing
	JZ	PgDn
	CMP	AL,1Bh
	JNZ	NotEsc
	JMP	EscHit
NotEsc:	CMP	AL,cr			;0Dh
	JZ	EnterHit
	CMP	AL,' '			;20h
	JNZ	GetCursorKey
	JMP	Hangup

UpArrow:
	DEC	DH
	JGE	GetCursorKey
	XOR	DH,DH
	JMP	SHORT GetCursorKey

DownArrrow:
	INC	DH
	CMP	DH,LastRow
	JNG	GetCursorKey
	MOV	DH,LastRow
	JMP	SHORT GetCursorKey

LeftArrow:
	DEC	DL
	JGE	GetCursorKey
	XOR	DL,DL
	JMP	SHORT GetCursorKey

RightArrow:
	INC	DL
	CMP	DL,LastColumn
	JNG	GetCursorKey
	MOV	DL,LastColumn		;don't go past end of line !
	JMP	SHORT GetCursorKey

PgUp:	XOR	DH,DH			;Row zero and...
Home:	XOR	DL,DL			;Column zero
	JMP	SHORT GetCursorKey

PgDn:	MOV	DH,LastRow
	JMP	SHORT Home

LineEnd:MOV	DL,LastColumn
	JMP	GetCursorKey

EnterHit:
	MOV	PrevPos,DX
	MOV	DI,OFFSET NumberBuffer
MoveCursorAndReadChar:
	CALL	SetCrsrPos		;DX set by getting number, crsr will
					; end up just past number it will dial.
	MOV	AH,8			;read char to AL and attrib to AH
	MOV	BH,VideoPage
	PUSH	DI
	CALL	DoVideoInt
	MOV	DI,OFFSET PhoneNoChars
	MOV	CX,11h
	REPNZ	SCASB
	POP	DI			;pointer in NumberBuffer
	JZ	SaveChar
	CMP	DI,OFFSET NumberBuffer
	JNZ	NumberStored
	JMP	SHORT NextChar

SaveChar:
	STOSB
NextChar:
	INC	DL
	CMP	DL,LastColumn
	JNG	MoveCursorAndReadChar
NumberStored:
	XOR	AL,AL
	STOSB
	CMP	DI,OFFSET NumberBuffer
	JZ	EscHit
;dial and redial
Redial:	MOV	SI,OFFSET ATDT_str
	CALL	SendLoop
	CMP	AH,80h
	JZ	EscHit			;exit after 1st timeout
	MOV	SI,OFFSET NumberBuffer
	CALL	SendLoop
	MOV	SI,OFFSET CRstr
	CALL	SendLoop
	XOR	AH,AH
	PUSHF
	CALL	DWORD PTR CS:OldInt16Offset ;wait for any key
Hangup:	MOV	SI,OFFSET ATH0_Str
	CALL	SendLoop
	JMP	SHORT EscHit

SendLoop:
	LODSB
	OR	AL,AL
	JZ	Ret1
	PUSH	DX
	MOV	AH,1			;transmit character in AL
	MOV	DX,PortNo
	INT	14h			;Serial port stuff
	AND	AH,80h
	CMP	AH,80h			;time-out error, wrong COM port ?
	POP	DX
	JZ	Ret1
	JMP	SHORT SendLoop

Ret1:	RET				;w/AH=80h if time-out error

EscHit:	MOV	DX,RowAndColumn
	CALL	SetCrsrPos		;DH=row, DL=column
	MOV	CX,CursorScanLines
	MOV	AH,1			;set cursor type
	CALL	DoVideoInt
	POP	ES
	POP	DS
	POP	BP
	POP	SI
	POP	DI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POPF
	MOV	SS,CS:SavedSS_2
	MOV	SP,CS:SavedSP_2
	MOV	AH,CS:INT16func
	JMP	DWORD PTR CS:OldInt16Offset

DoVideoInt:
	PUSH	DI
	PUSH	SI
	PUSH	BP
	INT	10h
	POP	BP
	POP	SI
	POP	DI
	RET

SetCrsrPos:
	PUSH	AX
	PUSH	BX
	MOV	AH,2			;Set Cursor position per DH, DL
	MOV	BH,VideoPage
	CALL	DoVideoInt
	POP	BX
	POP	AX
	RET
;
Begin:	MOV	DX,OFFSET Banner
	MOV	AH,9
	INT	21h
Delay:	
	MOV	SI,80h			;length of command line params
	LODSB
	OR	AL,AL
	JZ	ToParamsDone
	MOV	CL,AL
	SUB	CH,CH
FindSlashLoop:
	LODSB
	CMP	AL,'/'
	JZ	SlashFound
ToFindSlashLoop:
	LOOP	FindSlashLoop
ToParamsDone:
	JMP	ParamsDone		;near beginning of code

SlashFound:
	DEC	CX
	JZ	ToParamsDone
	LODSB
	SUB	AL,31h			;convert to hex-1 (COM4 => AL=3)
	JC	ToFindSlashLoop		; as req'd for INT 14h
	CMP	AL,7			;Take COM1 - COM8
	JA	ToFindSlashLoop
	XOR	AH,AH
	MOV	PortNo,AX
;Fix for BIOS that lists adresses of COM ports at 0040:0000 in oder found
; instead of COM1, COM2, COM3, COM4.  Mine has F8 03 F8 02 E8 02 00 00, which
; is COM1, COM2, COM4; Int 14h and the MODE command don't recognize COM4 !
	CMP	AL,3			; /4 (COM4) on command line ?
	JNZ	ToFindSlashLoop
	PUSH	ES
	PUSH	BX
	XOR	BX,BX
	MOV	ES,BX
	MOV	BX,2E8h			;port of COM4
	MOV	WORD PTR ES:0406h,BX
	POP	BX
	POP	ES
	JMP	SHORT ToFindSlashLoop

Banner		DB	'Dial-Res V 2.00',cr,lf
		DB	'1990 Roger Schlafly, mods by J.E.Arkay ''96$'

EndPgm	EQU	$
	
CSEG	ends
	END	Start
