VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Object = "{137F00F1-1F0B-11D6-BF85-FAC8D6171C1B}#1.0#0"; "ANIGIFEX.OCX"
Begin VB.Form frmMain 
   Caption         =   "AniGif ActiveX control sample project by Inspired Creations"
   ClientHeight    =   7305
   ClientLeft      =   135
   ClientTop       =   420
   ClientWidth     =   8955
   FillStyle       =   0  'Solid
   ForeColor       =   &H8000000F&
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   ScaleHeight     =   7305
   ScaleWidth      =   8955
   StartUpPosition =   2  'CenterScreen
   Begin vbAniGifEx.AniGifEx AniGifEx1 
      Height          =   5400
      Left            =   3960
      TabIndex        =   65
      Top             =   1860
      Width           =   4905
      _ExtentX        =   8652
      _ExtentY        =   9525
      BorderStyle     =   1
      ArrayStoredSize =   8536
      ArrayStored     =   "frmMain.frx":0442
   End
   Begin VB.Frame Frame1 
      Caption         =   "Gif info"
      Height          =   2130
      Left            =   45
      TabIndex        =   35
      Top             =   1770
      Width           =   3780
      Begin VB.CommandButton Command4 
         Caption         =   "Read"
         Height          =   315
         Left            =   2250
         TabIndex        =   64
         Top             =   1710
         Width           =   795
      End
      Begin VB.CommandButton Command3 
         Caption         =   "Read"
         Height          =   315
         Left            =   2250
         TabIndex        =   63
         Top             =   1365
         Width           =   795
      End
      Begin VB.Line Line1 
         BorderColor     =   &H80000014&
         X1              =   75
         X2              =   3720
         Y1              =   1230
         Y2              =   1230
      End
      Begin VB.Label Label43 
         AutoSize        =   -1  'True
         Caption         =   "App Extensions :"
         Height          =   195
         Left            =   465
         TabIndex        =   62
         Top             =   1770
         Width           =   1185
      End
      Begin VB.Label Label42 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1800
         TabIndex        =   61
         Top             =   1785
         Width           =   45
      End
      Begin VB.Label Label41 
         AutoSize        =   -1  'True
         Caption         =   "Comments :"
         Height          =   195
         Left            =   825
         TabIndex        =   60
         Top             =   1425
         Width           =   825
      End
      Begin VB.Label Label40 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1800
         TabIndex        =   59
         Top             =   1440
         Width           =   45
      End
      Begin VB.Label Label31 
         AutoSize        =   -1  'True
         Caption         =   "Size(bytes) :"
         Height          =   195
         Left            =   420
         TabIndex        =   47
         Top             =   270
         Width           =   855
      End
      Begin VB.Label Label28 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1320
         TabIndex        =   46
         Top             =   285
         Width           =   45
      End
      Begin VB.Label Label27 
         AutoSize        =   -1  'True
         Caption         =   "Width :"
         Height          =   195
         Left            =   750
         TabIndex        =   45
         Top             =   570
         Width           =   510
      End
      Begin VB.Label Label18 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1320
         TabIndex        =   44
         Top             =   600
         Width           =   45
      End
      Begin VB.Label Label17 
         AutoSize        =   -1  'True
         Caption         =   "Height :"
         Height          =   195
         Left            =   705
         TabIndex        =   43
         Top             =   870
         Width           =   555
      End
      Begin VB.Label Label16 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1320
         TabIndex        =   42
         Top             =   900
         Width           =   45
      End
      Begin VB.Label Label13 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   41
         Top             =   885
         Width           =   45
      End
      Begin VB.Label Label14 
         AutoSize        =   -1  'True
         Caption         =   "Loops :"
         Height          =   195
         Left            =   2625
         TabIndex        =   40
         Top             =   870
         Width           =   525
      End
      Begin VB.Label Label19 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   39
         Top             =   615
         Width           =   45
      End
      Begin VB.Label Label20 
         AutoSize        =   -1  'True
         Caption         =   "Colors :"
         Height          =   195
         Left            =   2625
         TabIndex        =   38
         Top             =   585
         Width           =   525
      End
      Begin VB.Label Label10 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   37
         Top             =   300
         Width           =   45
      End
      Begin VB.Label Label9 
         AutoSize        =   -1  'True
         Caption         =   "Frames :"
         Height          =   195
         Left            =   2550
         TabIndex        =   36
         Top             =   285
         Width           =   600
      End
   End
   Begin MSComDlg.CommonDialog Dlg 
      Left            =   0
      Top             =   6705
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame Frame3 
      Caption         =   "Properties"
      Height          =   1650
      Left            =   3975
      TabIndex        =   15
      Top             =   45
      Width           =   4890
      Begin VB.CheckBox Check3 
         Caption         =   "Drop Target"
         Height          =   285
         Left            =   210
         TabIndex        =   58
         Top             =   1275
         Value           =   1  'Checked
         Width           =   1305
      End
      Begin VB.CommandButton Command2 
         Caption         =   "o"
         Height          =   360
         Left            =   2880
         TabIndex        =   26
         Top             =   360
         Width           =   390
      End
      Begin VB.Frame Frame4 
         Caption         =   "Size"
         Height          =   1395
         Left            =   3480
         TabIndex        =   22
         Top             =   180
         Width           =   1320
         Begin VB.OptionButton optSize 
            Caption         =   "Normal"
            Height          =   210
            Index           =   0
            Left            =   150
            TabIndex        =   25
            Top             =   300
            Value           =   -1  'True
            Width           =   1140
         End
         Begin VB.OptionButton optSize 
            Caption         =   "Auto size"
            Height          =   210
            Index           =   1
            Left            =   150
            TabIndex        =   24
            Top             =   675
            Width           =   1140
         End
         Begin VB.OptionButton optSize 
            Caption         =   "Stretch"
            Height          =   210
            Index           =   2
            Left            =   150
            TabIndex        =   23
            Top             =   1050
            Width           =   1140
         End
      End
      Begin VB.CheckBox Check2 
         Caption         =   "MouseCapture"
         Height          =   285
         Left            =   210
         TabIndex        =   21
         Top             =   945
         Width           =   1515
      End
      Begin VB.ComboBox Combo1 
         Height          =   315
         Left            =   1815
         Style           =   2  'Dropdown List
         TabIndex        =   19
         Top             =   1155
         Width           =   1440
      End
      Begin VB.CheckBox Check 
         Caption         =   "Borders"
         Height          =   285
         Left            =   210
         TabIndex        =   18
         Top             =   285
         Value           =   1  'Checked
         Width           =   1305
      End
      Begin VB.CommandButton Command1 
         Caption         =   "BackColor"
         Height          =   360
         Left            =   1815
         TabIndex        =   17
         Top             =   360
         Width           =   1035
      End
      Begin VB.CheckBox Check1 
         Caption         =   "AutoStart"
         Height          =   285
         Left            =   210
         TabIndex        =   16
         Top             =   615
         Value           =   1  'Checked
         Width           =   1305
      End
      Begin VB.Label Label11 
         AutoSize        =   -1  'True
         Caption         =   "Display Errors"
         Height          =   195
         Left            =   2055
         TabIndex        =   20
         Top             =   870
         Width           =   960
      End
   End
   Begin VB.CommandButton cmdPreviousFrame 
      Caption         =   "<"
      Enabled         =   0   'False
      Height          =   372
      Left            =   765
      TabIndex        =   14
      Top             =   6855
      Width           =   450
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Height          =   372
      Left            =   1440
      TabIndex        =   13
      Top             =   6855
      Width           =   870
   End
   Begin VB.CommandButton cmdNextFrame 
      Caption         =   ">"
      Enabled         =   0   'False
      Height          =   372
      Left            =   2535
      TabIndex        =   12
      Top             =   6855
      Width           =   450
   End
   Begin VB.Frame Frame2 
      Caption         =   "Frame info"
      Height          =   2355
      Left            =   45
      TabIndex        =   3
      Top             =   4290
      Width           =   3780
      Begin VB.Label Label39 
         AutoSize        =   -1  'True
         Caption         =   "Interlace :"
         Height          =   195
         Left            =   2430
         TabIndex        =   55
         Top             =   975
         Width           =   705
      End
      Begin VB.Label Label38 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   54
         Top             =   975
         Width           =   45
      End
      Begin VB.Label Label37 
         AutoSize        =   -1  'True
         Caption         =   "Local col table :"
         Height          =   195
         Left            =   135
         TabIndex        =   53
         Top             =   1620
         Width           =   1125
      End
      Begin VB.Label Label36 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1305
         TabIndex        =   52
         Top             =   1620
         Width           =   45
      End
      Begin VB.Label Label35 
         AutoSize        =   -1  'True
         Caption         =   "LCT colors :"
         Height          =   195
         Left            =   405
         TabIndex        =   51
         Top             =   1950
         Width           =   855
      End
      Begin VB.Label Label34 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1305
         TabIndex        =   50
         Top             =   1950
         Width           =   45
      End
      Begin VB.Label Label33 
         AutoSize        =   -1  'True
         Caption         =   "User Input :"
         Height          =   195
         Left            =   2310
         TabIndex        =   49
         Top             =   1950
         Width           =   825
      End
      Begin VB.Label Label32 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   48
         Top             =   1950
         Width           =   45
      End
      Begin VB.Label Label8 
         AutoSize        =   -1  'True
         Caption         =   "Disposal mthd :"
         Height          =   195
         Left            =   180
         TabIndex        =   34
         Top             =   1290
         Width           =   1080
      End
      Begin VB.Label Label7 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1305
         TabIndex        =   33
         Top             =   1290
         Width           =   45
      End
      Begin VB.Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "Transparency :"
         Height          =   195
         Left            =   2070
         TabIndex        =   32
         Top             =   1290
         Width           =   1065
      End
      Begin VB.Label Label5 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   31
         Top             =   1290
         Width           =   45
      End
      Begin VB.Label Label4 
         AutoSize        =   -1  'True
         Caption         =   "Delay(msec) :"
         Height          =   195
         Left            =   300
         TabIndex        =   30
         Top             =   975
         Width           =   960
      End
      Begin VB.Label Label3 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1305
         TabIndex        =   29
         Top             =   975
         Width           =   45
      End
      Begin VB.Label Label2 
         AutoSize        =   -1  'True
         Caption         =   "Trans col index :"
         Height          =   195
         Left            =   1965
         TabIndex        =   28
         Top             =   1620
         Width           =   1170
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   27
         Top             =   1620
         Width           =   45
      End
      Begin VB.Label Label21 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   11
         Top             =   645
         Width           =   45
      End
      Begin VB.Label Label22 
         AutoSize        =   -1  'True
         Caption         =   "Frame Height :"
         Height          =   195
         Left            =   2100
         TabIndex        =   10
         Top             =   645
         Width           =   1035
      End
      Begin VB.Label Label23 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   3195
         TabIndex        =   9
         Top             =   315
         Width           =   45
      End
      Begin VB.Label Label24 
         AutoSize        =   -1  'True
         Caption         =   "Frame Width :"
         Height          =   195
         Left            =   2145
         TabIndex        =   8
         Top             =   315
         Width           =   990
      End
      Begin VB.Label Label25 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1305
         TabIndex        =   7
         Top             =   645
         Width           =   45
      End
      Begin VB.Label Label26 
         AutoSize        =   -1  'True
         Caption         =   "Frame Top :"
         Height          =   195
         Left            =   405
         TabIndex        =   6
         Top             =   645
         Width           =   855
      End
      Begin VB.Label Label29 
         AutoSize        =   -1  'True
         Caption         =   "-"
         Height          =   195
         Left            =   1305
         TabIndex        =   5
         Top             =   315
         Width           =   45
      End
      Begin VB.Label Label30 
         AutoSize        =   -1  'True
         Caption         =   "Frame Left :"
         Height          =   195
         Left            =   420
         TabIndex        =   4
         Top             =   315
         Width           =   840
      End
   End
   Begin VB.FileListBox File1 
      Height          =   1650
      Left            =   2160
      Pattern         =   "*.gif"
      TabIndex        =   2
      Top             =   75
      Width           =   1680
   End
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   75
      TabIndex        =   1
      Top             =   90
      Width           =   1995
   End
   Begin VB.DirListBox Dir1 
      Height          =   1215
      Left            =   75
      TabIndex        =   0
      Top             =   495
      Width           =   1995
   End
   Begin VB.Label Label15 
      AutoSize        =   -1  'True
      Caption         =   "-"
      Height          =   195
      Left            =   2535
      TabIndex        =   57
      Top             =   4035
      Width           =   45
   End
   Begin VB.Label Label12 
      AutoSize        =   -1  'True
      Caption         =   "Current Frame :"
      Height          =   195
      Left            =   1275
      TabIndex        =   56
      Top             =   4035
      Width           =   1080
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Option Explicit

Private lCurFrame As Long   ' Current frame variable

Private Sub Form_Load()
    
    ' Fill the combo box
    Combo1.AddItem "None"
    Combo1.AddItem "Global"
    Combo1.AddItem "Frame"
    Combo1.AddItem "All"
    
    Combo1.ListIndex = 1
    
    ' Get and show the preloaded Gif file info
    Call GetGifInfo

End Sub

Private Sub Form_Resize()

  On Error Resume Next
    
    ' Exit if Autosize = True
    If optSize(1).Value = True Then Exit Sub
    
    ' Size the control
    AniGifEx1.Width = Me.Width - AniGifEx1.Left - 300
    AniGifEx1.Height = Me.Height - AniGifEx1.Top - 550

End Sub

Private Sub Form_Unload(Cancel As Integer)

    Unload frmInfo
    Set frmInfo = Nothing

End Sub

Private Sub Drive1_Change()

  On Error Resume Next

    Dir1 = Drive1

End Sub

Private Sub Dir1_Change()

  On Error Resume Next

    File1 = Dir1

End Sub

' BorderStyle
Private Sub Check_Click()
    
    ' Set the BorderStyle property
    AniGifEx1.BorderStyle = Check.Value
    
    ' Initialize buttons and labels
    Call InitControls
    
End Sub

' AutoStart
Private Sub Check1_Click()

    ' Set the AutoStart property
    If Check1.Value = vbChecked Then
        AniGifEx1.AutoStart = True
        Else
        AniGifEx1.AutoStart = False
    End If

End Sub

' MouseCapture
Private Sub Check2_Click()
    
    ' Set the MouseCapture property
    AniGifEx1.MouseCapture = Check2.Value

End Sub

' Drop Target
Private Sub Check3_Click()

    ' Set the DropTarget property
    If Check3.Value = vbChecked Then
        AniGifEx1.DropTarget = True
        Else
        AniGifEx1.DropTarget = False
    End If

End Sub

' Sizing
Private Sub optSize_Click(index As Integer)
    
    ' Set the Sizing property
    AniGifEx1.Sizing = index
    
    ' Initialize buttons and labels
    Call InitControls

End Sub

' DisplayErrors
Private Sub Combo1_Click()

    ' Set the DisplayErrors property
    AniGifEx1.DisplayErrors = Combo1.ListIndex

End Sub

' BackColor
Private Sub Command1_Click()

  On Error GoTo Out

    Dlg.ShowColor
    
    If Dlg.Color Then
        ' Set the BackColor property
        AniGifEx1.BackColor = Dlg.Color
        Call AniGifEx1.Refresh
        ' Initialize buttons and labels
        Call InitControls
    End If

Out:

End Sub

' BackColor reset
Private Sub Command2_Click()

    ' Reset the BackColor property
    AniGifEx1.BackColor = vbButtonFace
    Call AniGifEx1.Refresh
    ' Initialize buttons and labels
    Call InitControls

End Sub

Private Sub Command3_Click()

  Dim i As Integer
  Dim x As Integer

    x = AniGifEx1.Comments.Count
    
    If x = 0 Then Exit Sub
    
    With frmInfo
        ' Clean
        .Text1 = ""
        ' Get the Comments
        For i = 1 To AniGifEx1.Comments.Count
            .Text1 = .Text1 & vbCrLf & vbCrLf & i & ") " & AniGifEx1.Comments(i) ' AniGifEx1.Comments(i).Text (Default member)
        Next
        .Text1.SelStart = Len(.Text1)
    End With
    
    frmInfo.Show vbModal

End Sub

Private Sub Command4_Click()

  Dim i As Integer
  Dim x As Integer

    x = AniGifEx1.AppExtensions.Count
    
    If x = 0 Then Exit Sub
    
    With frmInfo
        ' Clean
        .Text1 = ""
        For i = 1 To AniGifEx1.AppExtensions.Count
            ' ApplicationData is the Default member
            .Text1 = .Text1 & vbCrLf & vbCrLf & i & ") ApplicationIdentifier : " & AniGifEx1.AppExtensions(i).ApplicationIdentifier & vbCrLf & "    ApplicationData : " & AniGifEx1.AppExtensions(i).ApplicationData
        Next
        .Text1.SelStart = Len(.Text1)
    End With
    
    frmInfo.Show vbModal

End Sub

Private Sub File1_Click()

  Dim sPath As String
    
  On Error Resume Next
    
    ' Normalize path
    If Right$(File1.Path, 1) = "\" Then
        sPath = File1.Path
        Else
        sPath = File1.Path & "\"
    End If
    
    ' Give time to the system to process the files,
    ' in case we roll the list fast.
    DoEvents
    
    ' By setting the Filename property, the specified Gif file
    ' will be loaded. If AutoStart = True then, if it is an
    ' animated Gif file, the animation will start, otherwise
    ' the first frame will be drawn.
    AniGifEx1.FileName = sPath & File1.FileName
    
    ' By calling the StartRender function followed by a filepath,
    ' the specified Gif file will be loaded. If it is an animated
    ' Gif file, the animation will start ignoring the AutoStart
    ' property, otherwise the first frame will be drawn.

'    AniGifEx1.StartRender sPath & File1.FileName
    
    ' Initialize buttons and labels
    Call InitControls
    
    ' Get the Gif file name
    Caption = AniGifEx1.FileName
    
    ' Get and show the preloaded Gif file info
    Call GetGifInfo
    
    Me.Refresh

End Sub

Private Sub cmdStop_Click()

  On Error Resume Next
    
    ' Stop
    If cmdStop.Caption = "Stop" Then
        ' Stop the animation
        AniGifEx1.StopRender
        ' Get the current frame
        lCurFrame = AniGifEx1.CurrentFrame
        ' Get the current frame info
        Call GetFrameInfo(lCurFrame)
        ' Set controls
        cmdPreviousFrame.Enabled = True
        cmdNextFrame.Enabled = True
        cmdStop.Caption = "Play"
        ' Start/Continue
        Else
        ' By calling the StartRender function without specifing a
        ' filepath, the control will start/continue rendering,
        ' any Gif file specified in the Filename property.
        AniGifEx1.StartRender
        cmdStop.Caption = "Stop"
        cmdPreviousFrame.Enabled = False
        cmdNextFrame.Enabled = False
        ' Initialize the labels
        Call ClearLabels
    End If

End Sub

Private Sub cmdPreviousFrame_Click()

    ' Static Gif file
    If AniGifEx1.Frames.Count < 2 Then Exit Sub
    ' Error handling
    If lCurFrame > AniGifEx1.Frames.Count Then Exit Sub
    
    ' Decrease the counter
    lCurFrame = lCurFrame - 1
    ' If the first frame has been reached then loop to the last one
    If lCurFrame < 1 Then lCurFrame = AniGifEx1.Frames.Count
    
    ' Render the frame
    Call AniGifEx1.RenderFrame(lCurFrame)
    
    ' Get and show frame info
    Call GetFrameInfo(lCurFrame)

End Sub

Private Sub cmdNextFrame_Click()

    ' Static Gif file
    If AniGifEx1.Frames.Count < 2 Then Exit Sub
    ' Error handling
    If lCurFrame < 0 Then Exit Sub
    
    ' Increase the counter
    lCurFrame = lCurFrame + 1
    ' If the last frame has been reached then loop to the first one
    If lCurFrame > AniGifEx1.Frames.Count Then lCurFrame = 1

    ' Render the frame
    Call AniGifEx1.RenderFrame(lCurFrame)
    
    ' Get and show frame info
    Call GetFrameInfo(lCurFrame)

End Sub




























' ################### PROJECT FUNCTIONS ###################

' Initialize variables, labels and controls
Private Sub ClearLabels()
    
    Label29.Caption = "-"
    Label25.Caption = "-"
    Label23.Caption = "-"
    Label21.Caption = "-"
    Label7.Caption = "-"
    Label5.Caption = "-"
    Label3.Caption = "-"
    Label1.Caption = "-"
    Label38.Caption = "-"
    Label36.Caption = "-"
    Label34.Caption = "-"
    Label32.Caption = "-"
    Label40.Caption = "-"
    Label42.Caption = "-"
    Label15.Caption = "-"
    
End Sub

' Initializes buttons and labels
Private Sub InitControls()
    
    lCurFrame = 1
    
    ' If this is an animated Gif file
    If AniGifEx1.NumberOfFrames > 1 Then
        ' AutoStart = True
        If Check1.Value = vbChecked Then
            cmdStop.Caption = "Stop"
            cmdStop.Enabled = True
            cmdPreviousFrame.Enabled = False
            cmdNextFrame.Enabled = False
            Call ClearLabels
            ' AutoStart = False
            Else
            ' Get the first frame's info
            Call GetFrameInfo(1)
            cmdStop.Caption = "Play"
            cmdStop.Enabled = True
            cmdPreviousFrame.Enabled = True
            cmdNextFrame.Enabled = True
        End If
        ' If this is a static Gif file
        Else
        cmdStop.Caption = "Stop"
        cmdStop.Enabled = False
        cmdPreviousFrame.Enabled = False
        cmdNextFrame.Enabled = False
        Call ClearLabels
    End If

End Sub

' Read the Gif file info and set the labels
Private Sub GetGifInfo()
    
    Label28.Caption = Format$(AniGifEx1.GifSize, "#,000")
    Label18.Caption = AniGifEx1.GifWidth
    Label16.Caption = AniGifEx1.GifHeight
    Label10.Caption = AniGifEx1.NumberOfFrames
    Label19.Caption = AniGifEx1.GifColors
    Label13.Caption = AniGifEx1.GifLoops
    Label40.Caption = AniGifEx1.Comments.Count
    Label42.Caption = AniGifEx1.AppExtensions.Count
    
End Sub

' Read the frame info and set the labels
Private Sub GetFrameInfo(ByVal index As Long)
    
    Label29.Caption = AniGifEx1.Frames(index).FrameLeft
    Label25.Caption = AniGifEx1.Frames(index).FrameTop
    Label23.Caption = AniGifEx1.Frames(index).FrameWidth
    Label21.Caption = AniGifEx1.Frames(index).FrameHeight
    Label7.Caption = AniGifEx1.Frames(index).DisposalMethod
    Label5.Caption = AniGifEx1.Frames(index).TransparentColorFlag
    Label3.Caption = AniGifEx1.Frames(index).DelayTime
    Label1.Caption = AniGifEx1.Frames(index).TransparentColorIndex
    Label38.Caption = AniGifEx1.Frames(index).InterLaceFlag
    Label36.Caption = AniGifEx1.Frames(index).LocalColorTableFlag
    Label34.Caption = AniGifEx1.Frames(index).SizeOfLocalColorTable
    Label32.Caption = AniGifEx1.Frames(index).UserInputFlag

End Sub




























' ################### CONTROL EVENTS ###################

' AniGif control's event "NewFile"
' Occurs when a new file has been loaded
' Returns: Filepath = Full file path
Private Sub AniGifEx1_NewFile(ByVal Filepath As String)
    
    ' Refresh the info labels
    GetGifInfo

End Sub

' AniGif control's event "Change"
' Occurs when a new frame has been rendered
' Returns: index = CurrentFrame
Private Sub AniGifEx1_Change(ByVal index As Long)

    Label15.Caption = index
  
    ' This gives the same result
    ' Label15.Caption = AniGifEx1.CurrentFrame

End Sub
