Attribute VB_Name = "api"
' ********************************************************
' Antes de examinar el cdigo que hay aqu le recomiendo
' ojear el de los formularios y sus explicaciones.

' Before examining the code below I recommend you to
' take a quick look to the one in the forms and its
' explanations.
' ********************************************************



Private Const BLACK_PEN = 7
Private Const PS_SOLID = 0
Private Const R2_COPYPEN = 13

Private Const WM_MOVE = &H3
Private Const WM_SIZE = &H5
Private Const WM_PAINT = &HF
Private Const WM_RBUTTONUP = &H205

Private Const TPM_RETURNCMD = &H100
Private Const TPM_NONOTIFY = &H80
Private Const MF_ENABLED = &H0&
Private Const MF_GRAYED = &H1&
Private Const MF_DISABLED = &H2&
Private Const MF_STRING = &H0&
Private Const MF_SEPARATOR = &H800&
Private Const MF_BYCOMMAND = &H0&
Private Const MF_BYPOSITION = &H400&

Private Const GWL_WNDPROC = (-4)
Private Const GWL_USERDATA = (-21)

Private Const GWL_MI_OLDPROC = &H0
Private Const GWL_MI_THREADID = &H4
Private Const GWL_MI_THREADSTATE = &H8
Private Const GWL_MI_THREADINTERVAL = &HC
Private Const GWL_MI_CLEARFLAG = &H10

Private Const GMEM_MOVEABLE = &H2
Private Const GMEM_ZEROINIT = &H40
Private Const GHND = (GMEM_MOVEABLE Or GMEM_ZEROINIT)

Private Const BEZIER_MAX As Integer = 40
Private Const OFFSET_MAX As Integer = 10
Private Const OFFSET_MIN As Integer = 2
Private Const CURVES As Integer = 1
Private Const POINTS As Integer = 3 * CURVES + 1

Type POINTAPI
    X As Long
    Y As Long
End Type

Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Type BZPOINTS
    pts(POINTS) As POINTAPI
End Type

Type POLYDATA
    nTotal              As Integer
    nCurrent            As Integer
    nColor              As Integer
    ptOffset(POINTS)    As POINTAPI
    bzData(BEZIER_MAX)  As BZPOINTS
    nColorArr(20)       As Long
End Type

Type HandlerAddresses
    autoHandler As Long
    initHandler As Long
    termHandler As Long
End Type

Private Declare Function CallWindowProc Lib "user32" Alias "CallWindowProcA" (ByVal lpPrevWndFunc As Long, ByVal hwnd As Long, ByVal msg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long
Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function BitBlt Lib "gdi32" (ByVal hDestDC As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal dwRop As Long) As Long
Private Declare Function PolyBezier Lib "gdi32" (ByVal hdc As Long, lppt As POINTAPI, ByVal cPoints As Long) As Long
Private Declare Function GetStockObject Lib "gdi32" (ByVal nIndex As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function CreatePen Lib "gdi32" (ByVal nPenStyle As Long, ByVal nWidth As Long, ByVal crColor As Long) As Long
Private Declare Function SetROP2 Lib "gdi32" (ByVal hdc As Long, ByVal nDrawMode As Long) As Long
Private Declare Function SetTextColor Lib "gdi32" (ByVal hdc As Long, ByVal crColor As Long) As Long
Private Declare Function SetTextAlign Lib "gdi32" (ByVal hdc As Long, ByVal wFlags As Long) As Long
Private Declare Function SetBkMode Lib "gdi32" (ByVal hdc As Long, ByVal nBkMode As Long) As Long
Private Declare Function TextOut Lib "gdi32" Alias "TextOutA" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal lpString As String, ByVal nCount As Long) As Long

Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function GlobalLock Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function GlobalUnlock Lib "kernel32" (ByVal hMem As Long) As Long

Private Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long
Private Declare Function CreatePopupMenu Lib "user32" () As Long
Private Declare Function AppendMenu Lib "user32" Alias "AppendMenuA" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal wIDNewItem As Long, ByVal lpNewItem As Any) As Long
Private Declare Function ModifyMenu Lib "user32" Alias "ModifyMenuA" (ByVal hMenu As Long, ByVal nPosition As Long, ByVal wFlags As Long, ByVal wIDNewItem As Long, ByVal lpString As Any) As Long
Private Declare Function TrackPopupMenu Lib "user32" (ByVal hMenu As Long, ByVal wFlags As Long, ByVal X As Long, ByVal Y As Long, ByVal nReserved As Long, ByVal hwnd As Long, lpRect As Any) As Long

Private Declare Sub RtlMoveMemory Lib "kernel32" (dst As Any, src As Any, ByVal cbCopy As Long)
'Private Declare Sub Sleep Lib "kernel32" (ByVal dwMilliseconds As Long)

Private nColorArr(20) As Long
Private hSubMenu As Long

Public pHandler As HandlerAddresses

Public bUnloading As Boolean
Public nChildren As Integer

Public Const GCL_CBWNDEXTRA = (-18)
'Private Declare Function GetClassLong Lib "user32" Alias "GetClassLongA" (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Public Declare Function SetClassLong Lib "user32" Alias "SetClassLongA" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long

Public Declare Function DestroyWindow Lib "user32" (ByVal hwnd As Long) As Long

Public ThreadObject As Threadv4s

' Para empaquetar direcciones
    ' to pack addresses
    
Private Function getAddress(in_Addr As Long) As Long
    getAddress = in_Addr
End Function

Public Sub Main()
   
    Dim hMenu As Long
    
    pHandler.autoHandler = getAddress(AddressOf autoHandler)
    pHandler.initHandler = getAddress(AddressOf initHandler)
    pHandler.termHandler = getAddress(AddressOf termHandler)
    
    Randomize
    
    nColorArr(0) = &H1111FF: nColorArr(1) = &H11FF11
    nColorArr(2) = &H11FF11: nColorArr(3) = &H11FFFF
    nColorArr(4) = &HFF11FF: nColorArr(5) = &HFFFF11
    nColorArr(6) = &HFFFFFF: nColorArr(7) = &H111181
    nColorArr(8) = &H118010: nColorArr(9) = &H801111
    nColorArr(10) = &H118080: nColorArr(11) = &H801180
    nColorArr(12) = &H808011: nColorArr(13) = &H808080
    nColorArr(14) = &H1111FF: nColorArr(15) = &H11FF11
    nColorArr(16) = &HFF1111: nColorArr(17) = &H11FFFF
    nColorArr(18) = &HFF11FF: nColorArr(19) = &HFFFF11
    
    ' creamos un men
        ' create a menu handler
    
    hSubMenu = CreatePopupMenu()
    AppendMenu hSubMenu, MF_STRING Or MF_ENABLED, ByVal 2&, "&Acelerar (Speed up)"
    AppendMenu hSubMenu, MF_STRING Or MF_ENABLED, ByVal 3&, "&Ralentizar (Slow down)"
    AppendMenu hSubMenu, MF_SEPARATOR, ByVal 0&, ByVal 0&
    AppendMenu hSubMenu, MF_STRING Or MF_ENABLED, ByVal 5&, "&Pausa (pause)"
    AppendMenu hSubMenu, MF_STRING Or MF_ENABLED, ByVal 6&, "&Continuar (resume)"
   
    bUnloading = False
    
    Load parent
    
    parent.Arrange 2
 
    parent.Show
    
End Sub

'obtener un entero aleatorio
    ' get a random integer
Private Function GetRndSeed() As Integer
   
   GetRndSeed = Int(32000 * Rnd + 1)

End Function

' obtener un desplazamiento aleatorio
    ' get a random offset
Private Function GetRndOffset(i As Integer) As Integer

    Dim nRet As Integer
    
    If ((i = 1) Or (i = 2)) Then
        nRet = ((GetRndSeed() Mod OFFSET_MAX) / 3) + OFFSET_MIN
    Else
        nRet = (GetRndSeed() Mod OFFSET_MAX) + OFFSET_MIN
    End If

    GetRndOffset = IIf(nRet < 0, -nRet, nRet)

End Function

' nuestro propio procesamiento de mensajes
    ' our own window procedure to process some messages

Private Function SubClassedProc( _
        ByVal hwnd As Long, _
        ByVal iMsg As Long, _
        ByVal wParam As Long, _
        ByVal lParam As Long) _
    As Long
   
    ' primero llamamos a la rutina original para que realice el
    ' procesamiento por defecto
        ' first we call the original routine so it performs the
        ' default processing
    SubClassedProc = CallWindowProc(ByVal GetWindowLong(ByVal hwnd, GWL_MI_OLDPROC), hwnd, iMsg, wParam, lParam)
    
    ' aqui manejamos algunos mensajes de manera especial
        ' and some messages are handled here
    Select Case iMsg
        
       Case WM_SIZE, WM_PAINT  'WM_MOVE,
            UpdateClient hwnd
            
        Case WM_RBUTTONUP
            PopMenu hwnd
            UpdateClient hwnd
 
    End Select

End Function

' el men contextual
    ' the context menu
    
Private Sub PopMenu(ByVal hwnd As Long)
    
    Dim threadId As Long, threadState As Long, threadInterval As Long
    Dim nRet As Long
    Dim lp As POINTAPI
    
    threadId = GetWindowLong(ByVal hwnd, GWL_MI_THREADID)
    threadState = GetWindowLong(ByVal hwnd, GWL_MI_THREADSTATE)
    threadInterval = GetWindowLong(ByVal hwnd, GWL_MI_THREADINTERVAL)
    
    ModifyMenu ByVal hSubMenu, ByVal 0&, ByVal (MF_BYPOSITION Or IIf(threadState = 1 And threadInterval > 10, MF_ENABLED, MF_GRAYED)), ByVal 2&, "&Acelerar (Speed up)"
    ModifyMenu ByVal hSubMenu, ByVal 1&, ByVal (MF_BYPOSITION Or IIf(threadState = 1 And threadInterval < 90, MF_ENABLED, MF_GRAYED)), ByVal 3&, "&Ralentizar (Slow down)"
    ModifyMenu ByVal hSubMenu, ByVal 3&, ByVal (MF_BYPOSITION Or IIf(threadState = 1, MF_ENABLED, MF_GRAYED)), ByVal 5&, "&Pausa (pause)"
    ModifyMenu ByVal hSubMenu, ByVal 4&, ByVal (MF_BYPOSITION Or IIf(threadState = 0, MF_ENABLED, MF_GRAYED)), ByVal 6&, "&Continuar (resume)"
  
    GetCursorPos lp
    
    nRet = TrackPopupMenu(ByVal hSubMenu, ByVal TPM_RETURNCMD Or TPM_NONOTIFY, ByVal lp.X, ByVal lp.Y, ByVal 0&, ByVal hwnd, ByVal 0&)
   
    Select Case nRet
        Case 2: threadInterval = threadInterval - 10
        Case 3: threadInterval = threadInterval + 10
        Case 5: threadState = 0
        Case 6: threadState = 1
        Case Else
            Exit Sub
    End Select
    
    SetWindowLong ByVal hwnd, GWL_MI_THREADSTATE, ByVal threadState
    SetWindowLong ByVal hwnd, GWL_MI_THREADINTERVAL, ByVal threadInterval
    
    Select Case nRet
        Case 2, 3: ThreadObject.ModifyThread ByVal threadId, , , ByVal threadInterval, ByVal -1
        Case 5
            ThreadObject.ModifyThread ByVal threadId, , , ByVal 0&, ByVal -1
            ThreadObject.PauseThread ByVal threadId
        Case 6
            ThreadObject.ModifyThread ByVal threadId, , , ByVal threadInterval, ByVal -1
            ThreadObject.ResumeThread ByVal threadId
    End Select

End Sub

' redibujar la ventana
    ' repaint the window

Private Sub UpdateClient(hwnd As Long)

    ' si el hilo est activo, dejar el procesamiento  para el mismo
        ' if thread is active, rely repaint processing on it
  
    If GetWindowLong(ByVal hwnd, GWL_MI_THREADSTATE) = 1 Then
        SetWindowLong ByVal hwnd, GWL_MI_CLEARFLAG, 1&
        Exit Sub
    End If
   
    ' sino...
        ' else...
      
    Dim pMem As Long
    Dim pd As POLYDATA
    Dim bzTmp As BZPOINTS
    
    Dim hdc As Long
    Dim hpen As Long
    Dim i As Integer
    Dim j As Integer
    Dim rc As RECT
    Dim oldTx As Long, oldAl As Long
    
    ' obtenemos la posicin de memoria donde se almacenan los datos
    ' de las curvas de los datos asociados a la ventana
        ' get the memory address where curves's data is stored from
        ' the window structure data
    pMem = GetWindowLong(ByVal hwnd, GWL_USERDATA)
    If pMem = 0 Then Exit Sub
    
    pMem = GlobalLock(ByVal pMem)
    If pMem <> 0 Then
    
        ' obtenemos el contexto de dispositivo de la ventana
            ' get the window device context
        hdc = GetDC(ByVal hwnd)
        If hdc <> 0 Then
        
            ' copiamos los datos obtenidos anteriormente a una estructura
            ' ms sencilla de manejar que un bloque lineal de datos
                ' copy the data obtained above to a structure, so we may
                ' handle data easier than with a linear data block
            RtlMoveMemory pd, ByVal pMem, ByVal Len(pd)
                        
            ' obtenemos el rea cliente de la ventana
                ' get the window client area
            GetClientRect ByVal hwnd, rc
            
            ' repintamos el fondo
                ' fill the backgroung
            BitBlt ByVal hdc, 0, 0, ByVal rc.Right, ByVal rc.Bottom, ByVal 0, 0, 0, ByVal 0
            
            ' repintamos la ltima curva (para que quede bonito)
                ' repaint the last curve (to make it fine)
            hpen = SelectObject(ByVal hdc, CreatePen(ByVal PS_SOLID, ByVal 1, ByVal pd.nColorArr(pd.nColor)))
            PolyBezier ByVal hdc, pd.bzData(pd.nCurrent).pts(0), ByVal POINTS
            DeleteObject (SelectObject(ByVal hdc, ByVal hpen))
            SelectObject ByVal hdc, ByVal hpen
            
            ' escribimos el texto
                ' print the text
            oldTx = SetTextColor(ByVal hdc, ByVal &HFFFF00)
            oldAl = SetTextAlign(ByVal hdc, ByVal 14&)
            SetBkMode ByVal hdc, ByVal 1& 'Transparente
    
            TextOut ByVal hdc, ByVal rc.Left + ((rc.Right - rc.Left) / 2), ByVal rc.Bottom, "En pausa - Paused", 17&
    
            SetBkMode ByVal hdc, ByVal 2& 'Opaco
            SetTextAlign ByVal hdc, ByVal oldAl
            SetTextColor ByVal hdc, ByVal oldTx
            
            ' liberamos recursos
                ' free resources
            ReleaseDC ByVal hwnd, ByVal hdc
            
        End If

        GlobalUnlock ByVal pMem
    End If
    
End Sub

' rutina de inicializacion
    ' initialization routine

Private Function initHandler(ByVal tId As Long, ByVal hwnd As Long) As Long
    
    Dim pMem As Long
    Dim pd As POLYDATA
    Dim idx As Integer
    Dim rc As RECT
    
    initHandler = 1 ' asumimos fallo ' assume error
    
    ' reservamos memoria para los datos necesarios
        ' allocate memory needed for the data
    pMem = GlobalAlloc(GHND, ByVal Len(pd))
    If pMem <> 0 Then
        pMem = GlobalLock(ByVal pMem)
        If pMem <> 0 Then
            ' inicializamos los mismos a traves de una estructura
            ' ms sencilla de manejar que un bloque lineal de datos
                ' initialize them through a structure, so we may
                ' handle data easier than with a linear data block
            pd.nTotal = 20
            pd.nCurrent = 0
            pd.nColor = (GetRndSeed() Mod 20)

            GetClientRect ByVal hwnd, rc
        
            For idx = 0 To POINTS - 2
                pd.bzData(0).pts(idx).X = (GetRndSeed() Mod rc.Right)
                pd.bzData(0).pts(idx).Y = (GetRndSeed() Mod rc.Bottom)
                pd.ptOffset(idx).X = GetRndOffset(idx)
                pd.ptOffset(idx).Y = GetRndOffset(idx)
            Next idx
            
            For i = 0 To 19
                pd.nColorArr(i) = nColorArr(i)
            Next i
            
            ' copiamos los datos a rea de memoria que hemos reservado
                ' copy data to the memory previously allocated
            RtlMoveMemory ByVal pMem, pd, ByVal Len(pd)
                   
            GlobalUnlock ByVal pMem
            
            ' establecemos parmetros iniciales del hilo y los copiamos
            ' en los bytes adicionales reservados para la clase de ventana
                ' set thread initial parameters and copy them to the
                ' additional memory reserved for this window class
            SetWindowLong ByVal hwnd, GWL_MI_THREADID, ByVal tId
            SetWindowLong ByVal hwnd, GWL_MI_THREADSTATE, ByVal 1&
            SetWindowLong ByVal hwnd, GWL_MI_THREADINTERVAL, ByVal 50&
            SetWindowLong ByVal hwnd, GWL_USERDATA, ByVal pMem
            
            ' establecemos la nueva rutina de procesamiento
                ' set the new window procedure
            SetWindowLong ByVal hwnd, GWL_MI_OLDPROC, _
                    ByVal SetWindowLong(ByVal hwnd, GWL_WNDPROC, AddressOf SubClassedProc)
            
            ' establecemos el nuevo intervalo para el hilo
                'set the new thread interval
            ThreadObject.ModifyThread tId, , , 50, AddressOf autoHandler
            ThreadObject.ModifyThread tId, , , 50, AddressOf autoHandler
            
            initHandler = 0 ' success
        End If
    End If
          
    
End Function

' rutina de finalizacin: liberamos memoria y reasignamos a la ventana
' su procedimiento original
    ' termination routine: free memory and reasign the default window
    ' procedute to the window
Private Sub termHandler(ByVal tId As Long, ByVal hwnd As Long, ByVal reason As Long)
 
    Dim pMem As Long
    
    pMem = GetWindowLong(ByVal hwnd, GWL_USERDATA)
    
    SetWindowLong ByVal hwnd, GWL_WNDPROC, ByVal GetWindowLong(ByVal hwnd, GWL_MI_OLDPROC)
    
    GlobalFree ByVal pMem

End Sub

' el corazn de todo: todo lo que hay aqu ya lo hemos visto antes
' as que el estudio de la misma es una tarea para el estudiante
    ' the heart of all: we have seen all this before so the study
    'of it is left as an assigment to the student
Private Function autoHandler(ByVal tId As Long, ByVal hwnd As Long) As Long

    Dim rc As RECT
    Dim idx As Integer, j As Integer
    Dim pd As POLYDATA
    Dim lpPrev As BZPOINTS
    Dim pMem As Long, hdc As Long, hpen As Long, X As Long, Y As Long

    autoHandler = 0

    pMem = GetWindowLong(ByVal hwnd, GWL_USERDATA)
    If pMem = 0 Then Exit Function

    pMem = GlobalLock(ByVal pMem)
    If pMem <> 0 Then

        hdc = GetDC(ByVal hwnd)
        If hdc <> 0 Then
            GetClientRect ByVal hwnd, rc

            RtlMoveMemory pd, ByVal pMem, ByVal Len(pd)

            lpPrev = pd.bzData(pd.nCurrent)
            
            If GetWindowLong(ByVal hwnd, GWL_MI_CLEARFLAG) <> 0 Then
            
                hpen = SelectObject(ByVal hdc, ByVal GetStockObject(BLACK_PEN))
                PolyBezier ByVal hdc, pd.bzData(nCurrent).pts(0), ByVal POINTS
                SelectObject ByVal hdc, ByVal hpen
            
                pd.bzData(0) = lpPrev
                pd.nCurrent = 0

                For j = 1 To pd.nTotal - 1
                   For idx = 0 To POINTS - 1
                        pd.bzData(j).pts(idx).X = -1
                        pd.bzData(j).pts(idx).Y = 0
                    Next idx
                Next j
            
                BitBlt ByVal hdc, 0, 0, ByVal rc.Right, ByVal rc.Bottom, ByVal 0, 0, 0, ByVal 0
                 
                SetWindowLong ByVal hwnd, GWL_MI_CLEARFLAG, 0&

            Else
            
                pd.nCurrent = pd.nCurrent + 1
    
                If (pd.nCurrent >= pd.nTotal) Then
                    pd.nCurrent = 0
                    pd.nColor = (((pd.nColor + 1) Mod 20))
                End If
    
                If (pd.bzData(pd.nCurrent).pts(0).X <> -1) Then
                    hpen = SelectObject(ByVal hdc, ByVal GetStockObject(BLACK_PEN))
                    PolyBezier ByVal hdc, pd.bzData(pd.nCurrent).pts(0), ByVal POINTS
                    SelectObject ByVal hdc, ByVal hpen
                End If
    
                For idx = 0 To POINTS - 1
    
                    X = lpPrev.pts(idx).X
                    Y = lpPrev.pts(idx).Y
                    X = X + pd.ptOffset(idx).X
                    Y = Y + pd.ptOffset(idx).Y
    
                    If (X >= rc.Right) Then
                        X = rc.Right - ((X - rc.Right) + 1)
                        pd.ptOffset(idx).X = -GetRndOffset(idx)
                    End If
    
                    If (X <= rc.Left) Then
                        X = rc.Left + ((rc.Left - X) + 1)
                        pd.ptOffset(idx).X = GetRndOffset(idx)
                    End If
    
                    If (Y >= rc.Bottom) Then
                        Y = rc.Bottom - ((Y - rc.Bottom) + 1)
                        pd.ptOffset(idx).Y = -GetRndOffset(idx)
                    End If
    
                    If (Y <= rc.Top) Then
                        Y = rc.Top + ((rc.Top - Y) + 1)
                        pd.ptOffset(idx).Y = GetRndOffset(idx)
                    End If
    
                    pd.bzData(pd.nCurrent).pts(idx).X = X
                    pd.bzData(pd.nCurrent).pts(idx).Y = Y
    
                Next idx
            
            End If

            hpen = SelectObject(ByVal hdc, CreatePen(ByVal PS_SOLID, ByVal 1, ByVal pd.nColorArr(pd.nColor)))
            PolyBezier ByVal hdc, pd.bzData(pd.nCurrent).pts(0), ByVal POINTS
            DeleteObject (SelectObject(ByVal hdc, ByVal hpen))
            SelectObject ByVal hdc, ByVal hpen
            SetROP2 ByVal hdc, ByVal R2_COPYPEN
            ReleaseDC ByVal hwnd, ByVal hdc

            RtlMoveMemory ByVal pMem, pd, ByVal Len(pd)

        End If

        GlobalUnlock ByVal pMem
    End If
    
End Function

