VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Class1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'
' Scanner = %%SCANNER_NAME%%
' Generated by ScanGen %%DATE_TIME%%
' BlackBox Software & Consulting
' input = %%SCANNER_SOURCE%%
'
Private mScan As rxScanner

'%%TOKEN_CONSTANTS%%
Private Const TOK_NULL      As Integer = 0
Private Const TOK_IGNORE    As Integer = 0
Private Const TOK_MAX_CHAR  As Integer = 256

Private Const TOK_DOUBLE    As Integer = TOK_MAX_CHAR + 1
Private Const TOK_INTEGER   As Integer = TOK_MAX_CHAR + 2
Private Const TOK_DQUOTE    As Integer = TOK_MAX_CHAR + 3
Private Const TOK_SQUOTE    As Integer = TOK_MAX_CHAR + 4
Private Const TOK_VNAME     As Integer = TOK_MAX_CHAR + 5
Private Const TOK_CRLF      As Integer = TOK_MAX_CHAR + 6
Private Const TOK_CR        As Integer = TOK_MAX_CHAR + 7
Private Const TOK_LF        As Integer = TOK_MAX_CHAR + 8
Private Const TOK_BOOLEAN   As Integer = TOK_MAX_CHAR + 9
Private Const TOK_QSTRING   As Integer = TOK_MAX_CHAR + 10
Private Const TOK_CTRLCHR   As Integer = TOK_MAX_CHAR + 11
Private Const TOK_ESCDQUOTE   As Integer = TOK_MAX_CHAR + 12
Private Const TOK_ESCSQUOTE   As Integer = TOK_MAX_CHAR + 13


'%%PATTERN CONSTANTS%%
Private Const PATTERN_DOUBLE        As String = "[-+]?(([0-9]+)|([0-9]*\.[0-9]+)([eE][-+]?[0-9]+)?)"
Private Const PATTERN_INTEGER       As String = "[1-9][0-9]*"
Private Const PATTERN_QSTRING       As String = """\""([^""]|\\\"")*\"""
Private Const PATTERN_IGNORE        As String = "[ \t]"
Private Const PATTERN_VNAME         As String = "[a-zA-Z][a-zA-Z0-9_]*"
Private Const PATTERN_CRLF          As String = "\r\n"
Private Const PATTERN_LF            As String = "\n"
Private Const PATTERN_CR            As String = "\r"
Private Const PATTERN_NOTSQUOTE     As String = "[^'\r\n]"
Private Const PATTERN_NOTDQUOTE     As String = "[^""\r\n]"
Private Const PATTERN_CTRLCHR       As String = "\\[TRNtrn" ']"
Private Const PATTERN_BOOLEAN       As String = "(""true""|""false"")"
Private Const PATTERN_DQUOTE        As String = """"
Private Const PATTERN_SQUOTE        As String = "'"

'%%STATE_CONSTANTS%%
Private Const SCANSTATE_DQSTRING    As String = "DQSTRING"
Private Const SCANSTATE_SQSTRING    As String = "SQSTRING"

'%%USER_DEFINES%%
Dim mQString As String

Private Sub Class_Initialize()
    Set mScan = New rxScanner

    '%%TOKEN_INIT%%
    mScan.AddPattern TOK_DOUBLE, PATTERN_DOUBLE
    mScan.AddPattern TOK_INTEGER, PATTERN_INTEGER
    mScan.AddPattern TOK_DQUOTE, PATTERN_DQUOTE
    mScan.AddPattern TOK_SQUOTE, PATTERN_SQUOTE
    mScan.AddPattern 0, PATTERN_IGNORE
    mScan.AddPattern TOK_VNAME, PATTERN_VNAME
    mScan.AddPattern TOK_CRLF, PATTERN_CRLF
    mScan.AddPattern TOK_CR, PATTERN_CR
    mScan.AddPattern TOK_LF, PATTERN_LF
    mScan.AddPattern TOK_CTRLCHR, PATTERN_CTRLCHR
    mScan.AddPattern TOK_BOOLEAN, PATTERN_BOOLEAN

    mScan.AddPattern TOK_ESCDQUOTE, "\\\""", SCANSTATE_DQSTRING
    mScan.AddPattern TOK_DQUOTE, PATTERN_DQUOTE, SCANSTATE_DQSTRING
    mScan.AddPattern TOK_CTRLCHR, PATTERN_CTRLCHR, SCANSTATE_DQSTRING
    mScan.AddPattern TOK_CRLF, PATTERN_CRLF, SCANSTATE_DQSTRING
    mScan.AddPattern TOK_CR, PATTERN_CR, SCANSTATE_DQSTRING
    mScan.AddPattern TOK_LF, PATTERN_LF, SCANSTATE_DQSTRING
    mScan.AddPattern TOK_LF, PATTERN_NOTDQUOTE, SCANSTATE_DQSTRING

    mScan.AddPattern TOK_ESCSQUOTE, "\\'", SCANSTATE_SQSTRING
    mScan.AddPattern TOK_DQUOTE, PATTERN_DQUOTE, SCANSTATE_SQSTRING
    mScan.AddPattern TOK_CTRLCHR, PATTERN_CTRLCHR, SCANSTATE_SQSTRING
    mScan.AddPattern TOK_CRLF, PATTERN_CRLF, SCANSTATE_SQSTRING
    mScan.AddPattern TOK_CR, PATTERN_CR, SCANSTATE_SQSTRING
    mScan.AddPattern TOK_LF, PATTERN_LF, SCANSTATE_SQSTRING
    mScan.AddPattern TOK_LF, PATTERN_NOTSQUOTE, SCANSTATE_SQSTRING

End Sub


Public Function GetToken(TokenType As Integer, TokenValue As Variant) As Boolean

    While mScan.GetToken(TokenType, TokenValue)
        
        '%%TOKEN_SWITCH%%
        Select Case mScan.CurrentState
        
        Case SCANSTATE_DQSTRING
            ' double quoted string
            Select Case TokenType
            Case TOK_DQUOTE
                TokenValue = mQString
                TokenType = TOK_QSTRING
                PopState
            Case TOK_CTRLCHR
                mQString = mQString & TranslateEscChr(CStr(TokenValue))
                TokenType = TOK_IGNORE
            Case TOK_ESCDQUOTE
                mQString = mQString & TranslateEscChr(CStr(TokenValue))
                TokenType = TOK_IGNORE
            Case TOK_CRLF, TOK_CR, TOK_LF
                Err.Raise vbObjectError, , "Unterminated string"
            Case Else
                mQString = mQString & CStr(TokenValue)
                TokenType = TOK_IGNORE
            End Select
        Case SCANSTATE_SQSTRING
            ' single quoted string
            Select Case TokenType
            Case TOK_SQUOTE
                TokenValue = mQString
                TokenType = TOK_QSTRING
                PopState
            Case TOK_CTRLCHR
                mQString = mQString & TranslateEscChr(CStr(TokenValue))
                TokenType = TOK_IGNORE
            Case TOK_ESCDQUOTE
                mQString = mQString & TranslateEscChr(CStr(TokenValue))
                TokenType = TOK_IGNORE
            Case TOK_CRLF, TOK_CR, TOK_LF
                Err.Raise vbObjectError, , "Unterminated string"
            Case Else
                mQString = mQString & CStr(TokenValue)
                TokenType = TOK_IGNORE
            End Select
        Case Else
            ' default scanner state
            Select Case TokenType
            Case TOK_INTEGER
                TokenValue = CInt(TokenValue)
            Case TOK_DOUBLE
                TokenValue = CDbl(TokenValue)
            Case TOK_DQUOTE
                mScan.PushState SCANSTATE_DQSTRING
            Case TOK_SQUOTE
                mScan.PushState SCANSTATE_DQSTRING
            Case TOK_VNAME
            Case TOK_CRLF
            Case TOK_CR
            Case TOK_LF
            Case TOK_BOOLEAN
            Case TOK_QSTRING
            End Select
        
        End Select
        
        ' Automatically ignore tokens that are considered whitespace
        If TokenType <> TOK_IGNORE Then
            GetToken = True
            Exit Function
        End If
    Wend
    GetToken = False
End Function

Public Function CurrentState() As String
    CurrentState = mScan.CurrentState()
End Function

Public Sub UnGetToken(Value As String)
    Call mScan.UnGetToken(Value)
End Sub

Public Sub PopState()
    mScan.PopState
End Sub

Public Sub PushState(Name As String)
    mScan.PushState Name
End Sub

Public Property Let ScanInput(S As String)
    mScan.ScanInput = S
End Property

Public Property Get ScanInput() As String
    ScanInput = mScan.ScanInput
End Property

'%%USER_CODE%%
Private Function TranslateEscChr(TokenChar As String) As String
    Select Case Right(TokenChar, 1)
    Case "r", "R"
        TranslateEscChr = vbCr
    Case "t", "T"
        TranslateEscChr = vbTab
    Case "n", "N"
        TranslateEscChr = vbLf
    Case """"
        TranslateEscChr = """"
    Case "'"
        TranslateEscChr = "'"
    Case Else
        TranslateEscChr = Right(TokenChar, 1)
    End Select
End Function

